// RUN: %dxc -Tlib_6_3 -verify %s
// RUN: %dxc -Tps_6_0 -verify %s

// Ensure that invalid unbounded multidimensional resource arrays of various kinds
// Fail appropriately

struct MyFloat4 {
  float4 f;
};

// Invalid 2D multidimensional resource arrays
Texture1D<float4>          Tex1D[3][] : register(t0, space0);    /* expected-error {{array has incomplete element type 'Texture1D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture1DArray<float4>     Tex1DArr[3][] : register(t0, space1);    /* expected-error {{array has incomplete element type 'Texture1DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2D<float4>          Tex2D[3][] : register(t0, space2);    /* expected-error {{array has incomplete element type 'Texture2D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2DArray<float4>     Tex2DArr[3][] : register(t0, space3);    /* expected-error {{array has incomplete element type 'Texture2DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture3D<float4>          Tex3D[3][] : register(t0, space4);    /* expected-error {{array has incomplete element type 'Texture3D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

RWTexture1D<float4>        RWTex1D[3][] : register(u0, space5);    /* expected-error {{array has incomplete element type 'RWTexture1D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture1DArray<float4>   RWTex1DArr[3][] : register(u0, space6);    /* expected-error {{array has incomplete element type 'RWTexture1DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture2D<float4>        RWTex2D[3][] : register(u0, space7);    /* expected-error {{array has incomplete element type 'RWTexture2D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture2DArray<float4>   RWTex2DArr[3][] : register(u0, space8);    /* expected-error {{array has incomplete element type 'RWTexture2DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture3D<float4>        RWTex3D[3][] : register(u0, space9);    /* expected-error {{array has incomplete element type 'RWTexture3D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

Texture2DMS<float4>        Tex2DMS[3][] : register(t0, space10);    /* expected-error {{array has incomplete element type 'Texture2DMS<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2DMSArray<float4>   Tex2DMSArr[3][] : register(t0, space11);    /* expected-error {{array has incomplete element type 'Texture2DMSArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureCube<float4>        TexCube[3][] : register(t0, space12);    /* expected-error {{array has incomplete element type 'TextureCube<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureCubeArray<float4>   TexCubeArr[3][] : register(t0, space13);    /* expected-error {{array has incomplete element type 'TextureCubeArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
SamplerState               Samp[3][] : register(t0, space14);    /* expected-error {{array has incomplete element type 'SamplerState []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
SamplerComparisonState     SampCmp[3][] : register(t0, space15);    /* expected-error {{array has incomplete element type 'SamplerComparisonState []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */


ConstantBuffer<MyFloat4>   CBuf[3][] : register(b0, space16);    /* expected-error {{array has incomplete element type 'ConstantBuffer<MyFloat4> []'}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureBuffer<MyFloat4>    TBuf[3][] : register(t0, space17);    /* expected-error {{array has incomplete element type 'TextureBuffer<MyFloat4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

Buffer<float4>             Buf[3][] : register(t0, space18);    /* expected-error {{array has incomplete element type 'Buffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
StructuredBuffer<float4>   SBuf[3][] : register(t0, space19);    /* expected-error {{array has incomplete element type 'StructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
ByteAddressBuffer          BABuf[3][] : register(t0, space20);    /* expected-error {{array has incomplete element type 'ByteAddressBuffer []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

RWBuffer<float4>           RWBuf[3][] : register(u0, space21);    /* expected-error {{array has incomplete element type 'RWBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWStructuredBuffer<float4> RWSBuf[3][] : register(u0, space22);    /* expected-error {{array has incomplete element type 'RWStructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWByteAddressBuffer        RWBABuf[3][] : register(u0, space23);    /* expected-error {{array has incomplete element type 'RWByteAddressBuffer []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

ConsumeStructuredBuffer<float4> CSBuf[3][] : register(u0, space24);    /* expected-error {{array has incomplete element type 'ConsumeStructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
AppendStructuredBuffer<float4>  ASBuf[3][] : register(u0, space25);    /* expected-error {{array has incomplete element type 'AppendStructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
FeedbackTexture2D<SAMPLER_FEEDBACK_MIN_MIP>      FBTex2D[3][] : register(u0, space26);    /* expected-error {{array has incomplete element type 'FeedbackTexture2D<SAMPLER_FEEDBACK_MIN_MIP> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3000: unrecognized identifier 'FeedbackTexture2D'}} */
FeedbackTexture2DArray<SAMPLER_FEEDBACK_MIN_MIP> FBTex2DArr[3][] : register(u0, space27);    /* expected-error {{array has incomplete element type 'FeedbackTexture2DArray<SAMPLER_FEEDBACK_MIN_MIP> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3000: unrecognized identifier 'FeedbackTexture2DArray'}} */

// Invalid 3D multidimensional resource arrays with mid unbound dimension
Texture1D<float4>          Tex1D[3][][2] : register(t0, space0);    /* expected-error {{array has incomplete element type 'Texture1D<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture1DArray<float4>     Tex1DArr[3][][2] : register(t0, space1);    /* expected-error {{array has incomplete element type 'Texture1DArray<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2D<float4>          Tex2D[3][][2] : register(t0, space2);    /* expected-error {{array has incomplete element type 'Texture2D<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2DArray<float4>     Tex2DArr[3][][2] : register(t0, space3);    /* expected-error {{array has incomplete element type 'Texture2DArray<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture3D<float4>          Tex3D[3][][2] : register(t0, space4);    /* expected-error {{array has incomplete element type 'Texture3D<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

RWTexture1D<float4>        RWTex1D[3][][2] : register(u0, space5);    /* expected-error {{array has incomplete element type 'RWTexture1D<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture1DArray<float4>   RWTex1DArr[3][][2] : register(u0, space6);    /* expected-error {{array has incomplete element type 'RWTexture1DArray<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture2D<float4>        RWTex2D[3][][2] : register(u0, space7);    /* expected-error {{array has incomplete element type 'RWTexture2D<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture2DArray<float4>   RWTex2DArr[3][][2] : register(u0, space8);    /* expected-error {{array has incomplete element type 'RWTexture2DArray<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture3D<float4>        RWTex3D[3][][2] : register(u0, space9);    /* expected-error {{array has incomplete element type 'RWTexture3D<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

Texture2DMS<float4>        Tex2DMS[3][][2] : register(t0, space10);    /* expected-error {{array has incomplete element type 'Texture2DMS<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2DMSArray<float4>   Tex2DMSArr[3][][2] : register(t0, space11);    /* expected-error {{array has incomplete element type 'Texture2DMSArray<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureCube<float4>        TexCube[3][][2] : register(t0, space12);    /* expected-error {{array has incomplete element type 'TextureCube<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureCubeArray<float4>   TexCubeArr[3][][2] : register(t0, space13);    /* expected-error {{array has incomplete element type 'TextureCubeArray<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
SamplerState               Samp[3][][2] : register(t0, space14);    /* expected-error {{array has incomplete element type 'SamplerState [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
SamplerComparisonState     SampCmp[3][][2] : register(t0, space15);    /* expected-error {{array has incomplete element type 'SamplerComparisonState [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

ConstantBuffer<MyFloat4>   CBuf[3][][2] : register(b0, space16);    /* expected-error {{array has incomplete element type 'ConstantBuffer<MyFloat4> [][2]'}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureBuffer<MyFloat4>    TBuf[3][][2] : register(t0, space17);    /* expected-error {{array has incomplete element type 'TextureBuffer<MyFloat4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

Buffer<float4>             Buf[3][][2] : register(t0, space18);    /* expected-error {{array has incomplete element type 'Buffer<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
StructuredBuffer<float4>   SBuf[3][][2] : register(t0, space19);    /* expected-error {{array has incomplete element type 'StructuredBuffer<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
ByteAddressBuffer          BABuf[3][][2] : register(t0, space20);    /* expected-error {{array has incomplete element type 'ByteAddressBuffer [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

RWBuffer<float4>           RWBuf[3][][2] : register(u0, space21);    /* expected-error {{array has incomplete element type 'RWBuffer<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWStructuredBuffer<float4> RWSBuf[3][][2] : register(u0, space22);    /* expected-error {{array has incomplete element type 'RWStructuredBuffer<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWByteAddressBuffer        RWBABuf[3][][2] : register(u0, space23);    /* expected-error {{array has incomplete element type 'RWByteAddressBuffer [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

ConsumeStructuredBuffer<float4> CSBuf[3][][2] : register(u0, space24);    /* expected-error {{array has incomplete element type 'ConsumeStructuredBuffer<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
AppendStructuredBuffer<float4>  ASBuf[3][][2] : register(u0, space25);    /* expected-error {{array has incomplete element type 'AppendStructuredBuffer<float4> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
FeedbackTexture2D<SAMPLER_FEEDBACK_MIN_MIP>      FBTex2D[3][][2] : register(u0, space26);    /* expected-error {{array has incomplete element type 'FeedbackTexture2D<SAMPLER_FEEDBACK_MIN_MIP> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3000: unrecognized identifier 'FeedbackTexture2D'}} */
FeedbackTexture2DArray<SAMPLER_FEEDBACK_MIN_MIP> FBTex2DArr[3][][2] : register(u0, space27);    /* expected-error {{array has incomplete element type 'FeedbackTexture2DArray<SAMPLER_FEEDBACK_MIN_MIP> [][2]'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3000: unrecognized identifier 'FeedbackTexture2DArray'}} */

// Invalid 3D multidimensional resource arrays with last unbound dimension
Texture1D<float4>          Tex1D[3][2][] : register(t0, space0);    /* expected-error {{array has incomplete element type 'Texture1D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture1DArray<float4>     Tex1DArr[3][2][] : register(t0, space1);    /* expected-error {{array has incomplete element type 'Texture1DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2D<float4>          Tex2D[3][2][] : register(t0, space2);    /* expected-error {{array has incomplete element type 'Texture2D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2DArray<float4>     Tex2DArr[3][2][] : register(t0, space3);    /* expected-error {{array has incomplete element type 'Texture2DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture3D<float4>          Tex3D[3][2][] : register(t0, space4);    /* expected-error {{array has incomplete element type 'Texture3D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

RWTexture1D<float4>        RWTex1D[3][2][] : register(u0, space5);    /* expected-error {{array has incomplete element type 'RWTexture1D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture1DArray<float4>   RWTex1DArr[3][2][] : register(u0, space6);    /* expected-error {{array has incomplete element type 'RWTexture1DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture2D<float4>        RWTex2D[3][2][] : register(u0, space7);    /* expected-error {{array has incomplete element type 'RWTexture2D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture2DArray<float4>   RWTex2DArr[3][2][] : register(u0, space8);    /* expected-error {{array has incomplete element type 'RWTexture2DArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWTexture3D<float4>        RWTex3D[3][2][] : register(u0, space9);    /* expected-error {{array has incomplete element type 'RWTexture3D<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

Texture2DMS<float4>        Tex2DMS[3][2][] : register(t0, space10);    /* expected-error {{array has incomplete element type 'Texture2DMS<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
Texture2DMSArray<float4>   Tex2DMSArr[3][2][] : register(t0, space11);    /* expected-error {{array has incomplete element type 'Texture2DMSArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureCube<float4>        TexCube[3][2][] : register(t0, space12);    /* expected-error {{array has incomplete element type 'TextureCube<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureCubeArray<float4>   TexCubeArr[3][2][] : register(t0, space13);    /* expected-error {{array has incomplete element type 'TextureCubeArray<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
SamplerState               Samp[3][2][] : register(t0, space14);    /* expected-error {{array has incomplete element type 'SamplerState []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
SamplerComparisonState     SampCmp[3][2][] : register(t0, space15);    /* expected-error {{array has incomplete element type 'SamplerComparisonState []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

ConstantBuffer<MyFloat4>   CBuf[3][2][] : register(b0, space16);    /* expected-error {{array has incomplete element type 'ConstantBuffer<MyFloat4> []'}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
TextureBuffer<MyFloat4>    TBuf[3][2][] : register(t0, space17);    /* expected-error {{array has incomplete element type 'TextureBuffer<MyFloat4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

Buffer<float4>             Buf[3][2][] : register(t0, space18);    /* expected-error {{array has incomplete element type 'Buffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
StructuredBuffer<float4>   SBuf[3][2][] : register(t0, space19);    /* expected-error {{array has incomplete element type 'StructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
ByteAddressBuffer          BABuf[3][2][] : register(t0, space20);    /* expected-error {{array has incomplete element type 'ByteAddressBuffer []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

RWBuffer<float4>           RWBuf[3][2][] : register(u0, space21);    /* expected-error {{array has incomplete element type 'RWBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWStructuredBuffer<float4> RWSBuf[3][2][] : register(u0, space22);    /* expected-error {{array has incomplete element type 'RWStructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
RWByteAddressBuffer        RWBABuf[3][2][] : register(u0, space23);    /* expected-error {{array has incomplete element type 'RWByteAddressBuffer []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */

ConsumeStructuredBuffer<float4> CSBuf[3][2][] : register(u0, space24);    /* expected-error {{array has incomplete element type 'ConsumeStructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
AppendStructuredBuffer<float4>  ASBuf[3][2][] : register(u0, space25);    /* expected-error {{array has incomplete element type 'AppendStructuredBuffer<float4> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3073: secondary array dimensions must be explicit}} */
FeedbackTexture2D<SAMPLER_FEEDBACK_MIN_MIP>      FBTex2D[3][2][] : register(u0, space26);    /* expected-error {{array has incomplete element type 'FeedbackTexture2D<SAMPLER_FEEDBACK_MIN_MIP> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3000: unrecognized identifier 'FeedbackTexture2D'}} */
FeedbackTexture2DArray<SAMPLER_FEEDBACK_MIN_MIP> FBTex2DArr[3][2][] : register(u0, space27);    /* expected-error {{array has incomplete element type 'FeedbackTexture2DArray<SAMPLER_FEEDBACK_MIN_MIP> []'}} expected-error {{invalid register specification, expected 'b', 'c', or 'i' binding}} fxc-error {{X3000: unrecognized identifier 'FeedbackTexture2DArray'}} */

[shader("pixel")]
float4 main() : SV_Target {
  return 0.0;
}


