/* valaforstatement.c generated by valac, the Vala compiler
 * generated from valaforstatement.vala, do not modify */

/* valaforstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaForStatementPrivate {
	ValaList* initializer;
	ValaList* iterator;
};

static gint ValaForStatement_private_offset;
static gpointer vala_for_statement_parent_class = NULL;
static ValaStatementIface * vala_for_statement_vala_statement_parent_iface = NULL;

static void vala_for_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_for_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static void vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_for_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_for_statement_finalize (ValaCodeNode * obj);
static GType vala_for_statement_get_type_once (void);

static inline gpointer
vala_for_statement_get_instance_private (ValaForStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaForStatement_private_offset);
}

/**
 * Creates a new for statement.
 *
 * @param condition        loop condition
 * @param body             loop body
 * @param source_reference reference to source code
 * @return                 newly created for statement
 */
ValaForStatement*
vala_for_statement_construct (GType object_type,
                              ValaExpression* condition,
                              ValaBlock* body,
                              ValaSourceReference* source_reference)
{
	ValaForStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForStatement*) vala_loop_construct (object_type, condition, body, source_reference);
	return self;
}

ValaForStatement*
vala_for_statement_new (ValaExpression* condition,
                        ValaBlock* body,
                        ValaSourceReference* source_reference)
{
	return vala_for_statement_construct (VALA_TYPE_FOR_STATEMENT, condition, body, source_reference);
}

/**
 * Appends the specified expression to the list of initializers.
 *
 * @param init an initializer expression
 */
void
vala_for_statement_add_initializer (ValaForStatement* self,
                                    ValaExpression* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
	_tmp0_ = self->priv->initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
}

/**
 * Returns the list of initializers.
 *
 * @return initializer list
 */
ValaList*
vala_for_statement_get_initializer (ValaForStatement* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializer;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified expression to the iterator.
 *
 * @param iter an iterator expression
 */
void
vala_for_statement_add_iterator (ValaForStatement* self,
                                 ValaExpression* iter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) iter, (ValaCodeNode*) self);
	_tmp0_ = self->priv->iterator;
	vala_collection_add ((ValaCollection*) _tmp0_, iter);
}

/**
 * Returns the iterator.
 *
 * @return iterator
 */
ValaList*
vala_for_statement_get_iterator (ValaForStatement* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->iterator;
	result = _tmp0_;
	return result;
}

static void
vala_for_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_for_statement (visitor, self);
}

static void
vala_for_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaBlock* _tmp26_;
	ValaBlock* _tmp27_;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp0_;
		gint _init_expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _init_expr_index = 0;
		_tmp0_ = self->priv->initializer;
		_init_expr_list = _tmp0_;
		_tmp1_ = _init_expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_init_expr_size = _tmp3_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_init_expr_index = _init_expr_index + 1;
			_tmp4_ = _init_expr_index;
			_tmp5_ = _init_expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _init_expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _init_expr_index);
			init_expr = (ValaExpression*) _tmp7_;
			_tmp8_ = init_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_tmp9_ = init_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp9_);
			_vala_code_node_unref0 (init_expr);
		}
	}
	_tmp10_ = vala_loop_get_condition ((ValaLoop*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		_tmp12_ = vala_loop_get_condition ((ValaLoop*) self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
		_tmp14_ = vala_loop_get_condition ((ValaLoop*) self);
		_tmp15_ = _tmp14_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp15_);
	}
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp16_;
		gint _it_expr_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _it_expr_index = 0;
		_tmp16_ = self->priv->iterator;
		_it_expr_list = _tmp16_;
		_tmp17_ = _it_expr_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_it_expr_size = _tmp19_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaExpression* _tmp24_;
			ValaExpression* _tmp25_;
			_it_expr_index = _it_expr_index + 1;
			_tmp20_ = _it_expr_index;
			_tmp21_ = _it_expr_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _it_expr_list;
			_tmp23_ = vala_list_get (_tmp22_, _it_expr_index);
			it_expr = (ValaExpression*) _tmp23_;
			_tmp24_ = it_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
			_tmp25_ = it_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp25_);
			_vala_code_node_unref0 (it_expr);
		}
	}
	_tmp26_ = vala_loop_get_body ((ValaLoop*) self);
	_tmp27_ = _tmp26_;
	vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
}

static void
vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaForStatement * self;
	self = (ValaForStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	VALA_CODE_NODE_CLASS (vala_for_statement_parent_class)->replace_expression ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_LOOP, ValaLoop), old_node, new_node);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializer;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializer;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializer;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				ValaList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				ValaExpression* _tmp17_;
				gboolean _tmp18_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = self->priv->iterator;
				_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				if (!(i < _tmp14_)) {
					break;
				}
				_tmp15_ = self->priv->iterator;
				_tmp16_ = vala_list_get (_tmp15_, i);
				_tmp17_ = (ValaExpression*) _tmp16_;
				_tmp18_ = _tmp17_ == old_node;
				_vala_code_node_unref0 (_tmp17_);
				if (_tmp18_) {
					ValaList* _tmp19_;
					_tmp19_ = self->priv->iterator;
					vala_list_set (_tmp19_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gboolean
vala_for_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaForStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaBlock* _tmp6_;
	gboolean _tmp22_ = FALSE;
	ValaExpression* _tmp23_;
	ValaExpression* _tmp24_;
	ValaLocalVariable* first_local = NULL;
	ValaSemanticAnalyzer* _tmp66_;
	ValaSemanticAnalyzer* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaBooleanLiteral* _tmp75_;
	ValaBooleanLiteral* _tmp76_;
	ValaSourceReference* _tmp77_;
	ValaSourceReference* _tmp78_;
	ValaLocalVariable* _tmp79_;
	ValaLocalVariable* _tmp80_;
	ValaBlock* _tmp81_;
	ValaLocalVariable* _tmp82_;
	ValaSourceReference* _tmp83_;
	ValaSourceReference* _tmp84_;
	ValaDeclarationStatement* _tmp85_;
	ValaDeclarationStatement* _tmp86_;
	ValaBlock* iterator_block = NULL;
	ValaSourceReference* _tmp87_;
	ValaSourceReference* _tmp88_;
	ValaBlock* _tmp89_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	ValaSourceReference* _tmp108_;
	ValaSourceReference* _tmp109_;
	ValaMemberAccess* _tmp110_;
	ValaMemberAccess* _tmp111_;
	ValaSourceReference* _tmp112_;
	ValaSourceReference* _tmp113_;
	ValaUnaryExpression* _tmp114_;
	ValaUnaryExpression* _tmp115_;
	ValaBlock* _tmp116_;
	ValaSourceReference* _tmp117_;
	ValaSourceReference* _tmp118_;
	ValaIfStatement* _tmp119_;
	ValaIfStatement* _tmp120_;
	ValaBlock* _tmp121_;
	ValaBlock* _tmp122_;
	ValaIfStatement* _tmp123_;
	ValaBlock* _tmp124_;
	ValaBlock* _tmp125_;
	ValaLocalVariable* _tmp126_;
	const gchar* _tmp127_;
	const gchar* _tmp128_;
	ValaSourceReference* _tmp129_;
	ValaSourceReference* _tmp130_;
	ValaMemberAccess* _tmp131_;
	ValaMemberAccess* _tmp132_;
	ValaSourceReference* _tmp133_;
	ValaSourceReference* _tmp134_;
	ValaBooleanLiteral* _tmp135_;
	ValaBooleanLiteral* _tmp136_;
	ValaSourceReference* _tmp137_;
	ValaSourceReference* _tmp138_;
	ValaAssignment* _tmp139_;
	ValaAssignment* _tmp140_;
	ValaSourceReference* _tmp141_;
	ValaSourceReference* _tmp142_;
	ValaExpressionStatement* _tmp143_;
	ValaExpressionStatement* _tmp144_;
	ValaBlock* _tmp145_;
	ValaBlock* _tmp146_;
	ValaBlock* _tmp147_;
	ValaSourceReference* _tmp148_;
	ValaSourceReference* _tmp149_;
	ValaLoopStatement* _tmp150_;
	ValaLoopStatement* _tmp151_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp152_;
	ValaCodeNode* _tmp153_;
	ValaBlock* _tmp154_;
	ValaBlock* _tmp155_;
	ValaBlock* _tmp156_;
	gboolean _tmp157_;
	gboolean _tmp158_;
	gboolean result = FALSE;
	self = (ValaForStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_block_new (_tmp5_);
	block = _tmp6_;
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp7_;
		gint _init_expr_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _init_expr_index = 0;
		_tmp7_ = self->priv->initializer;
		_init_expr_list = _tmp7_;
		_tmp8_ = _init_expr_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_init_expr_size = _tmp10_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaBlock* _tmp15_;
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaExpressionStatement* _tmp20_;
			ValaExpressionStatement* _tmp21_;
			_init_expr_index = _init_expr_index + 1;
			_tmp11_ = _init_expr_index;
			_tmp12_ = _init_expr_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _init_expr_list;
			_tmp14_ = vala_list_get (_tmp13_, _init_expr_index);
			init_expr = (ValaExpression*) _tmp14_;
			_tmp15_ = block;
			_tmp16_ = init_expr;
			_tmp17_ = init_expr;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_statement_new (_tmp16_, _tmp19_);
			_tmp21_ = _tmp20_;
			vala_block_add_statement (_tmp15_, (ValaStatement*) _tmp21_);
			_vala_code_node_unref0 (_tmp21_);
			_vala_code_node_unref0 (init_expr);
		}
	}
	_tmp23_ = vala_loop_get_condition ((ValaLoop*) self);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == NULL) {
		_tmp22_ = TRUE;
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_loop_get_condition ((ValaLoop*) self);
		_tmp26_ = _tmp25_;
		_tmp22_ = vala_expression_is_always_true (_tmp26_);
	}
	if (_tmp22_) {
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_loop_get_condition ((ValaLoop*) self);
		_tmp28_ = _tmp27_;
		if (vala_expression_is_always_false (_tmp28_)) {
			ValaBlock* _tmp29_;
			ValaBlock* _tmp30_;
			ValaExpression* _tmp31_;
			ValaExpression* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaSourceReference* _tmp34_;
			ValaBreakStatement* _tmp35_;
			ValaBreakStatement* _tmp36_;
			_tmp29_ = vala_loop_get_body ((ValaLoop*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_loop_get_condition ((ValaLoop*) self);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_break_statement_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_block_insert_statement (_tmp30_, 0, (ValaStatement*) _tmp36_);
			_vala_code_node_unref0 (_tmp36_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaExpression* _tmp40_;
			ValaSourceReference* _tmp41_;
			ValaSourceReference* _tmp42_;
			ValaUnaryExpression* _tmp43_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp44_;
			ValaExpression* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaSourceReference* _tmp47_;
			ValaBlock* _tmp48_;
			ValaBlock* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaBreakStatement* _tmp54_;
			ValaBreakStatement* _tmp55_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp56_;
			ValaBlock* _tmp57_;
			ValaExpression* _tmp58_;
			ValaExpression* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaIfStatement* _tmp62_;
			ValaBlock* _tmp63_;
			ValaBlock* _tmp64_;
			ValaIfStatement* _tmp65_;
			_tmp37_ = vala_loop_get_condition ((ValaLoop*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_loop_get_condition ((ValaLoop*) self);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp38_, _tmp42_);
			if_condition = _tmp43_;
			_tmp44_ = vala_loop_get_condition ((ValaLoop*) self);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_block_new (_tmp47_);
			true_block = _tmp48_;
			_tmp49_ = true_block;
			_tmp50_ = vala_loop_get_condition ((ValaLoop*) self);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_break_statement_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_block_add_statement (_tmp49_, (ValaStatement*) _tmp55_);
			_vala_code_node_unref0 (_tmp55_);
			_tmp56_ = if_condition;
			_tmp57_ = true_block;
			_tmp58_ = vala_loop_get_condition ((ValaLoop*) self);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_if_statement_new ((ValaExpression*) _tmp56_, _tmp57_, NULL, _tmp61_);
			if_stmt = _tmp62_;
			_tmp63_ = vala_loop_get_body ((ValaLoop*) self);
			_tmp64_ = _tmp63_;
			_tmp65_ = if_stmt;
			vala_block_insert_statement (_tmp64_, 0, (ValaStatement*) _tmp65_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp66_ = vala_code_context_get_analyzer (context);
	_tmp67_ = _tmp66_;
	_tmp68_ = _tmp67_->bool_type;
	_tmp69_ = vala_data_type_copy (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = vala_code_node_get_temp_name ();
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_boolean_literal_new (TRUE, _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_local_variable_new (_tmp70_, _tmp72_, (ValaExpression*) _tmp76_, _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_code_node_unref0 (_tmp76_);
	_g_free0 (_tmp72_);
	_vala_code_node_unref0 (_tmp70_);
	first_local = _tmp80_;
	_tmp81_ = block;
	_tmp82_ = first_local;
	_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_declaration_statement_new ((ValaSymbol*) _tmp82_, _tmp84_);
	_tmp86_ = _tmp85_;
	vala_block_add_statement (_tmp81_, (ValaStatement*) _tmp86_);
	_vala_code_node_unref0 (_tmp86_);
	_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_block_new (_tmp88_);
	iterator_block = _tmp89_;
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp90_;
		gint _it_expr_size = 0;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _it_expr_index = 0;
		_tmp90_ = self->priv->iterator;
		_it_expr_list = _tmp90_;
		_tmp91_ = _it_expr_list;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_it_expr_size = _tmp93_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp94_;
			gint _tmp95_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp96_;
			gpointer _tmp97_;
			ValaBlock* _tmp98_;
			ValaExpression* _tmp99_;
			ValaExpression* _tmp100_;
			ValaSourceReference* _tmp101_;
			ValaSourceReference* _tmp102_;
			ValaExpressionStatement* _tmp103_;
			ValaExpressionStatement* _tmp104_;
			_it_expr_index = _it_expr_index + 1;
			_tmp94_ = _it_expr_index;
			_tmp95_ = _it_expr_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _it_expr_list;
			_tmp97_ = vala_list_get (_tmp96_, _it_expr_index);
			it_expr = (ValaExpression*) _tmp97_;
			_tmp98_ = iterator_block;
			_tmp99_ = it_expr;
			_tmp100_ = it_expr;
			_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_expression_statement_new (_tmp99_, _tmp102_);
			_tmp104_ = _tmp103_;
			vala_block_add_statement (_tmp98_, (ValaStatement*) _tmp104_);
			_vala_code_node_unref0 (_tmp104_);
			_vala_code_node_unref0 (it_expr);
		}
	}
	_tmp105_ = first_local;
	_tmp106_ = vala_symbol_get_name ((ValaSymbol*) _tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_member_access_new_simple (_tmp107_, _tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp111_, _tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = iterator_block;
	_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_if_statement_new ((ValaExpression*) _tmp115_, _tmp116_, NULL, _tmp118_);
	_tmp120_ = _tmp119_;
	_vala_code_node_unref0 (_tmp115_);
	_vala_code_node_unref0 (_tmp111_);
	first_if = _tmp120_;
	_tmp121_ = vala_loop_get_body ((ValaLoop*) self);
	_tmp122_ = _tmp121_;
	_tmp123_ = first_if;
	vala_block_insert_statement (_tmp122_, 0, (ValaStatement*) _tmp123_);
	_tmp124_ = vala_loop_get_body ((ValaLoop*) self);
	_tmp125_ = _tmp124_;
	_tmp126_ = first_local;
	_tmp127_ = vala_symbol_get_name ((ValaSymbol*) _tmp126_);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_member_access_new_simple (_tmp128_, _tmp130_);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp134_ = _tmp133_;
	_tmp135_ = vala_boolean_literal_new (FALSE, _tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_assignment_new ((ValaExpression*) _tmp132_, (ValaExpression*) _tmp136_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_expression_statement_new ((ValaExpression*) _tmp140_, _tmp142_);
	_tmp144_ = _tmp143_;
	vala_block_insert_statement (_tmp125_, 1, (ValaStatement*) _tmp144_);
	_vala_code_node_unref0 (_tmp144_);
	_vala_code_node_unref0 (_tmp140_);
	_vala_code_node_unref0 (_tmp136_);
	_vala_code_node_unref0 (_tmp132_);
	_tmp145_ = block;
	_tmp146_ = vala_loop_get_body ((ValaLoop*) self);
	_tmp147_ = _tmp146_;
	_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp149_ = _tmp148_;
	_tmp150_ = vala_loop_statement_new (_tmp147_, _tmp149_);
	_tmp151_ = _tmp150_;
	vala_block_add_statement (_tmp145_, (ValaStatement*) _tmp151_);
	_vala_code_node_unref0 (_tmp151_);
	_tmp152_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp153_ = _tmp152_;
	parent_block = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_BLOCK, ValaBlock);
	_tmp154_ = parent_block;
	_tmp155_ = block;
	vala_block_replace_statement (_tmp154_, (ValaStatement*) self, (ValaStatement*) _tmp155_);
	_tmp156_ = block;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp156_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
	_tmp157_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp158_ = _tmp157_;
	result = !_tmp158_;
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (iterator_block);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}

static void
vala_for_statement_class_init (ValaForStatementClass * klass,
                               gpointer klass_data)
{
	vala_for_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_for_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaForStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_for_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_for_statement_real_check;
}

static void
vala_for_statement_vala_statement_interface_init (ValaStatementIface * iface,
                                                  gpointer iface_data)
{
	vala_for_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}

static void
vala_for_statement_instance_init (ValaForStatement * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_for_statement_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializer = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->iterator = (ValaList*) _tmp3_;
}

static void
vala_for_statement_finalize (ValaCodeNode * obj)
{
	ValaForStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOR_STATEMENT, ValaForStatement);
	_vala_iterable_unref0 (self->priv->initializer);
	_vala_iterable_unref0 (self->priv->iterator);
	VALA_CODE_NODE_CLASS (vala_for_statement_parent_class)->finalize (obj);
}

/**
 * Represents a for iteration statement in the source code.
 */
static GType
vala_for_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForStatement), 0, (GInstanceInitFunc) vala_for_statement_instance_init, NULL };
	static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_for_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_for_statement_type_id;
	vala_for_statement_type_id = g_type_register_static (VALA_TYPE_LOOP, "ValaForStatement", &g_define_type_info, 0);
	g_type_add_interface_static (vala_for_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	ValaForStatement_private_offset = g_type_add_instance_private (vala_for_statement_type_id, sizeof (ValaForStatementPrivate));
	return vala_for_statement_type_id;
}

GType
vala_for_statement_get_type (void)
{
	static volatile gsize vala_for_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_for_statement_type_id__volatile)) {
		GType vala_for_statement_type_id;
		vala_for_statement_type_id = vala_for_statement_get_type_once ();
		g_once_init_leave (&vala_for_statement_type_id__volatile, vala_for_statement_type_id);
	}
	return vala_for_statement_type_id__volatile;
}

