/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -igcd --flex-syntax
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2014 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce two trailing NULLs for flex... */
	if (IS_INTERNED(str->value.str.val)) {
		char *tmp = safe_emalloc(1, str->value.str.len, ZEND_MMAP_AHEAD);
		memcpy(tmp, str->value.str.val, str->value.str.len + ZEND_MMAP_AHEAD);
		str->value.str.val = tmp;
	} else {
		str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);
	}

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = str->value.str.val;
	size = str->value.str.len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result != 0) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			destroy_op_array(op_array TSRMLS_CC);
			efree(op_array);
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy4,  &&yy4,  &&yy2,  &&yy2,  &&yy4,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy4,  &&yy7,  &&yy9,  &&yy11, &&yy13, &&yy14, &&yy15, &&yy16,
				&&yy18, &&yy19, &&yy20, &&yy21, &&yy19, &&yy22, &&yy23, &&yy24,
				&&yy25, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy29, &&yy19, &&yy30, &&yy31, &&yy32, &&yy33,
				&&yy19, &&yy34, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy38,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy39, &&yy36, &&yy36, &&yy19, &&yy40, &&yy19, &&yy42, &&yy43,
				&&yy44, &&yy46, &&yy47, &&yy48, &&yy49, &&yy50, &&yy51, &&yy52,
				&&yy36, &&yy53, &&yy36, &&yy36, &&yy54, &&yy36, &&yy55, &&yy36,
				&&yy56, &&yy36, &&yy57, &&yy58, &&yy59, &&yy60, &&yy61, &&yy62,
				&&yy36, &&yy63, &&yy36, &&yy64, &&yy66, &&yy67, &&yy19, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
				&&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36
			};
			goto *yytarget[yych];
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy69;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return yytext[0];
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy8;
			if (yych <= 'Z') goto yy71;
			if (yych <= '^') goto yy8;
			goto yy71;
		} else {
			if (yych <= '`') goto yy8;
			if (yych <= 'z') goto yy71;
			if (yych <= '~') goto yy8;
			goto yy71;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy74;
		if (yych <= '>') goto yy76;
		goto yy8;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy78;
		if (yych == '=') goto yy80;
		goto yy8;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy18:
		YYDEBUG(18, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy83, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy83, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy83, &&yy83, &&yy8,  &&yy83, &&yy8,  &&yy83, &&yy8,
				&&yy8,  &&yy83, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy83,
				&&yy8,  &&yy8,  &&yy83, &&yy83, &&yy8,  &&yy83, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8
			};
			goto *yytarget[yych];
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
		goto yy8;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy94;
		goto yy8;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy96;
		if (yych == '=') goto yy98;
		goto yy8;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy100;
			goto yy8;
		} else {
			if (yych <= '=') goto yy102;
			if (yych <= '>') goto yy104;
			goto yy8;
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy8;
		if (yych <= '9') goto yy106;
		if (yych == '=') goto yy109;
		goto yy8;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy111;
			goto yy8;
		} else {
			if (yych <= '/') goto yy11;
			if (yych == '=') goto yy113;
			goto yy8;
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'b') goto yy116;
		if (yych == 'x') goto yy117;
		goto yy28;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy28:
		YYDEBUG(28, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy27;
		}
		if (yych <= 'D') {
			if (yych == '.') goto yy106;
			goto yy26;
		} else {
			if (yych <= 'E') goto yy115;
			if (yych == 'e') goto yy115;
			goto yy26;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy118;
		goto yy8;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy120;
			goto yy8;
		} else {
			if (yych <= '<') goto yy121;
			if (yych <= '=') goto yy123;
			if (yych <= '>') goto yy125;
			goto yy8;
		}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy126;
		if (yych <= '>') goto yy128;
		goto yy8;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy130;
		if (yych <= '>') goto yy132;
		goto yy8;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy134;
		goto yy8;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy136;
		goto yy37;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy36:
		YYDEBUG(36, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy37:
		YYDEBUG(37, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		goto yy35;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy137;
		goto yy37;
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy139;
		goto yy37;
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_SEPARATOR;
}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy140;
		goto yy8;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy142;
		goto yy37;
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(45, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'q') {
			if (yych == 'b') goto yy143;
			goto yy37;
		} else {
			if (yych <= 'r') goto yy144;
			if (yych <= 's') goto yy145;
			goto yy37;
		}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy9,   &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy16,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy147, &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy148, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'k') {
			if (yych == 'a') goto yy149;
			goto yy37;
		} else {
			if (yych <= 'l') goto yy150;
			if (yych == 'o') goto yy151;
			goto yy37;
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'h') {
			if (yych == 'e') goto yy152;
			goto yy37;
		} else {
			if (yych <= 'i') goto yy153;
			if (yych == 'o') goto yy154;
			goto yy37;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy156, &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy157, &&yy158, &&yy159, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy160, &&yy37,
				&&yy161, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'n') {
			if (yych == 'i') goto yy162;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy163;
			if (yych == 'u') goto yy164;
			goto yy37;
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy165;
		if (yych == 'o') goto yy166;
		goto yy37;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'm') {
			if (yych == 'f') goto yy167;
			if (yych <= 'l') goto yy37;
			goto yy169;
		} else {
			if (yych <= 'n') goto yy170;
			if (yych == 's') goto yy171;
			goto yy37;
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy172;
		goto yy37;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy173;
		if (yych == 'e') goto yy174;
		goto yy37;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy175;
		if (yych == 'u') goto yy176;
		goto yy37;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy177;
		goto yy37;
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy178;
		if (yych == 'w') goto yy179;
		goto yy37;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy180;
		if (yych == 'r') goto yy181;
		goto yy37;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy182;
		if (yych == 's') goto yy183;
		goto yy37;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy184;
		goto yy37;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy185;
		goto yy37;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy186;
		goto yy37;
yy64:
		YYDEBUG(64, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy187;
		if (yych == '|') goto yy189;
		goto yy8;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy191;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_EQUAL;
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy73, &&yy73, &&yy73, &&yy73, &&yy71,
				&&yy73, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy73, &&yy73, &&yy73, &&yy73, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71
			};
			goto *yytarget[yych];
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MOD_EQUAL;
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy193;
		if (yych == '\r') goto yy194;
yy77:
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_AND;
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AND_EQUAL;
}
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy83:
		YYDEBUG(83, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy82, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy82, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy85, &&yy86, &&yy84, &&yy87, &&yy84, &&yy88, &&yy84,
				&&yy84, &&yy89, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy90,
				&&yy84, &&yy84, &&yy91, &&yy92, &&yy84, &&yy93, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84
			};
			goto *yytarget[yych];
		}
yy84:
		YYDEBUG(84, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy8;
				} else {
					goto yy26;
				}
			} else {
				goto yy35;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy108;
				} else {
					goto yy112;
				}
			} else {
				goto yy122;
			}
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy195;
		goto yy84;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy196;
		if (yych == 'o') goto yy197;
		goto yy84;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy198;
		goto yy84;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy199;
		goto yy84;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy200;
		goto yy84;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy201;
		goto yy84;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy202;
		goto yy84;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy203;
		goto yy84;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy204;
		goto yy84;
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MUL_EQUAL;
}
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INC;
}
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PLUS_EQUAL;
}
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(101, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEC;
}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MINUS_EQUAL;
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy108;
			if (yych <= '9') goto yy106;
		} else {
			if (yych <= 'E') goto yy115;
			if (yych == 'e') goto yy115;
		}
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONCAT_EQUAL;
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy205;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(114, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIV_EQUAL;
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy206;
			goto yy84;
		} else {
			if (yych <= '-') goto yy206;
			if (yych <= '/') goto yy84;
			if (yych <= '9') goto yy207;
			goto yy84;
		}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy209;
		}
		goto yy84;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy212;
		}
		goto yy84;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy215;
		goto yy84;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy122;
		if (yych <= '<') goto yy216;
		if (yych <= '=') goto yy218;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL;
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_SMALLER_OR_EQUAL;
}
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		goto yy70;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy220;
		YYDEBUG(127, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_EQUAL;
}
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(129, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_ARROW;
}
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_GREATER_OR_EQUAL;
}
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy222;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR;
}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy224;
		if (yych == '\r') goto yy225;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy226;
		goto yy37;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_OR;
}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy228;
		goto yy37;
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_XOR_EQUAL;
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy230, &&yy231, &&yy37,  &&yy232, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy233, &&yy234, &&yy235, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy236, &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy237, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy238;
		goto yy37;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy239;
		goto yy37;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AS;
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy240;
		goto yy84;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy241;
		goto yy37;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') {
			if (yych == 'l') goto yy242;
			goto yy37;
		} else {
			if (yych <= 's') goto yy243;
			if (yych <= 't') goto yy244;
			goto yy37;
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy245;
		if (yych == 'o') goto yy246;
		goto yy37;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy247;
		goto yy37;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy248;
		if (yych == 'f') goto yy249;
		goto yy37;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy250;
		goto yy37;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(155, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DO;
}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy252;
		goto yy37;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy253;
		goto yy37;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy254;
		goto yy37;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy255;
		goto yy37;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy256;
		goto yy37;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy257;
		if (yych == 't') goto yy258;
		goto yy37;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy259;
		goto yy37;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy260;
		goto yy37;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy262;
		goto yy37;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy263;
		goto yy37;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy264;
		goto yy37;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IF;
}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy265;
		goto yy37;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') {
			if (yych == 'c') goto yy266;
			goto yy37;
		} else {
			if (yych <= 's') goto yy267;
			if (yych <= 't') goto yy268;
			goto yy37;
		}
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy269;
		goto yy37;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy270;
		goto yy37;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy271;
		goto yy37;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy272;
		goto yy37;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy274;
		if (yych == 'o') goto yy275;
		goto yy37;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy276;
		goto yy37;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'q') goto yy277;
		if (yych == 't') goto yy278;
		goto yy37;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy279;
		goto yy37;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy280;
		goto yy37;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy281;
		goto yy37;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy282;
		if (yych == 'y') goto yy283;
		goto yy37;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy285;
		goto yy37;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy286;
		goto yy37;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy288;
		goto yy37;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy290;
		goto yy37;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy291;
		goto yy37;
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OR_EQUAL;
}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_OR;
}
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_IDENTICAL;
}
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		goto yy77;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy193;
		goto yy77;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy292;
		goto yy84;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy293;
		goto yy84;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy294;
		goto yy84;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy295;
		goto yy84;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy296;
		goto yy84;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy297;
		goto yy84;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'j') goto yy298;
		goto yy84;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy299;
		goto yy84;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy300;
		goto yy84;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy301;
		goto yy84;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy84;
			if (yych <= '\n') goto yy302;
			goto yy84;
		} else {
			if (yych <= '\r') goto yy302;
			if (yych == ' ') goto yy302;
			goto yy84;
		}
yy206:
		YYDEBUG(206, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy84;
		if (yych >= ':') goto yy84;
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yych <= '/') goto yy108;
		if (yych <= '9') goto yy207;
		goto yy108;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy209;
		}
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_LONG * 8) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(bin, NULL, 2);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_bin_strtod(bin, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy212;
		}
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(hex, NULL, 16);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy304;
		goto yy84;
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy216, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy216, &&yy84,  &&yy305, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy306,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy307,
				&&yy84,  &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307
			};
			goto *yytarget[yych];
		}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL_EQUAL;
}
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_IDENTICAL;
}
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR_EQUAL;
}
yy224:
		YYDEBUG(224, *YYCURSOR);
		++YYCURSOR;
		goto yy135;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy224;
		goto yy135;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_AND;
}
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_XOR;
}
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy309;
		goto yy37;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy310;
		goto yy37;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy311;
		if (yych == 'U') goto yy312;
		goto yy37;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy313;
		goto yy37;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy314;
		goto yy37;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy315;
		goto yy37;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy316;
		goto yy37;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy317;
		goto yy37;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy318;
		goto yy37;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy319;
		goto yy37;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy216;
		goto yy84;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy320;
		goto yy37;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy321;
		goto yy37;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy322;
		goto yy37;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy324;
		goto yy37;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy325;
		goto yy37;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy326;
		goto yy37;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') goto yy37;
		if (yych <= 's') goto yy327;
		if (yych <= 't') goto yy328;
		goto yy37;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy329;
		goto yy37;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy330;
		goto yy37;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy331;
		goto yy37;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy333;
		goto yy37;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy335;
		goto yy37;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy336, &&yy37,  &&yy337, &&yy37,
				&&yy37,  &&yy338, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy339, &&yy37,  &&yy37,  &&yy37,  &&yy340,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy341;
		goto yy37;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy343;
		goto yy37;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy345;
		goto yy37;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy346;
		goto yy37;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy261, &&yy261, &&yy261, &&yy261, &&yy261, &&yy261,
				&&yy261, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy261, &&yy261, &&yy261, &&yy261, &&yy36,
				&&yy261, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy347, &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy261, &&yy261, &&yy261, &&yy261, &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36
			};
			goto *yytarget[yych];
		}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOR;
}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy348;
		goto yy37;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy349;
		goto yy37;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy350;
		goto yy37;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy352;
		goto yy37;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy353;
		goto yy37;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy354;
		goto yy37;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy355;
		goto yy37;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy356;
		goto yy37;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy357;
		goto yy37;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy359;
		goto yy37;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(273, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NEW;
}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy360;
		if (yych == 'v') goto yy361;
		goto yy37;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy362;
		goto yy37;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy363;
		goto yy37;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy364;
		goto yy37;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy365;
		goto yy37;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy366;
		goto yy37;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy367;
		goto yy37;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy368;
		goto yy37;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy369;
		goto yy37;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(284, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRY;
}
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy370;
		goto yy37;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(287, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_USE;
}
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_VAR;
}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy371;
		goto yy37;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy372;
		goto yy37;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy373;
		goto yy84;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy374;
		goto yy84;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy375;
		goto yy84;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy376;
		goto yy84;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy377;
		goto yy84;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy382;
		goto yy379;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy383;
		goto yy84;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy384;
		goto yy84;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy386;
		goto yy84;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy387;
		goto yy84;
yy302:
		YYDEBUG(302, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(303, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy112;
			if (yych <= '\n') goto yy302;
			goto yy112;
		} else {
			if (yych <= '\r') goto yy302;
			if (yych == ' ') goto yy302;
			goto yy112;
		}
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy388;
		goto yy84;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy84;
		if (yych <= '/') goto yy390;
		if (yych <= '9') goto yy84;
		goto yy390;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy84;
		if (yych <= '/') goto yy392;
		if (yych <= '9') goto yy84;
		goto yy392;
yy307:
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(308, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy393, &&yy84,  &&yy84,  &&yy395, &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy307,
				&&yy84,  &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307,
				&&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307, &&yy307
			};
			goto *yytarget[yych];
		}
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy396;
		goto yy37;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy397;
		goto yy37;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy398;
		goto yy37;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy399;
		goto yy37;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy400;
		goto yy37;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy401;
		goto yy37;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy402;
		goto yy37;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy403;
		goto yy37;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy404;
		goto yy37;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy405;
		goto yy37;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy406;
		goto yy37;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'k') goto yy408;
		goto yy37;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy410;
		goto yy37;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(323, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CASE;
}
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy411;
		goto yy37;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy413;
		goto yy37;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy415;
		goto yy37;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy417;
		goto yy37;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy419;
		goto yy37;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy420;
		goto yy37;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy421;
		goto yy37;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(332, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ECHO;
}
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy334, &&yy334, &&yy334, &&yy334, &&yy334, &&yy334,
				&&yy334, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy334, &&yy334, &&yy334, &&yy334, &&yy36,
				&&yy334, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy422, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy334, &&yy334, &&yy334, &&yy334, &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36
			};
			goto *yytarget[yych];
		}
yy334:
		YYDEBUG(334, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSE;
}
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy423;
		goto yy37;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy425;
		goto yy37;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy426;
		goto yy37;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy427;
		goto yy37;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy429;
		goto yy37;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy430;
		goto yy37;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(342, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EVAL;
}
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(344, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy431;
		goto yy37;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy432;
		goto yy37;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy434;
		goto yy37;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy435;
		goto yy37;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy436;
		goto yy37;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(351, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GOTO;
}
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy437;
		goto yy37;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy438;
		goto yy37;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy439;
		if (yych == 'e') goto yy440;
		goto yy37;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy441;
		goto yy37;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy442;
		goto yy37;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(358, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LIST;
}
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy444;
		goto yy37;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy445;
		goto yy37;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy447;
		goto yy37;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy448;
		goto yy37;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy449;
		goto yy37;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy450;
		goto yy37;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy451;
		goto yy37;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy452;
		goto yy37;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy453;
		goto yy37;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy454;
		goto yy37;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy456;
		goto yy37;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy458;
		goto yy37;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy460;
		goto yy37;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy462;
		goto yy37;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy464;
		goto yy84;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy466;
		goto yy84;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy471;
		goto yy468;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy472;
		goto yy84;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy384;
		goto yy84;
yy378:
		YYDEBUG(378, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy379:
		YYDEBUG(379, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy378;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy378;
			if (yych != ')') goto yy84;
		}
		YYDEBUG(380, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(381, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INT_CAST;
}
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'g') goto yy473;
		goto yy84;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy474;
		goto yy84;
yy384:
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(385, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy384;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy384;
			if (yych == ')') goto yy475;
			goto yy84;
		}
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy477;
		goto yy84;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy478;
		goto yy84;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy480;
		goto yy84;
yy389:
		YYDEBUG(389, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy390:
		YYDEBUG(390, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy481, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy389,
				&&yy84,  &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389
			};
			goto *yytarget[yych];
		}
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy392:
		YYDEBUG(392, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy481,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy391,
				&&yy84,  &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391
			};
			goto *yytarget[yych];
		}
yy393:
		YYDEBUG(393, *YYCURSOR);
		++YYCURSOR;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy393;
		goto yy394;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy482;
		goto yy37;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy483;
		goto yy37;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy484;
		goto yy37;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy485;
		goto yy37;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy486;
		goto yy37;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy487;
		goto yy37;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy488;
		goto yy37;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy489;
		goto yy37;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy490;
		goto yy37;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy491;
		goto yy37;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(407, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY;
}
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(409, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BREAK;
}
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy492;
		goto yy37;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(412, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CATCH;
}
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(414, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS;
}
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(416, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLONE;
}
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(418, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONST;
}
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy493;
		goto yy37;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy494;
		goto yy37;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy495;
		goto yy37;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy496;
		goto yy37;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(424, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EMPTY;
}
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy498;
		goto yy37;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy499;
		goto yy37;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(428, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDIF;
}
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy501;
		goto yy37;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy502;
		goto yy37;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy503;
		goto yy37;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy433, &&yy433, &&yy433, &&yy433, &&yy433, &&yy433,
				&&yy433, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy433, &&yy433, &&yy433, &&yy433, &&yy36,
				&&yy433, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy504, &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy433, &&yy433, &&yy433, &&yy433, &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36
			};
			goto *yytarget[yych];
		}
yy433:
		YYDEBUG(433, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINAL;
}
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy505;
		goto yy37;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy506;
		goto yy37;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy507;
		goto yy37;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy509;
		goto yy37;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy510;
		goto yy37;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy511;
		goto yy37;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy512;
		goto yy37;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy513;
		goto yy37;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(443, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ISSET;
}
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy514;
		goto yy37;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(446, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRINT;
}
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy515;
		goto yy37;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy516;
		goto yy37;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy517;
		goto yy37;
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy519;
		goto yy37;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy520;
		goto yy37;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy522;
		goto yy37;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy524;
		goto yy37;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(455, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_THROW;
}
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(457, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT;
}
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(459, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET;
}
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(461, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_WHILE;
}
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(463, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_YIELD;
}
yy464:
		YYDEBUG(464, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(465, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy464;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy464;
			if (yych == ')') goto yy526;
			goto yy84;
		}
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy528;
		goto yy84;
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy468:
		YYDEBUG(468, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy467;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy467;
			if (yych != ')') goto yy84;
		}
		YYDEBUG(469, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(470, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOL_CAST;
}
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy530;
		goto yy84;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy384;
		goto yy84;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy531;
		goto yy84;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy532;
		goto yy84;
yy475:
		YYDEBUG(475, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(476, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_CAST;
}
yy477:
		YYDEBUG(477, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'g') goto yy528;
		goto yy84;
yy478:
		YYDEBUG(478, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(479, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy478;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy478;
			if (yych == ')') goto yy534;
			goto yy84;
		}
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy536;
		goto yy84;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy393;
		if (yych == '\r') goto yy395;
		goto yy84;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy537;
		goto yy37;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy538;
		goto yy37;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy540;
		goto yy37;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy541;
		goto yy37;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy542;
		goto yy37;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy543;
		goto yy37;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy544;
		goto yy37;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy545;
		goto yy37;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy546;
		goto yy37;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy547;
		goto yy37;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy548;
		goto yy37;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy549;
		goto yy37;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy550;
		goto yy37;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy552;
		goto yy37;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(497, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSEIF;
}
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy554;
		goto yy37;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy500, &&yy500, &&yy500, &&yy500, &&yy500, &&yy500,
				&&yy500, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy500, &&yy500, &&yy500, &&yy500, &&yy36,
				&&yy500, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy555, &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy500, &&yy500, &&yy500, &&yy500, &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36
			};
			goto *yytarget[yych];
		}
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOR;
}
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy556;
		goto yy37;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy557;
		goto yy37;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy558;
		goto yy37;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy560;
		goto yy37;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy562;
		goto yy37;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy564;
		goto yy37;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(508, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GLOBAL;
}
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy565;
		goto yy37;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy566;
		goto yy37;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy568;
		goto yy37;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy569;
		goto yy37;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy570;
		goto yy37;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy571;
		goto yy37;
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy572;
		goto yy37;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy574;
		goto yy37;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PUBLIC;
}
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy575;
		goto yy37;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(521, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_RETURN;
}
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(523, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STATIC;
}
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(525, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SWITCH;
}
yy526:
		YYDEBUG(526, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(527, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY_CAST;
}
yy528:
		YYDEBUG(528, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(529, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy528;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy528;
			if (yych == ')') goto yy577;
			goto yy84;
		}
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy467;
		goto yy84;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy378;
		goto yy84;
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(533, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy84;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych == ')') goto yy579;
			goto yy84;
		}
yy534:
		YYDEBUG(534, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(535, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET_CAST;
}
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy581;
		goto yy84;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy583;
		goto yy37;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(539, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy584;
		goto yy37;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy586;
		goto yy37;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy587;
		goto yy37;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy589;
		goto yy37;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy590;
		goto yy37;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy591;
		goto yy37;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy592;
		goto yy37;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy593;
		goto yy37;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy595;
		goto yy37;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy597;
		goto yy37;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(551, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DECLARE;
}
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(553, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEFAULT;
}
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy599;
		goto yy37;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy600;
		goto yy37;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy601;
		goto yy37;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy602;
		goto yy37;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(559, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXTENDS;
}
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(561, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINALLY;
}
yy562:
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOREACH;
}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy604;
		goto yy37;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy606;
		goto yy37;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy567, &&yy567, &&yy567, &&yy567, &&yy567, &&yy567,
				&&yy567, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy567, &&yy567, &&yy567, &&yy567, &&yy607,
				&&yy567, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy567, &&yy567, &&yy567, &&yy567, &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36
			};
			goto *yytarget[yych];
		}
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE;
}
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy608;
		goto yy37;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy609;
		goto yy37;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy610;
		goto yy37;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy611;
		goto yy37;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(573, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRIVATE;
}
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy612;
		goto yy37;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy576, &&yy576, &&yy576, &&yy576, &&yy576, &&yy576,
				&&yy576, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy576, &&yy576, &&yy576, &&yy576, &&yy613,
				&&yy576, &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy576, &&yy576, &&yy576, &&yy576, &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,
				&&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36,  &&yy36
			};
			goto *yytarget[yych];
		}
yy576:
		YYDEBUG(576, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE;
}
yy577:
		YYDEBUG(577, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(578, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STRING_CAST;
}
yy579:
		YYDEBUG(579, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(580, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_CAST;
}
yy581:
		YYDEBUG(581, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(582, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy581, &&yy581, &&yy84,  &&yy84,  &&yy581, &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy581, &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy134, &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,
				&&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84,  &&yy84
			};
			goto *yytarget[yych];
		}
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy614;
		goto yy37;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy616;
		goto yy37;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(588, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy617;
		goto yy37;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy618;
		goto yy37;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy619;
		goto yy37;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy621;
		goto yy37;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(594, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ABSTRACT;
}
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(596, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
 return T_CALLABLE;
}
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONTINUE;
}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy622;
		goto yy37;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy623;
		goto yy37;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy624;
		goto yy37;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(603, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDWHILE;
}
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(605, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNCTION;
}
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy626;
		goto yy37;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy627;
		goto yy37;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy628;
		goto yy37;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy629;
		goto yy37;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy631;
		goto yy37;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy633;
		goto yy37;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy635;
		goto yy37;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy637;
		goto yy37;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *class_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT ==
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		/* We create a special __CLASS__ constant that is going to be resolved
		   at run-time */
		zendlval->value.str.len = sizeof("__CLASS__")-1;
		zendlval->value.str.val = estrndup("__CLASS__", zendlval->value.str.len);
		zendlval->type = IS_CONSTANT;
	} else {
		if (CG(active_class_entry)) {
			class_name = CG(active_class_entry)->name;
		}
		
		if (!class_name) {
			class_name = "";
		}
		
		zendlval->value.str.len = strlen(class_name);
		zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
		zendlval->type = IS_STRING;
	}
	return T_CLASS_C;
}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy638;
		goto yy37;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy639;
		goto yy37;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy641;
		goto yy37;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(620, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *trait_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT == 
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		trait_name = CG(active_class_entry)->name;
	}
	
	if (!trait_name) {
		trait_name = "";
	}
	
	zendlval->value.str.len = strlen(trait_name);
	zendlval->value.str.val = estrndup(trait_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	
	return T_TRAIT_C;
}
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy642;
		goto yy37;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy643;
		goto yy37;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy645;
		goto yy37;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDSWITCH;
}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy647;
		goto yy37;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy649;
		goto yy37;
yy628:
		YYDEBUG(628, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy650;
		goto yy37;
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(630, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
        return T_INSTEADOF;
}
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(632, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INTERFACE;
}
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(634, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NAMESPACE;
}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PROTECTED;
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy652;
		goto yy37;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy653;
		goto yy37;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(640, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	const char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy654;
		goto yy37;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy655;
		goto yy37;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(644, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDDECLARE;
}
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOREACH;
}
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(648, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IMPLEMENTS;
}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy656;
		goto yy37;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(651, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INSTANCEOF;
}
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy657;
		goto yy37;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy658;
		goto yy37;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy660;
		goto yy37;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy661;
		goto yy37;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy662;
		goto yy37;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy664;
		goto yy37;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(659, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy666;
		goto yy37;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy668;
		goto yy37;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(663, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE_ONCE;
}
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(665, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE_ONCE;
}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(667, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy37;
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy37;
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy36;
		}
		YYDEBUG(671, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_HALT_COMPILER;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(672, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy676, &&yy676, &&yy674, &&yy674, &&yy676, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy676, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy679, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy674, &&yy674, &&yy674, &&yy674, &&yy680,
				&&yy674, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy674, &&yy674, &&yy674, &&yy674, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680,
				&&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680, &&yy680
			};
			goto *yytarget[yych];
		}
yy674:
		YYDEBUG(674, *YYCURSOR);
		++YYCURSOR;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(677, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy676;
		}
		YYDEBUG(678, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy683;
		goto yy675;
yy680:
		YYDEBUG(680, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(681, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy680;
		}
		YYDEBUG(682, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy683:
		YYDEBUG(683, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(684, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_OPERATOR;
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(685, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy689;
		} else {
			if (yych <= '`') goto yy690;
			if (yych == '{') goto yy692;
		}
		YYDEBUG(687, *YYCURSOR);
		++YYCURSOR;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688, &&yy688,
				&&yy688, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy688, &&yy688, &&yy688, &&yy688, &&yy693,
				&&yy688, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy696, &&yy688, &&yy688, &&yy688, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693,
				&&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693, &&yy693
			};
			goto *yytarget[yych];
		}
yy690:
		YYDEBUG(690, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy698;
		goto yy688;
yy693:
		YYDEBUG(693, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(694, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy693;
		}
		if (yych == '-') goto yy700;
		if (yych <= '@') goto yy695;
		if (yych <= '[') goto yy702;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy696:
		YYDEBUG(696, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(697, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy698:
		YYDEBUG(698, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(699, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy704;
yy701:
		YYDEBUG(701, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy695;
yy702:
		YYDEBUG(702, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(703, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy701;
			if (yych <= 'Z') goto yy705;
			if (yych <= '^') goto yy701;
		} else {
			if (yych <= '`') goto yy701;
			if (yych <= 'z') goto yy705;
			if (yych <= '~') goto yy701;
		}
yy705:
		YYDEBUG(705, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(706, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(707, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy711;
		} else {
			if (yych <= '$') goto yy713;
			if (yych == '{') goto yy714;
		}
		YYDEBUG(709, *YYCURSOR);
		++YYCURSOR;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy711:
		YYDEBUG(711, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(712, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710, &&yy710,
				&&yy710, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy710, &&yy710, &&yy710, &&yy710, &&yy715,
				&&yy710, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy718, &&yy710, &&yy710, &&yy710, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715
			};
			goto *yytarget[yych];
		}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy720;
		goto yy710;
yy715:
		YYDEBUG(715, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(716, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy715;
		}
		if (yych == '-') goto yy722;
		if (yych <= '@') goto yy717;
		if (yych <= '[') goto yy724;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy718:
		YYDEBUG(718, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(719, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy720:
		YYDEBUG(720, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(721, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy726;
yy723:
		YYDEBUG(723, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy717;
yy724:
		YYDEBUG(724, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy723;
			if (yych <= 'Z') goto yy727;
			if (yych <= '^') goto yy723;
		} else {
			if (yych <= '`') goto yy723;
			if (yych <= 'z') goto yy727;
			if (yych <= '~') goto yy723;
		}
yy727:
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(728, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(729, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy733;
		if (yych == '{') goto yy734;
		YYDEBUG(731, *YYCURSOR);
		++YYCURSOR;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy732, &&yy732, &&yy732, &&yy732, &&yy735,
				&&yy732, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy738, &&yy732, &&yy732, &&yy732, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735
			};
			goto *yytarget[yych];
		}
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy740;
		goto yy732;
yy735:
		YYDEBUG(735, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(736, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy735;
		}
		if (yych == '-') goto yy742;
		if (yych <= '@') goto yy737;
		if (yych <= '[') goto yy744;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy738:
		YYDEBUG(738, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(739, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy740:
		YYDEBUG(740, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(741, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy746;
yy743:
		YYDEBUG(743, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy737;
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy743;
			if (yych <= 'Z') goto yy747;
			if (yych <= '^') goto yy743;
		} else {
			if (yych <= '`') goto yy743;
			if (yych <= 'z') goto yy747;
			if (yych <= '~') goto yy743;
		}
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(748, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(749, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy751;
			if (yych <= 'Z') goto yy753;
			if (yych >= '_') goto yy753;
		} else {
			if (yych <= '`') goto yy751;
			if (yych <= 'z') goto yy753;
			if (yych >= 0x7F) goto yy753;
		}
yy751:
		YYDEBUG(751, *YYCURSOR);
		++YYCURSOR;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
yy753:
		YYDEBUG(753, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy752, &&yy752, &&yy752, &&yy755,
				&&yy752, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy752, &&yy752, &&yy755, &&yy752, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755,
				&&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755, &&yy755
			};
			goto *yytarget[yych];
		}
yy754:
		YYDEBUG(754, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy755:
		YYDEBUG(755, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy754;
		}
		if (yych <= '@') goto yy756;
		if (yych <= '[') goto yy757;
		if (yych == '}') goto yy757;
yy756:
		YYDEBUG(756, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy752;
yy757:
		YYDEBUG(757, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(758, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(759, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761,
				&&yy761, &&yy763, &&yy763, &&yy761, &&yy761, &&yy763, &&yy761, &&yy761,
				&&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761,
				&&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761,
				&&yy763, &&yy765, &&yy765, &&yy763, &&yy767, &&yy765, &&yy765, &&yy763,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy768, &&yy770, &&yy770, &&yy770, &&yy770, &&yy770, &&yy770, &&yy770,
				&&yy770, &&yy770, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy765, &&yy763, &&yy775, &&yy765, &&yy772,
				&&yy765, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy765, &&yy765, &&yy765, &&yy765, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772,
				&&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772, &&yy772
			};
			goto *yytarget[yych];
		}
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy763:
		YYDEBUG(763, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(764, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy765:
		YYDEBUG(765, *YYCURSOR);
		++YYCURSOR;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy767:
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy766;
			if (yych <= 'Z') goto yy777;
			if (yych <= '^') goto yy766;
			goto yy777;
		} else {
			if (yych <= '`') goto yy766;
			if (yych <= 'z') goto yy777;
			if (yych <= '~') goto yy766;
			goto yy777;
		}
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'a') {
			if (yych <= '/') goto yy769;
			if (yych <= '9') goto yy780;
		} else {
			if (yych <= 'b') goto yy783;
			if (yych == 'x') goto yy785;
		}
yy769:
		YYDEBUG(769, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
yy770:
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(771, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy770;
		}
		goto yy769;
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(773, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy772;
		}
		YYDEBUG(774, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy775:
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(778, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy779, &&yy779, &&yy779, &&yy779, &&yy777,
				&&yy779, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy779, &&yy779, &&yy779, &&yy779, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777
			};
			goto *yytarget[yych];
		}
yy779:
		YYDEBUG(779, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(781, *YYCURSOR);
		if (yych <= '/') goto yy782;
		if (yych <= '9') goto yy780;
yy782:
		YYDEBUG(782, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
yy783:
		YYDEBUG(783, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy786;
		}
yy784:
		YYDEBUG(784, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy769;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy788;
		}
		goto yy784;
yy786:
		YYDEBUG(786, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(787, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy786;
		}
		goto yy782;
yy788:
		YYDEBUG(788, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(789, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy788;
		}
		goto yy782;
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(790, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych == '<') goto yy794;
		YYDEBUG(792, *YYCURSOR);
		++YYCURSOR;
yy793:
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy794:
		YYDEBUG(794, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '>') {
			if (yych != '%') goto yy793;
		} else {
			if (yych <= '?') goto yy797;
			if (yych == 's') goto yy799;
			goto yy793;
		}
		YYDEBUG(795, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy801;
		YYDEBUG(796, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy797:
		YYDEBUG(797, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '=') goto yy803;
		if (yych == 'p') goto yy805;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy806;
yy800:
		YYDEBUG(800, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy793;
		} else {
			goto yy798;
		}
yy801:
		YYDEBUG(801, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(802, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
yy803:
		YYDEBUG(803, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(804, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy805:
		YYDEBUG(805, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy807;
		goto yy800;
yy806:
		YYDEBUG(806, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy808;
		goto yy800;
yy807:
		YYDEBUG(807, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy809;
		goto yy800;
yy808:
		YYDEBUG(808, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy810;
		goto yy800;
yy809:
		YYDEBUG(809, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy800;
			if (yych <= '\n') goto yy811;
			goto yy800;
		} else {
			if (yych <= '\r') goto yy813;
			if (yych == ' ') goto yy811;
			goto yy800;
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy814;
		goto yy800;
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy813:
		YYDEBUG(813, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy811;
		goto yy812;
yy814:
		YYDEBUG(814, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy800;
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy800;
		goto yy817;
yy816:
		YYDEBUG(816, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy817:
		YYDEBUG(817, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy816;
		}
		if (yych != 'l') goto yy800;
		YYDEBUG(818, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy800;
		YYDEBUG(819, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy800;
		YYDEBUG(820, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy800;
		YYDEBUG(821, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy800;
		YYDEBUG(822, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy800;
		YYDEBUG(823, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy800;
		YYDEBUG(824, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy800;
yy825:
		YYDEBUG(825, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(826, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy825, &&yy825, &&yy800, &&yy800, &&yy825, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy825, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy827, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800
			};
			goto *yytarget[yych];
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(828, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy827, &&yy827, &&yy800, &&yy800, &&yy827, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy827, &&yy800, &&yy829, &&yy800, &&yy800, &&yy800, &&yy800, &&yy830,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy831, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800
			};
			goto *yytarget[yych];
		}
yy829:
		YYDEBUG(829, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy832;
		goto yy800;
yy830:
		YYDEBUG(830, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy833;
		goto yy800;
yy831:
		YYDEBUG(831, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy834;
		goto yy800;
yy832:
		YYDEBUG(832, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy835;
		goto yy800;
yy833:
		YYDEBUG(833, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy836;
		goto yy800;
yy834:
		YYDEBUG(834, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy837;
		goto yy800;
yy835:
		YYDEBUG(835, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy839;
		goto yy800;
yy836:
		YYDEBUG(836, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy840;
		goto yy800;
yy837:
		YYDEBUG(837, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(838, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy837, &&yy837, &&yy800, &&yy800, &&yy837, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy837, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy841, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800,
				&&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800, &&yy800
			};
			goto *yytarget[yych];
		}
yy839:
		YYDEBUG(839, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy837;
		goto yy800;
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy837;
		goto yy800;
yy841:
		YYDEBUG(841, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(842, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	YYCTYPE *bracket = (YYCTYPE*)zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(843, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(845, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(846, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(847, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(849, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(850, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
}

}
real_world/php20140822_zend_language_scanner.re:1017:12: warning: escape has no effect: '\[' [-Wuseless-escape]
real_world/php20140822_zend_language_scanner.re:1007:0: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
