# Make Unix man pages from Netpbm HTML user manual

MAKEMAN = makeman

MANDIR = /usr/share/man/

# These can convert to man pages cleanly
MAN1 = \
	411toppm.1 \
	anytopnm.1 \
	asciitopgm.1 \
	atktopbm.1 \
	bioradtopgm.1 \
	bmptopnm.1 \
	bmptoppm.1 \
	brushtopbm.1 \
	cameratopam.1 \
	cmuwmtopbm.1 \
	ddbugtopbm.1 \
	escp2topbm.1 \
	eyuvtoppm.1 \
	fiascotopnm.1 \
	fitstopnm.1 \
	fstopgm.1 \
	g3topbm.1 \
	gemtopbm.1 \
	gemtopnm.1 \
	giftopnm.1 \
	gouldtoppm.1 \
	hdifftopam.1 \
	hipstopgm.1 \
	hpcdtoppm.1 \
	icontopbm.1 \
	ilbmtoppm.1 \
	imgtoppm.1 \
	infotopam.1 \
	jbigtopnm.1 \
	jpeg2ktopam.1 \
	jpegtopnm.1 \
	leaftoppm.1 \
	lispmtopgm.1 \
	macptopbm.1 \
	manweb.1 \
	mdatopbm.1 \
	mgrtopbm.1 \
	mrf.1 \
	mrftopbm.1 \
	mtvtoppm.1 \
	neotoppm.1 \
	palmtopnm.1 \
	pamarith.1 \
	pamchannel.1 \
	pamcomp.1 \
	pamcut.1 \
	pamdeinterlace.1 \
	pamdice.1 \
	pamditherbw.1 \
	pamedge.1 \
	pamendian.1 \
	pamfile.1 \
	pamfixtrunc.1 \
	pamflip.1 \
	pamfunc.1 \
	pamgauss.1 \
	pamlookup.1 \
	pamoil.1 \
	pamperspective.1 \
	pampop9.1 \
	pamscale.1 \
	pamseq.1 \
	pamsharpmap.1 \
	pamsharpness.1 \
	pamslice.1 \
	pamstack.1 \
	pamstereogram.1 \
	pamstretch-gen.1 \
	pamstretch.1 \
	pamsumm.1 \
	pamsummcol.1 \
	pamtodjvurle.1 \
	pamtohdiff.1 \
	pamtohtmltbl.1 \
	pamtojpeg2k.1 \
	pamtopfm.1 \
	pamtopnm.1 \
	pamtotga.1 \
	pamtouil.1 \
	pbmclean.1 \
	pbmlife.1 \
	pbmmake.1 \
	pbmmask.1 \
	pbmpage.1 \
	pbmpscale.1 \
	pbmreduce.1 \
	pbmtext.1 \
	pbmtextps.1 \
	pbmto10x.1 \
	pbmto4425.1 \
	pbmtoascii.1 \
	pbmtoatk.1 \
	pbmtobbnbg.1 \
	pbmtocmuwm.1 \
	pbmtodjvurle.1 \
	pbmtoepsi.1 \
	pbmtoepson.1 \
	pbmtoescp2.1 \
	pbmtog3.1 \
	pbmtogem.1 \
	pbmtogo.1 \
	pbmtoicon.1 \
	pbmtolj.1 \
	pbmtoln03.1 \
	pbmtolps.1 \
	pbmtomacp.1 \
	pbmtomda.1 \
	pbmtomgr.1 \
	pbmtomrf.1 \
	pbmtonokia.1 \
	pbmtopgm.1 \
	pbmtopi3.1 \
	pbmtopk.1 \
	pbmtoplot.1 \
	pbmtoppa.1 \
	pbmtopsg3.1 \
	pbmtoptx.1 \
	pbmtowbmp.1 \
	pbmtox10bm.1 \
	pbmtoxbm.1 \
	pbmtoybm.1 \
	pbmtozinc.1 \
	pbmupc.1 \
	pc1toppm.1 \
	pcdovtoppm.1 \
	pcxtoppm.1 \
	pfmtopam.1 \
	pgmabel.1 \
	pgmbentley.1 \
	pgmcrater.1 \
	pgmedge.1 \
	pgmenhance.1 \
	pgmhist.1 \
	pgmkernel.1 \
	pgmminkowski.1 \
	pgmmorphconv.1 \
	pgmnoise.1 \
	pgmnorm.1 \
	pgmoil.1 \
	pgmramp.1 \
	pgmslice.1 \
	pgmtexture.1 \
	pgmtofs.1 \
	pgmtolispm.1 \
	pgmtopbm.1 \
	pgmtopgm.1 \
	pgmtoppm.1 \
	pi1toppm.1 \
	pi3topbm.1 \
	picttoppm.1 \
	pjtoppm.1 \
	pktopbm.1 \
	pngtopnm.1 \
	pnmalias.1 \
	pnmarith.1 \
	pnmcat.1 \
	pnmcolormap.1 \
	pnmcomp.1 \
	pnmconvol.1 \
	pnmcrop.1 \
	pnmcut.1 \
	pnmdepth.1 \
	pnmenlarge.1 \
	pnmfile.1 \
	pnmgamma.1 \
	pnmhisteq.1 \
	pnmhistmap.1 \
	pnmindex.1 \
	pnminterp.1 \
	pnminvert.1 \
	pnmmargin.1 \
	pnmmontage.1 \
	pnmnlfilt.1 \
	pnmnoraw.1 \
	pnmnorm.1 \
	pnmpad.1 \
	pnmpaste.1 \
	pnmpsnr.1 \
	pnmquant.1 \
	pnmremap.1 \
	pnmrotate.1 \
	pnmscale.1 \
	pnmscalefixed.1 \
	pnmshear.1 \
	pnmsmooth.1 \
	pnmsplit.1 \
	pnmstitch.1 \
	pnmtile.1 \
	pnmtoddif.1 \
	pnmtofiasco.1 \
	pnmtofits.1 \
	pnmtojbig.1 \
	pnmtojpeg.1 \
	pnmtopalm.1 \
	pnmtopclxl.1 \
	pnmtoplainpnm.1 \
	pnmtopng.1 \
	pnmtopnm.1 \
	pnmtops.1 \
	pnmtorast.1 \
	pnmtorle.1 \
	pnmtosgi.1 \
	pnmtosir.1 \
	pnmtotiff.1 \
	pnmtotiffcmyk.1 \
	pnmtoxwd.1 \
	ppm3d.1 \
	ppmbrighten.1 \
	ppmchange.1 \
	ppmcie.1 \
	ppmcolormask.1 \
	ppmdim.1 \
	ppmdist.1 \
	ppmdither.1 \
	ppmfade.1 \
	ppmflash.1 \
	ppmforge.1 \
	ppmglobe.1 \
	ppmhist.1 \
	ppmlabel.1 \
	ppmmake.1 \
	ppmmix.1 \
	ppmnorm.1 \
	ppmntsc.1 \
	ppmpat.1 \
	ppmquant.1 \
	ppmquantall.1 \
	ppmrainbow.1 \
	ppmrelief.1 \
	ppmrough.1 \
	ppmshadow.1 \
	ppmshift.1 \
	ppmspread.1 \
	ppmsvgalib.1 \
	ppmtoacad.1 \
	ppmtoarbtxt.1 \
	ppmtobmp.1 \
	ppmtoeyuv.1 \
	ppmtoicr.1 \
	ppmtoilbm.1 \
	ppmtojpeg.1 \
	ppmtoleaf.1 \
	ppmtolj.1 \
	ppmtomap.1 \
	ppmtomitsu.1 \
	ppmtompeg.1 \
	ppmtoneo.1 \
	ppmtopcx.1 \
	ppmtopgm.1 \
	ppmtopi1.1 \
	ppmtopict.1 \
	ppmtopj.1 \
	ppmtopjxl.1 \
	ppmtoppm.1 \
	ppmtopuzz.1 \
	ppmtorgb3.1 \
	ppmtosixel.1 \
	ppmtoterm.1 \
	ppmtotga.1 \
	ppmtouil.1 \
	ppmtowinicon.1 \
	ppmtoxpm.1 \
	ppmtoyuv.1 \
	ppmtoyuvsplit.1 \
	ppmtv.1 \
	ppmwheel.1 \
	psidtopgm.1 \
	pstopnm.1 \
	qrttoppm.1 \
	rasttopnm.1 \
	rawtopgm.1 \
	rawtoppm.1 \
	rgb3toppm.1 \
	rletopnm.1 \
	sbigtopgm.1 \
	sgitopnm.1 \
	sirtopnm.1 \
	sldtoppm.1 \
	spctoppm.1 \
	spottopgm.1 \
	sputoppm.1 \
	tgatoppm.1 \
	thinkjettopbm.1 \
	tifftopnm.1 \
	vidtoppm.1 \
	wbmptopbm.1 \
	winicontoppm.1 \
	xbmtopbm.1 \
	ximtoppm.1 \
	xpmtoppm.1 \
	xvminitoppm.1 \
	xwdtopnm.1 \
	ybmtopbm.1 \
	yuvsplittoppm.1 \
	yuvtoppm.1 \
	zeisstopnm.1 \
        pamaddnoise.1 \
        pambackground.1 \
        pambayer.1 \
        pamdepth.1 \
        pamenlarge.1 \
        pamgradient.1 \
        pammasksharpen.1 \
        pammixinterlace.1 \
        pampick.1 \
        pamrgbatopng.1 \
        pamsplit.1 \
        pamthreshold.1 \
        pamtilt.1 \
        pamtofits.1 \
        pamtogif.1 \
        pamtosvg.1 \
        pamtotiff.1 \
        pamtoxvmini.1 \
        pamx.1 \
        pbmtoibm23xx.1 \
        pbmtomatrixorbital.1 \
        pgmdeshadow.1 \
        pgmmake.1 \
        pgmmedian.1 \
        ppmdcfont.1 \
        ppmddumpfont.1 \
        ppmdmkfont.1 \
        ppmdraw.1 \
        rlatopam.1 \

MAN3 = \
	libnetpbm.3 \
	libnetpbm_image.3 \
	libnetpbm_ug.3 \
	libpbm.3 \
	libpgm.3 \
	libpm.3 \
	libpnm.3 \
	libppm.3 \
	libsystem.3 \
	libtmpfile.3 \

MAN5 = \
	extendedopacity.5 \
	pam.5 \
	pbm.5 \
        pfm.5 \
	pgm.5 \
	pnm.5 \
	ppm.5 \

# These things do get converted to man pages and installed.
MANPAGES = netpbm.1 $(MAN1) $(MAN3) $(MAN5)
HTMLMANUALS = $(MAN1:.1=.html) $(MAN3:.3=.html) $(MAN5:.5=.html)

# These things don't get converted to manual pages.
EXCEPTIONS = directory.html libnetpbm_dir.html libnetpbm_draw.html error.html
STUBS = pcdindex.1 ppmcolors.1 pnmflip.1 ppmtogif.1

# This works if you've done a full SVN checkout.
USERGUIDE= ../../userguide

XML = $(HTMLMANUALS:.html=.xml) netpbm.xml

# List everything in the userguide directory that is not categorized above.
# Use this to check that 'make manpages' converts as much as possible
# of the HTML documentation.
uncategorized:
	@echo $(HTMLMANUALS) $(EXCEPTIONS) $(STUBS) | tr " " "\n" | sort >LIST1
	@(cd $(USERGUIDE); ls | sort) >LIST2
	@comm -3 LIST1 LIST2
	@rm LIST1 LIST2

# Make man pages -- reports bad lines to standard error.
manpages:
	@python $(MAKEMAN) -d $(USERGUIDE) index.html $(HTMLMANUALS) 
	@mv index.1 netpbm.1

# Make XML pages, and validate them.
xmlpages:
	@for x in $(MANPAGES); do doclifter -v $$x; done
	@for x in $(MANPAGES); do xmllint -xinclude --postvalid $$x.xml >/dev/null; done

# This will install the generated man pages
installman:
	set -x
	for f in netpbm.1 $(MAN1); do if [ -f $$f ]; then gzip <$$f >$(MANDIR)/man1/$$f.gz; fi; done
	for f in $(MAN3); do if [ -f $$f ]; then gzip <$$f >$(MANDIR)/man3/$$f.gz; fi; done
	for f in $(MAN5); do if [ -f $$f ]; then gzip <$$f >$(MANDIR)/man5/$$f.gz; fi; done

# This will uninstall them
uninstallman:
	for f in netpbm.1 $(MAN1); do rm -f $(MANDIR)/man1/$$f.gz; fi; done
	for f in $(MAN3); do rm -f $(MANDIR)/man3/$$f.gz; fi; done
	for f in $(MAN5); do rm -f $(MANDIR)/man5/$$f.gz; fi; done

oldclean:
	# Clean up old locations on Fedora Core 2
	rm -f $(MANDIR)/man1/extendedopacity.1.gz 
	rm -f $(MANDIR)/man3/directory.3.gz
	rm -f $(MANDIR)/man3/libnetpbm_dir.3.gz
	# remove pointer man pages (that say, "The man page isn't here")
	# which might have been installed previously
	for f in $(MAN1); do rm -f $(MANDIR)/man1/$$f; done
	for f in $(MAN3); do rm -f $(MANDIR)/man3/$$f; done
	for f in $(MAN5); do rm -f $(MANDIR)/man5/$$f; done

clean:
	@rm -f *.[135] $(XML)

