import builtins
import typing
import cairo

from gi.repository import Gdk
from gi.repository import GdkPixbuf
from gi.repository import Gio
from gi.repository import Pango
from gi.repository import xlib


class X11AppLaunchContext(Gdk.AppLaunchContext):
    ...


class X11Cursor(Gdk.Cursor):

    def get_xcursor(self) -> builtins.int: ...

    def get_xdisplay(self) -> xlib.Display: ...


class X11DeviceCore(Gdk.Device):
    ...


class X11DeviceManagerCore(Gdk.DeviceManager):
    ...


class X11DeviceXI2(Gdk.Device):
    ...


class X11Display(Gdk.Display):

    def error_trap_pop(self) -> builtins.int: ...

    def error_trap_pop_ignored(self) -> None: ...

    def error_trap_push(self) -> None: ...

    @staticmethod
    def get_glx_version(display: Gdk.Display) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    def get_startup_notification_id(self) -> builtins.str: ...

    def get_user_time(self) -> builtins.int: ...

    def get_xdisplay(self) -> xlib.Display: ...

    def grab(self) -> None: ...

    def set_cursor_theme(self, theme: typing.Optional[builtins.str], size: builtins.int) -> None: ...

    def set_startup_notification_id(self, startup_id: builtins.str) -> None: ...

    def set_window_scale(self, scale: builtins.int) -> None: ...

    def string_to_compound_text(self, str: builtins.str) -> typing.Tuple[builtins.int, Gdk.Atom, builtins.int, builtins.bytes]: ...

    def text_property_to_text_list(self, encoding: Gdk.Atom, format: builtins.int, text: builtins.int, length: builtins.int, list: builtins.str) -> builtins.int: ...

    def ungrab(self) -> None: ...

    def utf8_to_compound_text(self, str: builtins.str) -> typing.Tuple[builtins.bool, Gdk.Atom, builtins.int, builtins.bytes]: ...


class X11DisplayManager(Gdk.DisplayManager):
    ...


class X11DragContext(Gdk.DragContext):
    ...


class X11GLContext(Gdk.GLContext):
    ...


class X11Keymap(Gdk.Keymap):

    def get_group_for_state(self, state: builtins.int) -> builtins.int: ...

    def key_is_modifier(self, keycode: builtins.int) -> builtins.bool: ...


class X11Monitor(Gdk.Monitor):

    @staticmethod
    def get_output(monitor: Gdk.Monitor) -> builtins.int: ...


class X11Screen(Gdk.Screen):

    def get_current_desktop(self) -> builtins.int: ...

    def get_monitor_output(self, monitor_num: builtins.int) -> builtins.int: ...

    def get_number_of_desktops(self) -> builtins.int: ...

    def get_screen_number(self) -> builtins.int: ...

    def get_window_manager_name(self) -> builtins.str: ...

    def get_xscreen(self) -> xlib.Screen: ...

    def lookup_visual(self, xvisualid: builtins.int) -> X11Visual: ...

    def supports_net_wm_hint(self, property: Gdk.Atom) -> builtins.bool: ...


class X11Visual(Gdk.Visual):

    def get_xvisual(self) -> xlib.Visual: ...


class X11Window(Gdk.Window):

    @staticmethod
    def foreign_new_for_display(display: X11Display, window: builtins.int) -> Gdk.Window: ...

    def get_desktop(self) -> builtins.int: ...

    def get_xid(self) -> builtins.int: ...

    @staticmethod
    def lookup_for_display(display: X11Display, window: builtins.int) -> X11Window: ...

    def move_to_current_desktop(self) -> None: ...

    def move_to_desktop(self, desktop: builtins.int) -> None: ...

    def set_frame_extents(self, left: builtins.int, right: builtins.int, top: builtins.int, bottom: builtins.int) -> None: ...

    def set_frame_sync_enabled(self, frame_sync_enabled: builtins.bool) -> None: ...

    def set_hide_titlebar_when_maximized(self, hide_titlebar_when_maximized: builtins.bool) -> None: ...

    def set_theme_variant(self, variant: builtins.str) -> None: ...

    def set_user_time(self, timestamp: builtins.int) -> None: ...

    def set_utf8_property(self, name: builtins.str, value: typing.Optional[builtins.str]) -> None: ...


class X11DeviceManagerXI2(X11DeviceManagerCore):
    ...


def x11_atom_to_xatom(atom: Gdk.Atom) -> builtins.int: ...


def x11_atom_to_xatom_for_display(display: X11Display, atom: Gdk.Atom) -> builtins.int: ...


def x11_device_get_id(device: X11DeviceCore) -> builtins.int: ...


def x11_device_manager_lookup(device_manager: X11DeviceManagerCore, device_id: builtins.int) -> typing.Optional[X11DeviceCore]: ...


def x11_free_compound_text(ctext: builtins.int) -> None: ...


def x11_free_text_list(list: builtins.str) -> None: ...


def x11_get_default_root_xwindow() -> builtins.int: ...


def x11_get_default_screen() -> builtins.int: ...


def x11_get_default_xdisplay() -> xlib.Display: ...


def x11_get_parent_relative_pattern() -> cairo.Pattern: ...


def x11_get_server_time(window: X11Window) -> builtins.int: ...


def x11_get_xatom_by_name(atom_name: builtins.str) -> builtins.int: ...


def x11_get_xatom_by_name_for_display(display: X11Display, atom_name: builtins.str) -> builtins.int: ...


def x11_get_xatom_name(xatom: builtins.int) -> builtins.str: ...


def x11_get_xatom_name_for_display(display: X11Display, xatom: builtins.int) -> builtins.str: ...


def x11_grab_server() -> None: ...


def x11_lookup_xdisplay(xdisplay: xlib.Display) -> X11Display: ...


def x11_register_standard_event_type(display: X11Display, event_base: builtins.int, n_events: builtins.int) -> None: ...


def x11_set_sm_client_id(sm_client_id: typing.Optional[builtins.str]) -> None: ...


def x11_ungrab_server() -> None: ...


def x11_xatom_to_atom(xatom: builtins.int) -> Gdk.Atom: ...


def x11_xatom_to_atom_for_display(display: X11Display, xatom: builtins.int) -> Gdk.Atom: ...


