/*
  Interface definition for Reed-Solomon utility functions
*/

#ifndef _ECC_RS_H
#define _ECC_RS_H

#define ECC_SIZE 10

/**
 * calculate_ecc_rs - Calculate 10 byte Reed-Solomon ECC code for 512 byte block
 * @dat:	raw data
 * @ecc_code:	buffer for ECC
 */
extern int calculate_ecc_rs(const unsigned char *data, unsigned char *ecc_code);


/**
 * correct_data_rs - Detect and correct bit error(s) using 10-byte Reed-Solomon ECC
 * @dat:	raw data read from the chip
 * @store_ecc:	ECC from the chip
 * @calc_ecc:	the ECC calculated from raw data
 */
extern int correct_data_rs(unsigned char *data, unsigned char *store_ecc, unsigned char *calc_ecc);

#endif
