/*
 * Copyright © 2009 Corbin Simpson
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS, AUTHORS
 * AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 */
/*
 * Authors:
 *      Corbin Simpson <MostAwesomeDude@gmail.com>
 */
#ifndef RADEON_DRM_WINSYS_H
#define RADEON_DRM_WINSYS_H

#include "gallium/drivers/radeon/radeon_winsys.h"
#include "pipebuffer/pb_cache.h"
#include "os/os_thread.h"
#include "util/list.h"
#include <radeon_drm.h>

#ifndef DRM_RADEON_GEM_USERPTR

#define DRM_RADEON_GEM_USERPTR		0x2d

#define RADEON_GEM_USERPTR_READONLY	(1 << 0)
#define RADEON_GEM_USERPTR_ANONONLY	(1 << 1)
#define RADEON_GEM_USERPTR_VALIDATE	(1 << 2)
#define RADEON_GEM_USERPTR_REGISTER	(1 << 3)

struct drm_radeon_gem_userptr {
       uint64_t                addr;
       uint64_t                size;
       uint32_t                flags;
       uint32_t                handle;
};

#endif

struct radeon_drm_cs;

enum radeon_generation {
    DRV_R300,
    DRV_R600,
    DRV_SI
};

struct radeon_drm_winsys {
    struct radeon_winsys base;
    struct pipe_reference reference;
    struct pb_cache bo_cache;

    int fd; /* DRM file descriptor */
    int num_cs; /* The number of command streams created. */
    uint64_t allocated_vram;
    uint64_t allocated_gtt;
    uint64_t buffer_wait_time; /* time spent in buffer_wait in ns */
    uint64_t num_cs_flushes;

    enum radeon_generation gen;
    struct radeon_info info;
    uint32_t va_start;
    uint32_t va_unmap_working;
    uint32_t accel_working2;

    /* List of buffer GEM names. Protected by bo_handles_mutex. */
    struct util_hash_table *bo_names;
    /* List of buffer handles. Protectded by bo_handles_mutex. */
    struct util_hash_table *bo_handles;
    /* List of buffer virtual memory ranges. Protectded by bo_handles_mutex. */
    struct util_hash_table *bo_vas;
    pipe_mutex bo_handles_mutex;
    pipe_mutex bo_va_mutex;

    uint64_t va_offset;
    struct list_head va_holes;

    /* BO size alignment */
    unsigned size_align;

    struct radeon_surface_manager *surf_man;

    uint32_t num_cpus;      /* Number of CPUs. */

    struct radeon_drm_cs *hyperz_owner;
    pipe_mutex hyperz_owner_mutex;
    struct radeon_drm_cs *cmask_owner;
    pipe_mutex cmask_owner_mutex;

    /* rings submission thread */
    pipe_mutex cs_stack_lock;
    pipe_semaphore cs_queued;
    pipe_thread thread;
    int kill_thread;
    int ncs;
    struct radeon_drm_cs *cs_stack[RING_LAST];
};

static inline struct radeon_drm_winsys *
radeon_drm_winsys(struct radeon_winsys *base)
{
    return (struct radeon_drm_winsys*)base;
}

void radeon_drm_ws_queue_cs(struct radeon_drm_winsys *ws, struct radeon_drm_cs *cs);
void radeon_surface_init_functions(struct radeon_drm_winsys *ws);

#endif
