.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
sphereeversion - Displays a sphere eversion.
.SH SYNOPSIS
.B sphereeversion
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-mode \fIdisplay-mode\fP]
[\-surface]
[\-transparent]
[\-appearance \fIappearance\fP]
[\-solid]
[\-parallel-bands]
[\-meridian-bands]
[\-graticule \fImode\fP]
[\-surface-order \fIorder\fP]
[\-colors \fIcolor-scheme\fP]
[\-twosided-colors]
[\-parallel-colors]
[\-meridian-colors]
[\-deformation-speed \fIfloat\fP]
[\-projection \fImode\fP]
[\-perspective]
[\-orthographic]
[\-speed-x \fIfloat\fP]
[\-speed-y \fIfloat\fP]
[\-speed-z \fIfloat\fP]
.SH DESCRIPTION
The \fIsphereeversion\fP program shows a sphere eversion, i.e., a
smooth deformation (homotopy) that turns a sphere inside out.  During
the eversion, the deformed sphere is allowed to intersect itself
transversally.  However, no creases or pinch points are allowed to
occur.
.PP
The deformed sphere can be projected to the screen either
perspectively or orthographically.
.PP
There are three display modes for the sphere: solid, transparent, or
random.  If random mode is selected, the mode is changed each time an
eversion has been completed.
.PP
The appearance of the sphere can be as a solid object, as a set of
see-through bands, or random.  The bands can be parallel bands or
meridian bands, i.e., bands that run along the parallels (lines of
latitude) or bands that run along the meridians (lines of longitude)
of the sphere.  If random mode is selected, the appearance is changed
each time an eversion has been completed.
.PP
It is also possible to display a graticule (i.e., a coordinate grid
consisting of parallel and meridian lines) on top of the surface.  The
graticule mode can be set to on, off, or random.  If random mode is
selected, the graticule mode is changed each time an eversion has been
completed.
.PP
It is possible to define a surface order of the sphere eversion as
random or as a value between 2 and 5.  This determines the the
complexity of the deformation.  For higher surface orders, some
z-fighting might occur around the central stage of the eversion, which
might lead to some irregular flickering of the displayed surface if it
is displayed as a solid object.  For odd surface orders, z-fighting
will occur very close to the central stage of the eversion since the
deformed sphere is a doubly covered Boy surface (for surface order 3)
or a doubly covered generalized Boy surface (for surface order 5) in
this case.  If you find this distracting, you should set the surface
order to 2.  If a random surface order is selected, the surface order
is changed each time an eversion has been completed.
.PP
The colors with with the sphere is drawn can be set to two-sided,
parallel, meridian, or random.  In two-sided mode, the sphere is drawn
with red on one side and green on the other side.  In parallel mode,
the sphere is displayed with colors that run from red to cyan on one
side of the surface and from green to violet on the other side.  The
colors are aligned with the parallels of the sphere in this mode.  In
meridian mode, the the sphere is displayed with colors that run from
red to white to cyan to black and back to red on one side of the
surface and from green to white to violet to black and back to green
on the other side.  The colors are aligned with the meridians of the
sphere in this mode. If random mode is selected, the color scheme is
changed each time an eversion has been completed.
.PP
By default, the sphere is rotated to a new viewing position each time
an eversion has been completed.  In addition, it is possible to rotate
the sphere while it is deforming.  The rotation speed for each of the
three coordinate axes around which the sphere rotates can be chosen
arbitrarily.  For best effects, however, it is suggested to rotate
only around the z axis while the sphere is deforming.
.PP
This program is inspired by the following paper: Adam Bednorz, Witold
Bednorz: "Analytic sphere eversion using ruled surfaces", Differential
Geometry and its Applications 64:59-79, 2019.
.SH OPTIONS
.I sphereeversion
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 10000, or 1/100th second.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following three options are mutually exclusive.  They determine
how the deformed sphere is displayed.
.TP 8
.B \-mode random
Display the sphere in a random display mode (default).
.TP 8
.B \-mode surface \fP(Shortcut: \fB\-surface\fP)
Display the sphere as a solid surface.
.TP 8
.B \-mode transparent \fP(Shortcut: \fB\-transparent\fP)
Display the sphere as a transparent surface.
.PP
The following four options are mutually exclusive.  They determine the
appearance of the deformed sphere.
.TP 8
.B \-appearance random
Display the sphere with a random appearance (default).
.TP 8
.B \-appearance solid \fP(Shortcut: \fB\-solid\fP)
Display the sphere as a solid object.
.TP 8
.B \-appearance parallel-bands \fP(Shortcut: \fB\-parallel-bands\fP)
Display the sphere as see-through bands that lie along the parallels
of the sphere.
.TP 8
.B \-appearance meridian-bands \fP(Shortcut: \fB\-meridian-bands\fP)
Display the sphere as see-through bands that lie along the meridians
of the sphere.
.PP
The following three options are mutually exclusive.  They determine
whether a graticule is displayed on top of the sphere.
.TP 8
.B \-graticule random
Randomly choose whether to display a graticule (default).
.TP 8
.B \-graticule on
Display a graticule.
.TP 8
.B \-graticule off
Do not display a graticule.
.PP
The following option determines the order of the surface to be
displayed.
.TP 8
.B \-surface-order \fIorder\fP
The surface order can be set to random or to a value between 2 and 5
(default: random).  This determines the the complexity of the
deformation.
.PP
The following four options are mutually exclusive.  They determine how
to color the deformed sphere.
.TP 8
.B \-colors random
Display the sphere with a random color scheme (default).
.TP 8
.B \-colors twosided \fP(Shortcut: \fB\-twosided-colors\fP)
Display the sphere with two colors: red on one side and green on the
other side.
.TP 8
.B \-colors parallel \fP(Shortcut: \fB\-parallel-colors\fP)
Display the sphere with colors that run from red to cyan on one side
of the surface and from green to violet on the other side.  The colors
are aligned with the parallels of the sphere.  If the sphere is
displayed as parallel bands, each band will be displayed with a
different color.
.TP 8
.B \-colors meridian \fP(Shortcut: \fB\-meridian-colors\fP)
Display the sphere with colors that run from red to white to cyan to
black and back to red on one side of the surface and from green to
white to violet to black and back to green on the other side.  The
colors are aligned with the meridians of the sphere.  If the sphere is
displayed as meridian bands, each band will be displayed with a
different color.
.PP
The following option determines the deformation speed.
.TP 8
.B \-deformation-speed \fIfloat\fP
The deformation speed is measured in percent of some sensible maximum
speed (default: 10.0).
.PP
The following three options are mutually exclusive.  They determine
how the deformed sphere is projected from 3d to 2d (i.e., to the
screen).
.TP 8
.B \-projection random
Project the sphere from 3d to 2d using a random projection mode
(default).
.TP 8
.B \-projection perspective \fP(Shortcut: \fB\-perspective\fP)
Project the sphere from 3d to 2d using a perspective projection.
.TP 8
.B \-projection orthographic \fP(Shortcut: \fB\-orthographic\fP)
Project the sphere from 3d to 2d using an orthographic projection.
.PP
The following three options determine the rotation speed of the
deformed sphere around the three possible axes.  The rotation speed is
measured in degrees per frame.  The speeds should be set to relatively
small values, e.g., less than 4 in magnitude.
.TP 8
.B \-speed-x \fIfloat\fP
Rotation speed around the x axis (default: 0.0).
.TP 8
.B \-speed-y \fIfloat\fP
Rotation speed around the y axis (default: 0.0).
.TP 8
.B \-speed-z \fIfloat\fP
Rotation speed around the z axis (default: 0.0).
.SH INTERACTION
If you run this program in standalone mode, you can rotate the
deformed sphere by dragging the mouse while pressing the left mouse
button.  This rotates the sphere in 3d.  To examine the deformed
sphere at your leisure, it is best to set all speeds to 0.  Otherwise,
the deformed sphere will rotate while the left mouse button is not
pressed.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2020 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 01-jun-2020.
