/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2014 Freescale Semiconductor, Inc.
 */

#ifndef __MX6SX_RDC_H__
#define __MX6SX_RDC_H__

#define RDC_SEMA_PROC_ID 2  /* The processor ID for main CPU */

enum {
	RDC_PER_PWM1 = 0,
	RDC_PER_PWM2,
	RDC_PER_PWM3,
	RDC_PER_PWM4,
	RDC_PER_CAN1,
	RDC_PER_CAN2,
	RDC_PER_GPT,
	RDC_PER_GPIO1,
	RDC_PER_GPIO2,
	RDC_PER_GPIO3,
	RDC_PER_GPIO4,
	RDC_PER_GPIO5,
	RDC_PER_GPIO6,
	RDC_PER_GPIO7,
	RDC_PER_KPP,
	RDC_PER_WDOG1,
	RDC_PER_WODG2,
	RDC_PER_CCM,
	RDC_PER_ANATOPDIG,
	RDC_PER_SNVSHP,
	RDC_PER_EPIT1,
	RDC_PER_EPIT2,
	RDC_PER_SRC,
	RDC_PER_GPC,
	RDC_PER_IOMUXC,
	RDC_PER_IOMUXCGPR,
	RDC_PER_CANFD1,
	RDC_PER_SDMA,
	RDC_PER_CANFD2,
	RDC_PER_SEMA1,
	RDC_PER_SEMA2,
	RDC_PER_RDC,
	RDC_PER_AIPSTZ1_GE1,
	RDC_PER_AIPSTZ2_GE2,
	RDC_PER_USBO2H_PL301,
	RDC_PER_USBO2H_USB,
	RDC_PER_ENET1,
	RDC_PER_MLB25,
	RDC_PER_USDHC1,
	RDC_PER_USDHC2,
	RDC_PER_USDHC3,
	RDC_PER_USDHC4,
	RDC_PER_I2C1,
	RDC_PER_I2C2,
	RDC_PER_I2C3,
	RDC_PER_ROMCP,
	RDC_PER_MMDC,
	RDC_PER_ENET2,
	RDC_PER_EIM,
	RDC_PER_OCOTP,
	RDC_PER_CSU,
	RDC_PER_PERFMON1,
	RDC_PER_PERFMON2,
	RDC_PER_AXIMON,
	RDC_PER_TZASC1,
	RDC_PER_SAI1,
	RDC_PER_AUDMUX,
	RDC_PER_SAI2,
	RDC_PER_QSPI1,
	RDC_PER_QSPI2,
	RDC_PER_UART2,
	RDC_PER_UART3,
	RDC_PER_UART4,
	RDC_PER_UART5,
	RDC_PER_I2C4,
	RDC_PER_QOSC,
	RDC_PER_CAAM,
	RDC_PER_DAP,
	RDC_PER_ADC1,
	RDC_PER_ADC2,
	RDC_PER_WDOG3,
	RDC_PER_ECSPI5,
	RDC_PER_SEMA4,
	RDC_PER_MUPORT1,
	RDC_PER_CANFD_CPU,
	RDC_PER_MUPORT2,
	RDC_PER_UART6,
	RDC_PER_PWM5,
	RDC_PER_PWM6,
	RDC_PER_PWM7,
	RDC_PER_PWM8,
	RDC_PER_AIPSTZ3_GE0,
	RDC_PER_AIPSTZ3_GE1,
	RDC_PER_RESERVED1,
	RDC_PER_SPDIF,
	RDC_PER_ECSPI1,
	RDC_PER_ECSPI2,
	RDC_PER_ECSPI3,
	RDC_PER_ECSPI4,
	RDC_PER_RESERVED2,
	RDC_PER_RESERVED3,
	RDC_PER_UART1,
	RDC_PER_ESAI,
	RDC_PER_SSI1,
	RDC_PER_SSI2,
	RDC_PER_SSI3,
	RDC_PER_ASRC,
	RDC_PER_RESERVED4,
	RDC_PER_SPBA_MA,
	RDC_PER_GIS,
	RDC_PER_DCIC1,
	RDC_PER_DCIC2,
	RDC_PER_CSI1,
	RDC_PER_PXP,
	RDC_PER_CSI2,
	RDC_PER_LCDIF1,
	RDC_PER_LCDIF2,
	RDC_PER_VADC,
	RDC_PER_VDEC,
	RDC_PER_SPBA_DISPLAYMIX,
};

enum {
	RDC_MA_A9_L2CACHE = 0,
	RDC_MA_M4,
	RDC_MA_GPU,
	RDC_MA_CSI1,
	RDC_MA_CSI2,
	RDC_MA_LCDIF1,
	RDC_MA_LCDIF2,
	RDC_MA_PXP,
	RDC_MA_PCIE_CTRL,
	RDC_MA_DAP,
	RDC_MA_CAAM,
	RDC_MA_SDMA_PERI,
	RDC_MA_SDMA_BURST,
	RDC_MA_APBHDMA,
	RDC_MA_RAWNAND,
	RDC_MA_USDHC1,
	RDC_MA_USDHC2,
	RDC_MA_USDHC3,
	RDC_MA_USDHC4,
	RDC_MA_USB,
	RDC_MA_MLB,
	RDC_MA_TEST,
	RDC_MA_ENET1_TX,
	RDC_MA_ENET1_RX,
	RDC_MA_ENET2_TX,
	RDC_MA_ENET2_RX,
	RDC_MA_SDMA,
};

#endif	/* __MX6SX_RDC_H__*/
