.\"
.\" Copyright © 2007 Keith Packard.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.\"
.TH XBACKLIGHT __appmansuffix__ __vendorversion__
.SH NAME
xbacklight \- adjust backlight brightness using RandR extension
.SH SYNOPSIS
.B "xbacklight"
[\-help]  [\-display \fIdisplay\fP]
[\-get]
[\-set percent]
[\-inc percent]
[\-dec percent]
.SH DESCRIPTION
.I Xbacklight
is used to adjust the backlight brightness where supported. It finds all
outputs on the X server supporting backlight brightness control and changes
them all in the same way.
.IP \-get
Print out the current backlight brightness of each output with such a
control. The brightness is represented as a percentage of the maximum
brightness supported.
.IP "\-set \fIpercent\fP"
Sets each backlight brightness to the specified level.
.IP "\-inc \fIpercent\fP"
Increases brightness by the specified amount.
.IP "\-dec \fIpercent\fP"
Decreases brightness by the specified amount.
.IP \-help
Print out a summary of the usage and exit.
.IP \-version
Print out the program version and exit.
.IP "\-time \fImilliseconds\fP"
Length of time to spend fading the backlight between old and new value.
Default is 200.
.IP "\-steps \fInumber\fP"
Number of steps to take while fading. Default is 20.
.SH "SEE ALSO"
Xrandr(__libmansuffix__)
.SH AUTHORS
Keith Packard,
Open Source Technology Center, Intel Corporation.
