# - Try to find GStreamer
# Once done this will define
#
#  GSTREAMER_0_10_FOUND - system has GStreamer
#  GSTREAMER_0_10_INCLUDE_DIRS - the GStreamer include directory
#  GSTREAMER_0_10_LIBRARIES - the libraries needed to use GStreamer
#  GSTREAMER_0_10_DEFINITIONS - Compiler switches required for using GStreamer

# Copyright (c) 2006, Tim Beaulen <tbscope@gmail.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

# TODO: Other versions --> GSTREAMER_X_Y_FOUND (Example: GSTREAMER_0_8_FOUND and GSTREAMER_0_10_FOUND etc)

IF (GSTREAMER_0_10_INCLUDE_DIRS AND GSTREAMER_0_10_LIBRARIES AND GSTREAMER_0_10_BASE_LIBRARY AND GSTREAMER_0_10_INTERFACE_LIBRARY)
   # in cache already
   SET(GSTREAMER_0_10_FIND_QUIETLY TRUE)
ELSE (GSTREAMER_0_10_INCLUDE_DIRS AND GSTREAMER_0_10_LIBRARIES AND GSTREAMER_0_10_BASE_LIBRARY AND GSTREAMER_0_10_INTERFACE_LIBRARY)
   SET(GSTREAMER_0_10_FIND_QUIETLY FALSE)
ENDIF (GSTREAMER_0_10_INCLUDE_DIRS AND GSTREAMER_0_10_LIBRARIES AND GSTREAMER_0_10_BASE_LIBRARY AND GSTREAMER_0_10_INTERFACE_LIBRARY)

IF (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   FIND_PACKAGE(PkgConfig)
   PKG_CHECK_MODULES(PC_GSTREAMER_0_10 QUIET gstreamer-0.10)
   #MESSAGE(STATUS "DEBUG: GStreamer include directory = ${GSTREAMER_0_10_INCLUDE_DIRSS}")
   #MESSAGE(STATUS "DEBUG: GStreamer link directory = ${GSTREAMER_0_10_LIBRARY_DIRS}")
   #MESSAGE(STATUS "DEBUG: GStreamer CFlags = ${GSTREAMER_0_10_CFLAGS_OTHER}") 
   SET(GSTREAMER_0_10_DEFINITIONS ${PC_GSTREAMER_0_10_CFLAGS_OTHER})
ENDIF (NOT WIN32)

FIND_PATH(GSTREAMER_0_10_INCLUDE_DIRS gst/gst.h
   PATHS
   ${PC_GSTREAMER_0_10_INCLUDEDIR}
   ${PC_GSTREAMER_0_10_INCLUDE_DIRSS}
   #PATH_SUFFIXES gst
   )

FIND_LIBRARY(GSTREAMER_0_10_LIBRARIES NAMES gstreamer-0.10
   PATHS
   ${PC_GSTREAMER_0_10_LIBDIR}
   ${PC_GSTREAMER_0_10_LIBRARY_DIRS}
   )

FIND_LIBRARY(GSTREAMER_0_10_BASE_LIBRARY NAMES gstbase-0.10
   PATHS
   ${PC_GSTREAMER_0_10_LIBDIR}
   ${PC_GSTREAMER_0_10_LIBRARY_DIRS}
   )

FIND_LIBRARY(GSTREAMER_0_10_APP_LIBRARY NAMES gstapp-0.10
   PATHS
   ${PC_GSTREAMER_0_10_LIBDIR}
   ${PC_GSTREAMER_0_10_LIBRARY_DIRS}
   )

FIND_LIBRARY(GSTREAMER_0_10_INTERFACE_LIBRARY NAMES gstinterfaces-0.10
   PATHS
   ${PC_GSTREAMER_0_10_LIBDIR}
   ${PC_GSTREAMER_0_10_LIBRARY_DIRS}
   )

FIND_PACKAGE(Glib REQUIRED)
FIND_PACKAGE(LibXml2 REQUIRED)

IF (GSTREAMER_0_10_INCLUDE_DIRS)
   #MESSAGE(STATUS "DEBUG: Found GStreamer include dir: ${GSTREAMER_0_10_INCLUDE_DIRS}")
ELSE (GSTREAMER_0_10_INCLUDE_DIRS)
   MESSAGE(STATUS "GStreamer: WARNING: include dir not found")
ENDIF (GSTREAMER_0_10_INCLUDE_DIRS)

IF (GSTREAMER_0_10_LIBRARIES)
   #MESSAGE(STATUS "DEBUG: Found GStreamer library: ${GSTREAMER_0_10_LIBRARIES}")
ELSE (GSTREAMER_0_10_LIBRARIES)
   MESSAGE(STATUS "GStreamer: WARNING: library not found")
ENDIF (GSTREAMER_0_10_LIBRARIES)

IF (GSTREAMER_0_10_INTERFACE_LIBRARY)
   #MESSAGE(STATUS "DEBUG: Found GStreamer interface library: ${GSTREAMER_0_10_INTERFACE_LIBRARY}")
ELSE (GSTREAMER_0_10_INTERFACE_LIBRARY)
   MESSAGE(STATUS "GStreamer: WARNING: interface library not found")
ENDIF (GSTREAMER_0_10_INTERFACE_LIBRARY)

set(_GSTREAMER_0_10_REQUIRED_VARS
	Glib_INCLUDE_DIRS
	Glib_LIBRARIES
	LIBXML2_INCLUDE_DIR
	LIBXML2_LIBRARIES
	GSTREAMER_0_10_INCLUDE_DIRS
	GSTREAMER_0_10_LIBRARIES
	VERSION_OK
	GSTREAMER_0_10_BASE_INCLUDE_DIRS
	GSTREAMER_0_10_BASE_LIBRARY
	GSTREAMER_0_10_INTERFACE_INCLUDE_DIRS
	GSTREAMER_0_10_INTERFACE_LIBRARY)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GSTREAMER_0_10  DEFAULT_MSG
	GSTREAMER_0_10_LIBRARIES
	GSTREAMER_0_10_INCLUDE_DIRS
	GSTREAMER_0_10_BASE_LIBRARY
	GSTREAMER_0_10_INTERFACE_LIBRARY)

list(APPEND GSTREAMER_0_10_INCLUDE_DIRS ${Glib_INCLUDE_DIRS})
list(APPEND GSTREAMER_0_10_LIBRARIES ${Glib_LIBRARIES})
list(APPEND GSTREAMER_0_10_INCLUDE_DIRS ${LIBXML2_INCLUDE_DIR})
list(APPEND GSTREAMER_0_10_LIBRARIES ${LIBXML2_LIBRARIES})
list(APPEND GSTREAMER_0_10_INCLUDE_DIRS ${GSTREAMER_0_10_BASE_INCLUDE_DIR})
list(APPEND GSTREAMER_0_10_LIBRARIES ${GSTREAMER_0_10_BASE_LIBRARY})
list(APPEND GSTREAMER_0_10_INCLUDE_DIRS ${GSTREAMER_0_10_APP_INCLUDE_DIR})
list(APPEND GSTREAMER_0_10_LIBRARIES ${GSTREAMER_0_10_APP_LIBRARY})
list(APPEND GSTREAMER_0_10_INCLUDE_DIRS ${GSTREAMER_0_10_INTERFACE_INCLUDE_DIR})
list(APPEND GSTREAMER_0_10_LIBRARIES ${GSTREAMER_0_10_INTERFACE_LIBRARY})

MARK_AS_ADVANCED(GSTREAMER_0_10_INCLUDE_DIRS GSTREAMER_0_10_LIBRARIES GSTREAMER_0_10_BASE_LIBRARY GSTREAMER_0_10_INTERFACE_LIBRARY)

