/* switcher.c generated by valac 0.52.4, the Vala compiler
 * generated from switcher.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2016 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2019 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <cairo-gobject.h>

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;
typedef struct _SwitcherPrivate SwitcherPrivate;

#define SWITCHER_TYPE_IBUS_ENGINE_BUTTON (switcher_ibus_engine_button_get_type ())
#define SWITCHER_IBUS_ENGINE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton))
#define SWITCHER_IBUS_ENGINE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonClass))
#define SWITCHER_IS_IBUS_ENGINE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON))
#define SWITCHER_IS_IBUS_ENGINE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHER_TYPE_IBUS_ENGINE_BUTTON))
#define SWITCHER_IBUS_ENGINE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonClass))

typedef struct _SwitcherIBusEngineButton SwitcherIBusEngineButton;
typedef struct _SwitcherIBusEngineButtonClass SwitcherIBusEngineButtonClass;
enum  {
	SWITCHER_0_PROPERTY,
	SWITCHER_NUM_PROPERTIES
};
static GParamSpec* switcher_properties[SWITCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define __vala_GdkEventMotion_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventMotion_free (var), NULL)))
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))
typedef struct _SwitcherIBusEngineButtonPrivate SwitcherIBusEngineButtonPrivate;
enum  {
	SWITCHER_IBUS_ENGINE_BUTTON_0_PROPERTY,
	SWITCHER_IBUS_ENGINE_BUTTON_TRANSNAME_PROPERTY,
	SWITCHER_IBUS_ENGINE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* switcher_ibus_engine_button_properties[SWITCHER_IBUS_ENGINE_BUTTON_NUM_PROPERTIES];

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Switcher {
	GtkWindow parent_instance;
	SwitcherPrivate * priv;
};

struct _SwitcherClass {
	GtkWindowClass parent_class;
};

struct _SwitcherPrivate {
	GtkBox* m_box;
	GtkLabel* m_label;
	SwitcherIBusEngineButton** m_buttons;
	gint m_buttons_length1;
	gint _m_buttons_size_;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	guint m_selected_engine;
	guint m_keyval;
	guint m_modifiers;
	GdkModifierType m_primary_modifier;
	gboolean m_is_running;
	gchar* m_input_context_path;
	GMainLoop* m_loop;
	gint m_result;
	IBusEngineDesc* m_result_engine;
	guint m_popup_delay_time;
	guint m_popup_delay_time_id;
	gint m_root_x;
	gint m_root_y;
	gdouble m_mouse_init_x;
	gdouble m_mouse_init_y;
	gboolean m_mouse_moved;
	GHashTable* m_xkb_languages;
};

struct _Block11Data {
	int _ref_count_;
	Switcher* self;
	gint index;
	SwitcherIBusEngineButton* button;
};

struct _SwitcherIBusEngineButton {
	GtkButton parent_instance;
	SwitcherIBusEngineButtonPrivate * priv;
};

struct _SwitcherIBusEngineButtonClass {
	GtkButtonClass parent_class;
};

struct _SwitcherIBusEngineButtonPrivate {
	gchar* _transname;
};

static gint Switcher_private_offset;
static gpointer switcher_parent_class = NULL;
static gint SwitcherIBusEngineButton_private_offset;
static gpointer switcher_ibus_engine_button_parent_class = NULL;

GType switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Switcher, g_object_unref)
static GType switcher_ibus_engine_button_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitcherIBusEngineButton, g_object_unref)
static void _g_free0_ (gpointer var);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
gint switcher_run (Switcher* self,
                   guint keyval,
                   guint state,
                   GdkEvent* event,
                   IBusEngineDesc** engines,
                   gint engines_length1,
                   gint index,
                   const gchar* input_context_path);
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
static void switcher_update_engines (Switcher* self,
                              IBusEngineDesc** engines,
                              gint engines_length1);
static const gchar* switcher_ibus_engine_button_get_transname (SwitcherIBusEngineButton* self);
static gboolean ___lambda23_ (Switcher* self);
static void switcher_restore_window_position (Switcher* self,
                                       const gchar* debug_str);
static gboolean ____lambda23__gsource_func (gpointer self);
static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self,
                                   gint length);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static SwitcherIBusEngineButton* switcher_ibus_engine_button_new (IBusEngineDesc* engine,
                                                           Switcher* switcher);
static SwitcherIBusEngineButton* switcher_ibus_engine_button_construct (GType object_type,
                                                                 IBusEngineDesc* engine,
                                                                 Switcher* switcher);
static gboolean _____lambda20_ (Switcher* self,
                         GdkEventCrossing* e);
static gboolean ______lambda20__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                        GdkEventCrossing* event,
                                                        gpointer self);
static gboolean _____lambda21_ (Block11Data* _data11_,
                         GdkEventMotion* e);
static GdkEventMotion* _vala_GdkEventMotion_copy (GdkEventMotion* self);
static void _vala_GdkEventMotion_free (GdkEventMotion* self);
static gboolean ______lambda21__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                         GdkEventMotion* event,
                                                         gpointer self);
static gboolean _____lambda22_ (Block11Data* _data11_,
                         GdkEventButton* e);
static gboolean ______lambda22__gtk_widget_button_press_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
static void switcher_ibus_engine_button_set_transname (SwitcherIBusEngineButton* self,
                                                const gchar* value);
static void _vala_array_add25 (SwitcherIBusEngineButton** * array,
                        gint* length,
                        gint* size,
                        SwitcherIBusEngineButton* value);
static void switcher_next_engine (Switcher* self);
static void switcher_previous_engine (Switcher* self);
static void switcher_real_show (GtkWidget* base);
static gboolean switcher_real_key_press_event (GtkWidget* base,
                                        GdkEventKey* e);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
static gboolean switcher_real_key_release_event (GtkWidget* base,
                                          GdkEventKey* e);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event,
                                                            guint primary_modifier);
void switcher_set_popup_delay_time (Switcher* self,
                                    guint popup_delay_time);
gchar* switcher_get_xkb_language (Switcher* self,
                                  IBusEngineDesc* engine);
gboolean switcher_is_running (Switcher* self);
gchar* switcher_get_input_context_path (Switcher* self);
IBusEngineDesc* switcher_get_selected_engine (Switcher* self);
void switcher_reset (Switcher* self);
GType icon_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IconWidget, g_object_unref)
IconWidget* icon_widget_new (const gchar* icon_name_or_path,
                             GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type,
                                   const gchar* icon_name_or_path,
                                   GtkIconSize size);
static gboolean switcher_ibus_engine_button_real_draw (GtkWidget* base,
                                                cairo_t* cr);
static void switcher_ibus_engine_button_finalize (GObject * obj);
static GType switcher_ibus_engine_button_get_type_once (void);
static void _vala_switcher_ibus_engine_button_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_switcher_ibus_engine_button_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void switcher_finalize (GObject * obj);
static GType switcher_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
switcher_get_instance_private (Switcher* self)
{
	return G_STRUCT_MEMBER_P (self, Switcher_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Switcher*
switcher_construct (GType object_type)
{
	Switcher * self = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkLabel* _tmp5_;
	AtkObject* obj = NULL;
	GtkLabel* _tmp6_;
	AtkObject* _tmp7_;
	AtkObject* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	self = (Switcher*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "events", GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, "window-position", GTK_WIN_POS_CENTER, "accept-focus", TRUE, "decorated", FALSE, "modal", TRUE, "focus-visible", TRUE, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	vbox = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->m_box);
	self->priv->m_box = _tmp1_;
	_tmp2_ = self->priv->m_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	_tmp3_ = self->priv->m_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->m_box;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp4_, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_label = _tmp5_;
	_tmp6_ = self->priv->m_label;
	_tmp7_ = gtk_widget_get_accessible ((GtkWidget*) _tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	obj = _tmp8_;
	atk_object_set_role (obj, ATK_ROLE_STATUSBAR);
	_tmp9_ = self->priv->m_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp9_, 3);
	_tmp10_ = self->priv->m_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 3);
	_tmp11_ = self->priv->m_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 3);
	_tmp12_ = self->priv->m_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp12_, 3);
	_tmp13_ = self->priv->m_label;
	gtk_box_pack_end (vbox, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (obj);
	_g_object_unref0 (vbox);
	return self;
}

Switcher*
switcher_new (void)
{
	return switcher_construct (TYPE_SWITCHER);
}

static gboolean
___lambda23_ (Switcher* self)
{
	gboolean result = FALSE;
	switcher_restore_window_position (self, "timeout");
	result = FALSE;
	return result;
}

static gboolean
____lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda23_ ((Switcher*) self);
	return result;
}

gint
switcher_run (Switcher* self,
              guint keyval,
              guint state,
              GdkEvent* event,
              IBusEngineDesc** engines,
              gint engines_length1,
              gint index,
              const gchar* input_context_path)
{
	GMainLoop* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	SwitcherIBusEngineButton** _tmp3_;
	gint _tmp3__length1;
	SwitcherIBusEngineButton* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SwitcherIBusEngineButton** _tmp7_;
	gint _tmp7__length1;
	SwitcherIBusEngineButton* _tmp8_;
	GdkDevice* pointer = NULL;
	GdkSeat* seat = NULL;
	GdkSeat* _tmp11_;
	GdkSeat* _tmp12_;
	GdkSeat* _tmp13_;
	GdkSeat* _tmp19_;
	GdkDevice* _tmp20_;
	GdkDevice* _tmp21_;
	GdkGrabStatus status = 0;
	GdkSeat* _tmp22_;
	GdkWindow* _tmp23_;
	GdkGrabStatus _tmp24_;
	GdkSeat* _tmp26_;
	GdkWindow* _tmp27_;
	GdkGrabStatus _tmp28_;
	GdkDevice* _tmp30_;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	GMainLoop* _tmp33_;
	GMainLoop* _tmp34_;
	GdkSeat* _tmp35_;
	IBusEngineDesc** _tmp36_;
	gint _tmp36__length1;
	IBusEngineDesc** _tmp37_;
	gint _tmp37__length1;
	IBusEngineDesc* _tmp38_;
	IBusEngineDesc* _tmp39_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	g_return_val_if_fail (input_context_path != NULL, 0);
	_tmp0_ = self->priv->m_loop;
	_vala_assert (_tmp0_ == NULL, "m_loop == null");
	_vala_assert (index < engines_length1, "index < engines.length");
	self->priv->m_is_running = TRUE;
	self->priv->m_keyval = keyval;
	self->priv->m_modifiers = state;
	self->priv->m_primary_modifier = keybinding_manager_get_primary_modifier (state & KEYBINDING_MANAGER_MODIFIER_FILTER);
	self->priv->m_result = index;
	self->priv->m_selected_engine = (guint) self->priv->m_result;
	_tmp1_ = g_strdup (input_context_path);
	_g_free0 (self->priv->m_input_context_path);
	self->priv->m_input_context_path = _tmp1_;
	_g_object_unref0 (self->priv->m_result_engine);
	self->priv->m_result_engine = NULL;
	switcher_update_engines (self, engines, (gint) engines_length1);
	gtk_window_resize ((GtkWindow*) self, 1, 1);
	_tmp2_ = self->priv->m_label;
	_tmp3_ = self->priv->m_buttons;
	_tmp3__length1 = self->priv->m_buttons_length1;
	_tmp4_ = _tmp3_[index];
	_tmp5_ = switcher_ibus_engine_button_get_transname (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp2_, _tmp6_);
	_tmp7_ = self->priv->m_buttons;
	_tmp7__length1 = self->priv->m_buttons_length1;
	_tmp8_ = _tmp7_[index];
	gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
	if (self->priv->m_popup_delay_time > ((guint) 0)) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gtk_window_get_position ((GtkWindow*) self, &_tmp9_, &_tmp10_);
		self->priv->m_root_x = _tmp9_;
		self->priv->m_root_y = _tmp10_;
		gtk_window_move ((GtkWindow*) self, -1000, -1000);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	if (self->priv->m_popup_delay_time > ((guint) 0)) {
		self->priv->m_popup_delay_time_id = g_timeout_add_full (G_PRIORITY_DEFAULT, self->priv->m_popup_delay_time, ____lambda23__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp11_ = gdk_event_get_seat (event);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	seat = _tmp12_;
	_tmp13_ = seat;
	if (_tmp13_ == NULL) {
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp14_;
		GdkDisplay* _tmp15_;
		GdkDisplay* _tmp16_;
		GdkSeat* _tmp17_;
		GdkSeat* _tmp18_;
		_tmp14_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp15_ = _g_object_ref0 (_tmp14_);
		display = _tmp15_;
		_tmp16_ = display;
		_tmp17_ = gdk_display_get_default_seat (_tmp16_);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (seat);
		seat = _tmp18_;
		_g_object_unref0 (display);
	}
	_tmp19_ = seat;
	_tmp20_ = gdk_seat_get_pointer (_tmp19_);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (pointer);
	pointer = _tmp21_;
	_tmp22_ = seat;
	_tmp23_ = gtk_widget_get_window ((GtkWidget*) self);
	status = gdk_seat_grab (_tmp22_, _tmp23_, GDK_SEAT_CAPABILITY_KEYBOARD, TRUE, NULL, event, NULL, NULL);
	_tmp24_ = status;
	if (_tmp24_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp25_;
		_tmp25_ = status;
		g_warning ("switcher.vala:202: Grab keyboard failed! status = %d", (gint) _tmp25_);
	}
	_tmp26_ = seat;
	_tmp27_ = gtk_widget_get_window ((GtkWidget*) self);
	status = gdk_seat_grab (_tmp26_, _tmp27_, GDK_SEAT_CAPABILITY_POINTER, TRUE, NULL, event, NULL, NULL);
	_tmp28_ = status;
	if (_tmp28_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp29_;
		_tmp29_ = status;
		g_warning ("switcher.vala:210: Grab pointer failed! status = %d", (gint) _tmp29_);
	}
	_tmp30_ = pointer;
	gdk_device_get_position_double (_tmp30_, NULL, &_tmp31_, &_tmp32_);
	self->priv->m_mouse_init_x = _tmp31_;
	self->priv->m_mouse_init_y = _tmp32_;
	self->priv->m_mouse_moved = FALSE;
	_tmp33_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = _tmp33_;
	_tmp34_ = self->priv->m_loop;
	g_main_loop_run (_tmp34_);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = NULL;
	_tmp35_ = seat;
	gdk_seat_ungrab (_tmp35_);
	gtk_widget_hide ((GtkWidget*) self);
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
	_tmp36_ = self->priv->m_engines;
	_tmp36__length1 = self->priv->m_engines_length1;
	_vala_assert (self->priv->m_result < _tmp36__length1, "m_result < m_engines.length");
	_tmp37_ = self->priv->m_engines;
	_tmp37__length1 = self->priv->m_engines_length1;
	_tmp38_ = _tmp37_[self->priv->m_result];
	_tmp39_ = _g_object_ref0 (_tmp38_);
	_g_object_unref0 (self->priv->m_result_engine);
	self->priv->m_result_engine = _tmp39_;
	self->priv->m_is_running = FALSE;
	result = self->priv->m_result;
	_g_object_unref0 (seat);
	_g_object_unref0 (pointer);
	return result;
}

static IBusEngineDesc**
_vala_array_dup5 (IBusEngineDesc** self,
                  gint length)
{
	if (length >= 0) {
		IBusEngineDesc** result;
		gint i;
		result = g_new0 (IBusEngineDesc*, length + 1);
		for (i = 0; i < length; i++) {
			IBusEngineDesc* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		Switcher* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->button);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
_____lambda20_ (Switcher* self,
                GdkEventCrossing* e)
{
	gboolean result = FALSE;
	g_return_val_if_fail (e != NULL, FALSE);
	result = TRUE;
	return result;
}

static gboolean
______lambda20__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                               GdkEventCrossing* event,
                                               gpointer self)
{
	gboolean result;
	result = _____lambda20_ ((Switcher*) self, event);
	return result;
}

static GdkEventMotion*
_vala_GdkEventMotion_copy (GdkEventMotion* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventMotion_copy0 (gpointer self)
{
	return self ? _vala_GdkEventMotion_copy (self) : NULL;
}

static void
_vala_GdkEventMotion_free (GdkEventMotion* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static gboolean
_____lambda21_ (Block11Data* _data11_,
                GdkEventMotion* e)
{
	Switcher* self;
	GdkEventMotion* pe = NULL;
	GdkEventMotion* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	SwitcherIBusEngineButton* _tmp5_;
	gboolean result = FALSE;
	self = _data11_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = __vala_GdkEventMotion_copy0 (e);
	pe = _tmp0_;
	if (self->priv->m_selected_engine == ((guint) _data11_->index)) {
		result = FALSE;
		__vala_GdkEventMotion_free0 (pe);
		return result;
	}
	if (!self->priv->m_mouse_moved) {
		GdkEventMotion* _tmp3_;
		_tmp3_ = pe;
		_tmp2_ = self->priv->m_mouse_init_x == _tmp3_->x_root;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkEventMotion* _tmp4_;
		_tmp4_ = pe;
		_tmp1_ = self->priv->m_mouse_init_y == _tmp4_->y_root;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		__vala_GdkEventMotion_free0 (pe);
		return result;
	}
	self->priv->m_mouse_moved = TRUE;
	_tmp5_ = _data11_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	self->priv->m_selected_engine = (guint) _data11_->index;
	result = FALSE;
	__vala_GdkEventMotion_free0 (pe);
	return result;
}

static gboolean
______lambda21__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                GdkEventMotion* event,
                                                gpointer self)
{
	gboolean result;
	result = _____lambda21_ (self, event);
	return result;
}

static gboolean
_____lambda22_ (Block11Data* _data11_,
                GdkEventButton* e)
{
	Switcher* self;
	GMainLoop* _tmp0_;
	gboolean result = FALSE;
	self = _data11_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->m_selected_engine = (guint) _data11_->index;
	self->priv->m_result = (gint) self->priv->m_selected_engine;
	_tmp0_ = self->priv->m_loop;
	g_main_loop_quit (_tmp0_);
	result = TRUE;
	return result;
}

static gboolean
______lambda22__gtk_widget_button_press_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = _____lambda22_ (self, event);
	return result;
}

static void
_vala_array_add25 (SwitcherIBusEngineButton** * array,
                   gint* length,
                   gint* size,
                   SwitcherIBusEngineButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (SwitcherIBusEngineButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
switcher_update_engines (Switcher* self,
                         IBusEngineDesc** engines,
                         gint engines_length1)
{
	SwitcherIBusEngineButton** _tmp0_;
	gint _tmp0__length1;
	SwitcherIBusEngineButton** _tmp3_;
	IBusEngineDesc** _tmp5_;
	gint _tmp5__length1;
	gint max_label_width = 0;
	GtkLabel* _tmp39_;
	SwitcherIBusEngineButton** _tmp40_;
	gint _tmp40__length1;
	SwitcherIBusEngineButton* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GtkLabel* _tmp44_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp45_;
	GdkDisplay* _tmp46_;
	gint screen_width = 0;
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp47_;
	GdkMonitor* _tmp48_;
	GdkMonitor* _tmp49_;
	GdkRectangle area = {0};
	GdkMonitor* _tmp50_;
	GdkRectangle _tmp51_ = {0};
	GdkRectangle _tmp52_;
	gboolean _tmp53_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_buttons;
	_tmp0__length1 = self->priv->m_buttons_length1;
	{
		SwitcherIBusEngineButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			SwitcherIBusEngineButton* _tmp1_;
			SwitcherIBusEngineButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				SwitcherIBusEngineButton* _tmp2_;
				_tmp2_ = button;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp3_ = g_new0 (SwitcherIBusEngineButton*, 0 + 1);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_buttons = _tmp3_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	if (engines == NULL) {
		IBusEngineDesc** _tmp4_;
		_tmp4_ = g_new0 (IBusEngineDesc*, 0 + 1);
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp4_;
		self->priv->m_engines_length1 = 0;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		return;
	}
	_tmp5_ = (engines != NULL) ? _vala_array_dup5 (engines, engines_length1) : engines;
	_tmp5__length1 = engines_length1;
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = _tmp5_;
	self->priv->m_engines_length1 = _tmp5__length1;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	max_label_width = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				Block11Data* _data11_;
				IBusEngineDesc** _tmp8_;
				gint _tmp8__length1;
				IBusEngineDesc* engine = NULL;
				IBusEngineDesc** _tmp9_;
				gint _tmp9__length1;
				IBusEngineDesc* _tmp10_;
				IBusEngineDesc* _tmp11_;
				IBusEngineDesc* _tmp12_;
				SwitcherIBusEngineButton* _tmp13_;
				gchar* longname = NULL;
				IBusEngineDesc* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* textdomain = NULL;
				IBusEngineDesc* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* transname = NULL;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				SwitcherIBusEngineButton* _tmp23_;
				SwitcherIBusEngineButton* _tmp24_;
				SwitcherIBusEngineButton* _tmp25_;
				SwitcherIBusEngineButton* _tmp26_;
				SwitcherIBusEngineButton* _tmp27_;
				SwitcherIBusEngineButton* _tmp28_;
				SwitcherIBusEngineButton* _tmp29_;
				const gchar* _tmp30_;
				GtkLabel* _tmp31_;
				const gchar* _tmp32_;
				gint width = 0;
				GtkLabel* _tmp33_;
				gint _tmp34_ = 0;
				GtkBox* _tmp35_;
				SwitcherIBusEngineButton* _tmp36_;
				SwitcherIBusEngineButton* _tmp37_;
				SwitcherIBusEngineButton* _tmp38_;
				_data11_ = g_slice_new0 (Block11Data);
				_data11_->_ref_count_ = 1;
				_data11_->self = g_object_ref (self);
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->m_engines;
				_tmp8__length1 = self->priv->m_engines_length1;
				if (!(i < _tmp8__length1)) {
					block11_data_unref (_data11_);
					_data11_ = NULL;
					break;
				}
				_data11_->index = i;
				_tmp9_ = self->priv->m_engines;
				_tmp9__length1 = self->priv->m_engines_length1;
				_tmp10_ = _tmp9_[i];
				_tmp11_ = _g_object_ref0 (_tmp10_);
				engine = _tmp11_;
				_tmp12_ = engine;
				_tmp13_ = switcher_ibus_engine_button_new (_tmp12_, self);
				g_object_ref_sink (_tmp13_);
				_data11_->button = _tmp13_;
				_tmp14_ = engine;
				_tmp15_ = ibus_engine_desc_get_longname (_tmp14_);
				_tmp16_ = g_strdup (_tmp15_);
				longname = _tmp16_;
				_tmp17_ = engine;
				_tmp18_ = ibus_engine_desc_get_textdomain (_tmp17_);
				_tmp19_ = g_strdup (_tmp18_);
				textdomain = _tmp19_;
				_tmp20_ = textdomain;
				_tmp21_ = longname;
				_tmp22_ = g_strdup (g_dgettext (_tmp20_, _tmp21_));
				transname = _tmp22_;
				_tmp23_ = _data11_->button;
				gtk_button_set_relief ((GtkButton*) _tmp23_, GTK_RELIEF_NONE);
				_tmp24_ = _data11_->button;
				gtk_widget_add_events ((GtkWidget*) _tmp24_, (gint) GDK_POINTER_MOTION_MASK);
				_tmp25_ = _data11_->button;
				gtk_widget_show ((GtkWidget*) _tmp25_);
				_tmp26_ = _data11_->button;
				g_signal_connect_object ((GtkWidget*) _tmp26_, "enter-notify-event", (GCallback) ______lambda20__gtk_widget_enter_notify_event, self, 0);
				_tmp27_ = _data11_->button;
				g_signal_connect_data ((GtkWidget*) _tmp27_, "motion-notify-event", (GCallback) ______lambda21__gtk_widget_motion_notify_event, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
				_tmp28_ = _data11_->button;
				g_signal_connect_data ((GtkWidget*) _tmp28_, "button-press-event", (GCallback) ______lambda22__gtk_widget_button_press_event, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
				_tmp29_ = _data11_->button;
				_tmp30_ = transname;
				switcher_ibus_engine_button_set_transname (_tmp29_, _tmp30_);
				_tmp31_ = self->priv->m_label;
				_tmp32_ = transname;
				gtk_label_set_label (_tmp31_, _tmp32_);
				_tmp33_ = self->priv->m_label;
				gtk_widget_get_preferred_width ((GtkWidget*) _tmp33_, NULL, &_tmp34_);
				width = _tmp34_;
				max_label_width = MAX (max_label_width, width);
				_tmp35_ = self->priv->m_box;
				_tmp36_ = _data11_->button;
				gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, TRUE, TRUE, (guint) 0);
				_tmp37_ = _data11_->button;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_vala_array_add25 (&self->priv->m_buttons, &self->priv->m_buttons_length1, &self->priv->_m_buttons_size_, _tmp38_);
				_g_free0 (transname);
				_g_free0 (textdomain);
				_g_free0 (longname);
				_g_object_unref0 (engine);
				block11_data_unref (_data11_);
				_data11_ = NULL;
			}
		}
	}
	_tmp39_ = self->priv->m_label;
	_tmp40_ = self->priv->m_buttons;
	_tmp40__length1 = self->priv->m_buttons_length1;
	_tmp41_ = _tmp40_[0];
	_tmp42_ = switcher_ibus_engine_button_get_transname (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_label_set_text (_tmp39_, _tmp43_);
	_tmp44_ = self->priv->m_label;
	gtk_label_set_ellipsize (_tmp44_, PANGO_ELLIPSIZE_END);
	_tmp45_ = gdk_display_get_default ();
	_tmp46_ = _g_object_ref0 (_tmp45_);
	display = _tmp46_;
	screen_width = 0;
	_tmp47_ = display;
	_tmp48_ = gdk_display_get_primary_monitor (_tmp47_);
	_tmp49_ = _g_object_ref0 (_tmp48_);
	monitor = _tmp49_;
	_tmp50_ = monitor;
	gdk_monitor_get_geometry (_tmp50_, &_tmp51_);
	area = _tmp51_;
	_tmp52_ = area;
	screen_width = _tmp52_.width;
	if (screen_width > 0) {
		_tmp53_ = max_label_width > (screen_width / 4);
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		max_label_width = screen_width / 4;
	}
	max_label_width += 20;
	gtk_window_set_default_size ((GtkWindow*) self, max_label_width, -1);
	_g_object_unref0 (monitor);
	_g_object_unref0 (display);
}

static void
switcher_next_engine (Switcher* self)
{
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	GtkLabel* _tmp2_;
	SwitcherIBusEngineButton** _tmp3_;
	gint _tmp3__length1;
	SwitcherIBusEngineButton* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SwitcherIBusEngineButton** _tmp7_;
	gint _tmp7__length1;
	SwitcherIBusEngineButton* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (self->priv->m_selected_engine == ((guint) (_tmp0__length1 - 1))) {
		self->priv->m_selected_engine = (guint) 0;
	} else {
		guint _tmp1_;
		_tmp1_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp1_ + 1;
	}
	_tmp2_ = self->priv->m_label;
	_tmp3_ = self->priv->m_buttons;
	_tmp3__length1 = self->priv->m_buttons_length1;
	_tmp4_ = _tmp3_[self->priv->m_selected_engine];
	_tmp5_ = switcher_ibus_engine_button_get_transname (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp2_, _tmp6_);
	_tmp7_ = self->priv->m_buttons;
	_tmp7__length1 = self->priv->m_buttons_length1;
	_tmp8_ = _tmp7_[self->priv->m_selected_engine];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp8_);
}

static void
switcher_previous_engine (Switcher* self)
{
	GtkLabel* _tmp2_;
	SwitcherIBusEngineButton** _tmp3_;
	gint _tmp3__length1;
	SwitcherIBusEngineButton* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SwitcherIBusEngineButton** _tmp7_;
	gint _tmp7__length1;
	SwitcherIBusEngineButton* _tmp8_;
	g_return_if_fail (self != NULL);
	if (self->priv->m_selected_engine == ((guint) 0)) {
		IBusEngineDesc** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->m_engines;
		_tmp0__length1 = self->priv->m_engines_length1;
		self->priv->m_selected_engine = (guint) (_tmp0__length1 - 1);
	} else {
		guint _tmp1_;
		_tmp1_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp1_ - 1;
	}
	_tmp2_ = self->priv->m_label;
	_tmp3_ = self->priv->m_buttons;
	_tmp3__length1 = self->priv->m_buttons_length1;
	_tmp4_ = _tmp3_[self->priv->m_selected_engine];
	_tmp5_ = switcher_ibus_engine_button_get_transname (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp2_, _tmp6_);
	_tmp7_ = self->priv->m_buttons;
	_tmp7__length1 = self->priv->m_buttons_length1;
	_tmp8_ = _tmp7_[self->priv->m_selected_engine];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp8_);
}

static void
switcher_restore_window_position (Switcher* self,
                                  const gchar* debug_str)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug_str != NULL);
	g_debug ("switcher.vala:404: restore_window_position %s: (%ld, %ld)\n", debug_str, (glong) self->priv->m_root_x, (glong) self->priv->m_root_y);
	if (self->priv->m_popup_delay_time_id == ((guint) 0)) {
		return;
	}
	g_source_remove (self->priv->m_popup_delay_time_id);
	self->priv->m_popup_delay_time_id = (guint) 0;
	gtk_window_move ((GtkWindow*) self, self->priv->m_root_x, self->priv->m_root_y);
}

static void
switcher_real_show (GtkWidget* base)
{
	Switcher * self;
	self = (Switcher*) base;
	GTK_WIDGET_CLASS (switcher_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_focus_visible ((GtkWindow*) self, TRUE);
}

static GdkEventKey*
_vala_GdkEventKey_copy (GdkEventKey* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventKey_copy0 (gpointer self)
{
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}

static void
_vala_GdkEventKey_free (GdkEventKey* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static gboolean
switcher_real_key_press_event (GtkWidget* base,
                               GdkEventKey* e)
{
	Switcher * self;
	gboolean retval = FALSE;
	GdkEventKey* pe = NULL;
	GdkEventKey* _tmp0_;
	gboolean result = FALSE;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	retval = TRUE;
	_tmp0_ = __vala_GdkEventKey_copy0 (e);
	pe = _tmp0_;
	if (self->priv->m_popup_delay_time > ((guint) 0)) {
		switcher_restore_window_position (self, "pressed");
	}
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			guint modifiers = 0U;
			GdkEventKey* _tmp2_;
			GdkModifierType _tmp3_;
			gboolean _tmp4_ = FALSE;
			GdkEventKey* _tmp5_;
			GdkEventKey* _tmp6_;
			if (!_tmp1_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp2_ = pe;
			_tmp3_ = _tmp2_->state;
			modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp3_;
			if (modifiers != self->priv->m_modifiers) {
				_tmp4_ = modifiers != (self->priv->m_modifiers | GDK_SHIFT_MASK);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				break;
			}
			_tmp5_ = pe;
			if (_tmp5_->keyval == self->priv->m_keyval) {
				if (modifiers == self->priv->m_modifiers) {
					switcher_next_engine (self);
				} else {
					switcher_previous_engine (self);
				}
				break;
			}
			_tmp6_ = pe;
			switch (_tmp6_->keyval) {
				case 0x08fb:
				case 0xff51:
				{
					switcher_previous_engine (self);
					break;
				}
				case 0x08fc:
				case 0xff52:
				{
					break;
				}
				case 0x08fd:
				case 0xff53:
				{
					switcher_next_engine (self);
					break;
				}
				case 0x08fe:
				case 0xff54:
				{
					break;
				}
				default:
				{
					GdkEventKey* _tmp7_;
					_tmp7_ = pe;
					g_debug ("switcher.vala:470: 0x%04x", _tmp7_->keyval);
					break;
				}
			}
		}
	}
	result = retval;
	__vala_GdkEventKey_free0 (pe);
	return result;
}

static gboolean
switcher_real_key_release_event (GtkWidget* base,
                                 GdkEventKey* e)
{
	Switcher * self;
	GdkEventKey* pe = NULL;
	GdkEventKey* _tmp0_;
	GdkEventKey* _tmp1_;
	GdkModifierType _tmp2_;
	GMainLoop* _tmp3_;
	GMainLoop* _tmp4_;
	gboolean result = FALSE;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = __vala_GdkEventKey_copy0 (e);
	pe = _tmp0_;
	_tmp1_ = pe;
	_tmp2_ = self->priv->m_primary_modifier;
	if (keybinding_manager_primary_modifier_still_pressed ((GdkEvent*) _tmp1_, (guint) _tmp2_)) {
		result = TRUE;
		__vala_GdkEventKey_free0 (pe);
		return result;
	}
	_tmp3_ = self->priv->m_loop;
	if (_tmp3_ == NULL) {
		result = FALSE;
		__vala_GdkEventKey_free0 (pe);
		return result;
	}
	if (self->priv->m_popup_delay_time > ((guint) 0)) {
		if (self->priv->m_popup_delay_time_id != ((guint) 0)) {
			g_source_remove (self->priv->m_popup_delay_time_id);
			self->priv->m_popup_delay_time_id = (guint) 0;
		}
	}
	_tmp4_ = self->priv->m_loop;
	g_main_loop_quit (_tmp4_);
	self->priv->m_result = (gint) self->priv->m_selected_engine;
	result = TRUE;
	__vala_GdkEventKey_free0 (pe);
	return result;
}

void
switcher_set_popup_delay_time (Switcher* self,
                               guint popup_delay_time)
{
	g_return_if_fail (self != NULL);
	self->priv->m_popup_delay_time = popup_delay_time;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

gchar*
switcher_get_xkb_language (Switcher* self,
                           IBusEngineDesc* engine)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* language = NULL;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gconstpointer _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gint length = 0;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gint index = 0;
	GHashTable* _tmp17_;
	GList* _tmp18_;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (engine != NULL, NULL);
	_tmp0_ = ibus_engine_desc_get_name (engine);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = string_slice (_tmp2_, (glong) 0, (glong) 4);
	_tmp4_ = _tmp3_;
	_vala_assert (g_strcmp0 (_tmp4_, "xkb:") == 0, "name[0:4] == \"xkb:\"");
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->m_xkb_languages;
	_tmp6_ = name;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	language = _tmp8_;
	_tmp9_ = language;
	if (_tmp9_ != NULL) {
		result = language;
		_g_free0 (name);
		return result;
	}
	_tmp10_ = ibus_engine_desc_get_language (engine);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (language);
	language = _tmp11_;
	_tmp12_ = language;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	length = _tmp14_;
	if (length < 2) {
		result = language;
		_g_free0 (name);
		return result;
	}
	_tmp15_ = language;
	_tmp16_ = g_utf8_strup (_tmp15_, (gssize) -1);
	_g_free0 (language);
	language = _tmp16_;
	index = 0;
	_tmp17_ = self->priv->m_xkb_languages;
	_tmp18_ = g_hash_table_get_values (_tmp17_);
	{
		GList* saved_language_collection = NULL;
		GList* saved_language_it = NULL;
		saved_language_collection = _tmp18_;
		for (saved_language_it = saved_language_collection; saved_language_it != NULL; saved_language_it = saved_language_it->next) {
			const gchar* saved_language = NULL;
			saved_language = (const gchar*) saved_language_it->data;
			{
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gboolean _tmp23_;
				_tmp19_ = language;
				_tmp20_ = saved_language;
				_tmp21_ = string_slice (_tmp20_, (glong) 0, (glong) length);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strcmp0 (_tmp19_, _tmp22_) == 0;
				_g_free0 (_tmp22_);
				if (_tmp23_) {
					gint _tmp24_;
					_tmp24_ = index;
					index = _tmp24_ + 1;
				}
			}
		}
		(saved_language_collection == NULL) ? NULL : (saved_language_collection = (g_list_free (saved_language_collection), NULL));
	}
	if (index > 0) {
		gunichar u = 0U;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		u = (gunichar) (0x2081 + index);
		_tmp25_ = language;
		_tmp26_ = g_unichar_to_string (u);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("%s%s", _tmp25_, _tmp27_);
		_g_free0 (language);
		language = _tmp28_;
		_g_free0 (_tmp27_);
	}
	_tmp29_ = self->priv->m_xkb_languages;
	_tmp30_ = name;
	_tmp31_ = g_strdup (_tmp30_);
	_tmp32_ = language;
	_tmp33_ = g_strdup (_tmp32_);
	g_hash_table_insert (_tmp29_, _tmp31_, _tmp33_);
	result = language;
	_g_free0 (name);
	return result;
}

gboolean
switcher_is_running (Switcher* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->m_is_running;
	return result;
}

gchar*
switcher_get_input_context_path (Switcher* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_input_context_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

IBusEngineDesc*
switcher_get_selected_engine (Switcher* self)
{
	IBusEngineDesc* _tmp0_;
	IBusEngineDesc* _tmp1_;
	IBusEngineDesc* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_result_engine;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
switcher_reset (Switcher* self)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_input_context_path);
	self->priv->m_input_context_path = _tmp0_;
	self->priv->m_result = -1;
	_g_object_unref0 (self->priv->m_result_engine);
	self->priv->m_result_engine = NULL;
}

static inline gpointer
switcher_ibus_engine_button_get_instance_private (SwitcherIBusEngineButton* self)
{
	return G_STRUCT_MEMBER_P (self, SwitcherIBusEngineButton_private_offset);
}

static SwitcherIBusEngineButton*
switcher_ibus_engine_button_construct (GType object_type,
                                       IBusEngineDesc* engine,
                                       Switcher* switcher)
{
	SwitcherIBusEngineButton * self = NULL;
	gchar* longname = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* textdomain = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* name = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_val_if_fail (engine != NULL, NULL);
	g_return_val_if_fail (switcher != NULL, NULL);
	self = (SwitcherIBusEngineButton*) g_object_new (object_type, NULL);
	_tmp0_ = ibus_engine_desc_get_longname (engine);
	_tmp1_ = g_strdup (_tmp0_);
	longname = _tmp1_;
	_tmp2_ = ibus_engine_desc_get_textdomain (engine);
	_tmp3_ = g_strdup (_tmp2_);
	textdomain = _tmp3_;
	_tmp4_ = textdomain;
	_tmp5_ = longname;
	switcher_ibus_engine_button_set_transname (self, g_dgettext (_tmp4_, _tmp5_));
	_tmp6_ = ibus_engine_desc_get_name (engine);
	_tmp7_ = g_strdup (_tmp6_);
	name = _tmp7_;
	_tmp9_ = name;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ < 4) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = name;
		_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) 4);
		_tmp14_ = _tmp13_;
		_tmp8_ = g_strcmp0 (_tmp14_, "xkb:") != 0;
		_g_free0 (_tmp14_);
	}
	if (_tmp8_) {
		IconWidget* icon = NULL;
		const gchar* _tmp15_;
		IconWidget* _tmp16_;
		IconWidget* _tmp17_;
		IconWidget* _tmp18_;
		IconWidget* _tmp19_;
		_tmp15_ = ibus_engine_desc_get_icon (engine);
		_tmp16_ = icon_widget_new (_tmp15_, GTK_ICON_SIZE_DIALOG);
		g_object_ref_sink (_tmp16_);
		icon = _tmp16_;
		_tmp17_ = icon;
		gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
		_tmp18_ = icon;
		gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
		_tmp19_ = icon;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp19_);
		_g_object_unref0 (icon);
	} else {
		gchar* language = NULL;
		gchar* _tmp20_;
		GtkLabel* label = NULL;
		const gchar* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		gchar* language_font = NULL;
		gchar* _tmp25_;
		gchar* markup = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		GtkLabel* _tmp29_;
		const gchar* _tmp30_;
		gint fixed_width = 0;
		gint fixed_height = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		GtkLabel* _tmp33_;
		GtkLabel* _tmp34_;
		_tmp20_ = switcher_get_xkb_language (switcher, engine);
		language = _tmp20_;
		_tmp21_ = language;
		_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
		g_object_ref_sink (_tmp22_);
		label = _tmp22_;
		_tmp23_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_CENTER);
		_tmp24_ = label;
		gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
		_tmp25_ = g_strdup ("Monospace Bold 16");
		language_font = _tmp25_;
		_tmp26_ = language_font;
		_tmp27_ = language;
		_tmp28_ = g_strdup_printf ("<span font=\"%s\">%s</span>", _tmp26_, _tmp27_);
		markup = _tmp28_;
		_tmp29_ = label;
		_tmp30_ = markup;
		gtk_label_set_markup (_tmp29_, _tmp30_);
		gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp31_, &_tmp32_);
		fixed_width = _tmp31_;
		fixed_height = _tmp32_;
		_tmp33_ = label;
		gtk_widget_set_size_request ((GtkWidget*) _tmp33_, fixed_width, fixed_height);
		_tmp34_ = label;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp34_);
		_g_free0 (markup);
		_g_free0 (language_font);
		_g_object_unref0 (label);
		_g_free0 (language);
	}
	_g_free0 (name);
	_g_free0 (textdomain);
	_g_free0 (longname);
	return self;
}

static SwitcherIBusEngineButton*
switcher_ibus_engine_button_new (IBusEngineDesc* engine,
                                 Switcher* switcher)
{
	return switcher_ibus_engine_button_construct (SWITCHER_TYPE_IBUS_ENGINE_BUTTON, engine, switcher);
}

static gboolean
switcher_ibus_engine_button_real_draw (GtkWidget* base,
                                       cairo_t* cr)
{
	SwitcherIBusEngineButton * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result = FALSE;
	self = (SwitcherIBusEngineButton*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	GTK_WIDGET_CLASS (switcher_ibus_engine_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), cr);
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		cairo_save (cr);
		cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self), (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self));
		cairo_set_source_rgba (cr, 0.0, 0.0, 1.0, 0.1);
		cairo_fill (cr);
		cairo_restore (cr);
	}
	result = TRUE;
	return result;
}

static const gchar*
switcher_ibus_engine_button_get_transname (SwitcherIBusEngineButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_transname;
	result = _tmp0_;
	return result;
}

static void
switcher_ibus_engine_button_set_transname (SwitcherIBusEngineButton* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switcher_ibus_engine_button_get_transname (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_transname);
		self->priv->_transname = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switcher_ibus_engine_button_properties[SWITCHER_IBUS_ENGINE_BUTTON_TRANSNAME_PROPERTY]);
	}
}

static void
switcher_ibus_engine_button_class_init (SwitcherIBusEngineButtonClass * klass,
                                        gpointer klass_data)
{
	switcher_ibus_engine_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitcherIBusEngineButton_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) switcher_ibus_engine_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_switcher_ibus_engine_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switcher_ibus_engine_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = switcher_ibus_engine_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHER_IBUS_ENGINE_BUTTON_TRANSNAME_PROPERTY, switcher_ibus_engine_button_properties[SWITCHER_IBUS_ENGINE_BUTTON_TRANSNAME_PROPERTY] = g_param_spec_string ("transname", "transname", "transname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
switcher_ibus_engine_button_instance_init (SwitcherIBusEngineButton * self,
                                           gpointer klass)
{
	self->priv = switcher_ibus_engine_button_get_instance_private (self);
}

static void
switcher_ibus_engine_button_finalize (GObject * obj)
{
	SwitcherIBusEngineButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton);
	_g_free0 (self->priv->_transname);
	G_OBJECT_CLASS (switcher_ibus_engine_button_parent_class)->finalize (obj);
}

static GType
switcher_ibus_engine_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitcherIBusEngineButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_ibus_engine_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitcherIBusEngineButton), 0, (GInstanceInitFunc) switcher_ibus_engine_button_instance_init, NULL };
	GType switcher_ibus_engine_button_type_id;
	switcher_ibus_engine_button_type_id = g_type_register_static (gtk_button_get_type (), "SwitcherIBusEngineButton", &g_define_type_info, 0);
	SwitcherIBusEngineButton_private_offset = g_type_add_instance_private (switcher_ibus_engine_button_type_id, sizeof (SwitcherIBusEngineButtonPrivate));
	return switcher_ibus_engine_button_type_id;
}

static GType
switcher_ibus_engine_button_get_type (void)
{
	static volatile gsize switcher_ibus_engine_button_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_ibus_engine_button_type_id__volatile)) {
		GType switcher_ibus_engine_button_type_id;
		switcher_ibus_engine_button_type_id = switcher_ibus_engine_button_get_type_once ();
		g_once_init_leave (&switcher_ibus_engine_button_type_id__volatile, switcher_ibus_engine_button_type_id);
	}
	return switcher_ibus_engine_button_type_id__volatile;
}

static void
_vala_switcher_ibus_engine_button_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SwitcherIBusEngineButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton);
	switch (property_id) {
		case SWITCHER_IBUS_ENGINE_BUTTON_TRANSNAME_PROPERTY:
		g_value_set_string (value, switcher_ibus_engine_button_get_transname (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switcher_ibus_engine_button_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SwitcherIBusEngineButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton);
	switch (property_id) {
		case SWITCHER_IBUS_ENGINE_BUTTON_TRANSNAME_PROPERTY:
		switcher_ibus_engine_button_set_transname (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
switcher_class_init (SwitcherClass * klass,
                     gpointer klass_data)
{
	switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Switcher_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) switcher_real_show;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) switcher_real_key_press_event;
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) switcher_real_key_release_event;
	G_OBJECT_CLASS (klass)->finalize = switcher_finalize;
}

static void
switcher_instance_init (Switcher * self,
                        gpointer klass)
{
	SwitcherIBusEngineButton** _tmp0_;
	gchar* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	self->priv = switcher_get_instance_private (self);
	_tmp0_ = g_new0 (SwitcherIBusEngineButton*, 0 + 1);
	self->priv->m_buttons = _tmp0_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	self->priv->m_is_running = FALSE;
	_tmp1_ = g_strdup ("");
	self->priv->m_input_context_path = _tmp1_;
	self->priv->m_result = -1;
	self->priv->m_result_engine = NULL;
	self->priv->m_popup_delay_time = (guint) 0;
	self->priv->m_popup_delay_time_id = (guint) 0;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
	self->priv->m_xkb_languages = _tmp4_;
}

static void
switcher_finalize (GObject * obj)
{
	Switcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWITCHER, Switcher);
	_g_object_unref0 (self->priv->m_box);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (self->priv->m_input_context_path);
	_g_main_loop_unref0 (self->priv->m_loop);
	_g_object_unref0 (self->priv->m_result_engine);
	_g_hash_table_unref0 (self->priv->m_xkb_languages);
	G_OBJECT_CLASS (switcher_parent_class)->finalize (obj);
}

static GType
switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Switcher), 0, (GInstanceInitFunc) switcher_instance_init, NULL };
	GType switcher_type_id;
	switcher_type_id = g_type_register_static (gtk_window_get_type (), "Switcher", &g_define_type_info, 0);
	Switcher_private_offset = g_type_add_instance_private (switcher_type_id, sizeof (SwitcherPrivate));
	return switcher_type_id;
}

GType
switcher_get_type (void)
{
	static volatile gsize switcher_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_type_id__volatile)) {
		GType switcher_type_id;
		switcher_type_id = switcher_get_type_once ();
		g_once_init_leave (&switcher_type_id__volatile, switcher_type_id);
	}
	return switcher_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

