# makefile variables and rules shared by both gkrellm and gkrellmd

GKRELLM_VERSION_MAJOR = 2
GKRELLM_VERSION_MINOR = 5
GKRELLM_VERSION_PATCH = 0
GKRELLM_VERSION = $(GKRELLM_VERSION_MAJOR).$(GKRELLM_VERSION_MINOR).$(GKRELLM_VERSION_PATCH)

ifdef CROSS
	# enforce overriding tools for mxe cross builds (http://mxe.cc)
	CC = $(CROSS)gcc
	AR = $(CROSS)ar
	PKG_CONFIG = $(CROSS)pkg-config
	WINDRES = $(CROSS)windres
else
	CC ?= gcc
	AR ?= ar
	PKG_CONFIG ?= pkg-config
	WINDRES ?= windres
endif

# Make configure use identical environment
export CC
export PKG_CONFIG

PREFIX ?= $(INSTALLROOT)
ifeq ($(PREFIX),)
	PREFIX = /usr/local
endif

BINEXT ?=

# Installation path for gkrellm binary
INSTALLDIR ?= $(PREFIX)/bin

# Installation path for gkrellmd binary
SINSTALLDIR ?= $(PREFIX)/bin

# Installation path for gkrellm2 include dir and include files
INCLUDEDIR ?= $(PREFIX)/include

LIBDIR ?= $(PREFIX)/lib

LOCALEDIR ?= $(PREFIX)/share/locale

# Installation path for pkg-config development file
PKGCONFIGDIR ?= $(PREFIX)/lib/pkgconfig

# man-page section for gkrellm manual installation
MANSECTION ?= 1
# Installation path for gkrellm manual
MANDIR ?= $(PREFIX)/share/man/man$(MANSECTION)

# man-page section for gkrellmd manual installation
SMANSECTION ?= 1
# Installation path for gkrellmd manual
SMANDIR ?= $(PREFIX)/share/man/man$(SMANSECTION)

INSTALL ?= install
INSTALL_DATA ?= $(INSTALL) -m 644
INSTALL_DIRECTORY ?= $(INSTALL) -d
INSTALL_PROGRAM ?= $(INSTALL)

LINK_FLAGS ?= -Wl,-E

SHARED_PATH = ../shared

# C standard that gkrellm code targets. Can be overridden
STD_FLAGS ?= -std=gnu99

# Warning flags. Can be overridden
WARN_FLAGS ?= -Wall

FLAGS = $(STD_FLAGS) $(WARN_FLAGS) -I.. -I$(SHARED_PATH)

# optimized build. Enabled by default
optimize ?= 1
ifeq ($(optimize),1)
    FLAGS += -O2
endif

# debug build. Disabled by default
ifeq ($(debug),1)
    FLAGS += -g
endif

# profile build. Disabled by default
ifeq ($(profile),1)
    FLAGS += -g -pg
endif

# i18n support. Enabled by default
enable_nls ?= 1
ifeq ($(enable_nls),1)
    FLAGS += -DENABLE_NLS -DLOCALEDIR=\"$(LOCALEDIR)\"
endif

%.o: %.c
	$(CC) -c $(FLAGS) $(CFLAGS) $(CPPFLAGS) $< -o $@

%-version.h: %-version.h.in
	sed \
		-e 's#@GKRELLM_VERSION_MAJOR@#$(GKRELLM_VERSION_MAJOR)#g'\
		-e 's#@GKRELLM_VERSION_MINOR@#$(GKRELLM_VERSION_MINOR)#g'\
		-e 's#@GKRELLM_VERSION_PATCH@#$(GKRELLM_VERSION_PATCH)#g'\
		$< > $@

%.rc: %.rc.in
	sed \
		-e 's#@GKRELLM_VERSION_MAJOR@#$(GKRELLM_VERSION_MAJOR)#g'\
		-e 's#@GKRELLM_VERSION_MINOR@#$(GKRELLM_VERSION_MINOR)#g'\
		-e 's#@GKRELLM_VERSION_PATCH@#$(GKRELLM_VERSION_PATCH)#g'\
		-e 's#@GKRELLM_VERSION@#$(GKRELLM_VERSION)#g'\
		$< > $@
