/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _is_chainup;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_is_chainup (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

void
vala_object_creation_expression_set_is_chainup (ValaObjectCreationExpression* self,
                                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	ValaDataType* _tmp118_;
	ValaDataType* _tmp119_;
	ValaTypeSymbol* _tmp120_;
	ValaDataType* _tmp226_;
	ValaDataType* _tmp227_;
	gboolean _tmp228_ = FALSE;
	ValaSymbol* _tmp229_;
	ValaSymbol* _tmp230_;
	ValaSymbol* _tmp239_;
	ValaSymbol* _tmp240_;
	ValaTypeSymbol* _tmp493_;
	gboolean _tmp494_;
	gboolean _tmp495_;
	gboolean _tmp583_;
	gboolean _tmp584_;
	gboolean _tmp640_;
	gboolean _tmp641_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp54_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp45_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp46_;
			ValaMemberAccess* _tmp47_;
			ValaExpression* _tmp48_;
			ValaExpression* _tmp49_;
			ValaMemberAccess* _tmp50_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp41_, "`%s' is not a creation method", _tmp44_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp45_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp45_);
			_tmp46_ = vala_object_creation_expression_get_member_name (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_member_access_get_inner (_tmp47_);
			_tmp49_ = _tmp48_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
			_tmp50_ = ma;
			if (_tmp50_ != NULL) {
				ValaMemberAccess* _tmp51_;
				ValaList* _tmp52_;
				ValaList* _tmp53_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_type_arguments (_tmp51_);
				_tmp53_ = _vala_iterable_ref0 (_tmp52_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp53_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp54_ = type_sym;
		if (VALA_IS_CLASS (_tmp54_)) {
			ValaSymbol* _tmp55_;
			ValaTypeSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp59_;
			_tmp55_ = type_sym;
			_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp56_;
			_tmp57_ = type;
			_tmp58_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_CLASS, ValaClass));
			_tmp59_ = _tmp58_;
			if (_tmp59_) {
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaErrorType* _tmp62_;
				ValaErrorType* _tmp63_;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_error_type_new (NULL, NULL, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp63_);
				_vala_code_node_unref0 (_tmp63_);
			} else {
				ValaTypeSymbol* _tmp64_;
				ValaObjectType* _tmp65_;
				ValaObjectType* _tmp66_;
				ValaDataType* _tmp67_;
				ValaDataType* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp64_ = type;
				_tmp65_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CLASS, ValaClass));
				_tmp66_ = _tmp65_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_tmp67_ = vala_object_creation_expression_get_type_reference (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp68_, _tmp70_);
			}
		} else {
			ValaSymbol* _tmp71_;
			_tmp71_ = type_sym;
			if (VALA_IS_STRUCT (_tmp71_)) {
				ValaSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaTypeSymbol* _tmp74_;
				ValaStructValueType* _tmp75_;
				ValaStructValueType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				ValaSourceReference* _tmp79_;
				ValaSourceReference* _tmp80_;
				_tmp72_ = type_sym;
				_tmp73_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp73_;
				_tmp74_ = type;
				_tmp75_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp76_ = _tmp75_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp76_);
				_vala_code_node_unref0 (_tmp76_);
				_tmp77_ = vala_object_creation_expression_get_type_reference (self);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp80_ = _tmp79_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp78_, _tmp80_);
			} else {
				ValaSymbol* _tmp81_;
				_tmp81_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp81_)) {
					ValaSymbol* _tmp82_;
					ValaTypeSymbol* _tmp83_;
					ValaSymbol* _tmp84_;
					ValaSymbol* _tmp85_;
					ValaSymbol* _tmp86_;
					ValaSymbol* _tmp87_;
					ValaSourceReference* _tmp88_;
					ValaSourceReference* _tmp89_;
					ValaErrorType* _tmp90_;
					ValaErrorType* _tmp91_;
					ValaSymbol* _tmp92_;
					_tmp82_ = type_sym;
					_tmp83_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp83_;
					_tmp84_ = type_sym;
					_tmp85_ = vala_symbol_get_parent_symbol (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = type_sym;
					_tmp88_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp89_ = _tmp88_;
					_tmp90_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp89_);
					_tmp91_ = _tmp90_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp91_);
					_vala_code_node_unref0 (_tmp91_);
					_tmp92_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				} else {
					ValaSourceReference* _tmp93_;
					ValaSourceReference* _tmp94_;
					ValaSymbol* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp94_ = _tmp93_;
					_tmp95_ = type_sym;
					_tmp96_ = vala_symbol_get_full_name (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_report_error (_tmp94_, "`%s' is not a class, struct, or error code", _tmp97_);
					_g_free0 (_tmp97_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp98_;
			gint _type_arg_size = 0;
			ValaList* _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
			gint _type_arg_index = 0;
			_tmp98_ = type_args;
			_type_arg_list = _tmp98_;
			_tmp99_ = _type_arg_list;
			_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
			_tmp101_ = _tmp100_;
			_type_arg_size = _tmp101_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp102_;
				gint _tmp103_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp104_;
				gpointer _tmp105_;
				ValaDataType* _tmp106_;
				ValaDataType* _tmp107_;
				ValaDataType* _tmp108_;
				_type_arg_index = _type_arg_index + 1;
				_tmp102_ = _type_arg_index;
				_tmp103_ = _type_arg_size;
				if (!(_tmp102_ < _tmp103_)) {
					break;
				}
				_tmp104_ = _type_arg_list;
				_tmp105_ = vala_list_get (_tmp104_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp105_;
				_tmp106_ = vala_object_creation_expression_get_type_reference (self);
				_tmp107_ = _tmp106_;
				_tmp108_ = type_arg;
				vala_data_type_add_type_argument (_tmp107_, _tmp108_);
				_vala_code_node_unref0 (type_arg);
			}
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		ValaTypeSymbol* _tmp111_;
		ValaTypeSymbol* _tmp112_;
		ValaTypeSymbol* _tmp113_;
		_tmp109_ = vala_object_creation_expression_get_type_reference (self);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_data_type_get_type_symbol (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = _vala_code_node_ref0 (_tmp112_);
		_vala_code_node_unref0 (type);
		type = _tmp113_;
	}
	_tmp114_ = vala_object_creation_expression_get_type_reference (self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_data_type_copy (_tmp115_);
	_tmp117_ = _tmp116_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp117_);
	_vala_code_node_unref0 (_tmp117_);
	_tmp118_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp119_ = _tmp118_;
	vala_data_type_set_value_owned (_tmp119_, TRUE);
	_tmp120_ = type;
	if (VALA_IS_CLASS (_tmp120_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp121_;
		ValaClass* _tmp122_;
		gboolean _tmp123_;
		ValaClass* _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp128_;
		ValaSymbol* _tmp134_;
		ValaSymbol* _tmp135_;
		gboolean _tmp154_ = FALSE;
		ValaSymbol* _tmp155_;
		ValaSymbol* _tmp156_;
		_tmp121_ = type;
		_tmp122_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp122_;
		_tmp123_ = self->priv->_struct_creation;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			vala_report_error (_tmp125_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp126_ = cl;
		_tmp127_ = vala_class_get_is_abstract (_tmp126_);
		_tmp128_ = _tmp127_;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			ValaClass* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = cl;
			_tmp132_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp131_);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp130_, "Can't create instance of abstract class `%s'", _tmp133_);
			_g_free0 (_tmp133_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp135_ = _tmp134_;
		if (_tmp135_ == NULL) {
			ValaClass* _tmp136_;
			ValaCreationMethod* _tmp137_;
			ValaCreationMethod* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaSymbol* _tmp146_;
			ValaSymbol* _tmp147_;
			ValaSymbol* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaVersionAttribute* _tmp150_;
			ValaVersionAttribute* _tmp151_;
			ValaSourceReference* _tmp152_;
			ValaSourceReference* _tmp153_;
			_tmp136_ = cl;
			_tmp137_ = vala_class_get_default_construction_method (_tmp136_);
			_tmp138_ = _tmp137_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp138_);
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				ValaClass* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp143_ = cl;
				_tmp144_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp143_);
				_tmp145_ = _tmp144_;
				vala_report_error (_tmp142_, "`%s' does not have a default constructor", _tmp145_);
				_g_free0 (_tmp145_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp147_ = _tmp146_;
			vala_symbol_set_used (_tmp147_, TRUE);
			_tmp148_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_symbol_get_version (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp153_ = _tmp152_;
			vala_version_attribute_check (_tmp151_, context, _tmp153_);
		}
		_tmp155_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp156_ = _tmp155_;
		if (_tmp156_ != NULL) {
			gboolean _tmp157_ = FALSE;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaSymbolAccessibility _tmp160_;
			ValaSymbolAccessibility _tmp161_;
			_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_symbol_get_access (_tmp159_);
			_tmp161_ = _tmp160_;
			if (_tmp161_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp157_ = TRUE;
			} else {
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaSymbolAccessibility _tmp164_;
				ValaSymbolAccessibility _tmp165_;
				_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_symbol_get_access (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp157_ = _tmp165_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp154_ = _tmp157_;
		} else {
			_tmp154_ = FALSE;
		}
		if (_tmp154_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp166_;
				ValaSemanticAnalyzer* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSymbol* _tmp170_;
				_tmp166_ = vala_code_context_get_analyzer (context);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_semantic_analyzer_get_current_symbol (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = _vala_code_node_ref0 (_tmp169_);
				this_symbol = _tmp170_;
				{
					gboolean _tmp171_ = FALSE;
					_tmp171_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp176_;
						ValaSymbol* _tmp177_;
						ValaClass* _tmp178_;
						if (!_tmp171_) {
							ValaSymbol* _tmp172_;
							ValaSymbol* _tmp173_;
							ValaSymbol* _tmp174_;
							ValaSymbol* _tmp175_;
							_tmp172_ = this_symbol;
							_tmp173_ = vala_symbol_get_parent_symbol (_tmp172_);
							_tmp174_ = _tmp173_;
							_tmp175_ = _vala_code_node_ref0 (_tmp174_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp175_;
						}
						_tmp171_ = FALSE;
						_tmp176_ = this_symbol;
						if (!(_tmp176_ != NULL)) {
							break;
						}
						_tmp177_ = this_symbol;
						_tmp178_ = cl;
						if (_tmp177_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp178_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp179_;
				ValaSourceReference* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				gchar* _tmp183_;
				gchar* _tmp184_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_symbol_get_full_name (_tmp182_);
				_tmp184_ = _tmp183_;
				vala_report_error (_tmp180_, "Access to non-public constructor `%s' denied", _tmp184_);
				_g_free0 (_tmp184_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp185_;
			ValaClass* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			gboolean _tmp189_;
			ValaClass* _tmp192_;
			ValaClass* _tmp193_;
			ValaClass* _tmp194_;
			ValaClass* _tmp195_;
			_tmp185_ = cl;
			if (!(_tmp185_ != NULL)) {
				break;
			}
			_tmp186_ = cl;
			_tmp187_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp186_, "CCode", "ref_sink_function", NULL);
			_tmp188_ = _tmp187_;
			_tmp189_ = _tmp188_ != NULL;
			_g_free0 (_tmp188_);
			if (_tmp189_) {
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				_tmp190_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp191_ = _tmp190_;
				vala_data_type_set_floating_reference (_tmp191_, TRUE);
				break;
			}
			_tmp192_ = cl;
			_tmp193_ = vala_class_get_base_class (_tmp192_);
			_tmp194_ = _tmp193_;
			_tmp195_ = _vala_code_node_ref0 (_tmp194_);
			_vala_code_node_unref0 (cl);
			cl = _tmp195_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp196_;
		_tmp196_ = type;
		if (VALA_IS_STRUCT (_tmp196_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp197_;
			ValaStruct* _tmp198_;
			gboolean _tmp199_ = FALSE;
			gboolean _tmp200_;
			ValaSymbol* _tmp205_;
			ValaSymbol* _tmp206_;
			gboolean _tmp210_ = FALSE;
			gboolean _tmp211_ = FALSE;
			gboolean _tmp212_ = FALSE;
			ValaProfile _tmp213_;
			ValaProfile _tmp214_;
			_tmp197_ = type;
			_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp198_;
			_tmp200_ = self->priv->_struct_creation;
			if (!_tmp200_) {
				gboolean _tmp201_;
				gboolean _tmp202_;
				_tmp201_ = vala_code_context_get_deprecated (context);
				_tmp202_ = _tmp201_;
				_tmp199_ = !_tmp202_;
			} else {
				_tmp199_ = FALSE;
			}
			if (_tmp199_) {
				ValaSourceReference* _tmp203_;
				ValaSourceReference* _tmp204_;
				_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp204_ = _tmp203_;
				vala_report_warning (_tmp204_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp205_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp206_ = _tmp205_;
			if (_tmp206_ == NULL) {
				ValaStruct* _tmp207_;
				ValaCreationMethod* _tmp208_;
				ValaCreationMethod* _tmp209_;
				_tmp207_ = st;
				_tmp208_ = vala_struct_get_default_construction_method (_tmp207_);
				_tmp209_ = _tmp208_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp209_);
			}
			_tmp213_ = vala_code_context_get_profile (context);
			_tmp214_ = _tmp213_;
			if (_tmp214_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp215_;
				_tmp215_ = st;
				_tmp212_ = vala_struct_is_simple_type (_tmp215_);
			} else {
				_tmp212_ = FALSE;
			}
			if (_tmp212_) {
				ValaSymbol* _tmp216_;
				ValaSymbol* _tmp217_;
				_tmp216_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp217_ = _tmp216_;
				_tmp211_ = _tmp217_ == NULL;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaList* _tmp218_;
				gint _tmp219_;
				gint _tmp220_;
				_tmp218_ = self->priv->object_initializer;
				_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
				_tmp220_ = _tmp219_;
				_tmp210_ = _tmp220_ == 0;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				ValaSourceReference* _tmp221_;
				ValaSourceReference* _tmp222_;
				ValaStruct* _tmp223_;
				gchar* _tmp224_;
				gchar* _tmp225_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp222_ = _tmp221_;
				_tmp223_ = st;
				_tmp224_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp223_);
				_tmp225_ = _tmp224_;
				vala_report_error (_tmp222_, "`%s' does not have a default constructor", _tmp225_);
				_g_free0 (_tmp225_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp226_ = vala_object_creation_expression_get_type_reference (self);
	_tmp227_ = _tmp226_;
	if (!vala_data_type_check_type_arguments (_tmp227_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp229_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp230_ = _tmp229_;
	if (_tmp230_ == NULL) {
		ValaList* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		_tmp231_ = self->priv->argument_list;
		_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
		_tmp233_ = _tmp232_;
		_tmp228_ = _tmp233_ != 0;
	} else {
		_tmp228_ = FALSE;
	}
	if (_tmp228_) {
		ValaSourceReference* _tmp234_;
		ValaSourceReference* _tmp235_;
		ValaTypeSymbol* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp235_ = _tmp234_;
		_tmp236_ = type;
		_tmp237_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp236_);
		_tmp238_ = _tmp237_;
		vala_report_error (_tmp235_, "No arguments allowed when constructing type `%s'", _tmp238_);
		_g_free0 (_tmp238_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp239_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp240_ = _tmp239_;
	if (VALA_IS_METHOD (_tmp240_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp241_;
		ValaSymbol* _tmp242_;
		ValaMethod* _tmp243_;
		gboolean _tmp244_;
		gboolean _tmp245_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp270_;
		ValaIterator* _tmp271_;
		ValaMethod* _tmp322_;
		gboolean _tmp323_;
		gboolean _tmp324_;
		ValaSemanticAnalyzer* _tmp387_;
		ValaSemanticAnalyzer* _tmp388_;
		ValaMethod* _tmp389_;
		ValaMethodType* _tmp390_;
		ValaMethodType* _tmp391_;
		ValaMethod* _tmp392_;
		ValaList* _tmp393_;
		ValaList* _tmp394_;
		_tmp241_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp242_ = _tmp241_;
		_tmp243_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp242_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp243_;
		_tmp244_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp245_ = _tmp244_;
		if (_tmp245_) {
			ValaMethod* _tmp246_;
			gboolean _tmp247_;
			gboolean _tmp248_;
			gboolean _tmp251_ = FALSE;
			ValaSemanticAnalyzer* _tmp252_;
			ValaSemanticAnalyzer* _tmp253_;
			ValaMethod* _tmp254_;
			ValaMethod* _tmp255_;
			_tmp246_ = m;
			_tmp247_ = vala_method_get_coroutine (_tmp246_);
			_tmp248_ = _tmp247_;
			if (!_tmp248_) {
				ValaSourceReference* _tmp249_;
				ValaSourceReference* _tmp250_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp250_ = _tmp249_;
				vala_report_error (_tmp250_, "yield expression requires async method");
			}
			_tmp252_ = vala_code_context_get_analyzer (context);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_semantic_analyzer_get_current_method (_tmp253_);
			_tmp255_ = _tmp254_;
			if (_tmp255_ == NULL) {
				_tmp251_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp256_;
				ValaSemanticAnalyzer* _tmp257_;
				ValaMethod* _tmp258_;
				ValaMethod* _tmp259_;
				gboolean _tmp260_;
				gboolean _tmp261_;
				_tmp256_ = vala_code_context_get_analyzer (context);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_semantic_analyzer_get_current_method (_tmp257_);
				_tmp259_ = _tmp258_;
				_tmp260_ = vala_method_get_coroutine (_tmp259_);
				_tmp261_ = _tmp260_;
				_tmp251_ = !_tmp261_;
			}
			if (_tmp251_) {
				ValaSourceReference* _tmp262_;
				ValaSourceReference* _tmp263_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp263_ = _tmp262_;
				vala_report_error (_tmp263_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp264_;
			_tmp264_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp264_)) {
				ValaMethod* _tmp265_;
				gboolean _tmp266_;
				gboolean _tmp267_;
				_tmp265_ = m;
				_tmp266_ = vala_method_get_coroutine (_tmp265_);
				_tmp267_ = _tmp266_;
				if (_tmp267_) {
					ValaSourceReference* _tmp268_;
					ValaSourceReference* _tmp269_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp269_ = _tmp268_;
					vala_report_error (_tmp269_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp270_ = self->priv->argument_list;
		_tmp271_ = vala_iterable_iterator ((ValaIterable*) _tmp270_);
		arg_it = _tmp271_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp272_;
			ValaList* _tmp273_;
			gint _param_size = 0;
			ValaList* _tmp274_;
			gint _tmp275_;
			gint _tmp276_;
			gint _param_index = 0;
			_tmp272_ = m;
			_tmp273_ = vala_callable_get_parameters ((ValaCallable*) _tmp272_);
			_param_list = _tmp273_;
			_tmp274_ = _param_list;
			_tmp275_ = vala_collection_get_size ((ValaCollection*) _tmp274_);
			_tmp276_ = _tmp275_;
			_param_size = _tmp276_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp277_;
				gint _tmp278_;
				ValaParameter* param = NULL;
				ValaList* _tmp279_;
				gpointer _tmp280_;
				ValaParameter* _tmp281_;
				ValaParameter* _tmp282_;
				gboolean _tmp283_;
				gboolean _tmp284_;
				ValaParameter* _tmp285_;
				gboolean _tmp286_;
				gboolean _tmp287_;
				ValaIterator* _tmp305_;
				_param_index = _param_index + 1;
				_tmp277_ = _param_index;
				_tmp278_ = _param_size;
				if (!(_tmp277_ < _tmp278_)) {
					break;
				}
				_tmp279_ = _param_list;
				_tmp280_ = vala_list_get (_tmp279_, _param_index);
				param = (ValaParameter*) _tmp280_;
				_tmp281_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp281_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp282_ = param;
				_tmp283_ = vala_parameter_get_ellipsis (_tmp282_);
				_tmp284_ = _tmp283_;
				if (_tmp284_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp285_ = param;
				_tmp286_ = vala_parameter_get_params_array (_tmp285_);
				_tmp287_ = _tmp286_;
				if (_tmp287_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp288_;
					ValaDataType* _tmp289_;
					ValaDataType* _tmp290_;
					ValaArrayType* _tmp291_;
					_tmp288_ = param;
					_tmp289_ = vala_variable_get_variable_type ((ValaVariable*) _tmp288_);
					_tmp290_ = _tmp289_;
					_tmp291_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp291_;
					while (TRUE) {
						ValaIterator* _tmp292_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp293_;
						gpointer _tmp294_;
						ValaExpression* _tmp295_;
						ValaArrayType* _tmp296_;
						ValaDataType* _tmp297_;
						ValaDataType* _tmp298_;
						ValaExpression* _tmp299_;
						ValaDataType* _tmp300_;
						ValaDataType* _tmp301_;
						ValaArrayType* _tmp302_;
						gboolean _tmp303_;
						gboolean _tmp304_;
						_tmp292_ = arg_it;
						if (!vala_iterator_next (_tmp292_)) {
							break;
						}
						_tmp293_ = arg_it;
						_tmp294_ = vala_iterator_get (_tmp293_);
						arg = (ValaExpression*) _tmp294_;
						_tmp295_ = arg;
						_tmp296_ = array_type;
						_tmp297_ = vala_array_type_get_element_type (_tmp296_);
						_tmp298_ = _tmp297_;
						vala_expression_set_target_type (_tmp295_, _tmp298_);
						_tmp299_ = arg;
						_tmp300_ = vala_expression_get_target_type (_tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = array_type;
						_tmp303_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp302_);
						_tmp304_ = _tmp303_;
						vala_data_type_set_value_owned (_tmp301_, _tmp304_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp305_ = arg_it;
				if (vala_iterator_next (_tmp305_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp306_;
					gpointer _tmp307_;
					ValaExpression* _tmp308_;
					ValaParameter* _tmp309_;
					ValaDataType* _tmp310_;
					ValaDataType* _tmp311_;
					ValaExpression* _tmp312_;
					ValaExpression* _tmp313_;
					ValaDataType* _tmp314_;
					ValaDataType* _tmp315_;
					ValaDataType* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaExpression* _tmp320_;
					ValaExpression* _tmp321_;
					_tmp306_ = arg_it;
					_tmp307_ = vala_iterator_get (_tmp306_);
					arg = (ValaExpression*) _tmp307_;
					_tmp308_ = arg;
					_tmp309_ = param;
					_tmp310_ = vala_variable_get_variable_type ((ValaVariable*) _tmp309_);
					_tmp311_ = _tmp310_;
					vala_expression_set_formal_target_type (_tmp308_, _tmp311_);
					_tmp312_ = arg;
					_tmp313_ = arg;
					_tmp314_ = vala_expression_get_formal_target_type (_tmp313_);
					_tmp315_ = _tmp314_;
					_tmp316_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp317_ = _tmp316_;
					_tmp318_ = vala_data_type_get_actual_type (_tmp315_, _tmp317_, NULL, (ValaCodeNode*) self);
					_tmp319_ = _tmp318_;
					vala_expression_set_target_type (_tmp312_, _tmp319_);
					_vala_code_node_unref0 (_tmp319_);
					_tmp320_ = arg;
					_tmp321_ = _vala_code_node_ref0 (_tmp320_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp321_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp322_ = m;
		_tmp323_ = vala_method_get_printf_format (_tmp322_);
		_tmp324_ = _tmp323_;
		if (_tmp324_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp325_;
			ValaStringLiteral* _tmp369_;
			format_literal = NULL;
			_tmp325_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp325_)) {
			} else {
				ValaExpression* _tmp326_;
				_tmp326_ = last_arg;
				if (_tmp326_ != NULL) {
					ValaExpression* _tmp327_;
					ValaStringLiteral* _tmp328_;
					gboolean _tmp329_ = FALSE;
					ValaStringLiteral* _tmp330_;
					_tmp327_ = last_arg;
					_tmp328_ = vala_string_literal_get_format_literal (_tmp327_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp328_;
					_tmp330_ = format_literal;
					if (_tmp330_ == NULL) {
						ValaList* _tmp331_;
						gint _tmp332_;
						gint _tmp333_;
						ValaMethod* _tmp334_;
						ValaList* _tmp335_;
						gint _tmp336_;
						gint _tmp337_;
						_tmp331_ = self->priv->argument_list;
						_tmp332_ = vala_collection_get_size ((ValaCollection*) _tmp331_);
						_tmp333_ = _tmp332_;
						_tmp334_ = m;
						_tmp335_ = vala_callable_get_parameters ((ValaCallable*) _tmp334_);
						_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
						_tmp337_ = _tmp336_;
						_tmp329_ = _tmp333_ == (_tmp337_ - 1);
					} else {
						_tmp329_ = FALSE;
					}
					if (_tmp329_) {
						ValaStringLiteral* _tmp338_;
						ValaStringLiteral* _tmp339_;
						ValaSemanticAnalyzer* _tmp340_;
						ValaSemanticAnalyzer* _tmp341_;
						ValaDataType* _tmp342_;
						ValaDataType* _tmp343_;
						ValaDataType* _tmp344_;
						ValaList* _tmp345_;
						ValaList* _tmp346_;
						gint _tmp347_;
						gint _tmp348_;
						ValaStringLiteral* _tmp349_;
						ValaList* _tmp350_;
						ValaIterator* _tmp351_;
						_tmp338_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp338_;
						_tmp339_ = format_literal;
						_tmp340_ = vala_code_context_get_analyzer (context);
						_tmp341_ = _tmp340_;
						_tmp342_ = _tmp341_->string_type;
						_tmp343_ = vala_data_type_copy (_tmp342_);
						_tmp344_ = _tmp343_;
						vala_expression_set_target_type ((ValaExpression*) _tmp339_, _tmp344_);
						_vala_code_node_unref0 (_tmp344_);
						_tmp345_ = self->priv->argument_list;
						_tmp346_ = self->priv->argument_list;
						_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = format_literal;
						vala_list_insert (_tmp345_, _tmp348_ - 1, (ValaExpression*) _tmp349_);
						_tmp350_ = self->priv->argument_list;
						_tmp351_ = vala_iterable_iterator ((ValaIterable*) _tmp350_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp351_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp352_;
							ValaList* _tmp353_;
							gint _param_size = 0;
							ValaList* _tmp354_;
							gint _tmp355_;
							gint _tmp356_;
							gint _param_index = 0;
							_tmp352_ = m;
							_tmp353_ = vala_callable_get_parameters ((ValaCallable*) _tmp352_);
							_param_list = _tmp353_;
							_tmp354_ = _param_list;
							_tmp355_ = vala_collection_get_size ((ValaCollection*) _tmp354_);
							_tmp356_ = _tmp355_;
							_param_size = _tmp356_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp357_;
								gint _tmp358_;
								ValaParameter* param = NULL;
								ValaList* _tmp359_;
								gpointer _tmp360_;
								gboolean _tmp361_ = FALSE;
								ValaParameter* _tmp362_;
								gboolean _tmp363_;
								gboolean _tmp364_;
								ValaIterator* _tmp368_;
								_param_index = _param_index + 1;
								_tmp357_ = _param_index;
								_tmp358_ = _param_size;
								if (!(_tmp357_ < _tmp358_)) {
									break;
								}
								_tmp359_ = _param_list;
								_tmp360_ = vala_list_get (_tmp359_, _param_index);
								param = (ValaParameter*) _tmp360_;
								_tmp362_ = param;
								_tmp363_ = vala_parameter_get_ellipsis (_tmp362_);
								_tmp364_ = _tmp363_;
								if (_tmp364_) {
									_tmp361_ = TRUE;
								} else {
									ValaParameter* _tmp365_;
									gboolean _tmp366_;
									gboolean _tmp367_;
									_tmp365_ = param;
									_tmp366_ = vala_parameter_get_params_array (_tmp365_);
									_tmp367_ = _tmp366_;
									_tmp361_ = _tmp367_;
								}
								if (_tmp361_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp368_ = arg_it;
								vala_iterator_next (_tmp368_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp369_ = format_literal;
			if (_tmp369_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp370_;
				gchar* _tmp371_;
				ValaSemanticAnalyzer* _tmp372_;
				ValaSemanticAnalyzer* _tmp373_;
				const gchar* _tmp374_;
				ValaIterator* _tmp375_;
				ValaSourceReference* _tmp376_;
				ValaSourceReference* _tmp377_;
				_tmp370_ = format_literal;
				_tmp371_ = vala_string_literal_eval (_tmp370_);
				format = _tmp371_;
				_tmp372_ = vala_code_context_get_analyzer (context);
				_tmp373_ = _tmp372_;
				_tmp374_ = format;
				_tmp375_ = arg_it;
				_tmp376_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp377_ = _tmp376_;
				if (!vala_semantic_analyzer_check_print_format (_tmp373_, _tmp374_, _tmp375_, _tmp377_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp378_;
			gint _arg_size = 0;
			ValaList* _tmp379_;
			gint _tmp380_;
			gint _tmp381_;
			gint _arg_index = 0;
			_tmp378_ = self->priv->argument_list;
			_arg_list = _tmp378_;
			_tmp379_ = _arg_list;
			_tmp380_ = vala_collection_get_size ((ValaCollection*) _tmp379_);
			_tmp381_ = _tmp380_;
			_arg_size = _tmp381_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp382_;
				gint _tmp383_;
				ValaExpression* arg = NULL;
				ValaList* _tmp384_;
				gpointer _tmp385_;
				ValaExpression* _tmp386_;
				_arg_index = _arg_index + 1;
				_tmp382_ = _arg_index;
				_tmp383_ = _arg_size;
				if (!(_tmp382_ < _tmp383_)) {
					break;
				}
				_tmp384_ = _arg_list;
				_tmp385_ = vala_list_get (_tmp384_, _arg_index);
				arg = (ValaExpression*) _tmp385_;
				_tmp386_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp386_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp387_ = vala_code_context_get_analyzer (context);
		_tmp388_ = _tmp387_;
		_tmp389_ = m;
		_tmp390_ = vala_method_type_new (_tmp389_);
		_tmp391_ = _tmp390_;
		_tmp392_ = m;
		_tmp393_ = vala_callable_get_parameters ((ValaCallable*) _tmp392_);
		_tmp394_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp388_, (ValaExpression*) self, (ValaDataType*) _tmp391_, _tmp393_, _tmp394_);
		_vala_code_node_unref0 (_tmp391_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp395_;
		ValaDataType* _tmp396_;
		_tmp395_ = vala_object_creation_expression_get_type_reference (self);
		_tmp396_ = _tmp395_;
		if (VALA_IS_ERROR_TYPE (_tmp396_)) {
			ValaDataType* _tmp397_;
			ValaDataType* _tmp398_;
			ValaMemberAccess* _tmp401_;
			ValaMemberAccess* _tmp402_;
			ValaList* _tmp423_;
			gint _tmp424_;
			gint _tmp425_;
			_tmp397_ = vala_object_creation_expression_get_type_reference (self);
			_tmp398_ = _tmp397_;
			if (_tmp398_ != NULL) {
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				_tmp399_ = vala_object_creation_expression_get_type_reference (self);
				_tmp400_ = _tmp399_;
				vala_code_node_check ((ValaCodeNode*) _tmp400_, context);
			}
			_tmp401_ = vala_object_creation_expression_get_member_name (self);
			_tmp402_ = _tmp401_;
			if (_tmp402_ != NULL) {
				ValaMemberAccess* _tmp403_;
				ValaMemberAccess* _tmp404_;
				_tmp403_ = vala_object_creation_expression_get_member_name (self);
				_tmp404_ = _tmp403_;
				vala_code_node_check ((ValaCodeNode*) _tmp404_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp405_;
				gint _arg_size = 0;
				ValaList* _tmp406_;
				gint _tmp407_;
				gint _tmp408_;
				gint _arg_index = 0;
				_tmp405_ = self->priv->argument_list;
				_arg_list = _tmp405_;
				_tmp406_ = _arg_list;
				_tmp407_ = vala_collection_get_size ((ValaCollection*) _tmp406_);
				_tmp408_ = _tmp407_;
				_arg_size = _tmp408_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp409_;
					gint _tmp410_;
					ValaExpression* arg = NULL;
					ValaList* _tmp411_;
					gpointer _tmp412_;
					ValaExpression* _tmp413_;
					_arg_index = _arg_index + 1;
					_tmp409_ = _arg_index;
					_tmp410_ = _arg_size;
					if (!(_tmp409_ < _tmp410_)) {
						break;
					}
					_tmp411_ = _arg_list;
					_tmp412_ = vala_list_get (_tmp411_, _arg_index);
					arg = (ValaExpression*) _tmp412_;
					_tmp413_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp413_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp414_;
				gint _init_size = 0;
				ValaList* _tmp415_;
				gint _tmp416_;
				gint _tmp417_;
				gint _init_index = 0;
				_tmp414_ = self->priv->object_initializer;
				_init_list = _tmp414_;
				_tmp415_ = _init_list;
				_tmp416_ = vala_collection_get_size ((ValaCollection*) _tmp415_);
				_tmp417_ = _tmp416_;
				_init_size = _tmp417_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp418_;
					gint _tmp419_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp420_;
					gpointer _tmp421_;
					ValaMemberInitializer* _tmp422_;
					_init_index = _init_index + 1;
					_tmp418_ = _init_index;
					_tmp419_ = _init_size;
					if (!(_tmp418_ < _tmp419_)) {
						break;
					}
					_tmp420_ = _init_list;
					_tmp421_ = vala_list_get (_tmp420_, _init_index);
					init = (ValaMemberInitializer*) _tmp421_;
					_tmp422_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp422_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp423_ = self->priv->argument_list;
			_tmp424_ = vala_collection_get_size ((ValaCollection*) _tmp423_);
			_tmp425_ = _tmp424_;
			if (_tmp425_ == 0) {
				ValaSourceReference* _tmp426_;
				ValaSourceReference* _tmp427_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp426_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp427_ = _tmp426_;
				vala_report_error (_tmp427_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp428_;
				ValaIterator* _tmp429_;
				ValaIterator* _tmp430_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp431_;
				gpointer _tmp432_;
				gboolean _tmp433_ = FALSE;
				ValaExpression* _tmp434_;
				ValaDataType* _tmp435_;
				ValaDataType* _tmp436_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp445_;
				ValaStringLiteral* _tmp446_;
				ValaStringLiteral* _tmp447_;
				ValaList* _tmp456_;
				ValaIterator* _tmp457_;
				ValaIterator* _tmp458_;
				ValaSemanticAnalyzer* _tmp459_;
				ValaSemanticAnalyzer* _tmp460_;
				ValaIterator* _tmp461_;
				ValaSourceReference* _tmp462_;
				ValaSourceReference* _tmp463_;
				_tmp428_ = self->priv->argument_list;
				_tmp429_ = vala_iterable_iterator ((ValaIterable*) _tmp428_);
				arg_it = _tmp429_;
				_tmp430_ = arg_it;
				vala_iterator_next (_tmp430_);
				_tmp431_ = arg_it;
				_tmp432_ = vala_iterator_get (_tmp431_);
				ex = (ValaExpression*) _tmp432_;
				_tmp434_ = ex;
				_tmp435_ = vala_expression_get_value_type (_tmp434_);
				_tmp436_ = _tmp435_;
				if (_tmp436_ == NULL) {
					_tmp433_ = TRUE;
				} else {
					ValaExpression* _tmp437_;
					ValaDataType* _tmp438_;
					ValaDataType* _tmp439_;
					ValaSemanticAnalyzer* _tmp440_;
					ValaSemanticAnalyzer* _tmp441_;
					ValaDataType* _tmp442_;
					_tmp437_ = ex;
					_tmp438_ = vala_expression_get_value_type (_tmp437_);
					_tmp439_ = _tmp438_;
					_tmp440_ = vala_code_context_get_analyzer (context);
					_tmp441_ = _tmp440_;
					_tmp442_ = _tmp441_->string_type;
					_tmp433_ = !vala_data_type_compatible (_tmp439_, _tmp442_);
				}
				if (_tmp433_) {
					ValaSourceReference* _tmp443_;
					ValaSourceReference* _tmp444_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp443_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp444_ = _tmp443_;
					vala_report_error (_tmp444_, "Invalid type for argument 1");
				}
				_tmp445_ = ex;
				_tmp446_ = vala_string_literal_get_format_literal (_tmp445_);
				format_literal = _tmp446_;
				_tmp447_ = format_literal;
				if (_tmp447_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp448_;
					gchar* _tmp449_;
					ValaSemanticAnalyzer* _tmp450_;
					ValaSemanticAnalyzer* _tmp451_;
					const gchar* _tmp452_;
					ValaIterator* _tmp453_;
					ValaSourceReference* _tmp454_;
					ValaSourceReference* _tmp455_;
					_tmp448_ = format_literal;
					_tmp449_ = vala_string_literal_eval (_tmp448_);
					format = _tmp449_;
					_tmp450_ = vala_code_context_get_analyzer (context);
					_tmp451_ = _tmp450_;
					_tmp452_ = format;
					_tmp453_ = arg_it;
					_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp455_ = _tmp454_;
					if (!vala_semantic_analyzer_check_print_format (_tmp451_, _tmp452_, _tmp453_, _tmp455_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp456_ = self->priv->argument_list;
				_tmp457_ = vala_iterable_iterator ((ValaIterable*) _tmp456_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp457_;
				_tmp458_ = arg_it;
				vala_iterator_next (_tmp458_);
				_tmp459_ = vala_code_context_get_analyzer (context);
				_tmp460_ = _tmp459_;
				_tmp461_ = arg_it;
				_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp463_ = _tmp462_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp460_, _tmp461_, 1, _tmp463_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp464_;
		gint _arg_size = 0;
		ValaList* _tmp465_;
		gint _tmp466_;
		gint _tmp467_;
		gint _arg_index = 0;
		_tmp464_ = self->priv->argument_list;
		_arg_list = _tmp464_;
		_tmp465_ = _arg_list;
		_tmp466_ = vala_collection_get_size ((ValaCollection*) _tmp465_);
		_tmp467_ = _tmp466_;
		_arg_size = _tmp467_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp468_;
			gint _tmp469_;
			ValaExpression* arg = NULL;
			ValaList* _tmp470_;
			gpointer _tmp471_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp472_;
			gboolean _tmp473_ = FALSE;
			ValaSizeofExpression* _tmp474_;
			_arg_index = _arg_index + 1;
			_tmp468_ = _arg_index;
			_tmp469_ = _arg_size;
			if (!(_tmp468_ < _tmp469_)) {
				break;
			}
			_tmp470_ = _arg_list;
			_tmp471_ = vala_list_get (_tmp470_, _arg_index);
			arg = (ValaExpression*) _tmp471_;
			_tmp472_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp472_) ? ((ValaSizeofExpression*) _tmp472_) : NULL;
			_tmp474_ = sizeof_expr;
			if (_tmp474_ != NULL) {
				ValaSizeofExpression* _tmp475_;
				ValaDataType* _tmp476_;
				ValaDataType* _tmp477_;
				_tmp475_ = sizeof_expr;
				_tmp476_ = vala_sizeof_expression_get_type_reference (_tmp475_);
				_tmp477_ = _tmp476_;
				_tmp473_ = VALA_IS_GENERIC_TYPE (_tmp477_);
			} else {
				_tmp473_ = FALSE;
			}
			if (_tmp473_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp478_;
				ValaDataType* _tmp479_;
				ValaDataType* _tmp480_;
				ValaDataType* _tmp481_;
				ValaDataType* _tmp482_;
				ValaDataType* _tmp483_;
				ValaDataType* _tmp484_;
				ValaList* _tmp485_;
				ValaDataType* _tmp486_;
				ValaExpression* _tmp487_;
				ValaDataType* _tmp488_;
				ValaSourceReference* _tmp489_;
				ValaSourceReference* _tmp490_;
				ValaSizeofExpression* _tmp491_;
				ValaSizeofExpression* _tmp492_;
				_tmp478_ = sizeof_expr;
				_tmp479_ = vala_sizeof_expression_get_type_reference (_tmp478_);
				_tmp480_ = _tmp479_;
				_tmp481_ = vala_object_creation_expression_get_type_reference (self);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_object_creation_expression_get_type_reference (self);
				_tmp484_ = _tmp483_;
				_tmp485_ = vala_data_type_get_type_arguments (_tmp484_);
				_tmp486_ = vala_data_type_get_actual_type (_tmp480_, _tmp482_, _tmp485_, (ValaCodeNode*) self);
				sizeof_type = _tmp486_;
				_tmp487_ = arg;
				_tmp488_ = sizeof_type;
				_tmp489_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp490_ = _tmp489_;
				_tmp491_ = vala_sizeof_expression_new (_tmp488_, _tmp490_);
				_tmp492_ = _tmp491_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp487_, (ValaExpression*) _tmp492_);
				_vala_code_node_unref0 (_tmp492_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp493_ = type;
	_tmp494_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp493_);
	_tmp495_ = _tmp494_;
	if (!_tmp495_) {
		ValaSemanticAnalyzer* _tmp496_;
		ValaSemanticAnalyzer* _tmp497_;
		ValaDataType* _tmp498_;
		ValaDataType* _tmp499_;
		_tmp496_ = vala_code_context_get_analyzer (context);
		_tmp497_ = _tmp496_;
		_tmp498_ = vala_object_creation_expression_get_type_reference (self);
		_tmp499_ = _tmp498_;
		vala_semantic_analyzer_check_type (_tmp497_, _tmp499_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp500_;
		gint _init_size = 0;
		ValaList* _tmp501_;
		gint _tmp502_;
		gint _tmp503_;
		gint _init_index = 0;
		_tmp500_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp500_;
		_tmp501_ = _init_list;
		_tmp502_ = vala_collection_get_size ((ValaCollection*) _tmp501_);
		_tmp503_ = _tmp502_;
		_init_size = _tmp503_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp504_;
			gint _tmp505_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp506_;
			gpointer _tmp507_;
			ValaMemberInitializer* _tmp508_;
			ValaExpression* _tmp509_;
			ValaExpression* _tmp510_;
			gint index = 0;
			ValaList* _tmp511_;
			ValaMemberInitializer* _tmp512_;
			ValaList* _tmp513_;
			gpointer _tmp514_;
			ValaMemberInitializer* _tmp515_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp516_;
			ValaExpression* _tmp517_;
			ValaExpression* _tmp518_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp525_;
			gchar* _tmp526_;
			ValaMemberInitializer* _tmp527_;
			ValaExpression* _tmp528_;
			ValaExpression* _tmp529_;
			ValaMemberInitializer* _tmp530_;
			ValaExpression* _tmp531_;
			ValaExpression* _tmp532_;
			ValaSourceReference* _tmp533_;
			ValaSourceReference* _tmp534_;
			ValaLocalVariable* _tmp535_;
			ValaLocalVariable* _tmp536_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp537_;
			ValaMemberInitializer* _tmp538_;
			ValaExpression* _tmp539_;
			ValaExpression* _tmp540_;
			ValaSourceReference* _tmp541_;
			ValaSourceReference* _tmp542_;
			ValaDeclarationStatement* _tmp543_;
			ValaDeclarationStatement* _tmp544_;
			ValaSemanticAnalyzer* _tmp545_;
			ValaSemanticAnalyzer* _tmp546_;
			ValaBlock* _tmp547_;
			ValaDeclarationStatement* _tmp548_;
			_init_index = _init_index + 1;
			_tmp504_ = _init_index;
			_tmp505_ = _init_size;
			if (!(_tmp504_ < _tmp505_)) {
				break;
			}
			_tmp506_ = _init_list;
			_tmp507_ = vala_list_get (_tmp506_, _init_index);
			init = (ValaMemberInitializer*) _tmp507_;
			_tmp508_ = init;
			_tmp509_ = vala_member_initializer_get_initializer (_tmp508_);
			_tmp510_ = _tmp509_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp510_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp511_ = self->priv->object_initializer;
			_tmp512_ = init;
			index = vala_list_index_of (_tmp511_, _tmp512_);
			_tmp513_ = self->priv->object_initializer;
			_tmp514_ = vala_list_remove_at (_tmp513_, index);
			_tmp515_ = (ValaMemberInitializer*) _tmp514_;
			_vala_code_node_unref0 (_tmp515_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp516_ = init;
			_tmp517_ = vala_member_initializer_get_initializer (_tmp516_);
			_tmp518_ = _tmp517_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp518_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp519_;
				ValaExpression* _tmp520_;
				ValaExpression* _tmp521_;
				ValaMemberInitializer* _tmp522_;
				ValaExpression* _tmp523_;
				ValaExpression* _tmp524_;
				_tmp519_ = inner_mi;
				_tmp520_ = vala_member_initializer_get_initializer (_tmp519_);
				_tmp521_ = _tmp520_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp521_)) {
					break;
				}
				_tmp522_ = inner_mi;
				_tmp523_ = vala_member_initializer_get_initializer (_tmp522_);
				_tmp524_ = _tmp523_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp524_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp525_ = vala_code_node_get_temp_name ();
			_tmp526_ = _tmp525_;
			_tmp527_ = inner_mi;
			_tmp528_ = vala_member_initializer_get_initializer (_tmp527_);
			_tmp529_ = _tmp528_;
			_tmp530_ = inner_mi;
			_tmp531_ = vala_member_initializer_get_initializer (_tmp530_);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = vala_local_variable_new (NULL, _tmp526_, _tmp529_, _tmp534_);
			_tmp536_ = _tmp535_;
			_g_free0 (_tmp526_);
			local = _tmp536_;
			_tmp537_ = local;
			_tmp538_ = inner_mi;
			_tmp539_ = vala_member_initializer_get_initializer (_tmp538_);
			_tmp540_ = _tmp539_;
			_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp540_);
			_tmp542_ = _tmp541_;
			_tmp543_ = vala_declaration_statement_new ((ValaSymbol*) _tmp537_, _tmp542_);
			decl = _tmp543_;
			_tmp544_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp544_, context);
			_tmp545_ = vala_code_context_get_analyzer (context);
			_tmp546_ = _tmp545_;
			_tmp547_ = _tmp546_->insert_block;
			_tmp548_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp547_, (ValaStatement*) _tmp548_);
			{
				gboolean _tmp549_ = FALSE;
				_tmp549_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp551_;
					const gchar* _tmp552_;
					const gchar* _tmp553_;
					ValaLocalVariable* _tmp554_;
					const gchar* _tmp555_;
					const gchar* _tmp556_;
					ValaMemberInitializer* _tmp557_;
					ValaSourceReference* _tmp558_;
					ValaSourceReference* _tmp559_;
					ValaMemberAccess* _tmp560_;
					ValaMemberAccess* _tmp561_;
					ValaMemberInitializer* _tmp562_;
					ValaSourceReference* _tmp563_;
					ValaSourceReference* _tmp564_;
					ValaMemberInitializer* _tmp565_;
					ValaMemberInitializer* _tmp566_;
					ValaList* _tmp567_;
					gint _tmp568_;
					ValaMemberInitializer* _tmp569_;
					ValaMemberInitializer* _tmp570_;
					ValaCodeNode* _tmp571_;
					ValaCodeNode* _tmp572_;
					if (!_tmp549_) {
						ValaMemberInitializer* _tmp550_;
						_tmp550_ = inner_mi;
						if (!(_tmp550_ != NULL)) {
							break;
						}
					}
					_tmp549_ = FALSE;
					_tmp551_ = inner_mi;
					_tmp552_ = vala_member_initializer_get_name (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = local;
					_tmp555_ = vala_symbol_get_name ((ValaSymbol*) _tmp554_);
					_tmp556_ = _tmp555_;
					_tmp557_ = inner_mi;
					_tmp558_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_member_access_new (NULL, _tmp556_, _tmp559_);
					_tmp561_ = _tmp560_;
					_tmp562_ = inner_mi;
					_tmp563_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp562_);
					_tmp564_ = _tmp563_;
					_tmp565_ = vala_member_initializer_new (_tmp553_, (ValaExpression*) _tmp561_, _tmp564_);
					_tmp566_ = _tmp565_;
					_vala_code_node_unref0 (_tmp561_);
					member_init = _tmp566_;
					_tmp567_ = self->priv->object_initializer;
					_tmp568_ = index;
					index = _tmp568_ + 1;
					_tmp569_ = member_init;
					vala_list_insert (_tmp567_, _tmp568_, _tmp569_);
					_tmp570_ = inner_mi;
					_tmp571_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp570_);
					_tmp572_ = _tmp571_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp572_) ? ((ValaMemberInitializer*) _tmp572_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp573_;
		gint _init_size = 0;
		ValaList* _tmp574_;
		gint _tmp575_;
		gint _tmp576_;
		gint _init_index = 0;
		_tmp573_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp573_;
		_tmp574_ = _init_list;
		_tmp575_ = vala_collection_get_size ((ValaCollection*) _tmp574_);
		_tmp576_ = _tmp575_;
		_init_size = _tmp576_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp577_;
			gint _tmp578_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp579_;
			gpointer _tmp580_;
			ValaMemberInitializer* _tmp581_;
			ValaMemberInitializer* _tmp582_;
			_init_index = _init_index + 1;
			_tmp577_ = _init_index;
			_tmp578_ = _init_size;
			if (!(_tmp577_ < _tmp578_)) {
				break;
			}
			_tmp579_ = _init_list;
			_tmp580_ = vala_list_get (_tmp579_, _init_index);
			init = (ValaMemberInitializer*) _tmp580_;
			_tmp581_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp581_, (ValaCodeNode*) self);
			_tmp582_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp582_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp583_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp584_ = _tmp583_;
	if (_tmp584_) {
		gboolean _tmp585_ = FALSE;
		ValaCodeNode* _tmp586_;
		ValaCodeNode* _tmp587_;
		_tmp586_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp587_ = _tmp586_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp587_)) {
			_tmp585_ = TRUE;
		} else {
			ValaCodeNode* _tmp588_;
			ValaCodeNode* _tmp589_;
			_tmp588_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp589_ = _tmp588_;
			_tmp585_ = VALA_IS_EXPRESSION_STATEMENT (_tmp589_);
		}
		if (_tmp585_) {
		} else {
			ValaSemanticAnalyzer* _tmp590_;
			ValaSemanticAnalyzer* _tmp591_;
			ValaSymbol* _tmp592_;
			ValaSymbol* _tmp593_;
			_tmp590_ = vala_code_context_get_analyzer (context);
			_tmp591_ = _tmp590_;
			_tmp592_ = vala_semantic_analyzer_get_current_symbol (_tmp591_);
			_tmp593_ = _tmp592_;
			if (!VALA_IS_BLOCK (_tmp593_)) {
				ValaSourceReference* _tmp594_;
				ValaSourceReference* _tmp595_;
				_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp595_ = _tmp594_;
				vala_report_error (_tmp595_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp596_;
				ValaCodeNode* _tmp597_;
				ValaCodeNode* _tmp598_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp599_;
				ValaDataType* _tmp600_;
				ValaDataType* _tmp601_;
				ValaDataType* _tmp602_;
				gchar* _tmp603_;
				gchar* _tmp604_;
				ValaSourceReference* _tmp605_;
				ValaSourceReference* _tmp606_;
				ValaLocalVariable* _tmp607_;
				ValaLocalVariable* _tmp608_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp609_;
				ValaSourceReference* _tmp610_;
				ValaSourceReference* _tmp611_;
				ValaDeclarationStatement* _tmp612_;
				ValaSemanticAnalyzer* _tmp613_;
				ValaSemanticAnalyzer* _tmp614_;
				ValaBlock* _tmp615_;
				ValaDeclarationStatement* _tmp616_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp617_;
				ValaDataType* _tmp618_;
				ValaDataType* _tmp619_;
				ValaExpression* _tmp620_;
				ValaExpression* _tmp621_;
				ValaDataType* _tmp622_;
				ValaDataType* _tmp623_;
				ValaLocalVariable* _tmp624_;
				ValaDeclarationStatement* _tmp625_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp626_;
				ValaSemanticAnalyzer* _tmp627_;
				ValaSymbol* _tmp628_;
				ValaSymbol* _tmp629_;
				ValaBlock* _tmp630_;
				ValaBlock* _tmp631_;
				ValaLocalVariable* _tmp632_;
				ValaSemanticAnalyzer* _tmp633_;
				ValaSemanticAnalyzer* _tmp634_;
				ValaBlock* _tmp635_;
				ValaLocalVariable* _tmp636_;
				ValaCodeNode* _tmp637_;
				ValaExpression* _tmp638_;
				ValaExpression* _tmp639_;
				_tmp596_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp597_ = _tmp596_;
				_tmp598_ = _vala_code_node_ref0 (_tmp597_);
				old_parent_node = _tmp598_;
				_tmp599_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_data_type_copy (_tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_code_node_get_temp_name ();
				_tmp604_ = _tmp603_;
				_tmp605_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp606_ = _tmp605_;
				_tmp607_ = vala_local_variable_new (_tmp602_, _tmp604_, NULL, _tmp606_);
				_tmp608_ = _tmp607_;
				_g_free0 (_tmp604_);
				_vala_code_node_unref0 (_tmp602_);
				local = _tmp608_;
				_tmp609_ = local;
				_tmp610_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp611_ = _tmp610_;
				_tmp612_ = vala_declaration_statement_new ((ValaSymbol*) _tmp609_, _tmp611_);
				decl = _tmp612_;
				_tmp613_ = vala_code_context_get_analyzer (context);
				_tmp614_ = _tmp613_;
				_tmp615_ = _tmp614_->insert_block;
				_tmp616_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp615_, (ValaStatement*) _tmp616_);
				_tmp617_ = local;
				_tmp618_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_semantic_analyzer_create_temp_access (_tmp617_, _tmp619_);
				temp_access = _tmp620_;
				_tmp621_ = temp_access;
				_tmp622_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp623_ = _tmp622_;
				vala_expression_set_formal_target_type (_tmp621_, _tmp623_);
				_tmp624_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp624_, (ValaExpression*) self);
				_tmp625_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp625_, context);
				_tmp626_ = vala_code_context_get_analyzer (context);
				_tmp627_ = _tmp626_;
				_tmp628_ = vala_semantic_analyzer_get_current_symbol (_tmp627_);
				_tmp629_ = _tmp628_;
				_tmp630_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp629_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp630_;
				_tmp631_ = block;
				_tmp632_ = local;
				vala_block_remove_local_variable (_tmp631_, _tmp632_);
				_tmp633_ = vala_code_context_get_analyzer (context);
				_tmp634_ = _tmp633_;
				_tmp635_ = _tmp634_->insert_block;
				_tmp636_ = local;
				vala_block_add_local_variable (_tmp635_, _tmp636_);
				_tmp637_ = old_parent_node;
				_tmp638_ = temp_access;
				vala_code_node_replace_expression (_tmp637_, (ValaExpression*) self, _tmp638_);
				_tmp639_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp639_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp640_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp641_ = _tmp640_;
	result = !_tmp641_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

