.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XSetWMIconName __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetWMIconName, XGetWMIconName, XSetIconName, XGetIconName \- set or read a window's WM_ICON_NAME property
.SH SYNTAX
.HP
void XSetWMIconName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
XTextProperty *\fItext_prop\fP\^); 
.HP
Status XGetWMIconName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
XTextProperty *\fItext_prop_return\fP\^); 
.HP
int XSetIconName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, char
*\fIicon_name\fP\^); 
.HP
Status XGetIconName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, char
**\fIicon_name_return\fP\^); 
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIicon_name\fP 1i
Specifies the icon name,
which should be a null-terminated string.
.IP \fIicon_name_return\fP 1i
Returns the window's icon name,
which is a null-terminated string.
.IP \fItext_prop\fP 1i
Specifies the
.ZN XTextProperty
structure to be used.
.IP \fItext_prop_return\fP 1i
Returns the
.ZN XTextProperty
structure.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.ZN XSetWMIconName
convenience function calls
.ZN XSetTextProperty
to set the WM_ICON_NAME property.
.LP
The 
.ZN XGetWMIconName 
convenience function calls
.ZN XGetTextProperty 
to obtain the WM_ICON_NAME property.
It returns a nonzero status on success;
otherwise, it returns a zero status.
.LP
The
.ZN XSetIconName
function sets the name to be displayed in a window's icon.
.LP
.ZN XSetIconName
can generate
.ZN BadAlloc
and
.ZN BadWindow
errors.
.LP
The
.ZN XGetIconName
function returns the name to be displayed in the specified window's icon.
If it succeeds, it returns a nonzero status; otherwise, 
if no icon name has been set for the window,
it returns zero.
If you never assigned a name to the window,
.ZN XGetIconName
sets icon_name_return to NULL.
If the data returned by the server is in the Latin Portable Character Encoding,
then the returned string is in the Host Portable Character Encoding.
Otherwise, the result is implementation-dependent.
When finished with it, a client must free
the icon name string using
.ZN XFree .
.LP
.ZN XGetIconName
can generate a
.ZN BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_ICON_NAME\s+1
The name to be used in an icon.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(__libmansuffix__),
XAllocIconSize(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XAllocWMHints(__libmansuffix__),
XFree(__libmansuffix__),
XSetCommand(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
