# NTP_CACHEVERSION(component, version)
# ------------------------------------
# compare this configure script's cache version stamp with the stamp
# saved by the prior run in config.cache.  If they differ, clear all
# cache variables to avoid using results cached with a script that
# is known to differ in a cache-invalidating manner.
#
# Note: use immediately following AC_INIT in configure.ac, as clearing
# all _cv_ variables only makes sense immediately after loading, before
# use or modification.
#
# The top-level configure.ac in a subtree using NTP_CACHEVERSION
# will clear a previous cache lacking any saved cache version number,
# while children do not.  This comes into play only when introducing
# NTP_CACHEVERSION where it had not been previously used:  Previous
# cached results are presumed incompatible and not used.  The reason
# children do not flush the cache is it is shared with the parent and
# the children can rely on the parent having cleared any cache variables
# predating this mechanism.  Therefore the child can rely on the 
# config.cache generated by the parent on the first run despite not 
# finding the child version stamp in it.
#
# See html/copyright.html or COPYRIGHT in plain text.

AC_DEFUN_ONCE([NTP_CACHEVERSION], [
    AC_BEFORE([$0], [AM_INIT_AUTOMAKE])dnl
    AC_BEFORE([$0], [AC_CONFIG_HEADERS])dnl
    AC_BEFORE([$0], [AC_PROG_CC])dnl
    AC_BEFORE([$0], [AC_CONFIG_SUBDIRS])dnl

    ntp_cache_flush=1
    
    case "$ntp_cv_[$1]_cache_version" in
     [$2])
	# same version, good
	ntp_cache_flush=0
	;;
     '')
	# No cache, predates ntp_cv_$1_cache_version, or is empty.
	case "$cache_file" in
	 /dev/null)
	    ntp_cache_flush=0
	    ;;
	 *)
	    case "$NTP_CACHEVERSION_PARENT" in
	     '')
		# Do not clear the cache immediately after it is created
		# empty as it is noisy.  Differentiate a newly-created 
		# config.cache from one predating the cache version 
		# mechanism by looking for the first cached variable set 
		# by Autoconf
		case "$ac_cv_path_install" in
		 '')
		    # empty config.cache file
		    ntp_cache_flush=0
		esac
		;;
	     *)
		# Parent configure just created cache from empty,
		# flushing would be counterproductive.
		ntp_cache_flush=0;
		;;
	    esac
	esac
	;;
     *)
	# configure cache version mismatches config.cache version
	;;
    esac
    
    case "$ntp_cache_flush" in
     1)
	c_version="${ntp_cv_[$1]_cache_version:-(no version found)}"
	
	# Do we flush all variables or exclude others' version stamps?

	case "$NTP_CACHEVERSION_PARENT" in
	 '')
	    # Clear all *_cv_* variables including our child subdirs'
	    # ntp_cv_*_cache_version variables.  This prevents subdir
	    # configure scripts from noticing a version mismatch just
	    # after the top configure in the invocation cleared and
	    # recreated the cache.
	
	    c_varname_list=`set |
			    sed -n -e 's/=.*$//' \
				   -e '/_cv_/p'
			   `
	    ;;
	 *)
	    # This is not the top configure this particular invocation.
	    # Clear all *_cv_* variables sparing the version stamps
	    # of other configure scripts, so we don't trigger
	    # useless repeated clearings.

	    c_varname_list=`set |
			    sed -n -e 's/=.*$//' \
				   -e '/ntp_cv_.*_cache_version/d' \
				   -e '/_cv_/p'
			   `
	esac
	
	for c_varname in $c_varname_list
	do
	    AS_UNSET([$c_varname])
	done
	
	AC_MSG_NOTICE([[$cache_file saved by another version, ignored.]])
	AC_MSG_NOTICE([[configure script cache version: ]][$2])
	AC_MSG_NOTICE([[$cache_file version: $c_version]])
	AS_UNSET([c_varname])
	AS_UNSET([c_varname_list])
	AS_UNSET([c_version])
    esac

    AS_UNSET([ntp_cache_flush])

    # save configure version in config.cache for next time
    ntp_cv_[$1]_cache_version="[$2]"

    # let any subdir configure.ac NTP_CACHEVERSION invocations
    # know they are not the top level.
    NTP_CACHEVERSION_PARENT='[$1]' ; export NTP_CACHEVERSION_PARENT
])dnl
