.TH XvGrabPort __libmansuffix__ __vendorversion__ "libXv Functions"
.SH NAME
XvGrabPort \- lock port for exclusive use by client
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "int XvGrabPort(Display *" dpy ", XvPortID " port ", Time " time ");"
.fi
.SH ARGUMENTS
.\"
.IP \fIdpy\fR 8
Specifies the connection to the X server.
.IP \fIport\fR 8
Defines the port to be grabbed.
.IP \fItime\fR 8
Specifies the request timestamp.
.\"
.SH DESCRIPTION
.\"
.BR XvGrabPort (__libmansuffix__)
grabs a port.  Once a client grabs a port, only that client can make video
requests to that port.
.PP
If the time is before the current port time, the XvGrabPort request is
ignored and XvInvalidTime is returned.  If the port is already grabbed by
another client, XvAlreadyGrabbed is returned. Otherwise it returns a
status of \fISuccess\fR.  The port time is updated when the following
requests are processed:
.BR XvGrabPort (__libmansuffix__),
.BR XvUngrabPort (__libmansuffix__),
.BR XvPutVideo (__libmansuffix__),
.BR XvPutStill (__libmansuffix__),
.BR XvGetVideo (__libmansuffix__),
.BR XvGetStill (__libmansuffix__).
.PP
If the port is actively processing video for another client, the
video is preempted, and an XvVideoNotify event with detail XvPreempted
is generated for its drawable.
.\"
.SH RETURN VALUES
.IP [Success] 8
Returned if
.BR XvGrabPort (__libmansuffix__)
completed successfully.
.IP [XvInvalidTime] 8
Returned if requested time is older than the current port time.
.IP [XvAlreadyGrabbed] 8
Returned if the port is already grabbed by another client.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if
.BR XvGrabPort (__libmansuffix__)
failed to allocate memory to process the request.
.SH DIAGNOSTICS
.IP [XvBadPort] 15
Generated if the requested port does not exist.
.\"
.SH SEE ALSO
.\"
.BR XvUngrabPort (__libmansuffix__),
.BR XvVideoNotify (__libmansuffix__)

