/* Copyright (c) 2010 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#include "crc32_test.h"
#include "cgptlib_test.h"
#include "crc32.h"
#include "test_common.h"
#include "utility.h"

#define MAX_VECTOR_LEN 256

int TestCrc32TestVectors(void) {
	struct {
		uint8_t vector[MAX_VECTOR_LEN];
		int len;
		uint32_t crc32;
	} cases[] = {
		{{0x00}, 1, 0xD202EF8D},
		{{0x00, 0x00, 0x00, 0x00}, 4, 0x2144DF1C},
		{{0x01, 0x01, 0x01, 0x01}, 4, 0xF626D399},
		{{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		  0x00,0x00,0x00,0x28,0x86,0x4d,0x7f,0x99}, 48, 0x923D6EFD},
		{{0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		  0x00,0x00,0x00,0x28,0xc5,0x5e,0x45,0x7a}, 48, 0x49A04D82},
		{{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,
		  0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,
		  0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,
		  0x1f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,
		  0x00,0x00,0x00,0x28,0xbf,0x67,0x1e,0xd0}, 48, 0x688B3BFA},
	};
	int i;

	for (i = 0; i < ARRAY_SIZE(cases); ++i) {
		uint32_t crc32;

		crc32 = Crc32(cases[i].vector, cases[i].len);
		EXPECT(crc32 == cases[i].crc32);
	}
	return TEST_OK;
}
