.TH XvPutStill __libmansuffix__  __vendorversion__ "libXv Functions"
.SH NAME
XvPutStill \- write a single frame of video to a drawable
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "int XvPutStill(Display *" dpy ", XvPortID " port ", Drawable " d ", GC " gc ","
.BI "               int " vx ", int " vy ", unsigned int " vw ", unsigned int " vh ","
.BI "               int " dx ", int " dy ", unsigned int " dw ", unsigned int " dh ");"
.fi
.SH ARGUMENTS
.\"
.IP \fIdpy\fR 15
Specifies the connection to the X server.
.IP \fIport\fR 15
Defines the port from which to get the still.
.IP \fId\fR 15
Defines the drawable into which the still is to be written.
Pixmaps are currently not supported.
.IP \fIgc\fR 15
Defines the graphical context.
GC components are:
.IR subwindow-mode ,
.IR clip-x-origin ,
.IR clip-y-origin ,
and
.IR clip-mask .
.IP \fIvx,vy,vw,vh\fR 15
Define the location and size of the video region
to be written.  \fIvx\fP and \fIvy\fP define the
upper-left pixel of the region. \fIvw\fP and \fIvh\fP
define the width and height, in pixels, of the region.
.IP \fIdx,dy,dw,dh\fR 15
Define the location and size of the destination region into which the
still image is written.  \fIdx\fP and \fIdy\fP define the upper-left
corner of the region. \fIdw\fP and \fIdh\fP
define the width and height, in pixels, of the region.
.\"
.SH DESCRIPTION
.\"
.BR XvPutStill (__libmansuffix__)
writes a single frame of video to a drawable.
The position and size of the source (video) rectangle is specified by
.IR vx ,
.IR vy ,
.IR vw ,
and
.IR vh .
The position and size of the destination (drawable) rectangle is specified by
.IR dx ,
.IR dy ,
.IR dw ,
and
.IR dh .
.PP
Video data is clipped to the bounds of the video encoding, scaled to the
requested drawable region size (or the closest size supported) and
clipped to the bounds of the drawable.
.PP
If the port is grabbed by another client, this request is ignored, and
an XvVideoNotify event with detail XvBusy is generated for the
drawable.  If the port is not receiving a valid video signal a
VideoNotify event with detail XvHardError is generated for the drawable.
.\"
.SH RETURN VALUES
.IP [Success] 8
Returned if
.BR XvPutStill (__libmansuffix__)
completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if
.BR XvGetStill (__libmansuffix__)
failed to allocate memory to process the request.
.SH DIAGNOSTICS
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.IP [BadGC] 8
Generated if the requested graphics context does not exist.
.IP [BadAlloc] 8
Generated if there were insufficient resources to process the request.
.SH SEE ALSO
.\"
.BR XvPutVideo (__libmansuffix__),
.BR XvGetStill (__libmansuffix__),
.BR XvVideoNotify (__libmansuffix__)
