

# norootforbuild

Name:		xpaint
Version:	2.9.8.1
Release:	4.pm.4.1

Summary:	A color image editing tool
License:	GPLv3
Group:		Productivity/Graphics/Bitmap Editors
URL:		http://sf-xpaint.sourceforge.net/

Source0:	%{name}-%{version}.tar.bz2

Patch0:		%{name}-openjpeg.patch

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

BuildRequires:	bison flex libjpeg-devel libopenjpeg-devel libpng-devel
BuildRequires:	libtiff-devel update-desktop-files xorg-x11-devel
BuildRequires:	xorg-x11-libX11-devel xorg-x11-libXmu-devel
BuildRequires:	xorg-x11-libXpm-devel xorg-x11-libXt-devel xorg-x11-util-devel
BuildRequires:	xaw3d-devel


%description
Xpaint is a color image editing tool which features most standard paint program
options. It allows for the editing of multiple images simultaneously and
supports various formats, including PPM, XBM, TIFF, etc. 


%package devel
Group:		Productivity/Multimedia/Sound/Players
Summary:	Development package for %{name}
Requires:	%{name} = %{version}
Requires:	bison flex libjpeg-devel libopenjpeg-devel libpng-devel
Requires:	libtiff-devel update-desktop-files xorg-x11-devel
Requires:	xorg-x11-libX11-devel xorg-x11-libXmu-devel
Requires:	xorg-x11-libXpm-devel xorg-x11-libXt-devel xorg-x11-util-devel
Requires:	xaw3d-devel

%description devel
Development package for %{name}.


%package -n libXaw3dxft6
Group:		System/Libraries
Summary:	Library needed by xpaint

%description -n libXaw3dxft6
Xaw3dxft library needed by xpain.


%debug_package


%prep
%setup -q
%patch0 -p1


%build
export CFLAGS=$RPM_OPT_FLAGS
export CXXFLAGS=$RPM_OPT_FLAGS
./configure
%__make %{?jobs:-j%{jobs}} xaw3dxft.so


%install
%makeinstall

%__mkdir_p %{buildroot}/%{_datadir}/pixmaps
%__install -D -m 644 icons/xpaint* %{buildroot}/%{_datadir}/pixmaps/

%__mkdir_p %{buildroot}/%{_datadir}/applications
%__install -D -m 644 xpaint.desktop %{buildroot}/%{_datadir}/applications/
%suse_update_desktop_file %{name}

%__mkdir_p %{buildroot}/%{_libdir}
%__install -D -m 644 Xaw3dxft/libXaw3dxft.so.6* %{buildroot}/%{_libdir}/

%post -n libXaw3dxft6 -p /sbin/ldconfig
%postun -n libXaw3dxft6 -p /sbin/ldconfig

%clean
rm -rf "%{buildroot}"


%files
%defattr(-,root,root,-)
%{_bindir}/imgmerge
%{_bindir}/pdfconcat
%{_bindir}/xpaint
%{_datadir}/applications/xpaint.desktop
%{_datadir}/pixmaps/xpaint*
%{_datadir}/X11/app-defaults/XPaint*
%dir %{_datadir}/xpaint
%{_datadir}/xpaint/XPaintIcon.xpm
%dir %{_datadir}/xpaint/bin
%{_datadir}/xpaint/bin/xpaint_ocr
%dir %{_datadir}/xpaint/bitmaps
%{_datadir}/xpaint/bitmaps/brushbox.cfg
%dir %{_datadir}/xpaint/bitmaps/brushes
%{_datadir}/xpaint/bitmaps/brushes/*.xpm
%dir %{_datadir}/xpaint/bitmaps/elec
%{_datadir}/xpaint/bitmaps/elec/*.xpm
%dir %{_datadir}/xpaint/help
%{_datadir}/xpaint/help/Help*
%dir %{_datadir}/xpaint/messages
%{_datadir}/xpaint/messages/Messages*


%files devel
%defattr(-,root,root,-)
%dir %{_datadir}/xpaint/include
%{_datadir}/xpaint/include/*.h
%dir %{_datadir}/xpaint/c_scripts/3d_curves
%{_datadir}/xpaint/c_scripts/3d_curves/*.c
%dir %{_datadir}/xpaint/c_scripts/3d_surfaces
%{_datadir}/xpaint/c_scripts/3d_surfaces/*.c
%dir %{_datadir}/xpaint/c_scripts
%dir %{_datadir}/xpaint/c_scripts/batch
%{_datadir}/xpaint/c_scripts/batch/*.c
%dir %{_datadir}/xpaint/c_scripts/filters
%{_datadir}/xpaint/c_scripts/filters/*.c
%dir %{_datadir}/xpaint/c_scripts/images
%{_datadir}/xpaint/c_scripts/images/*.c
%dir %{_datadir}/xpaint/c_scripts/layers
%{_datadir}/xpaint/c_scripts/layers/*.c
%dir %{_datadir}/xpaint/c_scripts/procedures
%{_datadir}/xpaint/c_scripts/procedures/*.c
%dir %{_datadir}/xpaint/c_scripts/templates
%{_datadir}/xpaint/c_scripts/templates/*.c

%files -n libXaw3dxft6
%defattr(-,root,root,-)
%{_libdir}/libXaw3dxft.so.6*


%changelog
* Fri Dec 24 2010 detlef@links2linux.de
- new upstream version <2.9.8.1>
* Sat Nov 13 2010 detlef@links2linux.de
- new upstream version <2.9.8>
* Mon Oct 25 2010 detlef@links2linux.de
- new upstream version <2.9.6.4>
  * A couple of small improvements in spline, polygon, text and
    color operations.
  * fontOp.c, splineOp.c, polygonOp.c : implemented "Backspace"
    key action,  i.e. removing last point or last character;
    "Escape" now entirely restarts the operation from the beginning.
    Other small improvements (including correction of a potential
    segfault occurring in some strange circumstances...);
    polygonOp() code is now also much simpler and easier to read.
  * graphic.c : multiple clicks on any of the three color/pattern
    selection discs now switch primary and secondary colors/patterns.
  * updated accordingly Help files.
* Sat Oct  9 2010 detlef@links2linux.de
- new upstream version <2.9.6.3>
  * ops.h : minor compilation issue fixed.
  * graphic.c : corrected segfault bug of RegionToRGBA channels.
    (occurring only when alpha channel was to be saved.)
  * chroma.c : fixed minor scrolling issue in color variance scrollbars.
  * graphic.c : added new menu lines to proceed more easily to editing.
    of alpha channels or images in memory.
  * updated accordingly Help files, messages and app-defaults files.
* Sat Oct  2 2010 detlef@links2linux.de
- new upstream version <2.9.6.2>
  * iprocess.c : fixed bug occurring only in very rare circumstances
    (creation of image with an alpha channel, being edited and
    compiled on the fly through the embedded C-script editor)
  * print.c : printing was completely broken, as a result of using
    double values instead of float values. Reverted to float !
  * chroma.c, color.c, magnifier.c, fontSelect.c : revert to float !
  * graphic.c : small improvement in ModifyRGB (new routine to
    rescale gray levels linearly from given thresholds).
* Wed Sep 15 2010 detlef@links2linux.de
- new upstream version <2.9.6>
  * rw/rwTable.c, rw/readWriteTGA.c : fixes in TGA format, so as
    to prevent that xpaint could hang on certain non TGA files..
    Make sure anyway that TGA is parsed as a last resort, since TGA
    is a strange format without signature.
  * image.c, iprocess.c, graphic.c : substantial improvements in.
    filter routines :
  - Added new "Merge" filter : helpful to combine smoothly an image
    with the underlying canvas. Works according to 4 different modes
  - Added new "Distortion" filter which can be used to produce
    local deformations
  - Added powerful Floyd-Steinberg algorithm (color quantification
    enhanced with a diffusion process).
  - Replaced "ModifyRGB" by a generalized RGB transformation procedure
    with 7 different modes, including Gamma correction (with independent
    r_gamma, g_gamma, b_gamma parameters), and linear transform.
  - Fixed several shortcomings of "Normalize contrast" and "Emboss"
    routines; "Emboss" now has 2 parameters allowing linear correction.
  - Renamed "Tilt" as "Projective Transform" with several enhancements.
  - Renamed "ImageCopy" as "ImageCopyData" which says more accurately
    what it does.
  * graphic.c : Memory menu : management of R,G,B and alpha channels :
  - Added extraction of red, green, blue, alpha channels from region
  - Added merge procedure for those channels
  * msgedit.c : new utility which can be used to extract strings from
    the English version of "Messages" and combine them with a partially
    localized "Messages_XY" for any other language - useful as well to.
    avoid discrepancies between languages!
  * Many updates to Message and Help files.
* Sat Aug 21 2010 detlef@links2linux.de
- new upstream version <2.9.4>
  * rw/readWriteTGA.c : added support for TGA format (borrowed.
    mostly from mtpaint project).
  * rw/rwTable.c : code clean-up.
  * Paint.c, PaintRegion.c : fixes for certain complex situations.
    involving region selection with masks and alpha channel.
    (Segfault could occur in Fatbits editor under those circumstances).
  * graphic.c : Suppression of alpha channel could lead to segfault.
* Mon Aug  9 2010 detlef@links2linux.de
- new upstream version <2.9.3>
* Tue Aug  3 2010 detlef@links2linux.de
- new upstream version <2.9.2>
* Mon Jul  5 2010 detlef@links2linux.de
- new upstream version <2.9.1.4>
  * fatBitsEdit.c, Paint.c , Paintregion.c : several fixes in.
    handling of alpha channel in fatbits editor - some affecting
    alpha channel image bits.
  * app-defaults : change zoom labels to correct values xx:1 instead
    of 1:xx
  * graphic.c : prevent fatbits editor getting called undeservedly by.
    GetNonDirtyCanvas() routine ; removing alpha channel now moves it
    to memory rather than destroying it right away.
  * rw/readWritePS.c : fix for compilation of TeX/LaTeX files being
    called from random directories.
  * minor fixes throughout - thanks to the SUSE-Packman maintainer
    Detlef Reichelt <detlef@die-mafia.de> for help.
* Sun Jul  4 2010 detlef@links2linux.de
- build with Xaw3dxft <2.9.1-2>
* Fri Jul  2 2010 detlef@links2linux.de
- new upstream version <2.9.1>
* Tue Jan  5 2010 detlef@links2linux.de
- initial build for PackMan <2.8.8>
