/*
 *  Copyright 2013 (C) Michael Bohlender <michael.bohlender@kdemail.net>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License or (at your option) version 3 or any later version
 *  accepted by the membership of KDE e.V. (or its successor approved
 *  by the membership of KDE e.V.), which shall act as a proxy
 *  defined in Section 14 of version 3 of the license.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.1
import org.kde.plasma.components 0.1 as PlasmaComponents

PlasmaComponents.Page {
  id: root

  implicitWidth: pageRow.width * 2 /3

  //BEGIN: Tools
  tools: PlasmaComponents.ToolBarLayout {
    PlasmaComponents.ToolButton {

      anchors.left: parent.left

      iconSource: "go-previous"

      onClicked: pageRow.pop()
    }
  }
  //END: Tools

  Column {
    anchors.centerIn: parent

    spacing: 20

    PlasmaComponents.Button {
      text: i18n("Accounts")

      onClicked: {
        pageRow.pop(root)
        pageRow.push(Qt.resolvedUrl("AccountSettingsPage.qml"))
      }
    }
    PlasmaComponents.Button {
      text: i18n("Identities")

      onClicked: application.configureIdentity()
    }
    PlasmaComponents.Button {
      text: i18n("Favorites")

      onClicked: {
        pageRow.pop(root)
        pageRow.push(Qt.resolvedUrl("FavoriteManagerPage.qml"))
      }
    }
    PlasmaComponents.Button {
      text: i18n("Filter")

      onClicked: {
        pageRow.pop(root)
        pageRow.push(Qt.resolvedUrl("FilterEditor.qml"))
      }
    }
    PlasmaComponents.Button {
      text: i18n( "About" )

      onClicked: {
        pageRow.pop(root)
        pageRow.push(Qt.resolvedUrl("AboutPage.qml"))
      }
    }
  }
}