/*
  Copyright (c) 2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "filteractionbeeptest.h"
#include "../filteractions/filteractionbeep.h"
#include <qtest_kde.h>
#include <QWidget>
FilterActionBeepTest::FilterActionBeepTest(QObject *parent)
    : QObject(parent)
{

}

FilterActionBeepTest::~FilterActionBeepTest()
{

}

void FilterActionBeepTest::shouldHaveDefaultValue()
{
    MailCommon::FilterActionBeep w;
    QWidget *widget = w.createParamWidget(0);
    QCOMPARE(widget->objectName(), QLatin1String("empty_widget"));
}

void FilterActionBeepTest::shouldSieveCode()
{
    MailCommon::FilterActionBeep w;
    QVERIFY(w.sieveRequires().isEmpty());
}

void FilterActionBeepTest::shouldBeNotEmptyByDefault()
{
    MailCommon::FilterActionBeep w;
    QVERIFY(!w.isEmpty());
}

void FilterActionBeepTest::shouldHaveRequiresPart()
{
    MailCommon::FilterActionBeep w;
    QCOMPARE(w.requiredPart(), MailCommon::SearchRule::Envelope);
}

void FilterActionBeepTest::shouldSieveRequres()
{
    MailCommon::FilterActionBeep w;
    QCOMPARE(w.sieveRequires(), QStringList());

}

QTEST_KDEMAIN(FilterActionBeepTest, GUI)
