/*
  Copyright (c) 2014-2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "followupremindernoanswerdialog.h"
#include "followupreminderinfo.h"
#include "followupreminderinfowidget.h"

#include <KLocalizedString>
#include <KMenu>
#include <KSharedConfig>

#include <QHBoxLayout>
#include <QTreeWidget>
#include <QHeaderView>
#include <QLabel>


FollowUpReminderNoAnswerDialog::FollowUpReminderNoAnswerDialog(QWidget *parent)
    : KDialog(parent)
{
    setCaption( i18n("Follow Up Mail") );
    setWindowIcon( KIcon( QLatin1String("kmail") ) );
    setButtons( Ok|Cancel );
    setAttribute(Qt::WA_DeleteOnClose);
    QWidget *w = new QWidget(this);
    QVBoxLayout *vbox = new QVBoxLayout(w);
    QLabel *lab = new QLabel(i18n("You still wait an answer about this mail:"));
    vbox->addWidget(lab);
    connect(this, SIGNAL(okClicked()), SLOT(slotSave()));
    mWidget = new FollowUpReminderInfoWidget;
    mWidget->setObjectName(QLatin1String("FollowUpReminderInfoWidget"));
    vbox->addWidget(mWidget);
    setMainWidget(w);
    readConfig();
}

FollowUpReminderNoAnswerDialog::~FollowUpReminderNoAnswerDialog()
{
    writeConfig();
}

void FollowUpReminderNoAnswerDialog::setInfo(const QList<FollowUpReminder::FollowUpReminderInfo *> &info)
{
    mWidget->setInfo(info);
}

void FollowUpReminderNoAnswerDialog::readConfig()
{
    KConfigGroup group( KGlobal::config(), "FollowUpReminderNoAnswerDialog" );
    const QSize sizeDialog = group.readEntry( "Size", QSize(800,600) );
    if ( sizeDialog.isValid() ) {
        resize( sizeDialog );
    }
    mWidget->restoreTreeWidgetHeader(group.readEntry("HeaderState",QByteArray()));
}

void FollowUpReminderNoAnswerDialog::writeConfig()
{
    KConfigGroup group( KGlobal::config(), "FollowUpReminderNoAnswerDialog" );
    group.writeEntry( "Size", size() );
    mWidget->saveTreeWidgetHeader(group);
}

void FollowUpReminderNoAnswerDialog::slotSave()
{
    if (mWidget->save()) {
        Q_EMIT needToReparseConfiguration();
    }
}
