.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH KBD __drivermansuffix__ __vendorversion__
.SH NAME
kbd \- Keyboard input driver
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" idevname \*q
.B  "  Driver \*qkbd\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B kbd 
is an __xservername__ input driver for keyboards.  The driver supports the standard
OS-provided keyboard interface, but these are currently only available to
this driver module for Linux, BSD, and Solaris.  This driver is the
replacement for the built-in
.B keyboard
driver formerly included in __xservername__.
.PP
The
.B kbd
driver functions as a keyboard input device.
.SH CONFIGURATION DETAILS
.PP
Depending on the X server version in use, input device options may be set
in either a __xconfigfile__ file, an xorg.conf.d snippet, or in the
configuration files read by the Hardware Abstraction Layer (HAL) daemon,
hald(1).
.PP
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
The following driver
.B Options
are supported:
.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
Specify the keyboard device.  Default: the OS's default console keyboard
input source.  Property: "Device Node" (read-only).
.TP 7
.BI "Option \*qProtocol\*q \*q" string \*q
Specify the keyboard protocol.  Valid protocol types include:
.PP
.RS 12
Standard, Xqueue.
.RE
.PP
.RS 7
Not all protocols are supported on all platforms.  Default: "Standard".
.RE
.TP 7
.BI "Option \*qXLeds\*q \*q" ledlist \*q
makes the keyboard LEDs specified in
.I ledlist
available for client use instead of their traditional function
(Scroll Lock, Caps Lock and Num Lock).  The numbers in the list are
in the range 1 to 3.  Default: empty list.
.TP 7
.BI "Option \*qXkbRules\*q \*q" rules \*q
specifies which XKB rules file to use for interpreting the
.BR XkbModel ,
.BR XkbLayout ,
.BR XkbVariant ,
and
.B XkbOptions
settings.  Default: "base" for most platforms.
If you use the "base" value then you can
find listing of all valid values for these four options in the
.I
__xkb_path__/rules/base.lst
file.
.TP 7
.BI "Option \*qXkbModel\*q \*q" modelname \*q
specifies the XKB keyboard model name.  Default: "pc105" for most platforms.
.TP 7
.BI "Option \*qXkbLayout\*q \*q" layoutname \*q
specifies the XKB keyboard layout name.  This is usually the country or
language type of the keyboard.  Default: "us" for most platforms.
.TP 7
.BI "Option \*qXkbVariant\*q \*q" variants \*q
specifies the XKB keyboard variant components.  These can be used to
enhance the keyboard layout details.  Default: not set.
.TP 7
.BI "Option \*qXkbOptions\*q \*q" options \*q
specifies the XKB keyboard option components.  These can be used to
enhance the keyboard behaviour.  Default: not set.
.PP
For a list of available XKB options, see
.B xkeyboard-config(__miscmansuffix__).
.SH EXAMPLE
The following xorg.conf fragment ensures that user will be able to switch between
.I us
and
.I sk
layouts by pressing the "menu" key. The scroll lock LED shows which layout
is currently active.
.PP
The
.B XkbVariant
option defines which variants of the two layouts should be used. In case of the
.I us
layout
its default variant is used. In case of the
.I sk
layout
its
.I qwerty
variant is used.
.PP
.nf
.RS 4
Section \*qInputDevice\*q
.RS 4
Identifier   "Generic Keyboard"
Driver       "kbd"
Option       "CoreKeyboard"
Option       "XkbRules"      "base"
Option       "XkbModel"      "pc105"
Option       "XkbLayout"     "us,sk"
Option       "XkbVariant"    ",qwerty"
Option       "XkbOptions"    "grp:menu_toggle,grp_led:scroll"
.RE
EndSection
.RE
.fi
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), 
Xserver(__appmansuffix__), X(__miscmansuffix__).

hal(__miscmansuffix__), hald(__adminmansuffix__), fdi(__filemansuffix__).

xkeyboard-config(__miscmansuffix__).
