dnl -*- Autoconf -*-
dnl Copyright (C) 2017 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_PREREQ([2.59])

AC_DEFUN([CL_VADVISE],
[
  dnl On NetBSD 8, vadvise() exists, and <sys/vadvise.h> has the necessary
  dnl declarations.
  dnl On FreeBSD 11, vadvise() exists but is not usable, because VA_ANOM is
  dnl not defined anywhere.
  AC_CACHE_CHECK([for usable vadvise], [cl_cv_func_vadvise],
    [AC_LINK_IFELSE(
       [AC_LANG_PROGRAM([[
            #include <unistd.h>
            #include <sys/vadvise.h>
          ]],
          [[vadvise(VA_ANOM); vadvise(VA_NORM);]])
       ],
       [cl_cv_func_vadvise=yes],
       [cl_cv_func_vadvise=no])
    ])
  if test $cl_cv_func_vadvise = yes; then
    AC_DEFINE([HAVE_VADVISE],,[have <sys/vadvise.h> and the vadvise() system call])
  fi
])
