.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
photopile \- displays multiple images in a periodically shuffled pile
.SH SYNOPSIS
.B photopile
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-count \fIint\fP]
[\-scale \fIfactor\fP]
[\-maxTilt \fIdegrees\fP]
[\-titles | \-no\-titles]
[\-polaroid | \-no\-polaroid]
[\-shadows | \-no\-shadows]
[\-font \fIfont\fP]
[\-speed \fIratio\fP]
[\-duration \fIseconds\fP]
[\-fps]
[\-debug]
[\-wireframe]
.SH DESCRIPTION
Loads several random images, and displays them as if lying in a random pile.
The pile is periodically reshuffled, with new images coming in and old ones
being thrown out.

This program requires a good video card capable of supporting large
textures.

To specify the directory that images are loaded from, run
.BR xscreensaver-demo (1)
and click on the "Advanced" tab.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-count \fIint\fP
How many images to display.  Default 7.
.TP 8
.B \-scale \fIfactor\fP
Size of images in relation to the size of the window.  Default 0.4.
.TP 8
.B \-maxTilt \fIdegrees\fP
Maximum deviation from vertical.  Default 50 degrees.
.TP 8
.B \-duration \fIseconds\fP
Every \fIduration\fP seconds, one of the images will be replaced
with a new one.  Default 5 seconds.
.TP 8
.B \-speed \fIratio\fP
Speed up or slow down the animation.  0.5 means half as fast as the
default; 2.0 means twice as fast.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 10000 (0.01 seconds.).
.TP 8
.B \-titles \fB| \-no\-titles\fP
Whether to display the file names of the images beneath them.  Default: yes.
.TP 8
.B \-polaroid \fB| \-no\-polaroid\fP
Whether to simulate images taken by an instant camera.  Default: yes.
.TP 8
.B \-shadows \fB| \-no\-shadows\fP
Whether to draw images with drop shadows.  Default: no.
.TP 8
.B \-font \fIfont-name\fP
The font to use for the initial loading screen and for image titles.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.TP 8
.B \-debug
Prints debugging info to stderr.
.TP 8
.B \-wireframe
Another debug mode.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver-demo (1)
.BR xscreensaver-getimage (1)
.BR xscreensaver (1)
.BR carousel (MANSUFFIX)
.BR glslideshow (MANSUFFIX)
.SH COPYRIGHT
Copyright \(co 2005 by Jamie Zawinski.
Copyright \(co 2008 by Jens Kilian.

Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  No representations are made about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
.SH AUTHOR
Jens Kilian.
