#!/usr/bin/env python3
# Copyright 2021 The Meson development team

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import subprocess
import coverage
import os
import sys
from pathlib import Path

root_path = Path(__file__).parent.parent.absolute()

# Python magic so we can import mesonlib
sys.path.append(root_path.as_posix())
from mesonbuild import mesonlib

def generate_coveragerc() -> Path:
    i_file = (root_path / 'data' / '.coveragerc.in')
    o_file = (root_path / '.coveragerc')
    raw = i_file.read_text(encoding='utf-8')
    raw = raw.replace('@ROOT@', root_path.as_posix())
    o_file.write_text(raw, encoding='utf-8')
    return o_file

def main() -> int:
    # Remove old run data
    out_dir = root_path / '.coverage'
    mesonlib.windows_proof_rmtree(out_dir.as_posix())
    out_dir.mkdir(parents=True, exist_ok=True)

    # Setup coverage
    python_path = (root_path / 'ci').as_posix()
    os.environ['PYTHONPATH'] = os.pathsep.join([python_path, os.environ.get('PYTHONPATH', '')])
    os.environ['COVERAGE_PROCESS_START'] = generate_coveragerc().as_posix()
    coverage.process_startup()

    # Run the actual command
    cmd = mesonlib.python_command + sys.argv[1:]
    return subprocess.run(cmd, env=os.environ.copy()).returncode

if __name__ == '__main__':
    raise SystemExit(main())
