/*
 * Shim header file to get the functionality of ConditionalMacros.h
 * in all environments
 */
 
#ifndef KERBEROSCONDITIONALMACROS_H
#define KERBEROSCONDITIONALMACROS_H

#if defined(macintosh) && !(defined(__MACH__) && defined(__APPLE__))

    /* Mac OS 8 and 9 */
    #include <ConditionalMacros.h>

#elif defined(__GNUC__) && ( defined(__APPLE_CPP__) || defined(__APPLE_CC__) || defined(__MACOS_CLASSIC__))
    
    /* Mac OS X compilers we support */
    #include <TargetConditionals.h>			/* Darwin macros: TARGET_OS_*, TARGET_CPU_*, TARGET_RT_* */

    /* Things we use which are not defined by Darwin's conditional macros */
    #define TARGET_API_MAC_CARBON					1	/* Currently we require Carbon */
    #define TARGET_API_MAC_OSX						1	/* This is a Mac OS X box */
    #define BAGEL_STAPLING							1   /* We love Mac OS X */
    #define ALL_YOUR_KERBEROS_ARE_BELONG_TO_US		1	/* We love Kerberos */

#else
    #error "Unsupported environment"
#endif

#endif /* KERBEROSCONDITIONALMACROS_H */
