/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.gui.FileUtil;
import jarinstaller.gui.INavigation;
import jarinstaller.gui.IReport;
import jarinstaller.gui.StepPanel;
import jarinstaller.gui.UninstallUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class UnInstallPanel
extends StepPanel
implements IReport {
    Hashtable gp;
    public static final String ERROR_AT_DELETE_FILE = "Hiba az \u00e1llom\u00e1ny t\u00f6rl\u00e9se sor\u00e1n.";
    JLabel lblInfo = new JLabel();
    JLabel zippedFile = new JLabel();
    JLabel extractedFile = new JLabel();
    JProgressBar progressBar = new JProgressBar();
    INavigation navigation;
    URI sourcefile;
    String destDir;
    String info;
    String jarinstallerdir;
    boolean insresult = false;
    String errmsg = "";
    int pbvalue = 0;
    FileUtil fu;
    UninstallUtil unfu;
    Thread unfuThread;
    String uninstallfile;
    Vector removeFileList;
    Vector deletedFiles;
    Vector errFiles;

    public UnInstallPanel(Hashtable params) {
        this.gp = params;
        this.sourcefile = (URI)this.gp.get("parameter.option.sourcefile");
        this.destDir = (String)this.gp.get("DESTINATIONDIR");
        this.jarinstallerdir = (String)this.gp.get("parameter.dir.jarinstaller");
        this.navigation = (INavigation)this.gp.get("navigation.frameid");
        try {
            this.createElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createElements() throws Exception {
        this.setOpaque(false);
        this.lblInfo.setFont((Font)this.gp.get("gui.font.title"));
        this.lblInfo.setOpaque(false);
        this.zippedFile.setFont((Font)this.gp.get("gui.font.msg.small"));
        this.zippedFile.setOpaque(false);
        this.extractedFile.setFont((Font)this.gp.get("gui.font.msg.small"));
        this.extractedFile.setOpaque(false);
        this.progressBar.setForeground((Color)this.gp.get("gui.color.progress"));
        this.progressBar.setDoubleBuffered(true);
        this.progressBar.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridbag = new GridBagConstraints();
        gridbag.gridx = 0;
        gridbag.gridy = 0;
        gridbag.gridwidth = 1;
        gridbag.gridheight = 1;
        gridbag.weightx = 1.0;
        gridbag.weighty = 0.0;
        gridbag.anchor = 17;
        gridbag.fill = 2;
        gridbag.insets = new Insets(10, 20, 10, 10);
        this.add((Component)this.lblInfo, gridbag);
        gridbag.gridy = 1;
        gridbag.weightx = 1.0;
        gridbag.insets = new Insets(30, 20, 10, 10);
        this.add((Component)this.zippedFile, gridbag);
        gridbag.gridy = 2;
        gridbag.insets = new Insets(15, 20, 10, 10);
        this.add((Component)this.extractedFile, gridbag);
        gridbag.gridy = 3;
        gridbag.insets = new Insets(40, 20, 10, 20);
        this.progressBar.setPreferredSize(new Dimension(150, 20));
        this.add((Component)this.progressBar, gridbag);
        this.refresh();
        this.guiRefresh();
    }

    public void guiRefresh() throws Exception {
        this.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.setMaximumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setPreferredSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setMinimumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.lblInfo.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.zippedFile.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.extractedFile.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.zippedFile.setText("");
        this.extractedFile.setText("");
        this.progressBar.setValue(0);
        this.validate();
    }

    public boolean isActivate() {
        return !this.insresult;
    }

    public void setParams(Hashtable params) {
        this.info = (String)params.get("info");
        this.uninstallfile = (String)params.get("uninstallfile");
        this.lblInfo.setText(this.info);
        this.validate();
    }

    public boolean start(Hashtable start_params) {
        return this.exec();
    }

    private boolean exec() {
        try {
            this.fu = new FileUtil();
            String uninst = this.fu.replaceTokens(this.uninstallfile, this.gp);
            this.removeFileList = this.readUninstallFile(uninst);
            this.progressBar.setMaximum(this.removeFileList.size());
            this.insresult = false;
            this.unfu = new UninstallUtil(this.gp);
            this.unfu.setUninstallfile(uninst);
            this.unfu.setReport(this);
            this.unfuThread = new Thread(this.unfu);
            this.unfuThread.start();
        }
        catch (Exception e) {
            this.errmsg = e.getMessage();
            this.navigation.fwd();
        }
        return this.insresult;
    }

    private Vector readUninstallFile(String file) throws Exception {
        BufferedReader br = null;
        try {
            String line;
            Vector<String> out = new Vector<String>();
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = br.readLine()) != null) {
                out.add(line);
            }
            br.close();
            return out;
        }
        catch (Exception e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
    }

    public boolean isFinisdhed(boolean stop) {
        if (stop) {
            if (this.unfuThread.isAlive()) {
                this.unfu.stop();
                while (!this.unfu.isStopped()) {
                    this.sleep(2000L);
                }
                this.unfuThread = null;
            }
            return true;
        }
        return true;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Hashtable end() {
        this.gp.remove("option.installed.msg");
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("parameter.option.install.result", new Boolean(this.insresult));
        if (!this.insresult) {
            result.put("parameter.option.install.errmsg", this.errmsg);
        }
        return result;
    }

    public void inFormStart(String msg, String info, long size) {
        this.zippedFile.setText(msg);
        this.extractedFile.setText(info);
        this.validate();
    }

    public void inFormEnd(String msg, String info, long size) {
        this.pbvalue += (int)size;
        this.progressBar.setValue(this.pbvalue);
        this.validate();
    }

    public void setResult(boolean result, String msg, Hashtable data) {
        this.insresult = result;
        this.errmsg = msg;
        this.navigation.fwd();
    }
}

