#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0x9E,0x4B,0xF1,0x66,0x40,0x86,0x1B,0x84,0x7E,0x4B,0xC3,0x43,
		0x59,0x17,0xC6,0x2A,0x63,0x2E,0x0F,0xB7,0x0A,0x8A,0xAC,0x3F,
		0x07,0x6E,0xF8,0xC2,0x16,0xA6,0xE4,0x5B,0x2C,0x47,0xCF,0x51,
		0x18,0xDC,0x10,0xED,0xF6,0xAA,0xBC,0xC6,0x52,0xC8,0xB6,0x94,
		0xA2,0x4F,0x26,0x1C,0x39,0xBD,0xF1,0x5F,0xA9,0x45,0x90,0x8C,
		0x8B,0xE6,0x63,0x0C,0x27,0x85,0x13,0x68,0xA3,0x6B,0xD5,0x83,
		0x68,0x3C,0x7C,0x10,0xB4,0xA1,0x8A,0xFC,0xEF,0x4E,0xB3,0xCB,
		0xCE,0xD6,0x56,0x33,0x84,0x7B,0x27,0x16,0xF5,0x92,0xDC,0xB0,
		0xF0,0xD8,0x2F,0x7F,0x14,0x8F,0x59,0xB2,0x21,0xE4,0x54,0x28,
		0xD6,0x89,0x88,0xE2,0x7C,0x80,0x46,0x63,0x34,0xC9,0x09,0x90,
		0xD4,0xC1,0xEE,0xF5,0xB3,0x62,0x27,0x25,0x96,0x0D,0x4C,0x19,
		0x61,0x86,0x85,0xF3,0x7B,0x5C,0x79,0xC7,0x54,0x1E,0x27,0x8F,
		0x36,0x08,0x67,0xF4,0x91,0x9E,0x5D,0x44,0x09,0x93,0x3B,0xCB,
		0xAB,0xCE,0xFB,0xE3,0x33,0x68,0xFD,0x1C,0xE9,0xA8,0x35,0x0D,
		0x2B,0xF3,0x85,0xE1,0xD3,0xAD,0x70,0x57,0x1D,0x31,0x89,0x2C,
		0x79,0x75,0xF7,0x9C,0x6C,0x07,0xFD,0xEB,0x19,0x48,0xAE,0x02,
		0xC0,0x98,0x5D,0x5B,0x6A,0x86,0x01,0xA5,0xE8,0x24,0xC6,0x5C,
		0x7E,0x4B,0x72,0xE2,0xC1,0x8B,0x0A,0xCF,0xF0,0xDF,0xAF,0xD2,
		0xB9,0xAE,0xE8,0x3F,0x20,0x1A,0x3B,0x19,0x08,0x33,0xAF,0x4F,
		0xDA,0x0F,0x27,0xA5,0x9A,0xD9,0x7B,0xB9,0xDC,0x3F,0x94,0xF4,
		0x3C,0xFF,0x48,0x3C,0x9A,0x2D,0xE1,0x35,0xDA,0x9E,0xEF,0xCD,
		0xBF,0x40,0xC4,0xFB,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
#endif /* OPENSSL_NO_DH */
