/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.ErrorHandler;
import jarinstaller.gui.DebugInfo;
import jarinstaller.gui.EditorPanePanel;
import jarinstaller.gui.EmptyPanel;
import jarinstaller.gui.FileUtil;
import jarinstaller.gui.INavigation;
import jarinstaller.gui.ImagePanel;
import jarinstaller.gui.InfoPanel;
import jarinstaller.gui.InputDirPanel;
import jarinstaller.gui.InstallPanel;
import jarinstaller.gui.NavPanel;
import jarinstaller.gui.OptionPanel;
import jarinstaller.gui.RadioPanel;
import jarinstaller.gui.Resource;
import jarinstaller.gui.ResultPanel;
import jarinstaller.gui.StartPanel;
import jarinstaller.gui.StepPanel;
import jarinstaller.gui.TitlePanel;
import jarinstaller.gui.ToDoPanel;
import jarinstaller.gui.UnInstallPanel;
import jarinstaller.gui.UserToDoPanel;
import jarinstaller.oshandler.IOsHandler;
import jarinstaller.oshandler.OsFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;

public class MainFrame
extends JFrame
implements INavigation {
    private boolean debugOn = false;
    public static final String STPANEL_TYPE_START = "start";
    public static final String STPANEL_TYPE_INFO = "info";
    public static final String STPANEL_TYPE_EDITORPANE = "editorpane";
    public static final String STPANEL_TYPE_OPTION = "option";
    public static final String STPANEL_TYPE_REINSTALL = "reinstal";
    public static final String STPANEL_TYPE_UNINSTALL = "uninstall";
    public static final String STPANEL_TYPE_ACCEPT = "accept";
    public static final String STPANEL_TYPE_INPUTDIR = "inputdir";
    public static final String STPANEL_TYPE_INSTALL = "install";
    public static final String STPANEL_TYPE_RESULT = "result";
    public static final String STPANEL_TYPE_TODO = "todo";
    public static final String STPANEL_TYPE_USER_TODO = "usertodo";
    public static final String STPANEL_TYPE_RADIO = "radio";
    ErrorHandler err;
    private boolean is_applet;
    private URI source;
    private Hashtable params;
    private Vector pages;
    private int actpage;
    private int lastpage;
    private int resultpage;
    private boolean insresult = true;
    private boolean canceled = false;
    private Vector resultFiles;
    private Vector resultDirs;
    private Resource resource;
    private EmptyPanel emptyPanel = null;
    private ImagePanel imagePanel = null;
    private NavPanel navPanel = null;
    private TitlePanel titlePanel = null;
    private StartPanel startPanel = null;
    private ResultPanel resultPanel = null;
    private InfoPanel infoPanel = null;
    private InstallPanel installPanel = null;
    private InputDirPanel inputDirPanel = null;
    private EditorPanePanel editorPanePanel = null;
    private OptionPanel optionPanel = null;
    private RadioPanel radioPanel = null;
    private UnInstallPanel unInstallPanel = null;
    private ToDoPanel toDoPanel = null;
    private UserToDoPanel usertoDoPanel = null;
    private StepPanel actpanel = null;
    private JPanel mpane;
    private JPanel pane;
    private static final int DEF_X = 650;
    private static final int DEF_Y = 300;
    private static Dimension panelDim = new Dimension(650, 300);
    private BorderLayout frameLayout = new BorderLayout();
    private BorderLayout panelLayout = new BorderLayout();
    private static JRootPane rp = null;
    IOsHandler osHandler = OsFactory.getOsHandler();

    public MainFrame(URI source, boolean is_applet, Hashtable params) {
        this.source = source;
        this.is_applet = is_applet;
        this.params = params;
        this.err = new ErrorHandler(this.debugOn);
        rp = this.getRootPane();
        params.put("rootpane", rp);
        params.put("navigation.frameid", this);
        this.resource = (Resource)params.get("parameter.option.resources");
        this.pages = (Vector)params.get("pages");
        this.actpage = -1;
        this.lastpage = this.pages.size() - 1;
        this.resultpage = this.setResultPage();
        this.getDataStore();
        this.setUserParamsExists(params);
        this.createElements();
        Vector messages = (Vector)params.get("main_logic_messages");
        for (int i = 0; i < messages.size(); ++i) {
            String msg = (String)messages.elementAt(i);
            JOptionPane.showMessageDialog(this.navPanel, msg, "Figyelmeztet\u00e9s", 2);
        }
        if (!this.checkInstallable()) {
            JOptionPane.showMessageDialog(this.navPanel, "A keretprogramot kell el\u0151sz\u00f6r telep\u00edtenie, csak ut\u00e1na telep\u00edtheti ezt!", "Hiba", 0);
            this.doClose();
        }
        this.doNextStep(1, null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.canceled = true;
                MainFrame.this.doClose();
            }
        });
    }

    private void setUserParamsExists(Hashtable params) {
        if (params.containsKey("KRDIR") && ((String)params.get("KRDIR")).length() > 0 && params.containsKey("DESTINATIONDATADIR") && ((String)params.get("DESTINATIONDATADIR")).length() > 0) {
            params.put("USERPARAMSEXISTS", "true");
        }
    }

    public void viewSystemProperties() {
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            DebugInfo.showMessage(key + " = " + System.getProperty(key));
        }
        DebugInfo.showMessage("--------------------------------------------------");
        try {
            Field ff = ClassLoader.class.getDeclaredField("usr_paths");
            ff.setAccessible(true);
            String[] a = (String[])ff.get(null);
            for (int i = 0; i < a.length; ++i) {
                String s = a[i];
                DebugInfo.showMessage(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setParams(String key, Object data) {
        if (this.params == null) {
            this.params = new Hashtable();
        }
        this.params.put(key, data);
    }

    private void setGuiProperties() {
        this.params.put("gui.dimension.steppanel", new Dimension(180, 200));
        this.params.put("gui.color.bgrnd", SystemColor.control);
        this.params.put("gui.color.fgrnd", Color.BLACK);
        this.params.put("gui.color.title", Color.BLACK);
        this.params.put("gui.color.progress", Color.BLUE);
        this.params.put("gui.color.btn", SystemColor.controlText);
        this.params.put("gui.font.title", new Font("TimesRoman", 0, 18));
        this.params.put("gui.font.medium", new Font("TimesRoman", 0, 14));
        this.params.put("gui.font.msg", new Font("TimesRoman", 0, 12));
        this.params.put("gui.font.msg.small", new Font("TimesRoman", 0, 11));
        this.params.put("btn.text.cancel", "M\u00e9gse");
        this.params.put("btn.text.back", "Vissza");
        this.params.put("btn.text.fwd", "Tov\u00e1bb");
        this.params.put("btn.text.done", "Befejez\u00e9s");
        this.params.put("btn.text.browse", "Tall\u00f3z\u00e1s...");
        this.params.put("filechooser.title", "K\u00f6nyvt\u00e1r v\u00e1laszt\u00e1s");
        this.params.put("file.browser.border.title", " K\u00f6nyvt\u00e1r ");
    }

    public static JRootPane getRPane() {
        return rp;
    }

    private Object getParam(String key) {
        if (this.params.containsKey(key)) {
            return this.params.get(key);
        }
        return null;
    }

    private Hashtable getPanelParams(int pnum) {
        if (pnum < 0 || pnum > this.lastpage) {
            return null;
        }
        return (Hashtable)this.pages.get(pnum);
    }

    private boolean checkInstallable() {
        boolean isMain;
        Boolean installed = (Boolean)this.params.get("ISINSTALLED");
        boolean isInstalled = installed != null && installed != false;
        String mainprogram = (String)this.params.get("MAINPROGRAM");
        boolean bl = isMain = mainprogram == null || mainprogram.length() == 0 || mainprogram.equalsIgnoreCase("true");
        return isInstalled || isMain;
    }

    private void createElements() {
        this.setGuiProperties();
        this.mpane = new JPanel();
        this.pane = new JPanel();
        this.imagePanel = new ImagePanel(this.params);
        this.titlePanel = new TitlePanel(this.params);
        this.navPanel = new NavPanel(this, this.params);
        this.emptyPanel = new EmptyPanel();
        this.guiInit();
    }

    private void guiInit() {
        this.setProperties();
        this.setTitle(this.getParam("mainfrane.title").toString());
        this.setResizable(true);
        this.setContentPane(this.mpane);
        this.mpane.setOpaque(true);
        this.pane.setDoubleBuffered(true);
        this.setResizable(false);
        this.mpane.setLayout(this.frameLayout);
        this.mpane.setPreferredSize(panelDim);
        this.imagePanel.setMinimumSize(new Dimension(200, 300));
        this.imagePanel.setMaximumSize(new Dimension(200, 300));
        this.imagePanel.setPreferredSize(new Dimension(200, 300));
        this.mpane.add((Component)this.imagePanel, "West");
        this.pane.setLayout(this.panelLayout);
        this.pane.setMinimumSize(new Dimension(440, 300));
        this.pane.setMaximumSize(new Dimension(440, 300));
        this.pane.setPreferredSize(new Dimension(new Dimension(440, (int)this.getPreferredSize().getHeight())));
        this.mpane.add((Component)this.pane, "East");
        this.pane.add((Component)this.titlePanel, "North");
        this.pane.add((Component)this.emptyPanel, "Center");
        this.actpanel = this.emptyPanel;
        this.pane.add((Component)this.navPanel, "South");
        this.validate();
        this.setSize(panelDim);
    }

    private void enableAllButtons() {
        this.navPanel.enableButtons(true, true, true);
    }

    private void disableAllButtons() {
        this.navPanel.enableButtons(false, false, false);
    }

    private void disableAllButtonsExpectCancel() {
        this.navPanel.enableButtons(true, false, false);
    }

    private void enableAllButtonsExpectBk() {
        this.navPanel.enableButtons(true, false, true);
    }

    private void enableAllButtonsExpectCancel() {
        this.navPanel.enableButtons(false, true, true);
    }

    public void setPanelParams(StepPanel panel, Hashtable page_params) {
        if (panel != null) {
            try {
                panel.setParams(page_params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void guiRefresh() {
        this.titlePanel.refresh();
        if (this.actpanel != null) {
            this.actpanel.refresh();
        }
        this.validate();
    }

    public void setStepVisible(boolean show) {
        if (this.actpanel != null) {
            this.actpanel.setVisible(show);
        }
        this.guiRefresh();
    }

    private void addPanel(StepPanel np) {
        if (this.actpanel != null) {
            this.actpanel.setVisible(false);
            this.pane.remove(this.actpanel);
        }
        this.pane.add((Component)np, "Center");
        this.actpanel = np;
        this.actpanel.setVisible(true);
        this.actpanel.validate();
    }

    public void cancel() {
        this.canceled = true;
        this.doClose();
    }

    public void back() {
        this.doNextStep(-1, null);
    }

    public void fwd() {
        if (this.actpage > 0 && !this.actpanel.isFinisdhed(false)) {
            return;
        }
        this.doNextStep(1, null);
    }

    public void end() {
        this.canceled = false;
        this.doClose();
    }

    public void doNextStep(int step, String id) {
        Hashtable pagetable;
        Hashtable result = this.actpanel.end();
        if (result != null) {
            this.params.putAll(result);
        }
        int nextpage = this.actpage + step;
        if (id != null) {
            nextpage = this.getPageById(id);
        }
        if (this.actpage > -1 && step > 0 && (pagetable = this.getPanelParams(this.actpage)).containsKey("nextpages")) {
            String foundpage = null;
            Vector pp = (Vector)pagetable.get("nextpages");
            int i = 0;
            while (i++ < pp.size() && foundpage == null) {
                Hashtable pht = (Hashtable)pp.elementAt(i - 1);
                String key = (String)pht.get("key");
                if (!this.params.containsKey(key) || !((Boolean)this.params.get(key)).booleanValue()) continue;
                foundpage = (String)pht.get("nextpageid");
            }
            if (foundpage == null) {
                return;
            }
            nextpage = this.getPageById(foundpage);
        }
        if (this.params.containsKey("parameter.option.install.result") && !((Boolean)this.params.get("parameter.option.install.result")).booleanValue()) {
            nextpage = this.resultpage;
            this.insresult = false;
        }
        if (nextpage < 0 || nextpage > this.lastpage) {
            return;
        }
        pagetable = this.getPanelParams(nextpage);
        String pagetype = (String)pagetable.get("type");
        DebugInfo.showMessage("pagetype = " + pagetype);
        boolean lastpanel = false;
        if (pagetable.containsKey("lastpanel")) {
            lastpanel = ((String)pagetable.get("lastpanel")).compareTo("true") == 0;
        }
        StepPanel nextPanel = null;
        if (pagetype.compareTo(STPANEL_TYPE_START) == 0) {
            if (this.startPanel == null) {
                this.startPanel = new StartPanel(this.params);
            }
            if (!(nextPanel = this.startPanel).isActivate()) {
                return;
            }
            this.enableAllButtonsExpectBk();
        } else if (pagetype.compareTo(STPANEL_TYPE_INFO) == 0) {
            if (this.infoPanel == null) {
                this.infoPanel = new InfoPanel(this.params);
            }
            if (!(nextPanel = this.infoPanel).isActivate()) {
                return;
            }
            this.enableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_RADIO) == 0) {
            if (this.radioPanel == null) {
                this.radioPanel = new RadioPanel(this.params);
            }
            if (!(nextPanel = this.radioPanel).isActivate()) {
                return;
            }
            this.enableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_UNINSTALL) == 0) {
            if (this.unInstallPanel == null) {
                this.unInstallPanel = new UnInstallPanel(this.params);
            }
            if (!(nextPanel = this.unInstallPanel).isActivate()) {
                return;
            }
            this.disableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_EDITORPANE) == 0) {
            if (this.editorPanePanel == null) {
                this.editorPanePanel = new EditorPanePanel(this.params);
            }
            if (!(nextPanel = this.editorPanePanel).isActivate()) {
                return;
            }
            this.enableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_OPTION) == 0) {
            if (this.optionPanel == null) {
                this.optionPanel = new OptionPanel(this.params);
            }
            if (!(nextPanel = this.optionPanel).isActivate()) {
                return;
            }
            this.enableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_INSTALL) == 0) {
            if (this.installPanel == null) {
                this.installPanel = new InstallPanel(this.params);
            }
            if (!(nextPanel = this.installPanel).isActivate()) {
                return;
            }
            this.disableAllButtonsExpectCancel();
        } else if (pagetype.compareTo(STPANEL_TYPE_TODO) == 0) {
            if (this.toDoPanel == null) {
                this.toDoPanel = new ToDoPanel(this.params);
            }
            if (!(nextPanel = this.toDoPanel).isActivate()) {
                return;
            }
            this.disableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_USER_TODO) == 0) {
            if (this.usertoDoPanel == null) {
                this.usertoDoPanel = new UserToDoPanel(this.params);
            }
            if (!(nextPanel = this.usertoDoPanel).isActivate()) {
                return;
            }
            this.disableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_INPUTDIR) == 0) {
            if (this.inputDirPanel == null) {
                this.inputDirPanel = new InputDirPanel(this.params);
            }
            if (!(nextPanel = this.inputDirPanel).isActivate()) {
                return;
            }
            this.enableAllButtons();
        } else if (pagetype.compareTo(STPANEL_TYPE_RESULT) == 0) {
            if (this.resultPanel == null) {
                this.resultPanel = new ResultPanel(this.params);
            }
            if (!(nextPanel = this.resultPanel).isActivate()) {
                return;
            }
            if (this.insresult) {
                this.enableAllButtonsExpectCancel();
            } else {
                lastpanel = true;
            }
        }
        this.navPanel.setLastPage(lastpanel, this.insresult);
        this.actpage = nextpage;
        if (nextPanel != null) {
            nextPanel.setParams(pagetable);
            this.titlePanel.setParams(pagetable);
            this.addPanel(nextPanel);
            nextPanel.start(this.params);
        }
        this.validate();
        this.guiRefresh();
    }

    private int setResultPage() {
        for (int i = 0; i < this.pages.size(); ++i) {
            Hashtable ht = (Hashtable)this.pages.elementAt(i);
            if (!ht.containsKey("resultpanel") || ((String)ht.get("resultpanel")).compareTo("true") != 0) continue;
            return i;
        }
        return -1;
    }

    private int getPageById(String id) {
        for (int i = 0; i < this.pages.size(); ++i) {
            Hashtable ht = (Hashtable)this.pages.elementAt(i);
            if (!ht.containsKey("id") || ((String)ht.get("id")).compareTo(id) != 0) continue;
            return i;
        }
        return -1;
    }

    public void doClose() {
        if (this.canceled) {
            if (JOptionPane.showOptionDialog(this.navPanel, "Val\u00f3ban ki akar l\u00e9pni?", "Kil\u00e9p\u00e9s a telep\u00edt\u0151b\u0151l", 0, 3, null, null, null) == 0) {
                try {
                    this.actpanel.isFinisdhed(true);
                    if (!this.params.containsKey("parameter.option.install.ready")) {
                        FileUtil fu = new FileUtil();
                        fu.remove(this.resultFiles, this.resultDirs);
                    }
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        System.gc();
        this.dispose();
        if (!this.is_applet) {
            System.exit(0);
        }
    }

    private void getDataStore() {
        if (this.params.containsKey("parameter.option.install.filelist")) {
            this.resultFiles = (Vector)this.params.get("parameter.option.install.filelist");
        }
        if (this.params.containsKey("parameter.option.install.dirlist")) {
            this.resultDirs = (Vector)this.params.get("parameter.option.install.dirlist");
        }
    }

    private void setProperties() {
        UIManager.put("OptionPane.yesButtonText", "Igen");
        UIManager.put("OptionPane.noButtonText", "Nem");
        UIManager.put("FileChooser.title", "V\u00e1lasszon f\u00e1jlt");
        UIManager.put("FileChooser.lookInLabelText", "Hely :");
        UIManager.put("FileChooser.filesOfTypeLabelText", "F\u00e1jlt\u00edpus :");
        UIManager.put("FileChooser.upFolderToolTipText", "Egy szinttel feljebb");
        UIManager.put("FileChooser.fileNameLabelText", "F\u00e1jln\u00e9v :");
        UIManager.put("FileChooser.homeFolderToolTipText", "Nyit\u00f3mappa");
        UIManager.put("FileChooser.newFolderToolTipText", "\u00daj mappa");
        UIManager.put("FileChooser.listViewButtonToolTipTextlist", "N\u00e9zet");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "R\u00e9szletek");
        UIManager.put("FileChooser.listViewButtonToolTipText", "Lista");
        UIManager.put("FileChooser.saveButtonText", "Ment\u00e9s");
        UIManager.put("FileChooser.openButtonText", "Megnyit\u00e1s");
        UIManager.put("FileChooser.directoryOpenButtonText", "Megnyit\u00e1s");
        UIManager.put("FileChooser.cancelButtonText", "M\u00e9gsem");
        UIManager.put("FileChooser.updateButtonText", "Friss\u00edt\u00e9s");
        UIManager.put("FileChooser.helpButtonText", "Seg\u00edts\u00e9g !");
        UIManager.put("FileChooser.saveButtonToolTipText", "Ment\u00e9s");
        UIManager.put("FileChooser.openButtonToolTipText", "A kijel\u00f6lt f\u00e1jlok megnyit\u00e1sa");
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", "A kijel\u00f6lt mappa megnyit\u00e1sa");
        UIManager.put("FileChooser.cancelButtonToolTipText", "M\u00e9gsem");
        UIManager.put("FileChooser.updateButtonToolTipText", "Friss\u00edt\u00e9s");
        UIManager.put("FileChooser.helpButtonToolTipText", "Seg\u00edts\u00e9g");
        UIManager.put("FileChooser.acceptAllFileFilterText", "Minden k\u00f6nyvt\u00e1r");
        UIManager.put("FileChooser.fileNameHeaderText", "N\u00e9v");
        UIManager.put("FileChooser.fileSizeHeaderText", "M\u00e9ret");
        UIManager.put("FileChooser.fileTypeHeaderText", "T\u00edpus");
        UIManager.put("FileChooser.fileDateHeaderText", "M\u00f3dos\u00edtva");
        UIManager.put("FileChooser.fileAttrHeaderText", "Attributum");
    }
}

