macro(VsDefaultCompilerFlags_check tgt)
  set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/${tgt}.vcxproj")
  if(NOT EXISTS "${vcProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not exist.")
    return()
  endif()

  set(HAVE_BasicRuntimeChecks 0)
  set(HAVE_BufferSecurityCheck 0)
  set(HAVE_CallingConvention 0)
  set(HAVE_FloatingPointModel 0)
  set(HAVE_ForceConformanceInForLoopScope 0)
  set(HAVE_MinimalRebuild 0)
  set(HAVE_Optimization 0)
  set(HAVE_RemoveUnreferencedCodeData 0)
  set(HAVE_RuntimeLibrary 0)
  set(HAVE_SupportJustMyCode 0)
  set(HAVE_TreatWChar_tAsBuiltInType 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<BasicRuntimeChecks>Default</BasicRuntimeChecks>")
      set(HAVE_BasicRuntimeChecks 1)
    endif()
    if(line MATCHES "^ *<BufferSecurityCheck></BufferSecurityCheck>")
      set(HAVE_BufferSecurityCheck 1)
    endif()
    if(line MATCHES "^ *<CallingConvention></CallingConvention>")
      set(HAVE_CallingConvention 1)
    endif()
    if(line MATCHES "^ *<FloatingPointModel></FloatingPointModel>")
      set(HAVE_FloatingPointModel 1)
    endif()
    if(line MATCHES "^ *<ForceConformanceInForLoopScope></ForceConformanceInForLoopScope>")
      set(HAVE_ForceConformanceInForLoopScope 1)
    endif()
    if(line MATCHES "^ *<MinimalRebuild></MinimalRebuild>")
      set(HAVE_MinimalRebuild 1)
    endif()
    if(line MATCHES "^ *<Optimization>[^\\n<]*</Optimization>")
      set(HAVE_Optimization 1)
    endif()
    if(line MATCHES "^ *<RemoveUnreferencedCodeData></RemoveUnreferencedCodeData>")
      set(HAVE_RemoveUnreferencedCodeData 1)
    endif()
    if(line MATCHES "^ *<RuntimeLibrary>[^\\n<]*</RuntimeLibrary>")
      set(HAVE_RuntimeLibrary 1)
    endif()
    if(line MATCHES "^ *<SupportJustMyCode></SupportJustMyCode>")
      set(HAVE_SupportJustMyCode 1)
    endif()
    if(line MATCHES "^ *<TreatWChar_tAsBuiltInType></TreatWChar_tAsBuiltInType>")
      set(HAVE_TreatWChar_tAsBuiltInType 1)
    endif()
  endforeach()

  if(NOT HAVE_BasicRuntimeChecks)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <BasicRuntimeChecks> property.")
    return()
  endif()

  if(NOT HAVE_BufferSecurityCheck)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <BufferSecurityCheck> property.")
    return()
  endif()

  if(NOT HAVE_CallingConvention)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <CallingConvention> property.")
    return()
  endif()

  if(NOT HAVE_FloatingPointModel)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <FloatingPointModel> property.")
    return()
  endif()

  if(NOT HAVE_ForceConformanceInForLoopScope)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <ForceConformanceInForLoopScope> property.")
    return()
  endif()

  if(NOT HAVE_MinimalRebuild)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <MinimalRebuild> property.")
    return()
  endif()

  if(NOT HAVE_Optimization)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <Optimization> property.")
    return()
  endif()

  if(NOT HAVE_RemoveUnreferencedCodeData)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <RemoveUnreferencedCodeData> property.")
    return()
  endif()

  if(NOT HAVE_RuntimeLibrary)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <RuntimeLibrary> property.")
    return()
  endif()

  if(NOT HAVE_SupportJustMyCode)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <SupportJustMyCode> property.")
    return()
  endif()

  if(NOT HAVE_TreatWChar_tAsBuiltInType)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <TreatWChar_tAsBuiltInType> property.")
    return()
  endif()
endmacro()

macro(VsDefaultLinkerFlags_check tgt needs_subsystem_console)
  set(HAVE_DataExecutionPrevention 0)
  set(HAVE_ImageHasSafeExceptionHandlers 0)
  set(HAVE_LinkErrorReporting 0)
  set(HAVE_RandomizedBaseAddress 0)
  set(HAVE_SubSystem 0)
  set(HAVE_SubSystem_Console 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<DataExecutionPrevention></DataExecutionPrevention>")
      set(HAVE_DataExecutionPrevention 1)
    endif()
    if(line MATCHES "^ *<ImageHasSafeExceptionHandlers></ImageHasSafeExceptionHandlers>")
      set(HAVE_ImageHasSafeExceptionHandlers 1)
    endif()
    if(line MATCHES "^ *<LinkErrorReporting></LinkErrorReporting>")
      set(HAVE_LinkErrorReporting 1)
    endif()
    if(line MATCHES "^ *<RandomizedBaseAddress></RandomizedBaseAddress>")
      set(HAVE_RandomizedBaseAddress 1)
    endif()
    if(line MATCHES "^ *<SubSystem></SubSystem>")
      set(HAVE_SubSystem 1)
    endif()
    if(line MATCHES "^ *<SubSystem>Console</SubSystem>")
      set(HAVE_SubSystem_Console 1)
    endif()
  endforeach()

  if(NOT HAVE_DataExecutionPrevention)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <DataExecutionPrevention> property.")
    return()
  endif()

  if(NOT HAVE_ImageHasSafeExceptionHandlers)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <ImageHasSafeExceptionHandlers> property.")
    return()
  endif()

  if(NOT HAVE_LinkErrorReporting)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <LinkErrorReporting> property.")
    return()
  endif()

  if(NOT HAVE_RandomizedBaseAddress)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <RandomizedBaseAddress> property.")
    return()
  endif()

  if(${needs_subsystem_console})
    if(HAVE_SubSystem)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has a <SubSystem> property.")
      return()
    endif()

    if(NOT HAVE_SubSystem_Console)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <SubSystem> property with 'Console' value.")
      return()
    endif()
  else()
    if(NOT HAVE_SubSystem)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <SubSystem> property.")
      return()
    endif()

    if(HAVE_SubSystem_Console)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has a <SubSystem> property with 'Console' value.")
      return()
    endif()
  endif()
endmacro()

VsDefaultCompilerFlags_check(emptyStatic)

VsDefaultCompilerFlags_check(emptyShared)
VsDefaultLinkerFlags_check(emptyShared OFF)

VsDefaultCompilerFlags_check(main)
VsDefaultLinkerFlags_check(main ON)
