.\" Copyright 1988, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\"
.TH XWININFO 1 __xorgversion__
.SH NAME
xwininfo \- window information utility for X
.SH SYNOPSIS
.B "xwininfo"
[\-help] [\-id \fIwdid\fP] [\-root] [\-name \fIwdname\fP] [\-int]
[\-children] [\-tree] [\-stats] [\-bits] [\-events] [\-size] [\-wm] [\-shape]
[\-frame] [\-all]
[\-english] [\-metric]
[\-display \fIhost:dpy\fP] [\-version]
.SH DESCRIPTION
.PP
.I Xwininfo
is a utility for displaying information about windows.
Various information is displayed depending on which options are selected.
If no options are chosen, \fB\-stats\fP is assumed.
.PP
The user has the option of selecting the target window with
the mouse (by clicking any mouse button in the desired window) or by
specifying its window id on the command line with the \fB\-id\fP option.
Or instead of specifying
the window by its id number, the \fB\-name\fP option may be used to specify
which window is desired by name.
There is also a special \fB\-root\fP option to quickly obtain information
on the screen's root window.
.SH OPTIONS
.PP
.TP 8
.B "\-help"
Print out the `Usage:' command syntax summary.
.PP
.TP 8
.B "\-id \fIwdid\fP"
This option allows the user to specify a target window \fIwdid\fP on the
command line rather than using the mouse to select the target window.
This is very useful in debugging X applications where the target
window is not mapped to the screen or where the use of the mouse might
be impossible or interfere with the application.
.PP
.TP 8
.B "\-name \fIwdname\fP"
This option allows the user to specify that the window named \fIwdname\fP
is the target window on the command line rather than using the mouse to
select the target window.
.PP
.TP 8
.B "\-root"
This option specifies that X's root window is the target window.
This is useful in situations where the root window is completely obscured.
.PP
.TP 8
.B "\-int"
This option specifies that all X window ids should be displayed as
integer values.  The default is to display them as hexadecimal values.
.PP
.TP 8
.B \-children
This option causes the root, parent, and children windows' ids and names of
the selected window to be displayed.
.PP
.TP 8
.B \-tree
This option is like \fB\-children\fP but displays all children recursively.
.PP
.TP 8
.B \-stats
This option causes the display of various attributes pertaining to
the location and appearance of the selected window.
Information displayed includes the location of the window,
its width and height, its depth, border width, visual id and class,
colormap id if any, map state, backing-store hint, and location of the corners.
.PP
.TP 8
.B \-bits
This option causes the display of various attributes pertaining to
the selected window's raw bits and how the selected window is to be stored.
Displayed information includes the selected window's bit gravity,
window gravity, backing-store hint, backing-planes value, backing pixel,
and whether or not the window has save-under set.
.PP
.TP 8
.B \-events
This option causes the selected window's event masks to be displayed.
Both the event mask of events wanted by some client and the event mask of
events not to propagate are displayed.
.PP
.TP 8
.B \-size
This option causes the selected window's sizing hints to be displayed.
Displayed information includes: for both the normal size hints and the
zoom size hints, the user supplied location if any; the program supplied
location if any; the user supplied size if any; the program supplied size if
any; the minimum size if any; the maximum size if any; the resize increments
if any; and the minimum and maximum aspect ratios if any.
.PP
.TP 8
.B \-wm
This option causes the selected window's window manager hints to be
displayed.  Information displayed may include whether or not the application
accepts input, what the window's icon window # and name is, where the window's
icon should go, and what the window's initial state should be.
.PP
.TP 8
.B \-shape
This option causes the selected window's window and border shape extents to
be displayed.
.TP 8
.B \-frame
This option causes window manager frames to be considered when manually
selecting windows.
.PP
.TP 8
.B \-metric
This option causes all individual height, width, and x and y positions to be
displayed in millimeters as well as number of pixels, based on what the
server thinks the resolution is. Geometry specifications that are in
\fB+x+y\fP form are not changed.
.TP 8
.B \-english
This option causes all individual height, width, and x and y positions to be
displayed in inches (and feet, yards, and miles if necessary) as well as
number of pixels. \fB\-metric\fP and \fB\-english\fP may both be enabled at the
same time.
.PP
.TP 8
.B \-all
This option is a quick way to ask for all information possible.
.PP
.TP 8
.B "\-d, \-display" \fIhost:dpy\fP
This option allows you to specify the server to connect to; see \fIX(__miscmansuffix__)\fP.
.PP
.TP 8
.B \-version
This option indicates that
.I xwininfo
should print its version information and exit.
.SH EXAMPLE
.PP
The following is a sample summary taken with no options specified:

xwininfo: Window id: 0x60000f "xterm"

  Absolute upper-left X: 2
  Absolute upper-left Y: 85
  Relative upper-left X:  0
  Relative upper-left Y:  25
  Width: 579
  Height: 316
  Depth: 8
  Visual: 0x1e
  Visual Class: PseudoColor
  Border width: 0
  Class: InputOutput
  Colormap: 0x27 (installed)
  Bit Gravity State: NorthWestGravity
  Window Gravity State: NorthWestGravity
  Backing Store State: NotUseful
  Save Under State: no
  Map State: IsViewable
  Override Redirect State: no
  Corners:  +2+85  -699+85  -699-623  +2-623
  -geometry 80x24+0+58

.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
To get the default host and display number.
.SH SEE ALSO
.IR X (__miscmansuffix__),
.IR xprop (__appmansuffix__),
.IR xdpyinfo (__appmansuffix__),
.IR xdriinfo (__appmansuffix__),
.IR xvinfo (__appmansuffix__),
.IR glxinfo (__appmansuffix__)
.SH BUGS
Using \fB\-stats \-bits\fP shows some redundant information.
.PP
The \fB-geometry\fP string displayed must make assumptions about the
window's border width and the behavior of the application and the
window manager.  As a result, the location given is not always
correct.
.SH AUTHOR
Mark Lillibridge, MIT Project Athena
