//Auto-generated by kalyptus. DO NOT EDIT.
namespace Phonon {
    using Phonon;
    using System;
    using Qyoto;
    /// <remarks> \class MediaSource mediasource.h Phonon/MediaSource
    ///  Note that all constructors of this class are implicit, so that you can simply write
    ///  <pre>
    ///  MediaObject m;
    ///  string fileName("/home/foo/bar.ogg");
    ///  QUrl url("http://www.example.com/stream.mp3");
    ///  QBuffer someBuffer;
    ///  m.setCurrentSource(fileName);
    ///  m.setCurrentSource(url);
    ///  m.setCurrentSource(someBuffer);
    ///  m.setCurrentSource(Phonon.Cd);
    ///  </pre>
    ///  \ingroup Playback
    ///  \ingroup Recording
    ///  \author Matthias Kretz <kretz@kde.org>
    ///  </remarks>        <short>   \class MediaSource mediasource.</short>
    [SmokeClass("Phonon::MediaSource")]
    public class MediaSource : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected MediaSource(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(MediaSource), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static MediaSource() {
            staticInterceptor = new SmokeInvocation(typeof(MediaSource), null);
        }
        /// <remarks>
        ///  Identifies the type of media described by the MediaSource object.
        ///  \see MediaSource.Type()
        ///          </remarks>        <short>    Identifies the type of media described by the MediaSource object.</short>
        public enum TypeOf {
            Invalid = -1,
            LocalFile = 0,
            Url = 1,
            Disc = 2,
            Stream = 3,
            Empty = 4,
        }
        // Phonon::MediaSource* MediaSource(Phonon::MediaSourcePrivate& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates an empty MediaSource.
        ///  An empty MediaSource is considered valid and can be set on a MediaObject to unload its
        ///  current media.
        ///  \see Empty
        ///          </remarks>        <short>    Creates an empty MediaSource.</short>
        public MediaSource() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource", "MediaSource()", typeof(void));
        }
        /// <remarks>
        ///  Creates a MediaSource object for a local file or a Qt resource.
        ///  \param fileName file name of a local media file or a Qt resource that was compiled in.
        ///          </remarks>        <short>    Creates a MediaSource object for a local file or a Qt resource.</short>
        public MediaSource(string fileName) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource$", "MediaSource(const QString&)", typeof(void), typeof(string), fileName);
        }
        /// <remarks>
        ///  Creates a MediaSource object for a URL.
        ///  \param url URL to a media file or stream.
        ///          </remarks>        <short>    Creates a MediaSource object for a URL.</short>
        public MediaSource(QUrl url) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource#", "MediaSource(const QUrl&)", typeof(void), typeof(QUrl), url);
        }
        /// <remarks>
        ///  Creates a MediaSource object for discs.
        ///  \param discType See \ref DiscType
        ///  \param deviceName A platform dependent device name. This can be useful if the computer
        ///  has more than one CD drive. It is recommended to use Solid to retrieve the device name in
        ///  a portable way.
        ///          </remarks>        <short>    Creates a MediaSource object for discs.</short>
        public MediaSource(Phonon.DiscType discType, string deviceName) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource$$", "MediaSource(Phonon::DiscType, const QString&)", typeof(void), typeof(Phonon.DiscType), discType, typeof(string), deviceName);
        }
        public MediaSource(Phonon.DiscType discType) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource$", "MediaSource(Phonon::DiscType)", typeof(void), typeof(Phonon.DiscType), discType);
        }
        /// <remarks>
        ///  Creates a MediaSource object for a data stream.
        ///  Your application can provide the media data by subclassing AbstractMediaStream and
        ///  passing a pointer to that object. %Phonon will never delete the <pre>stream</pre>.
        ///  \param stream The AbstractMediaStream subclass to provide the media data.
        ///  \see setAutoDelete
        ///          </remarks>        <short>    Creates a MediaSource object for a data stream.</short>
        public MediaSource(Phonon.AbstractMediaStream stream) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource#", "MediaSource(Phonon::AbstractMediaStream*)", typeof(void), typeof(Phonon.AbstractMediaStream), stream);
        }
        /// <remarks>
        ///  Creates a MediaSource object for a QIODevice.
        ///  This constructor can be very handy in the combination of QByteArray and QBuffer.
        ///  \param ioDevice An arbitrary readable QIODevice subclass. If the device is not opened
        ///  MediaSource will open it as QIODevice.ReadOnly. Sequential I/O devices are possible,
        ///  too. For those MediaObject.IsSeekable() will have to return false obviously.
        ///  \see setAutoDelete
        ///          </remarks>        <short>    Creates a MediaSource object for a QIODevice.</short>
        public MediaSource(QIODevice ioDevice) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource#", "MediaSource(QIODevice*)", typeof(void), typeof(QIODevice), ioDevice);
        }
        /// <remarks>
        ///  Constructs a copy of <pre>rhs</pre>.
        ///  This constructor is fast thanks to explicit sharing.
        ///          </remarks>        <short>    Constructs a copy of \p rhs.</short>
        public MediaSource(Phonon.MediaSource rhs) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaSource#", "MediaSource(const Phonon::MediaSource&)", typeof(void), typeof(Phonon.MediaSource), rhs);
        }
        /// <remarks>
        ///  Returns <pre>true</pre> if this MediaSource is equal to <pre>rhs</pre>; otherwise returns <pre>false</pre>.
        ///          </remarks>        <short>    Returns \p true if this MediaSource is equal to \p rhs; otherwise returns \p false.</short>
        public override bool Equals(object o) {
            if (!(o is MediaSource)) { return false; }
            return this == (MediaSource) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Tell the MediaSource to take ownership of the AbstractMediaStream or QIODevice that was
        ///  passed in the constructor.
        ///  The default setting is <pre>false</pre>, for safety. If you turn it on, you should only access
        ///  the AbstractMediaStream/QIODevice object as long as you yourself keep a MediaSource
        ///  object around. As long as you keep the MediaSource object wrapping the stream/device
        ///  the object will not get deleted.
        ///  \see autoDelete
        ///          </remarks>        <short>    Tell the MediaSource to take ownership of the AbstractMediaStream or QIODevice that was  passed in the constructor.</short>
        public void SetAutoDelete(bool enable) {
            interceptor.Invoke("setAutoDelete$", "setAutoDelete(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Returns the setting of the auto-delete option. The default is <pre>false</pre>.
        ///  \see setAutoDelete
        ///          </remarks>        <short>    Returns the setting of the auto-delete option.</short>
        public bool AutoDelete() {
            return (bool) interceptor.Invoke("autoDelete", "autoDelete() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the type of the MediaSource (depends on the constructor that was used).
        ///  \see Type
        ///          </remarks>        <short>    Returns the type of the MediaSource (depends on the constructor that was used).</short>
        public Phonon.MediaSource.TypeOf type() {
            return (Phonon.MediaSource.TypeOf) interceptor.Invoke("type", "type() const", typeof(Phonon.MediaSource.TypeOf));
        }
        /// <remarks>
        ///  Returns the file name of the MediaSource if type() == LocalFile; otherwise returns
        ///  string().
        ///          </remarks>        <short>    Returns the file name of the MediaSource if type() == LocalFile; otherwise returns  string().</short>
        public string FileName() {
            return (string) interceptor.Invoke("fileName", "fileName() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the url of the MediaSource if type() == URL or type() == LocalFile; otherwise
        ///  returns QUrl().
        ///          </remarks>        <short>    Returns the url of the MediaSource if type() == URL or type() == LocalFile; otherwise  returns QUrl().</short>
        public QUrl Url() {
            return (QUrl) interceptor.Invoke("url", "url() const", typeof(QUrl));
        }
        /// <remarks>
        ///  Returns the disc type of the MediaSource if type() == Disc; otherwise returns \ref
        ///  NoDisc.
        ///          </remarks>        <short>    Returns the disc type of the MediaSource if type() == Disc; otherwise returns \ref  NoDisc.</short>
        public Phonon.DiscType discType() {
            return (Phonon.DiscType) interceptor.Invoke("discType", "discType() const", typeof(Phonon.DiscType));
        }
        /// <remarks>
        ///  Returns the device name of the MediaSource if type() == Disc; otherwise returns
        ///  string().
        ///          </remarks>        <short>    Returns the device name of the MediaSource if type() == Disc; otherwise returns  string().</short>
        public string DeviceName() {
            return (string) interceptor.Invoke("deviceName", "deviceName() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the media stream of the MediaSource if type() == Stream; otherwise returns 0.
        ///  QIODevices are handled as streams, too.
        ///          </remarks>        <short>    Returns the media stream of the MediaSource if type() == Stream; otherwise returns 0.</short>
        public Phonon.AbstractMediaStream Stream() {
            return (Phonon.AbstractMediaStream) interceptor.Invoke("stream", "stream() const", typeof(Phonon.AbstractMediaStream));
        }
        ~MediaSource() {
            interceptor.Invoke("~MediaSource", "~MediaSource()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~MediaSource", "~MediaSource()", typeof(void));
        }
        public static bool operator==(MediaSource lhs, Phonon.MediaSource rhs) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const Phonon::MediaSource&) const", typeof(bool), typeof(MediaSource), lhs, typeof(Phonon.MediaSource), rhs);
        }
        public static bool operator!=(MediaSource lhs, Phonon.MediaSource rhs) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const Phonon::MediaSource&) const", typeof(bool), typeof(MediaSource), lhs, typeof(Phonon.MediaSource), rhs);
        }
    }
}
