/*
 * Copyright (C) 2016 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:  GPL-2.0+
 */

#ifndef __MX7D_RDC_H__
#define __MX7D_RDC_H__

#define RDC_SEMA_PROC_ID 2  /* The processor ID for main CPU */

enum {
	RDC_PER_GPIO1 = 0,
	RDC_PER_GPIO2,
	RDC_PER_GPIO3,
	RDC_PER_GPIO4,
	RDC_PER_GPIO5,
	RDC_PER_GPIO6,
	RDC_PER_GPIO7,
	RDC_PER_IOMUXC_LPSR_GPR,
	RDC_PER_WDOG1,
	RDC_PER_WDOG2,
	RDC_PER_WDOG3,
	RDC_PER_WDOG4,
	RDC_PER_IOMUXC_LPSR,
	RDC_PER_GPT1,
	RDC_PER_GPT2,
	RDC_PER_GPT3,
	RDC_PER_GPT4,
	RDC_PER_ROMCP,
	RDC_PER_KPP,
	RDC_PER_IOMUXC,
	RDC_PER_IOMUXCGPR,
	RDC_PER_OCOTP,
	RDC_PER_ANATOP_DIG,
	RDC_PER_SNVS_HP,
	RDC_PER_CCM,
	RDC_PER_SRC,
	RDC_PER_GPC,
	RDC_PER_SEMA1,
	RDC_PER_SEMA2,
	RDC_PER_RDC,
	RDC_PER_CSU,
	RDC_PER_RESERVED1,
	RDC_PER_RESERVED2,
	RDC_PER_ADC1,
	RDC_PER_ADC2,
	RDC_PER_ECSPI4,
	RDC_PER_FLEX_TIMER1,
	RDC_PER_FLEX_TIMER2,
	RDC_PER_PWM1,
	RDC_PER_PWM2,
	RDC_PER_PWM3,
	RDC_PER_PWM4,
	RDC_PER_SYSTEM_COUNTER_READ,
	RDC_PER_SYSTEM_COUNTER_COMPARE,
	RDC_PER_SYSTEM_COUNTER_CONTROL,
	RDC_PER_PCIE_PHY,
	RDC_PER_RESERVED3,
	RDC_PER_EPDC,
	RDC_PER_PXP,
	RDC_PER_CSI,
	RDC_PER_RESERVED4,
	RDC_PER_LCDIF,
	RDC_PER_RESERVED5,
	RDC_PER_MIPI_CSI,
	RDC_PER_MIPI_DSI,
	RDC_PER_RESERVED6,
	RDC_PER_TZASC,
	RDC_PER_DDR_PHY,
	RDC_PER_DDRC,
	RDC_PER_RESERVED7,
	RDC_PER_PERFMON1,
	RDC_PER_PERFMON2,
	RDC_PER_AXI_DEBUG_MON,
	RDC_PER_QOSC,
	RDC_PER_FLEXCAN1,
	RDC_PER_FLEXCAN2,
	RDC_PER_I2C1,
	RDC_PER_I2C2,
	RDC_PER_I2C3,
	RDC_PER_I2C4,
	RDC_PER_UART4,
	RDC_PER_UART5,
	RDC_PER_UART6,
	RDC_PER_UART7,
	RDC_PER_MU_A,
	RDC_PER_MU_B,
	RDC_PER_SEMAPHORE_HS,
	RDC_PER_USB_PL301,
	RDC_PER_RESERVED8,
	RDC_PER_RESERVED9,
	RDC_PER_RESERVED10,
	RDC_PER_USB1,
	RDC_PER_USB2,
	RDC_PER_USB3,
	RDC_PER_USDHC1,
	RDC_PER_USDHC2,
	RDC_PER_USDHC3,
	RDC_PER_RESERVED11,
	RDC_PER_RESERVED12,
	RDC_PER_SIM1,
	RDC_PER_SIM2,
	RDC_PER_QSPI,
	RDC_PER_WEIM,
	RDC_PER_SDMA,
	RDC_PER_ENET1,
	RDC_PER_ENET2,
	RDC_PER_RESERVED13,
	RDC_PER_RESERVED14,
	RDC_PER_ECSPI1,
	RDC_PER_ECSPI2,
	RDC_PER_ECSPI3,
	RDC_PER_RESERVED15,
	RDC_PER_UART1,
	RDC_PER_UART2,
	RDC_PER_UART3,
	RDC_PER_RESERVED16,
	RDC_PER_SAI1,
	RDC_PER_SAI2,
	RDC_PER_SAI3,
	RDC_PER_RESERVED17,
	RDC_PER_RESERVED18,
	RDC_PER_SPBA,
	RDC_PER_DAP,
	RDC_PER_RESERVED19,
	RDC_PER_RESERVED20,
	RDC_PER_RESERVED21,
	RDC_PER_CAAM,
	RDC_PER_RESERVED22,
};

enum {
	RDC_MA_A7 = 0,
	RDC_MA_M4,
	RDC_MA_PCIE,
	RDC_MA_CSI,
	RDC_MA_EPDC,
	RDC_MA_LCDIF,
	RDC_MA_DISPLAY_PORT,
	RDC_MA_PXP,
	RDC_MA_CORESIGHT,
	RDC_MA_DAP,
	RDC_MA_CAAM,
	RDC_MA_SDMA_PERI,
	RDC_MA_SDMA_BURST,
	RDC_MA_APBHDMA,
	RDC_MA_RAWNAND,
	RDC_MA_USDHC1,
	RDC_MA_USDHC2,
	RDC_MA_USDHC3,
	RDC_MA_NC1,
	RDC_MA_USB,
	RDC_MA_NC2,
	RDC_MA_TEST,
	RDC_MA_ENET1_TX,
	RDC_MA_ENET1_RX,
	RDC_MA_ENET2_TX,
	RDC_MA_ENET2_RX,
	RDC_MA_SDMA,
};

#endif	/* __MX7D_RDC_H__*/
