#ifndef __CLOCK_CONFIG_H__
#define __CLOCK_CONFIG_H__

typedef unsigned long               UINT32;
typedef unsigned short              UINT16;
typedef long                        INT32;
typedef short                       INT16;
typedef unsigned char               UINT8;
typedef char                        INT8;

#define CLOCK_VER_MAJOR		2
#define CLOCK_VER_MINOR		0

struct clock_config {
	/* Header */
	UINT32 MAGIC;
	UINT16 VERSION_MAJOR;
	UINT16 VERSION_MINOR;
	/* PLL Freqs (MHz) */
	UINT32 PLL_FREQ_CPU;	/* 05, 06 */
	UINT32 PLL_FREQ_BUS;	/* 25, 26 */
	UINT32 PLL_FREQ_MEM;	/* 65, 66 */
	UINT32 PLL_FREQ_USB;	/* 85, 86 */
	/* DDR Flags */
	UINT16 DDR_CAL;
	UINT16 DDR_FLAGS;
	UINT32 DDR_PARA;
	/* AP sysctrl */
	UINT16 CLK_CPU;
	UINT16 CLK_AXI;
	UINT16 CLK_GCG;
	UINT16 CLK_AHB1;
	UINT16 CLK_APB1;
	UINT16 CLK_APB2;
	UINT16 CLK_MEM;
	UINT16 CLK_GPU;
	UINT16 CLK_VPU;
	UINT16 CLK_VOC;
	UINT16 CLK_SFLSH;
	UINT16 RESERVE;
	/* DDR timings */
	UINT16 DDR_CHAN_1_VALID;
	UINT16 DDR_TIMING_100H;
	UINT16 DDR_TIMING_101H;
	UINT16 DDR_TIMING_102H;
	UINT16 DDR_TIMING_103H;
	UINT16 DDR_TIMING_104H;
	UINT16 DDR_TIMING_105H;
	UINT16 DDR_TIMING_106H;
	UINT16 DDR_TIMING_107H;
	UINT16 DDR_TIMING_108H;
	UINT16 DDR_TIMING_109H;
	UINT16 DDR_TIMING_10AH;
	UINT16 DDR_TIMING_10BH;
	UINT16 DDR_TIMING_10CH;
	UINT16 DDR_TIMING_10DH;
	UINT16 DDR_TIMING_10EH;
	UINT16 DDR_TIMING_10FH;

	UINT16 DDR_CHAN_2_VALID;
	UINT16 DDR_TIMING_120H;
	UINT16 DDR_TIMING_121H;
	UINT16 DDR_TIMING_122H;
	UINT16 DDR_TIMING_123H;
	UINT16 DDR_TIMING_124H;
	UINT16 DDR_TIMING_125H;
	UINT16 DDR_TIMING_126H;
	UINT16 DDR_TIMING_127H;
	UINT16 DDR_TIMING_128H;
	UINT16 DDR_TIMING_129H;
	UINT16 DDR_TIMING_12AH;
	UINT16 DDR_TIMING_12BH;
	UINT16 DDR_TIMING_12CH;
	UINT16 DDR_TIMING_12DH;
	UINT16 DDR_TIMING_12EH;
	UINT16 DDR_TIMING_12FH;

	UINT16 DDR_CHAN_3_VALID;
	UINT16 DDR_TIMING_140H;
	UINT16 DDR_TIMING_141H;
	UINT16 DDR_TIMING_142H;
	UINT16 DDR_TIMING_143H;
	UINT16 DDR_TIMING_144H;
	UINT16 DDR_TIMING_145H;
	UINT16 DDR_TIMING_146H;
	UINT16 DDR_TIMING_147H;
	UINT16 DDR_TIMING_148H;
	UINT16 DDR_TIMING_149H;
	UINT16 DDR_TIMING_14AH;
	UINT16 DDR_TIMING_14BH;
	UINT16 DDR_TIMING_14CH;
	UINT16 DDR_TIMING_14DH;
	UINT16 DDR_TIMING_14EH;
	UINT16 DDR_TIMING_14FH;

	UINT16 DDR_CHAN_4_VALID;
	UINT16 DDR_TIMING_160H;
	UINT16 DDR_TIMING_161H;
	UINT16 DDR_TIMING_162H;
	UINT16 DDR_TIMING_163H;
	UINT16 DDR_TIMING_164H;
	UINT16 DDR_TIMING_165H;
	UINT16 DDR_TIMING_166H;
	UINT16 DDR_TIMING_167H;
	UINT16 DDR_TIMING_168H;
	UINT16 DDR_TIMING_169H;
	UINT16 DDR_TIMING_16AH;
	UINT16 DDR_TIMING_16BH;
	UINT16 DDR_TIMING_16CH;
	UINT16 DDR_TIMING_16DH;
	UINT16 DDR_TIMING_16EH;
	UINT16 DDR_TIMING_16FH;

	UINT16 DDR_TIMING_180H;
	UINT16 DDR_TIMING_181H;
	UINT16 DDR_TIMING_182H;
	UINT16 DDR_TIMING_183H;
	UINT16 DDR_TIMING_184H;
	UINT16 DDR_TIMING_185H;
	UINT16 DDR_TIMING_186H;
	UINT16 DDR_TIMING_187H;
	UINT16 DDR_TIMING_188H;
	UINT16 DDR_TIMING_189H;
	UINT16 DDR_TIMING_18AH;
	UINT16 DDR_TIMING_18BH;
	UINT16 DDR_TIMING_18CH;
	UINT16 DDR_TIMING_069H;
};

const struct clock_config *get_default_clock_config(void);

#endif
