/**
 * RdTk: Remote Desktop Toolkit
 *
 * Copyright 2014 Marc-Andre Moreau <marcandre.moreau@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rdtk_resources.h"

/* Nine Patches */

static BYTE btn_default_normal_9_png[] = {
	0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48, 0x44, 0x52,
	0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x32, 0x08, 0x06, 0x00, 0x00, 0x00, 0x42, 0xb5, 0xcb,
	0x95, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x89, 0x00, 0x00, 0x0b,
	0x89, 0x01, 0x37, 0xc9, 0xcb, 0xad, 0x00, 0x00, 0x02, 0x5d, 0x49, 0x44, 0x41, 0x54, 0x58, 0x85,
	0xed, 0x58, 0x41, 0xae, 0xd3, 0x40, 0x0c, 0x7d, 0x9e, 0x52, 0x84, 0x10, 0x69, 0xd5, 0x05, 0x57,
	0xe8, 0x8e, 0x4d, 0x51, 0x57, 0xdc, 0x80, 0x43, 0xf4, 0x08, 0x1c, 0xaa, 0x87, 0xe0, 0x02, 0x88,
	0x13, 0xb0, 0xeb, 0x0d, 0x10, 0x8b, 0x4a, 0x5f, 0x15, 0x42, 0xe4, 0x63, 0xb3, 0xa0, 0x53, 0x39,
	0x8e, 0x3d, 0x33, 0x49, 0xbf, 0xf4, 0x37, 0x58, 0x8a, 0x32, 0x3f, 0x99, 0xf1, 0xf3, 0x1b, 0x3f,
	0x7b, 0xd2, 0x4f, 0x22, 0x02, 0x22, 0x82, 0x63, 0xe2, 0x3d, 0x6c, 0xb0, 0x91, 0x33, 0x91, 0xb9,
	0xae, 0x9e, 0x02, 0x1d, 0xc0, 0xeb, 0xe3, 0xf1, 0xf8, 0x71, 0xbb, 0xdd, 0x7e, 0x00, 0x40, 0x44,
	0x74, 0x63, 0x6c, 0x99, 0xe7, 0x48, 0x45, 0x24, 0x8f, 0xe5, 0x74, 0x3a, 0x7d, 0x3d, 0x1c, 0x0e,
	0x9f, 0x01, 0xfc, 0xd4, 0x73, 0x5f, 0x38, 0x40, 0xdd, 0x7e, 0xbf, 0xff, 0xb4, 0xd9, 0x6c, 0x76,
	0x44, 0x84, 0x94, 0x52, 0x13, 0x10, 0x33, 0x43, 0x44, 0xb0, 0x5e, 0xaf, 0xdf, 0x03, 0xf8, 0xd2,
	0x02, 0xb4, 0xea, 0xba, 0x6e, 0xd7, 0xf7, 0xbd, 0xa4, 0x94, 0x6e, 0x40, 0x16, 0xcc, 0xb2, 0x61,
	0x66, 0x30, 0x33, 0xba, 0xae, 0xdb, 0x01, 0x58, 0x01, 0xf8, 0xae, 0x9d, 0x26, 0x8c, 0x93, 0xbe,
	0x64, 0xe6, 0x41, 0xd4, 0x3a, 0x99, 0xb5, 0xbf, 0xaf, 0x6b, 0x97, 0x36, 0x7a, 0x8f, 0xd1, 0x20,
	0xda, 0xcc, 0x42, 0x8f, 0xf5, 0x3b, 0x0d, 0x66, 0x41, 0x2d, 0x23, 0x6b, 0xe4, 0x2d, 0x72, 0x12,
	0x1f, 0x82, 0xc1, 0x11, 0x99, 0x07, 0x14, 0x32, 0x9c, 0xfa, 0x4e, 0x4f, 0xf3, 0xb6, 0x6e, 0x10,
	0x4d, 0x0d, 0x24, 0xd8, 0xae, 0x36, 0x46, 0x59, 0xaa, 0xf9, 0x1e, 0x6d, 0x65, 0x74, 0x79, 0xe6,
	0x32, 0xca, 0x0b, 0xb4, 0x08, 0x22, 0x86, 0x01, 0xd0, 0x88, 0x91, 0xab, 0x3a, 0xed, 0x00, 0x88,
	0x55, 0x67, 0x05, 0x32, 0x8b, 0x91, 0x8e, 0x9e, 0x99, 0x5d, 0x59, 0xe7, 0x77, 0x16, 0xcc, 0x63,
	0x54, 0x55, 0x5d, 0x8b, 0xe2, 0x5a, 0x94, 0x57, 0xcc, 0x11, 0x00, 0xa4, 0x94, 0x06, 0x0e, 0x4b,
	0x2d, 0x68, 0x32, 0xa3, 0x28, 0xe1, 0x76, 0x6c, 0xe7, 0x96, 0x98, 0x85, 0x75, 0xa4, 0x23, 0xd5,
	0x2c, 0x22, 0x46, 0x26, 0x80, 0x76, 0xd5, 0x45, 0x36, 0xf7, 0xb4, 0x2c, 0x32, 0xca, 0x6c, 0xf4,
	0x65, 0x41, 0xed, 0x75, 0x9d, 0xd3, 0x94, 0x23, 0x8a, 0xa2, 0x8e, 0x1a, 0x6a, 0x14, 0x6c, 0x8d,
	0xd1, 0x28, 0xc1, 0x59, 0x79, 0x5e, 0x7e, 0x74, 0x00, 0x93, 0x0b, 0x36, 0x2f, 0xce, 0x8e, 0xb5,
	0x20, 0xac, 0xd9, 0x43, 0x32, 0xda, 0xba, 0x62, 0x1d, 0x79, 0x2c, 0x22, 0x33, 0x2c, 0xa7, 0xd5,
	0x51, 0xa9, 0xa1, 0x96, 0xba, 0xb9, 0x67, 0xc5, 0x5e, 0x07, 0x60, 0xa0, 0xbc, 0x08, 0xbc, 0xa5,
	0x8e, 0x5c, 0xd5, 0xd5, 0xa2, 0xaf, 0x3d, 0xf7, 0x80, 0x8a, 0x05, 0x5b, 0xcb, 0x91, 0xc7, 0x2e,
	0x12, 0x8d, 0xbb, 0x75, 0x5a, 0x49, 0x79, 0xec, 0x39, 0x28, 0xc8, 0xfb, 0xbe, 0x16, 0xd4, 0xc2,
	0x2a, 0xb2, 0xb0, 0x8e, 0x98, 0x19, 0x29, 0xfd, 0x4b, 0xa1, 0x77, 0xa4, 0x5b, 0xb0, 0x5a, 0x0b,
	0x6a, 0xfa, 0x80, 0xb4, 0x7b, 0xaf, 0x81, 0xa3, 0xe3, 0xc3, 0x5a, 0x73, 0xaf, 0x6b, 0x3d, 0x77,
	0x9e, 0xe4, 0x28, 0x8f, 0x24, 0x7f, 0xf7, 0x51, 0x9e, 0x73, 0x64, 0xc7, 0x36, 0x10, 0xe7, 0x23,
	0x66, 0x7e, 0x1d, 0x79, 0x8d, 0xb5, 0x75, 0x3b, 0x43, 0x46, 0x76, 0x71, 0xad, 0xb1, 0x3a, 0x42,
	0x78, 0xb6, 0x8f, 0xfc, 0xb8, 0xd7, 0x59, 0x47, 0x25, 0x25, 0x3a, 0xef, 0x2c, 0x23, 0xba, 0xbb,
	0x33, 0xb4, 0x5a, 0x53, 0x1d, 0xcd, 0xd8, 0x3a, 0x57, 0x75, 0xa3, 0x87, 0xcc, 0x8c, 0xbe, 0xef,
	0x5d, 0x27, 0x25, 0x61, 0x10, 0x11, 0x96, 0xcb, 0xd1, 0xcf, 0xd7, 0x1b, 0x90, 0xb5, 0xc7, 0xf3,
	0xf9, 0xfc, 0xb0, 0x58, 0x2c, 0x56, 0x53, 0xb7, 0x8a, 0x88, 0x70, 0xb9, 0x5c, 0x1e, 0x00, 0x3c,
	0x8e, 0xde, 0x39, 0xf3, 0xdf, 0x02, 0x78, 0x77, 0xbd, 0x2f, 0x26, 0x21, 0x01, 0x7f, 0x00, 0xfc,
	0x00, 0xf0, 0xed, 0x7a, 0x2f, 0x02, 0xbd, 0x04, 0xf0, 0x06, 0xc0, 0x2b, 0x34, 0xca, 0x5f, 0x19,
	0x03, 0xf8, 0x05, 0xe0, 0x02, 0xe0, 0xf7, 0xc4, 0xb5, 0xff, 0xed, 0xb9, 0x6d, 0x46, 0xb5, 0x0b,
	0x26, 0xfe, 0xd3, 0x50, 0x44, 0xf0, 0x17, 0xa0, 0xb1, 0xe0, 0x73, 0xc3, 0xe6, 0x24, 0xdb, 0x00,
	0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static int btn_default_normal_9_png_len = 683;

static BYTE textfield_default_9_png[] = {
	0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48, 0x44, 0x52,
	0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x32, 0x08, 0x06, 0x00, 0x00, 0x00, 0x46, 0x40, 0x1b,
	0xa8, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x89, 0x00, 0x00, 0x0b,
	0x89, 0x01, 0x37, 0xc9, 0xcb, 0xad, 0x00, 0x00, 0x01, 0x53, 0x49, 0x44, 0x41, 0x54, 0x58, 0x85,
	0xed, 0x98, 0x4b, 0x6e, 0x83, 0x30, 0x10, 0x86, 0x67, 0xc6, 0xa8, 0x8a, 0x58, 0xb1, 0x45, 0xa2,
	0x9b, 0x8a, 0x83, 0xf4, 0x28, 0xbd, 0x03, 0xea, 0x71, 0xb8, 0x0b, 0xf7, 0x60, 0x55, 0xa9, 0x97,
	0x60, 0x51, 0x4f, 0x17, 0xcd, 0x44, 0x7e, 0x76, 0x30, 0x09, 0x52, 0xa9, 0xf8, 0x25, 0x0b, 0x3f,
	0x26, 0xf3, 0xf9, 0xb7, 0xad, 0x10, 0x07, 0x98, 0x19, 0x0a, 0x54, 0x16, 0xcc, 0x0c, 0x18, 0xf4,
	0x3d, 0x03, 0x44, 0x7d, 0xa5, 0xb2, 0x00, 0xf0, 0x29, 0x8d, 0xca, 0x1d, 0x99, 0xa6, 0xe9, 0xbd,
	0xef, 0xfb, 0x37, 0x71, 0x85, 0xa8, 0xb3, 0xdc, 0x15, 0xa8, 0xaa, 0x0a, 0xda, 0xb6, 0x7d, 0xcd,
	0x02, 0x2e, 0x97, 0x0b, 0xd7, 0x75, 0xfd, 0x63, 0xcd, 0x49, 0x9e, 0x02, 0xb9, 0x89, 0x83, 0x09,
	0x7d, 0xb9, 0x71, 0x1e, 0xc0, 0x18, 0xc3, 0xc6, 0x18, 0x40, 0xc4, 0x5b, 0x59, 0xeb, 0x80, 0x99,
	0xa5, 0x6e, 0xb3, 0x00, 0x22, 0x62, 0x22, 0x8a, 0x00, 0x39, 0x50, 0x98, 0xfc, 0xda, 0xf6, 0x0e,
	0x82, 0x07, 0x90, 0xa4, 0x2e, 0x24, 0x07, 0x90, 0x65, 0x94, 0xa7, 0xb5, 0x16, 0x52, 0x27, 0x32,
	0x02, 0x48, 0x72, 0x79, 0x6a, 0x0e, 0xa4, 0x10, 0x51, 0x32, 0x46, 0x75, 0xb0, 0x66, 0x1f, 0xc4,
	0x41, 0x22, 0x96, 0x93, 0x00, 0xb7, 0x9e, 0x83, 0xb8, 0x27, 0x47, 0x92, 0xa7, 0xe2, 0x92, 0xbe,
	0xb4, 0xe4, 0xa9, 0xc9, 0xe4, 0x54, 0x85, 0x1d, 0xa9, 0xe4, 0xbf, 0x6d, 0x72, 0x0a, 0xa8, 0x3a,
	0x08, 0x81, 0x25, 0xfd, 0xc5, 0x80, 0x7b, 0x75, 0x38, 0x40, 0xb4, 0x6e, 0x87, 0x73, 0xa0, 0x02,
	0xee, 0x7d, 0xd9, 0xa8, 0x80, 0x87, 0xeb, 0x7f, 0x00, 0x8a, 0x7e, 0x29, 0x6c, 0x01, 0x3c, 0x7c,
	0x63, 0x43, 0xc0, 0xae, 0xf2, 0x00, 0x6b, 0xbf, 0xc0, 0x36, 0x03, 0xf6, 0xd0, 0x09, 0x38, 0x01,
	0x27, 0xe0, 0x04, 0xfc, 0x01, 0x00, 0xaa, 0x80, 0xc2, 0x6b, 0x6e, 0xa4, 0xcd, 0x0e, 0xd6, 0x82,
	0xa3, 0xfb, 0x41, 0x70, 0xdf, 0x52, 0x21, 0x5a, 0xac, 0xe7, 0x80, 0x88, 0x10, 0x11, 0x09, 0x11,
	0xe9, 0x3a, 0xe6, 0xd5, 0x53, 0x45, 0xc6, 0xe5, 0x73, 0x4d, 0xd3, 0x78, 0x6f, 0x2d, 0xaf, 0x31,
	0x0c, 0xc3, 0x4b, 0xd7, 0x75, 0x4f, 0xea, 0xd4, 0x33, 0x5a, 0x96, 0xc5, 0xce, 0xf3, 0xbc, 0x8c,
	0xe3, 0xf8, 0xb1, 0x35, 0xc7, 0xa9, 0x23, 0x6a, 0xef, 0x3f, 0xa4, 0xbe, 0x01, 0x9f, 0x91, 0x87,
	0x71, 0x3a, 0x69, 0xd1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
	0x82
};
static int textfield_default_9_png_len = 417;

/* Fonts */

static BYTE source_serif_pro_regular_12_png[] = {
	0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48, 0x44, 0x52,
	0x00, 0x00, 0x02, 0xe7, 0x00, 0x00, 0x00, 0x11, 0x08, 0x06, 0x00, 0x00, 0x00, 0x7e, 0x53, 0x02,
	0xe5, 0x00, 0x00, 0x00, 0x04, 0x73, 0x42, 0x49, 0x54, 0x08, 0x08, 0x08, 0x08, 0x7c, 0x08, 0x64,
	0x88, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0e, 0xc4, 0x00, 0x00, 0x0e,
	0xc4, 0x01, 0x95, 0x2b, 0x0e, 0x1b, 0x00, 0x00, 0x20, 0x00, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c,
	0xed, 0x9d, 0x77, 0xd8, 0x55, 0xc5, 0xb5, 0xc6, 0x7f, 0x14, 0x15, 0xb1, 0xa2, 0x62, 0x12, 0x8d,
	0x0d, 0x1b, 0x26, 0xf6, 0x86, 0x1a, 0x13, 0x10, 0x7b, 0xb0, 0xc4, 0x28, 0x18, 0x4b, 0x14, 0x31,
	0x17, 0x15, 0x8d, 0xc6, 0x42, 0xbc, 0x26, 0x16, 0xbc, 0x46, 0x63, 0xbc, 0x26, 0xd8, 0x35, 0x09,
	0x0a, 0x51, 0xb1, 0x44, 0x63, 0x8f, 0x1d, 0xf9, 0x00, 0x1b, 0x62, 0x45, 0xc4, 0xd8, 0x51, 0x11,
	0x8d, 0x8a, 0x60, 0x45, 0x41, 0x7c, 0xef, 0x1f, 0xef, 0xcc, 0xdd, 0x73, 0xf6, 0xd9, 0xfb, 0x9c,
	0xf3, 0x7d, 0x7c, 0x60, 0xd4, 0xef, 0x7d, 0x9e, 0x79, 0xce, 0xd9, 0xb3, 0x67, 0x66, 0xcf, 0x9e,
	0xb2, 0x66, 0xcd, 0x5a, 0x6b, 0xd6, 0x6e, 0x27, 0x89, 0xaf, 0x19, 0x3a, 0x01, 0x5f, 0x00, 0x9f,
	0x87, 0xdf, 0x36, 0xb4, 0xa1, 0x0d, 0x6d, 0x68, 0x43, 0x1b, 0xda, 0xd0, 0x86, 0x79, 0x45, 0x07,
	0x60, 0x71, 0xe0, 0xfd, 0x2f, 0xbb, 0x22, 0x6d, 0xf8, 0x7a, 0xa3, 0x7d, 0xf2, 0xff, 0x5f, 0xc0,
	0x7e, 0x05, 0xff, 0x9b, 0x83, 0x29, 0xf3, 0x5a, 0xa1, 0x66, 0x22, 0x5f, 0xcf, 0x8d, 0x80, 0xbf,
	0x01, 0x9b, 0x00, 0x7f, 0xa9, 0x91, 0x6f, 0x10, 0xf0, 0xe6, 0x7c, 0xac, 0x57, 0x11, 0x9e, 0x03,
	0x56, 0x58, 0xc0, 0xcf, 0x9c, 0x1f, 0xe8, 0x04, 0x74, 0xfe, 0xb2, 0x2b, 0x31, 0x1f, 0xd0, 0x11,
	0xf8, 0x01, 0xb0, 0xd4, 0x97, 0x5d, 0x91, 0x36, 0xb4, 0xa1, 0x0d, 0x5f, 0x6b, 0x08, 0x78, 0x1b,
	0x18, 0x8d, 0xd7, 0xaa, 0x27, 0x81, 0x55, 0x0a, 0xd2, 0x9d, 0x0d, 0x3c, 0x16, 0xd2, 0x0f, 0x99,
	0x87, 0xe7, 0xfd, 0x1e, 0xb8, 0xb9, 0x99, 0x79, 0x96, 0x00, 0x0e, 0x00, 0xae, 0x06, 0x0e, 0x9b,
	0x87, 0x67, 0x47, 0x6c, 0x0a, 0xfc, 0x0f, 0xf0, 0x40, 0x0b, 0xf2, 0xfe, 0x04, 0x78, 0x0a, 0x98,
	0x0d, 0x34, 0x01, 0x0b, 0x35, 0x90, 0x27, 0xd6, 0xff, 0x1a, 0xea, 0xd7, 0x7f, 0x0c, 0x5e, 0x9f,
	0x17, 0xad, 0x11, 0xbf, 0x06, 0x70, 0x2d, 0xf0, 0x0e, 0x70, 0x74, 0x9d, 0xe7, 0xfe, 0x1c, 0xb8,
	0xaa, 0x81, 0xe7, 0xb6, 0xe1, 0xeb, 0x8b, 0x01, 0x78, 0x5e, 0x5f, 0x40, 0x36, 0x7f, 0xcf, 0x05,
	0x5e, 0x00, 0xfe, 0x8e, 0x37, 0x78, 0x35, 0xd1, 0x1e, 0x78, 0x06, 0xd8, 0x07, 0x58, 0x0d, 0xf8,
	0x6e, 0x88, 0x4f, 0xff, 0x03, 0xac, 0x09, 0x9c, 0x11, 0xfe, 0x6f, 0x06, 0xfc, 0x36, 0x57, 0xce,
	0x2a, 0xc0, 0xaf, 0x81, 0x2e, 0x98, 0xf1, 0xed, 0x14, 0xe2, 0x57, 0x06, 0xc6, 0x03, 0x93, 0x0a,
	0xf2, 0xc4, 0xe7, 0x9f, 0x96, 0x8b, 0x5b, 0x1f, 0xb8, 0x2f, 0xe4, 0x9b, 0x02, 0x5c, 0x49, 0xf5,
	0xa4, 0x89, 0x48, 0xeb, 0xb9, 0x3c, 0x70, 0x13, 0x6e, 0x84, 0x87, 0x42, 0x1d, 0x7e, 0x93, 0x4b,
	0xbf, 0x74, 0xf8, 0x9d, 0x01, 0xbc, 0x1b, 0xfe, 0x77, 0x02, 0x16, 0x29, 0x29, 0xbf, 0xb5, 0xb0,
	0x0e, 0xde, 0x69, 0x4f, 0x0b, 0xd7, 0xbb, 0x00, 0x13, 0xf0, 0x3b, 0x5e, 0x01, 0x2c, 0x96, 0xa4,
	0x6d, 0x0f, 0x6c, 0x0c, 0x1c, 0x1b, 0xd2, 0xa5, 0x58, 0x16, 0xf8, 0x2b, 0x70, 0x1b, 0xf0, 0x3a,
	0x70, 0x07, 0xd9, 0xfb, 0xb7, 0xc3, 0x6d, 0x7c, 0x0f, 0xf0, 0x08, 0x30, 0x11, 0xd8, 0xab, 0xa4,
	0x3e, 0x07, 0xe3, 0x01, 0x13, 0xf1, 0x12, 0x26, 0x7a, 0x69, 0x48, 0xd1, 0x01, 0xf8, 0x45, 0x78,
	0xde, 0x9f, 0xa8, 0x1c, 0x1b, 0x65, 0xe8, 0x1f, 0xea, 0xf0, 0x28, 0x26, 0x72, 0xab, 0x27, 0xf7,
	0x06, 0xe1, 0x81, 0x3b, 0x36, 0xa4, 0xe9, 0xd7, 0x40, 0x79, 0xf3, 0x1b, 0x83, 0x80, 0xfb, 0x81,
	0xb7, 0x80, 0xa1, 0x64, 0x63, 0x38, 0xc5, 0x32, 0xc0, 0xa9, 0xb8, 0xde, 0xf7, 0xe1, 0x85, 0xe6,
	0x69, 0xe0, 0x2c, 0x3c, 0xfe, 0xca, 0xb0, 0x3b, 0xf0, 0x11, 0xc5, 0xe3, 0xb8, 0x2f, 0xf0, 0x30,
	0xee, 0x8f, 0x29, 0xb8, 0xad, 0x26, 0x85, 0xb8, 0x1d, 0x73, 0x69, 0x37, 0xc6, 0x8b, 0xcd, 0xf8,
	0x24, 0xdd, 0x4d, 0x78, 0x81, 0xef, 0x1b, 0xea, 0x13, 0xcb, 0x69, 0x02, 0x1e, 0xc4, 0xf3, 0x7b,
	0x28, 0xf0, 0xad, 0xa4, 0x9c, 0xdd, 0x70, 0x5f, 0xa6, 0x69, 0x63, 0x78, 0x1d, 0xcf, 0xa1, 0x5a,
	0x69, 0xde, 0xa2, 0x92, 0x59, 0x58, 0x07, 0xb8, 0x34, 0xd4, 0x6b, 0x34, 0xf0, 0x04, 0x66, 0x2a,
	0x62, 0x9a, 0x7d, 0x70, 0x7f, 0x0b, 0xcf, 0xbb, 0x3b, 0x92, 0xbc, 0xb7, 0x85, 0x38, 0x85, 0x34,
	0xfb, 0x00, 0x7b, 0xe3, 0x71, 0x13, 0x99, 0x98, 0x7b, 0x93, 0xf4, 0xa7, 0xe0, 0xb9, 0xa3, 0x50,
	0x8f, 0x7b, 0xf0, 0x9c, 0xc9, 0xe7, 0x19, 0x85, 0x17, 0xf1, 0x83, 0x80, 0xd7, 0xf0, 0x9c, 0xbf,
	0x1f, 0x58, 0xb1, 0x20, 0xed, 0x5d, 0x54, 0xa3, 0x77, 0x78, 0x9f, 0xb9, 0xc0, 0xad, 0x05, 0xf7,
	0x23, 0x8e, 0x0c, 0xe5, 0x3c, 0x0a, 0xec, 0x1b, 0xda, 0xe2, 0xa1, 0x10, 0x77, 0x55, 0x2e, 0xed,
	0x51, 0x98, 0xc9, 0xf8, 0x3c, 0xb4, 0xcf, 0xa6, 0xc9, 0xbd, 0x7e, 0xb8, 0x6d, 0xc7, 0x84, 0xe7,
	0x0e, 0x03, 0x56, 0x4a, 0xee, 0x17, 0x8d, 0x93, 0xc7, 0xc3, 0xb3, 0xf6, 0xcf, 0x3d, 0x67, 0xe7,
	0xf0, 0xfe, 0xb1, 0xac, 0x0b, 0x80, 0xae, 0xb9, 0xb2, 0xf2, 0x63, 0xe5, 0x7e, 0xdc, 0x6f, 0x43,
	0x80, 0x85, 0x93, 0xb4, 0xed, 0x31, 0x6d, 0x7f, 0x3c, 0xa4, 0x79, 0x0a, 0x33, 0x29, 0xdd, 0x42,
	0xda, 0xb7, 0xc8, 0xc6, 0x45, 0x5a, 0x5e, 0xac, 0xeb, 0x0f, 0x42, 0x3d, 0x62, 0x7f, 0xdd, 0x15,
	0xca, 0x6c, 0x1f, 0xea, 0x38, 0x3d, 0xdc, 0x7b, 0x08, 0xd8, 0x0e, 0x38, 0x27, 0xa4, 0x13, 0x66,
	0x8c, 0x8e, 0x09, 0xf5, 0x58, 0x2a, 0xd4, 0xe1, 0x23, 0xe0, 0x45, 0xe0, 0x57, 0x21, 0xed, 0xd4,
	0x90, 0xf6, 0x29, 0xe0, 0x50, 0x2c, 0x38, 0x18, 0x85, 0xfb, 0xf5, 0x43, 0x60, 0x1c, 0x5e, 0x53,
	0xb6, 0xc7, 0xe3, 0xe6, 0xb3, 0xd0, 0x26, 0xeb, 0x02, 0x27, 0x01, 0xcf, 0x86, 0xfc, 0x53, 0x81,
	0x8b, 0xc2, 0xb3, 0x2e, 0xc2, 0x4c, 0xd8, 0x9b, 0x98, 0x39, 0x05, 0x33, 0x5d, 0xa3, 0x81, 0x8f,
	0xb1, 0x46, 0xf6, 0x11, 0xa0, 0x4f, 0x78, 0xde, 0x18, 0x4c, 0xdf, 0x5f, 0x04, 0x7e, 0x99, 0x94,
	0xd7, 0x94, 0x0b, 0x9f, 0x85, 0xf7, 0x8d, 0xcf, 0xd8, 0x06, 0x8f, 0x83, 0x5b, 0xf1, 0x7c, 0xcb,
	0xe3, 0x38, 0x3c, 0xb7, 0xe7, 0x15, 0x57, 0x02, 0x3d, 0x30, 0xb3, 0xda, 0x28, 0xba, 0x02, 0xdf,
	0x07, 0x7e, 0x46, 0x25, 0xed, 0x68, 0x29, 0x36, 0x02, 0x76, 0x00, 0xb6, 0x6a, 0x66, 0xbe, 0x6d,
	0x80, 0x11, 0x78, 0x2d, 0x1b, 0x09, 0x7c, 0x8a, 0xd7, 0xba, 0x7a, 0x88, 0xf5, 0xdf, 0x9b, 0xfa,
	0xf5, 0xef, 0x8a, 0x69, 0x7b, 0xc7, 0x1a, 0xf1, 0x6f, 0xe1, 0x79, 0xd4, 0xa5, 0x81, 0xb2, 0xd6,
	0xc5, 0x74, 0xac, 0x35, 0xda, 0xad, 0x0d, 0x5f, 0x4d, 0xfc, 0x09, 0xd3, 0x9c, 0x23, 0x92, 0xb8,
	0xa3, 0xf0, 0xf8, 0xef, 0x8b, 0xd7, 0xa5, 0xda, 0x90, 0xf4, 0xb9, 0xa4, 0xdf, 0x4a, 0x7a, 0x49,
	0xd2, 0x7e, 0x92, 0x08, 0xff, 0xf7, 0x0d, 0xff, 0x91, 0xb4, 0x93, 0xa4, 0x83, 0xc3, 0xff, 0x7e,
	0x92, 0xf6, 0x49, 0xee, 0xfd, 0x58, 0xd2, 0x74, 0x49, 0x47, 0x48, 0x9a, 0x26, 0xe9, 0x77, 0x92,
	0xee, 0x0e, 0xf7, 0xae, 0x95, 0x74, 0xa3, 0xa4, 0xf5, 0x65, 0x7c, 0x3f, 0xc9, 0x87, 0xa4, 0xe3,
	0x25, 0xed, 0x92, 0x8b, 0x7b, 0x41, 0xd2, 0x15, 0xe1, 0xff, 0xda, 0x21, 0xdf, 0xe1, 0xb9, 0x34,
	0x31, 0xa4, 0x75, 0xbe, 0x46, 0xd2, 0xb0, 0xe4, 0xde, 0x6a, 0x92, 0x66, 0x49, 0x5a, 0x37, 0x5c,
	0x2f, 0x2a, 0xe9, 0x7d, 0x49, 0xf7, 0x84, 0xf2, 0x6e, 0x0b, 0x75, 0x9d, 0x21, 0xe9, 0xc8, 0x92,
	0xf2, 0x5b, 0x2b, 0x1c, 0x2f, 0xe9, 0xc4, 0xf0, 0xbf, 0x7b, 0xa8, 0x57, 0x6c, 0x8b, 0x1b, 0x24,
	0x0d, 0x0f, 0xff, 0x3b, 0x4b, 0xba, 0x2f, 0xd4, 0x51, 0x92, 0x86, 0xe4, 0xca, 0xb9, 0x5b, 0xd2,
	0xed, 0xe1, 0x7f, 0x17, 0x49, 0x53, 0x92, 0xeb, 0x5f, 0x84, 0x3c, 0x6b, 0x86, 0xeb, 0xff, 0x92,
	0x34, 0x57, 0xd2, 0x86, 0xb9, 0x32, 0x56, 0x95, 0x34, 0x33, 0xa4, 0x8d, 0x71, 0xd3, 0x6a, 0xd4,
	0x7d, 0x39, 0x49, 0xe3, 0x24, 0x9d, 0x2c, 0xa9, 0x53, 0x12, 0xdf, 0x54, 0x10, 0x1e, 0x94, 0x34,
	0x59, 0xd2, 0x16, 0xa1, 0xfc, 0x1f, 0x86, 0xb4, 0xa3, 0x24, 0x3d, 0x14, 0xfe, 0x1f, 0x1e, 0xfa,
	0x61, 0xf5, 0x70, 0xbd, 0xbd, 0xa4, 0x2f, 0xc2, 0x6f, 0x4b, 0xda, 0x76, 0x39, 0x49, 0x2b, 0x34,
	0x98, 0x76, 0x05, 0x49, 0x5d, 0x4b, 0xee, 0x75, 0x91, 0x74, 0x8c, 0xa4, 0x2b, 0x25, 0xbd, 0x28,
	0xe9, 0x2e, 0x49, 0xed, 0x93, 0xfb, 0x7b, 0x84, 0x76, 0x3a, 0x3a, 0xd7, 0x0e, 0xcb, 0x4a, 0xba,
	0x3c, 0xdc, 0x5b, 0xbb, 0xa4, 0xec, 0x91, 0xa1, 0x3d, 0xf6, 0xaa, 0x51, 0x37, 0xa9, 0xb2, 0xbf,
	0x7f, 0x29, 0x69, 0x8e, 0xa4, 0xf5, 0xc2, 0xf5, 0x00, 0x49, 0xff, 0x96, 0xe7, 0x5b, 0x4c, 0xd3,
	0x41, 0xd2, 0x1b, 0xb9, 0x7c, 0xf9, 0x72, 0x96, 0x96, 0xc7, 0xd7, 0x9b, 0x92, 0xd6, 0xaa, 0xf3,
	0x4c, 0x42, 0x1b, 0xd4, 0x2a, 0x0f, 0x79, 0xde, 0xc4, 0xb8, 0xfd, 0x24, 0xbd, 0x2d, 0xa9, 0xaf,
	0xa4, 0x76, 0x49, 0x9a, 0xe3, 0x43, 0xde, 0x7a, 0xcf, 0x23, 0xc4, 0xe5, 0xd3, 0xd6, 0x4a, 0x5f,
	0xeb, 0x5e, 0x3e, 0xbe, 0xb3, 0xa4, 0xb1, 0x05, 0xef, 0x5e, 0xaf, 0xfc, 0x18, 0x66, 0xca, 0x34,
	0x72, 0xa5, 0x82, 0x7b, 0xed, 0x24, 0xfd, 0xab, 0xa4, 0xee, 0x71, 0x8e, 0xed, 0x5b, 0x70, 0x6f,
	0x4a, 0xee, 0xfa, 0x34, 0x49, 0x8f, 0x4b, 0xfa, 0x4e, 0x12, 0x77, 0x98, 0xdc, 0xdf, 0xf9, 0x31,
	0x95, 0xaf, 0x73, 0x2f, 0x99, 0x9e, 0x44, 0x1a, 0x79, 0xb8, 0xa4, 0x67, 0x24, 0xad, 0x9c, 0xd4,
	0xf1, 0x38, 0x49, 0x2f, 0xe7, 0xca, 0x2f, 0x2a, 0xeb, 0x5b, 0x32, 0x4d, 0x1d, 0x91, 0xc4, 0xfd,
	0x41, 0xd2, 0xd3, 0xf2, 0x38, 0x47, 0x52, 0x47, 0x49, 0x9f, 0x48, 0x3a, 0x34, 0xe4, 0x3d, 0xab,
	0xa4, 0xbc, 0xce, 0xf2, 0xbc, 0x6e, 0x49, 0xdf, 0xef, 0x11, 0xe2, 0x76, 0x2c, 0x48, 0xff, 0xa4,
	0xa4, 0x25, 0x92, 0xeb, 0xed, 0x42, 0xda, 0x9d, 0x72, 0xe9, 0x6e, 0x91, 0xf4, 0x4a, 0x2e, 0x6e,
	0x19, 0x99, 0x16, 0xa5, 0x71, 0x0b, 0xc9, 0x7d, 0xf8, 0x90, 0xb2, 0xf1, 0xdb, 0x41, 0x1e, 0x33,
	0xdf, 0x2d, 0x78, 0xfe, 0xc9, 0xe1, 0x79, 0x9b, 0x24, 0x71, 0x1d, 0x25, 0x3d, 0x20, 0x69, 0xe1,
	0xe4, 0x5d, 0x7f, 0x95, 0xcb, 0xd7, 0x27, 0xc4, 0x1f, 0x54, 0xd0, 0x16, 0x9b, 0xc9, 0x34, 0xbf,
	0x6c, 0x0c, 0x96, 0xb5, 0x5d, 0x73, 0x42, 0xb7, 0x50, 0xc7, 0x2e, 0xcd, 0xcc, 0xd7, 0x1a, 0xcf,
	0xae, 0xd5, 0xd7, 0xf5, 0xc2, 0xf5, 0x92, 0xae, 0x9e, 0x87, 0x67, 0x36, 0x52, 0xff, 0x85, 0x65,
	0xfe, 0xa0, 0x91, 0xf8, 0x46, 0xdb, 0xa3, 0x35, 0xdb, 0xed, 0xeb, 0x10, 0xce, 0xfb, 0x86, 0xb5,
	0x87, 0x72, 0xff, 0x87, 0xd4, 0xb8, 0x2e, 0x0c, 0xed, 0x81, 0x99, 0x78, 0xd7, 0xff, 0x0a, 0x96,
	0xa0, 0x12, 0x7e, 0x5f, 0x4a, 0x78, 0xf8, 0xd5, 0x81, 0x97, 0xc3, 0xff, 0xd5, 0x42, 0xda, 0x88,
	0x73, 0xb1, 0x24, 0xe5, 0x02, 0xac, 0x76, 0x1a, 0x89, 0x25, 0x20, 0x2b, 0x02, 0xdb, 0x62, 0xe9,
	0xc7, 0xf3, 0x21, 0x6d, 0xaf, 0x24, 0xdf, 0x7a, 0x58, 0xb2, 0x7e, 0x5b, 0x6e, 0xbf, 0xb0, 0x34,
	0x99, 0xda, 0x6a, 0x66, 0xf8, 0xfd, 0xa4, 0x64, 0x6f, 0x11, 0xeb, 0xbc, 0x1e, 0x96, 0x3c, 0x9d,
	0x93, 0xbb, 0x77, 0x27, 0x96, 0xb4, 0x01, 0xcc, 0x02, 0x96, 0xc3, 0xbb, 0x97, 0x6d, 0x80, 0xef,
	0x61, 0x89, 0xdc, 0x3a, 0xc0, 0x79, 0x05, 0x65, 0xcf, 0xab, 0x2a, 0x31, 0xc5, 0x6e, 0x64, 0x6a,
	0xc5, 0xc3, 0xb1, 0x94, 0xe7, 0x99, 0x70, 0x7d, 0x19, 0x56, 0x83, 0x2d, 0x8f, 0xdf, 0xb3, 0x37,
	0xde, 0x71, 0xe5, 0xb1, 0x10, 0x6e, 0xbf, 0x7f, 0x86, 0xeb, 0x19, 0xc0, 0x0d, 0x64, 0x6d, 0xba,
	0x08, 0x96, 0xa2, 0xbe, 0x10, 0xae, 0xaf, 0xc0, 0xd2, 0xa9, 0x54, 0xfa, 0xda, 0x0e, 0xbf, 0xeb,
	0x8d, 0xb9, 0xb2, 0x67, 0x52, 0x8c, 0x8e, 0xa1, 0xde, 0x97, 0x62, 0x95, 0xe4, 0xa7, 0xc9, 0xbd,
	0x5e, 0x05, 0xe1, 0x66, 0x2c, 0x5d, 0x8b, 0x75, 0x7a, 0x38, 0xfc, 0x8e, 0xc7, 0x52, 0x5f, 0x70,
	0xfb, 0xdf, 0x40, 0x36, 0xbe, 0xee, 0xc1, 0x12, 0xad, 0xe3, 0x4a, 0xea, 0x50, 0x86, 0x0e, 0x58,
	0xda, 0x3d, 0x09, 0xf7, 0x67, 0x23, 0xd8, 0x06, 0x4b, 0xba, 0x8f, 0x08, 0xf9, 0x53, 0xcc, 0xc0,
	0xbb, 0xdd, 0xfd, 0x71, 0xfd, 0x77, 0xc0, 0x12, 0x6f, 0x80, 0x3d, 0xb0, 0xf4, 0xa9, 0x2f, 0x96,
	0x42, 0xa7, 0xed, 0x30, 0x1d, 0x38, 0x10, 0x98, 0x8c, 0xa5, 0x6c, 0x79, 0xa9, 0x4e, 0x27, 0x2c,
	0x01, 0x7d, 0x93, 0xe6, 0x69, 0x08, 0x86, 0xe1, 0xf6, 0xdf, 0x19, 0xd8, 0x00, 0xf8, 0x33, 0x96,
	0x7c, 0xdd, 0x9e, 0xa4, 0x99, 0x4b, 0x36, 0x8e, 0xca, 0x30, 0x13, 0xab, 0xd8, 0x9e, 0x0b, 0xef,
	0x50, 0x0f, 0x77, 0x63, 0xa9, 0x60, 0x2d, 0xdc, 0x12, 0xd2, 0xac, 0x07, 0x0c, 0xc7, 0x52, 0x80,
	0xeb, 0xa8, 0xd4, 0xc6, 0x3c, 0x1c, 0xea, 0xf7, 0x65, 0xe3, 0xaf, 0xc0, 0x99, 0x64, 0x34, 0xa8,
	0xb9, 0xf8, 0x04, 0x4b, 0x6b, 0x07, 0x16, 0xdc, 0xdb, 0x8e, 0x72, 0x8d, 0xc9, 0x87, 0x58, 0x9a,
	0x7e, 0x11, 0xa6, 0x73, 0x65, 0xf8, 0x11, 0x70, 0x02, 0x96, 0xb4, 0xa5, 0xa6, 0x76, 0x17, 0x63,
	0xfa, 0x34, 0xbc, 0x4e, 0xfd, 0x9a, 0xb0, 0x9a, 0xf4, 0x38, 0x4c, 0xd3, 0x86, 0xe2, 0xf1, 0xf8,
	0x5a, 0xb8, 0x2f, 0x6c, 0x1e, 0x31, 0x19, 0xb8, 0xb0, 0x4e, 0x59, 0xff, 0x06, 0xae, 0xc7, 0xe3,
	0x3c, 0x62, 0x20, 0xa6, 0x39, 0x51, 0xe2, 0xfb, 0x39, 0x1e, 0x23, 0xef, 0x03, 0xef, 0xe1, 0x77,
	0x2c, 0xc2, 0x27, 0x98, 0x16, 0xb4, 0x04, 0xf1, 0x79, 0x3f, 0xcb, 0xc5, 0xaf, 0x87, 0x25, 0xf3,
	0x1f, 0x26, 0x71, 0xe3, 0xb0, 0x34, 0x7b, 0xbb, 0x24, 0x6e, 0x09, 0xac, 0x95, 0x58, 0x15, 0x4b,
	0x6c, 0x23, 0xb6, 0xc3, 0x1a, 0xaf, 0x14, 0x73, 0xb0, 0x74, 0x7e, 0x0b, 0x32, 0x13, 0xc9, 0x23,
	0x70, 0x3b, 0x4c, 0x2d, 0xa8, 0xdb, 0xf9, 0xe1, 0xf9, 0xa9, 0x69, 0xc3, 0xcf, 0x80, 0x7f, 0xe0,
	0xf5, 0x0f, 0xe0, 0x55, 0xac, 0x09, 0x88, 0x58, 0x1c, 0x8f, 0x83, 0x51, 0x14, 0xf7, 0xe7, 0xa3,
	0x58, 0x3b, 0x3d, 0x3f, 0x4d, 0xea, 0x5e, 0xc6, 0x9a, 0xd8, 0x0f, 0xeb, 0x25, 0xfc, 0x0f, 0xc3,
	0xa6, 0x64, 0xbc, 0xc7, 0xfc, 0xc2, 0x6c, 0x8a, 0xcf, 0xa7, 0xcd, 0xa6, 0x31, 0x13, 0x9a, 0x36,
	0xd4, 0xc7, 0xe6, 0x5f, 0x76, 0x05, 0xbe, 0x6a, 0x68, 0x8f, 0xd5, 0x7f, 0xef, 0x60, 0xa6, 0x2e,
	0x32, 0x4c, 0x2f, 0x90, 0x4d, 0x88, 0x26, 0xcc, 0xe0, 0x9e, 0x12, 0xfe, 0x0f, 0xc6, 0x8b, 0x5d,
	0x53, 0xb8, 0xbf, 0x12, 0x95, 0xea, 0xfa, 0x67, 0x31, 0x03, 0xff, 0x06, 0x66, 0xb4, 0x3f, 0x0b,
	0x01, 0x32, 0x95, 0xd0, 0xc2, 0xd8, 0x9c, 0xe5, 0xbf, 0x0b, 0xea, 0x34, 0x18, 0x2f, 0x0e, 0xfd,
	0x31, 0x23, 0x79, 0x35, 0x66, 0x34, 0x7b, 0x61, 0x46, 0x64, 0x36, 0x56, 0x6f, 0x76, 0x49, 0xea,
	0xdc, 0x3f, 0xfc, 0x9f, 0x94, 0x2b, 0xeb, 0x06, 0x6c, 0xaf, 0x16, 0xcd, 0x59, 0xe6, 0x60, 0x62,
	0xdd, 0x15, 0xdb, 0xe1, 0xf5, 0xc6, 0xea, 0xaa, 0xf9, 0x89, 0xae, 0x58, 0xbd, 0xf5, 0x74, 0xb8,
	0xee, 0x85, 0x99, 0xf3, 0x88, 0xa7, 0x30, 0xa3, 0xb8, 0x75, 0x9d, 0x72, 0xe6, 0x60, 0x55, 0xf2,
	0xc5, 0x49, 0xdc, 0xdc, 0x10, 0x0f, 0x5e, 0x78, 0xf7, 0x48, 0xee, 0xc5, 0x77, 0x7e, 0x23, 0x89,
	0x3b, 0x0a, 0x9b, 0x14, 0xbc, 0x9a, 0x2b, 0xbb, 0xec, 0x70, 0xcb, 0x01, 0x98, 0xe9, 0x1f, 0x51,
	0xa7, 0x6e, 0x60, 0xd3, 0x9c, 0x63, 0x71, 0x9f, 0x45, 0xc6, 0xa0, 0x77, 0xf8, 0x5d, 0x15, 0x2f,
	0xa2, 0xf1, 0x7f, 0x7e, 0xd1, 0x7b, 0x0c, 0x9b, 0x4b, 0xdd, 0x8d, 0xc7, 0x4f, 0x6a, 0xd3, 0x5e,
	0x14, 0xb7, 0x35, 0x5e, 0xd0, 0x76, 0x0c, 0xff, 0x47, 0x62, 0x26, 0xa2, 0xa9, 0x46, 0xe8, 0x10,
	0xd2, 0x6d, 0x8d, 0x37, 0x3f, 0x8f, 0x51, 0xde, 0xe6, 0x91, 0x71, 0x5f, 0x03, 0x6f, 0xe8, 0x46,
	0xe0, 0x8d, 0xda, 0x03, 0xa1, 0x1e, 0x97, 0x60, 0xe6, 0xb3, 0x09, 0xab, 0xa4, 0x85, 0x4d, 0x5b,
	0x36, 0xc2, 0x8b, 0x7c, 0x8a, 0x9d, 0x31, 0x93, 0x75, 0x0b, 0x99, 0x1a, 0xbc, 0x11, 0xc4, 0x74,
	0xef, 0xe2, 0x39, 0xf1, 0x34, 0xc5, 0xe6, 0x17, 0x3b, 0xe1, 0x8d, 0x53, 0x2d, 0x08, 0x6f, 0x3c,
	0x36, 0xa3, 0xd2, 0x94, 0x22, 0x8f, 0x89, 0x78, 0x0e, 0xdd, 0x5e, 0x23, 0xcd, 0xe3, 0x98, 0x31,
	0xbf, 0x1d, 0x9b, 0x3b, 0x4c, 0x22, 0xdb, 0x30, 0xa6, 0x18, 0x43, 0xb5, 0x9a, 0x78, 0x41, 0xe3,
	0x58, 0xea, 0xbf, 0x4f, 0x3d, 0xcc, 0x06, 0x2e, 0xc7, 0xa6, 0x60, 0xf9, 0xf7, 0xf9, 0x05, 0x99,
	0xd9, 0x43, 0x1e, 0x73, 0x31, 0xc3, 0xdd, 0x9e, 0x6c, 0xa3, 0x5c, 0x84, 0xa3, 0x30, 0x23, 0xf7,
	0x5c, 0xc1, 0xbd, 0xe1, 0xc0, 0x96, 0xc0, 0x86, 0x75, 0xea, 0x38, 0x15, 0x9f, 0x67, 0x39, 0x12,
	0xcf, 0x95, 0x22, 0x86, 0xf9, 0x52, 0x4c, 0x0b, 0x8b, 0x6c, 0x9b, 0x53, 0x74, 0xa5, 0x9a, 0x1e,
	0x6c, 0x43, 0xa5, 0xa9, 0xcb, 0x4f, 0xf0, 0x7b, 0x9f, 0x87, 0x37, 0x06, 0x65, 0xf8, 0x51, 0x9d,
	0x67, 0x95, 0x61, 0x36, 0x36, 0xdf, 0xda, 0x83, 0x4a, 0x93, 0xc3, 0x7e, 0x05, 0xcf, 0xfb, 0x0c,
	0x33, 0xdc, 0xa9, 0x40, 0x63, 0x17, 0xbc, 0x21, 0x79, 0x0f, 0xf8, 0x69, 0x12, 0xbf, 0x03, 0x95,
	0x26, 0x52, 0x11, 0xb7, 0x87, 0x70, 0x26, 0x9e, 0xf3, 0xbb, 0x62, 0x61, 0x53, 0x11, 0x66, 0xe0,
	0xf9, 0xdf, 0x8f, 0xec, 0x0c, 0xd1, 0x00, 0x2a, 0xcf, 0x38, 0xad, 0x8a, 0x05, 0x12, 0x11, 0x67,
	0x60, 0x3a, 0x52, 0xb4, 0xc1, 0x03, 0xcf, 0xcf, 0xbb, 0x30, 0xad, 0x68, 0x04, 0x7f, 0xc4, 0x1b,
	0x92, 0x7a, 0x7d, 0x99, 0xc7, 0x0c, 0xbc, 0xb9, 0x02, 0x0b, 0x4b, 0x6e, 0xc4, 0xc2, 0x91, 0x29,
	0xa1, 0xcc, 0x32, 0x73, 0x91, 0x65, 0xf0, 0xe6, 0xe2, 0x6e, 0x4c, 0xdb, 0x8f, 0x4f, 0xee, 0x6d,
	0x8e, 0x37, 0x1d, 0x0f, 0xe1, 0x7e, 0xf8, 0x75, 0x72, 0x6f, 0x0f, 0x4c, 0xb7, 0xee, 0xc7, 0x82,
	0xa3, 0xef, 0x15, 0x94, 0xbd, 0x1e, 0x16, 0xea, 0x8c, 0xc6, 0x63, 0xf7, 0x22, 0x4c, 0xfb, 0x36,
	0xc4, 0x7d, 0xb2, 0x0a, 0xde, 0x34, 0x35, 0xe1, 0x35, 0x3b, 0xc5, 0x31, 0x78, 0xdd, 0x7f, 0x28,
	0xe4, 0x3f, 0x10, 0xcf, 0xd5, 0x23, 0x73, 0xe9, 0x3a, 0x63, 0x13, 0xa6, 0x6b, 0x30, 0xbf, 0x73,
	0x13, 0x19, 0xd3, 0xdd, 0x13, 0xcf, 0xcf, 0xf7, 0x72, 0x79, 0x76, 0x0f, 0xf5, 0x7a, 0x97, 0x72,
	0x5c, 0x8b, 0x37, 0xa1, 0xaf, 0x51, 0x3e, 0x5e, 0xc0, 0x66, 0xa0, 0xe7, 0x63, 0x01, 0xc1, 0x40,
	0xbc, 0x81, 0xbe, 0x0f, 0x0b, 0x4e, 0x06, 0x62, 0x81, 0xd0, 0xd5, 0xd8, 0xec, 0xf5, 0x4e, 0xb2,
	0x31, 0x9f, 0xe6, 0x1b, 0x00, 0xfc, 0x01, 0x6f, 0x1a, 0xdf, 0xc6, 0x9b, 0xc1, 0x74, 0xe3, 0xb0,
	0x15, 0x1e, 0xdb, 0x63, 0x31, 0x7d, 0x3e, 0x33, 0x29, 0xa7, 0x1b, 0x5e, 0x23, 0x26, 0x61, 0x7a,
	0x33, 0x02, 0xf7, 0xd9, 0x2b, 0xd8, 0x3c, 0x2c, 0xa2, 0x2f, 0xde, 0xc4, 0x8f, 0x0b, 0xcf, 0xd9,
	0x9d, 0x4a, 0x41, 0x4d, 0x47, 0x3c, 0xee, 0x1f, 0xc4, 0x63, 0xf5, 0xa0, 0xf0, 0x0e, 0x23, 0xb0,
	0x00, 0xf7, 0x5e, 0xdc, 0x17, 0x13, 0xc9, 0x04, 0xa5, 0x9b, 0xe0, 0xf5, 0xa1, 0x07, 0xe6, 0xd3,
	0x9a, 0x30, 0xdf, 0xd7, 0x19, 0x9b, 0x88, 0x5e, 0x4c, 0xc6, 0xb7, 0x2c, 0x1e, 0xe2, 0x2e, 0x49,
	0xe2, 0xc6, 0xe2, 0xf9, 0xf1, 0x6f, 0xdc, 0x4f, 0x4b, 0xe3, 0xf1, 0xf4, 0x19, 0x9e, 0x33, 0xf1,
	0xfe, 0x54, 0x3c, 0xf6, 0xb6, 0xc2, 0x63, 0x2e, 0x9a, 0x1a, 0xae, 0x1e, 0xea, 0xf7, 0x41, 0xa8,
	0xd7, 0xd2, 0x58, 0xa0, 0xfc, 0x01, 0x16, 0xb2, 0x9d, 0x84, 0x85, 0x27, 0x93, 0xf0, 0xc6, 0xf5,
	0xa4, 0xd0, 0xae, 0x0f, 0x27, 0xcf, 0x1d, 0x81, 0x85, 0xcd, 0xe3, 0xc3, 0x73, 0xa3, 0x49, 0xe0,
	0x13, 0x64, 0xfc, 0xc5, 0x4c, 0x2c, 0xc4, 0x69, 0x3d, 0x48, 0x1a, 0x2d, 0x69, 0x9b, 0x3a, 0x22,
	0xf6, 0x7f, 0x24, 0xff, 0x6f, 0xcc, 0xdd, 0xbb, 0x55, 0x56, 0xfb, 0x0e, 0x91, 0xf4, 0x7a, 0xee,
	0xde, 0x9b, 0xb2, 0xda, 0xb3, 0x73, 0x10, 0xe5, 0x1f, 0x12, 0xe2, 0x4f, 0x93, 0x55, 0x97, 0xd7,
	0xc9, 0xea, 0xc4, 0x9f, 0xe7, 0xf2, 0x9d, 0x13, 0xd2, 0xff, 0x2e, 0x17, 0xbf, 0xa8, 0x6c, 0x8e,
	0x92, 0xaf, 0xdf, 0x63, 0xca, 0x4c, 0x61, 0xd2, 0x10, 0xcd, 0x62, 0x52, 0xd3, 0x99, 0x97, 0x64,
	0x95, 0x64, 0x67, 0x49, 0x4f, 0xd4, 0x51, 0x4b, 0xb4, 0x86, 0x1a, 0xe6, 0x20, 0x49, 0xe7, 0x26,
	0xd7, 0x1f, 0x4a, 0x3a, 0x3d, 0xb9, 0x5e, 0x24, 0x3c, 0xeb, 0x98, 0x16, 0x3c, 0xff, 0x61, 0xd9,
	0x74, 0x28, 0x1f, 0xdf, 0x49, 0x56, 0x4d, 0x8f, 0x56, 0xa6, 0x6a, 0xed, 0x2e, 0xe9, 0x9f, 0xb2,
	0xea, 0x76, 0x48, 0x28, 0x3f, 0xa6, 0x7f, 0x47, 0x36, 0xe3, 0x78, 0x54, 0xd2, 0x9d, 0x92, 0x7e,
	0x12, 0xe2, 0x9b, 0x24, 0x5d, 0x26, 0xe9, 0x8f, 0xb2, 0x49, 0xcd, 0x04, 0x49, 0x83, 0x55, 0x69,
	0xee, 0x11, 0xc3, 0x60, 0xd9, 0x24, 0x27, 0xbe, 0xd3, 0xe3, 0xb2, 0x5a, 0x7e, 0x50, 0xa8, 0x67,
	0x34, 0x3d, 0xc9, 0xab, 0xcd, 0x91, 0xfb, 0x79, 0x8e, 0xa4, 0xe7, 0x64, 0x73, 0x80, 0xa5, 0x93,
	0x7b, 0x69, 0xdc, 0x77, 0xe4, 0x7e, 0x7e, 0x4a, 0xd2, 0xb6, 0xf3, 0xd8, 0x2f, 0xdb, 0x86, 0x72,
	0xae, 0x50, 0xa6, 0xee, 0xef, 0x2a, 0x8f, 0xcd, 0xb7, 0x42, 0x3f, 0x7d, 0x2f, 0xf4, 0xd5, 0x0c,
	0x79, 0xbc, 0xb4, 0x97, 0xcd, 0x88, 0xa2, 0x2a, 0x7f, 0x7f, 0x59, 0xed, 0x8a, 0xa4, 0xa5, 0x42,
	0x9b, 0xe6, 0x4d, 0xa4, 0xae, 0x96, 0xcd, 0xba, 0x76, 0x0a, 0xf7, 0xfb, 0x96, 0xd4, 0x47, 0xaa,
	0x34, 0x09, 0xb8, 0x28, 0xb4, 0x61, 0x67, 0xd9, 0x64, 0xe6, 0x82, 0x06, 0xdf, 0x2b, 0x2d, 0x27,
	0x0d, 0x5d, 0xc3, 0xbd, 0x41, 0x35, 0xd2, 0xce, 0x68, 0xa0, 0xbc, 0x77, 0x92, 0xff, 0x6f, 0x34,
	0xa3, 0x5e, 0xb5, 0xea, 0x96, 0x1f, 0x8f, 0x8d, 0xcc, 0x81, 0xb2, 0x7b, 0x31, 0x7e, 0x1b, 0x49,
	0x1f, 0xa9, 0xb6, 0x1a, 0xbf, 0x56, 0xf9, 0x31, 0x4c, 0x91, 0xc7, 0x81, 0x24, 0xfd, 0x34, 0x89,
	0x5f, 0x59, 0xd2, 0xdf, 0x6a, 0xd4, 0x7d, 0x4a, 0xf8, 0xfd, 0x79, 0xb8, 0x7f, 0x42, 0xc1, 0x3d,
	0xe4, 0x39, 0x72, 0x5e, 0xc9, 0xb3, 0x97, 0x0d, 0x79, 0x0f, 0xab, 0x53, 0xe7, 0x5b, 0x65, 0x3a,
	0xfa, 0xa2, 0xa4, 0xbf, 0x96, 0x94, 0xb5, 0x62, 0xc8, 0x7b, 0x40, 0x8d, 0xb2, 0x76, 0x93, 0xf4,
	0xa9, 0x2a, 0xc7, 0xf0, 0x69, 0x21, 0xdd, 0x64, 0xd9, 0x74, 0x6e, 0x89, 0x82, 0xb2, 0xe7, 0xa5,
	0xbf, 0xca, 0xda, 0x6f, 0xf3, 0x10, 0xbf, 0x47, 0x12, 0x97, 0x37, 0x69, 0x89, 0xe1, 0x50, 0xd9,
	0x84, 0x66, 0xf9, 0x70, 0x7d, 0x9d, 0xdc, 0x3f, 0x97, 0x4a, 0x9a, 0x94, 0xa4, 0x7b, 0x4a, 0x36,
	0x59, 0x29, 0xaa, 0xdf, 0x5a, 0x92, 0x66, 0xcb, 0x73, 0x3f, 0x6f, 0x0a, 0x98, 0x0f, 0xdf, 0x96,
	0x4d, 0x89, 0x4e, 0x97, 0xe7, 0xf5, 0xa9, 0x35, 0xd2, 0xf6, 0x90, 0xcd, 0x0b, 0x8f, 0xab, 0xd3,
	0x16, 0x7d, 0x24, 0x5d, 0xd5, 0x40, 0xdb, 0xad, 0x2b, 0xd3, 0xd0, 0xa3, 0x55, 0xbd, 0x16, 0x37,
	0x1a, 0xba, 0x48, 0x7a, 0x2f, 0xa9, 0x77, 0x8f, 0xf0, 0x8c, 0x3e, 0x25, 0xcf, 0x1e, 0xab, 0xcc,
	0x1c, 0x70, 0x53, 0x99, 0x56, 0xf7, 0x97, 0xd7, 0xd1, 0x4f, 0x94, 0xad, 0xaf, 0x2b, 0x84, 0xf4,
	0x07, 0xc9, 0xe6, 0x46, 0x73, 0x24, 0xf5, 0x0e, 0xf7, 0x3a, 0xcb, 0x6b, 0xb7, 0x92, 0xb2, 0xd7,
	0x95, 0x4d, 0x62, 0xb7, 0x08, 0xd7, 0x8b, 0xc9, 0x34, 0x2f, 0x1d, 0xc3, 0x45, 0x6d, 0x15, 0xdb,
	0x4b, 0x92, 0x76, 0x0e, 0xd7, 0xdb, 0xc8, 0xfd, 0xb7, 0xaf, 0x2a, 0xcd, 0x91, 0x24, 0x8f, 0x81,
	0x68, 0x1e, 0xb6, 0x59, 0x88, 0x8b, 0xe3, 0x6a, 0xb0, 0xbc, 0xae, 0xa5, 0xf5, 0x42, 0x36, 0xe3,
	0x1d, 0x53, 0x10, 0x9f, 0xd6, 0x67, 0x67, 0xd9, 0x9c, 0xb6, 0x68, 0x3d, 0x4c, 0xd3, 0x2d, 0xa9,
	0x8c, 0xfe, 0x3f, 0x2a, 0x9b, 0x8f, 0x21, 0x9b, 0x5e, 0xcd, 0x91, 0x4d, 0x16, 0x51, 0x66, 0xfe,
	0xbb, 0x77, 0x41, 0xbe, 0x27, 0x64, 0x53, 0x5d, 0x94, 0x99, 0x8d, 0xc6, 0x77, 0xe8, 0x21, 0xd3,
	0xba, 0x2d, 0xc3, 0xf5, 0x42, 0xa1, 0xec, 0x1b, 0x92, 0x77, 0x3e, 0x25, 0xe4, 0xb9, 0x47, 0xd9,
	0xfa, 0xda, 0x43, 0xe6, 0xdd, 0xf6, 0x93, 0xcd, 0x4a, 0xe7, 0x28, 0xe3, 0x05, 0x17, 0x97, 0xd7,
	0xfc, 0xf4, 0xfd, 0xf7, 0x97, 0x4d, 0xdc, 0x24, 0xd3, 0xfd, 0xe1, 0x72, 0x9f, 0x9e, 0x1e, 0xde,
	0x2b, 0x9a, 0x15, 0xaf, 0x2f, 0xd3, 0x91, 0x5a, 0xf3, 0xbf, 0x43, 0x78, 0x56, 0x1a, 0x5f, 0x14,
	0x87, 0xa4, 0x67, 0x55, 0xc9, 0xf7, 0x2d, 0x16, 0x9e, 0x17, 0xaf, 0xff, 0xa5, 0x4a, 0x93, 0xe6,
	0x03, 0x42, 0x19, 0x3f, 0x4c, 0xe2, 0x26, 0x84, 0x7c, 0xf1, 0x7a, 0xaf, 0xf0, 0xee, 0x9b, 0x86,
	0xeb, 0xf3, 0x25, 0xed, 0x9a, 0xab, 0xf3, 0x73, 0x72, 0xff, 0xc6, 0xeb, 0xc8, 0xd7, 0xc4, 0xf7,
	0x89, 0xfd, 0xb8, 0xbe, 0x3c, 0xf6, 0xe2, 0xda, 0xba, 0x84, 0xcc, 0x3f, 0x94, 0xbd, 0xfb, 0x7b,
	0x32, 0x4f, 0x85, 0x6c, 0xba, 0xf7, 0xa0, 0x3c, 0x97, 0x57, 0x49, 0xd2, 0x5c, 0xda, 0x3e, 0xec,
	0x0c, 0xde, 0xae, 0xc3, 0xc3, 0xa7, 0x3b, 0xea, 0xbc, 0xfa, 0xa7, 0x3f, 0x96, 0x0a, 0x9e, 0x82,
	0x77, 0x7a, 0xa3, 0xf1, 0x6e, 0x18, 0xbc, 0x63, 0xda, 0x00, 0x1f, 0xc8, 0x99, 0x8b, 0x77, 0xe9,
	0x3d, 0xb0, 0xa4, 0x7d, 0x27, 0xac, 0x7e, 0x3c, 0x12, 0x9b, 0x76, 0xac, 0x8a, 0xa5, 0x33, 0x23,
	0xf0, 0xee, 0xfe, 0x58, 0xac, 0x3a, 0xec, 0x99, 0x3c, 0xab, 0x2f, 0xde, 0xd1, 0xe5, 0xb1, 0x06,
	0xd9, 0x61, 0xcb, 0x14, 0x53, 0x93, 0xfb, 0x11, 0xab, 0x63, 0xa9, 0xe9, 0x27, 0x54, 0xaa, 0x3c,
	0x37, 0xa7, 0xfa, 0x40, 0x64, 0xff, 0xe4, 0xfa, 0x22, 0x5a, 0x86, 0xdd, 0x70, 0xfb, 0x44, 0x74,
	0x26, 0x93, 0x76, 0x43, 0xa6, 0x0a, 0x6d, 0xae, 0x07, 0x94, 0x1f, 0xe1, 0x76, 0x3e, 0x31, 0x17,
	0x7f, 0x33, 0x96, 0x26, 0x6c, 0x82, 0x0f, 0x27, 0xcd, 0xc6, 0x3b, 0xde, 0x8b, 0xc8, 0x0e, 0x2b,
	0xe5, 0xf1, 0x6d, 0x2c, 0x85, 0xde, 0x0c, 0x4b, 0x97, 0xaf, 0xc7, 0x3b, 0xf5, 0x0d, 0x80, 0xb5,
	0xf1, 0x4e, 0x73, 0x07, 0x6c, 0x7e, 0x73, 0x42, 0x08, 0x29, 0x3a, 0x63, 0xb5, 0x7a, 0x34, 0x0f,
	0xfa, 0x0c, 0x4b, 0x89, 0x3f, 0xc2, 0x3b, 0xff, 0xe7, 0xb0, 0x59, 0x11, 0x58, 0x82, 0xdb, 0x17,
	0x4b, 0x04, 0xc1, 0x63, 0x60, 0x03, 0xac, 0xbd, 0xd9, 0x08, 0x8f, 0x83, 0xd4, 0xcc, 0x26, 0x8d,
	0x7b, 0x2e, 0xfc, 0x6e, 0x8c, 0x77, 0xfe, 0xf3, 0x82, 0x51, 0xa1, 0x9c, 0xe9, 0x64, 0x52, 0xcb,
	0xe1, 0x58, 0xda, 0x39, 0x1c, 0x8f, 0xd9, 0xc9, 0x58, 0x8a, 0x76, 0x1f, 0x1e, 0x2f, 0x03, 0x43,
	0x5d, 0x63, 0x9b, 0xaf, 0x81, 0xc7, 0x12, 0x58, 0x92, 0x05, 0x95, 0x87, 0x7b, 0x17, 0xc5, 0xd2,
	0xa2, 0x89, 0xa1, 0x8c, 0x0f, 0xa9, 0x6d, 0xda, 0xd2, 0x1f, 0xef, 0xca, 0xa7, 0x61, 0xc9, 0x51,
	0xdf, 0xf0, 0xdc, 0xe5, 0x28, 0x37, 0x3d, 0x6a, 0x14, 0x33, 0xc2, 0xef, 0xd2, 0xb9, 0xf8, 0xfe,
	0x64, 0x63, 0xbc, 0x4c, 0xad, 0x9e, 0xa6, 0x59, 0x36, 0x89, 0xef, 0x5a, 0x50, 0xaf, 0x65, 0xb0,
	0xf9, 0x40, 0x1a, 0xca, 0xca, 0x8a, 0xa1, 0x7f, 0xad, 0x8a, 0xb7, 0x00, 0x2b, 0xe1, 0xc3, 0xe0,
	0xef, 0x53, 0x7d, 0x28, 0xbc, 0x25, 0x98, 0x8c, 0x35, 0x01, 0x87, 0x26, 0x71, 0x87, 0x51, 0xdb,
	0x23, 0x54, 0xc4, 0x15, 0xd8, 0x9c, 0xe8, 0x54, 0x8a, 0x0f, 0xf7, 0x2d, 0x43, 0xb9, 0xe6, 0x2a,
	0xb6, 0x6d, 0xd9, 0x21, 0xb4, 0x4e, 0x58, 0xab, 0xf2, 0x43, 0x2c, 0x11, 0xfb, 0x2e, 0xa6, 0xe7,
	0x45, 0x88, 0xf1, 0xdf, 0xc9, 0xc5, 0xf7, 0xc7, 0x92, 0xa8, 0xe9, 0x78, 0x9e, 0xef, 0x4e, 0xa5,
	0x99, 0xdf, 0xc9, 0xb8, 0x0d, 0x57, 0xc2, 0x26, 0x42, 0x53, 0xf1, 0xf8, 0xcf, 0x9b, 0x85, 0xb5,
	0x36, 0x1e, 0xc1, 0xde, 0xb8, 0xf6, 0x09, 0xd7, 0xeb, 0x61, 0x49, 0x5f, 0x91, 0x59, 0xc6, 0x1d,
	0x78, 0x8d, 0xda, 0x16, 0xd3, 0xa2, 0xef, 0x60, 0x69, 0xe6, 0x75, 0xf8, 0x50, 0xe0, 0x9a, 0x40,
	0x77, 0x7c, 0x60, 0xb3, 0xcc, 0xd4, 0xea, 0x79, 0xdc, 0x57, 0x5d, 0x4a, 0x9e, 0x91, 0xe2, 0x2d,
	0xbc, 0x66, 0x1d, 0x82, 0xd7, 0xa8, 0x22, 0xb3, 0x48, 0xb0, 0x04, 0x6e, 0x18, 0x96, 0xb0, 0x0d,
	0xad, 0x53, 0xe6, 0x28, 0x4c, 0xd3, 0xeb, 0x69, 0x9b, 0x2e, 0xc4, 0x6b, 0xe3, 0x39, 0x98, 0x6e,
	0xef, 0x54, 0x27, 0x7d, 0x11, 0x16, 0xc5, 0xa6, 0x84, 0x97, 0x87, 0xeb, 0xa8, 0x69, 0xd9, 0xa0,
	0x24, 0xfd, 0x7d, 0x98, 0x3e, 0xc7, 0xb4, 0x77, 0x60, 0x93, 0xc2, 0xdf, 0x61, 0xc9, 0x65, 0x34,
	0x4d, 0x9d, 0x86, 0xc7, 0xd0, 0x6c, 0x3c, 0x66, 0xee, 0x25, 0x33, 0x23, 0xfa, 0x84, 0x6a, 0x8d,
	0xce, 0x19, 0x58, 0xfa, 0x19, 0xcd, 0x1f, 0x3f, 0xc6, 0x63, 0xb1, 0x2f, 0xf5, 0xb1, 0x6e, 0xf8,
	0x6d, 0x0a, 0xbf, 0x0f, 0xe3, 0xf6, 0x5e, 0x89, 0x6a, 0xcd, 0xec, 0xf5, 0x64, 0x34, 0xfe, 0x89,
	0xf0, 0xdb, 0x3d, 0xfc, 0xfe, 0x2f, 0xc5, 0x9a, 0xbf, 0x4b, 0x31, 0x2f, 0x53, 0x86, 0x1e, 0x58,
	0x72, 0x7f, 0x20, 0xf5, 0x5d, 0x36, 0x7f, 0x80, 0x25, 0xe2, 0xe0, 0xb6, 0x8a, 0x73, 0x71, 0x22,
	0xee, 0xef, 0xcb, 0xc2, 0x75, 0x34, 0x51, 0x5c, 0xa3, 0x20, 0xdf, 0xcd, 0x64, 0xe6, 0xc4, 0xb1,
	0x1d, 0xe3, 0x3b, 0x9c, 0x4e, 0xa6, 0xbd, 0x00, 0xf3, 0x17, 0xa7, 0x62, 0xe9, 0xf3, 0x16, 0xb8,
	0xaf, 0x4f, 0x0d, 0xf7, 0x1e, 0x20, 0xa3, 0x2b, 0xe3, 0x43, 0xf9, 0x47, 0x91, 0xf5, 0x57, 0x7c,
	0xe7, 0x8f, 0xb0, 0x84, 0x3c, 0xc5, 0x95, 0x64, 0xbc, 0xdd, 0x76, 0x78, 0x3d, 0xdc, 0x05, 0x3b,
	0xa2, 0x58, 0x07, 0x5b, 0x4c, 0x74, 0xc6, 0xf4, 0xb2, 0x9e, 0x16, 0x68, 0x2e, 0xd5, 0xed, 0x5b,
	0x14, 0x07, 0x36, 0xe9, 0xdc, 0x91, 0xcc, 0x84, 0x70, 0x57, 0x2a, 0xf9, 0xc0, 0x91, 0x98, 0x6e,
	0xc5, 0xb9, 0xb3, 0x27, 0x6e, 0xdb, 0x78, 0x50, 0xbe, 0x1b, 0xb6, 0x16, 0xf8, 0x38, 0xc9, 0x73,
	0x3d, 0xd6, 0xa0, 0xfc, 0x25, 0xbc, 0x43, 0xd1, 0xc1, 0xff, 0xe1, 0x98, 0x7f, 0x5b, 0x22, 0x5c,
	0xef, 0x40, 0x36, 0x56, 0xce, 0xc2, 0xfd, 0xd8, 0x01, 0x8f, 0x95, 0xfb, 0xb1, 0x16, 0xa0, 0x2b,
	0xa6, 0x23, 0x23, 0x0a, 0xde, 0x23, 0xe2, 0x44, 0xcc, 0x07, 0xf4, 0xc3, 0x1a, 0xab, 0x7d, 0xf1,
	0x9c, 0x1e, 0x81, 0xfb, 0x7e, 0x65, 0x60, 0xb3, 0xf6, 0x58, 0x6d, 0xf3, 0x4e, 0x71, 0x19, 0xff,
	0x8f, 0x94, 0x39, 0xcf, 0x33, 0x77, 0xd3, 0xb1, 0xea, 0x70, 0x6d, 0xdc, 0xe9, 0xdd, 0xf1, 0x84,
	0x5d, 0x11, 0xab, 0xbf, 0x3e, 0xc6, 0x13, 0xf6, 0xbf, 0xb0, 0x4d, 0xe5, 0x6f, 0xb0, 0xea, 0x60,
	0x37, 0xdc, 0x80, 0xcf, 0xe0, 0x46, 0xdd, 0x11, 0x13, 0x9c, 0x6e, 0x98, 0xd1, 0xfb, 0x53, 0x78,
	0xd9, 0xdb, 0x30, 0xd3, 0x48, 0x78, 0x99, 0x6b, 0x0a, 0xea, 0xb7, 0x38, 0x95, 0x76, 0xc0, 0x11,
	0xb3, 0x92, 0xfb, 0xf5, 0xf0, 0x08, 0x95, 0xf6, 0xd3, 0xe0, 0xc6, 0x8a, 0xd7, 0x83, 0x0a, 0xf2,
	0x34, 0x51, 0xcd, 0xd0, 0xa7, 0xe8, 0x84, 0xeb, 0x3e, 0x26, 0x89, 0xfb, 0x84, 0x4a, 0x75, 0xd4,
	0xc2, 0x49, 0x7c, 0xa3, 0x58, 0x1c, 0x0f, 0xd8, 0x83, 0xc9, 0x6c, 0xcc, 0x23, 0x76, 0xc7, 0x04,
	0xea, 0x70, 0xdc, 0x0f, 0x07, 0x63, 0x66, 0xfa, 0x46, 0xca, 0x6d, 0xf7, 0xe2, 0x82, 0x25, 0x3c,
	0xb0, 0x6e, 0x08, 0x79, 0x16, 0x0f, 0x75, 0x8f, 0x66, 0x2a, 0xff, 0xc2, 0xea, 0xb4, 0x43, 0x72,
	0xf9, 0x0f, 0x0d, 0xf5, 0x8f, 0x9b, 0x90, 0xe8, 0x71, 0x67, 0x5f, 0x6c, 0x3a, 0xd2, 0x0b, 0x13,
	0x85, 0x25, 0xf0, 0xe2, 0x72, 0x24, 0xee, 0xdf, 0x31, 0x78, 0xc1, 0x5f, 0x11, 0xb7, 0xff, 0x27,
	0x54, 0x33, 0x7b, 0x69, 0xdc, 0x01, 0x78, 0x31, 0x3a, 0x97, 0x4a, 0x26, 0x11, 0x1a, 0x33, 0x6b,
	0x49, 0xb1, 0x0c, 0x1e, 0x6f, 0x7d, 0xc8, 0xbc, 0x18, 0xcc, 0xc4, 0x6a, 0xb1, 0x13, 0xc8, 0x08,
	0xe1, 0x9a, 0x64, 0xe6, 0x5e, 0x87, 0x62, 0x55, 0x6b, 0xdc, 0x50, 0xad, 0x47, 0xc6, 0x9c, 0x7f,
	0x3b, 0xfc, 0xbe, 0x9e, 0x3c, 0x23, 0x7a, 0xcd, 0x20, 0xe4, 0xb9, 0x13, 0xf8, 0x31, 0x95, 0x0c,
	0x7c, 0x8a, 0x11, 0xd8, 0xbb, 0xc5, 0x32, 0x78, 0xd1, 0x98, 0x80, 0x99, 0x93, 0x19, 0xcc, 0xbb,
	0x3d, 0x6a, 0x64, 0xca, 0xa7, 0xe7, 0xe2, 0x47, 0x90, 0x8d, 0xf1, 0x57, 0x28, 0x46, 0x9a, 0x26,
	0x3d, 0x8b, 0x32, 0x9d, 0x6a, 0x66, 0x7f, 0x11, 0x4c, 0x03, 0x4e, 0xc0, 0x9b, 0xf1, 0x35, 0x72,
	0xf7, 0xd3, 0xb2, 0x62, 0x18, 0x51, 0xab, 0xe2, 0x2d, 0xc0, 0x6e, 0x98, 0xde, 0x0c, 0xc1, 0x1b,
	0xd2, 0xd5, 0x5a, 0xa1, 0xcc, 0x4b, 0xf0, 0x82, 0xb4, 0x3a, 0x7e, 0xc7, 0xcd, 0x68, 0xdc, 0x2d,
	0xdc, 0x20, 0xbc, 0x38, 0x8c, 0xa4, 0x7a, 0x13, 0x3e, 0x93, 0xf2, 0xbe, 0x8d, 0x6d, 0x9b, 0x57,
	0xb9, 0xf7, 0xc7, 0x0b, 0xe9, 0xad, 0xc0, 0x92, 0x98, 0x01, 0x7d, 0x04, 0x33, 0x09, 0x65, 0x36,
	0xb2, 0x31, 0x3e, 0xcf, 0x48, 0x8c, 0xc0, 0x73, 0x74, 0xc3, 0x50, 0xb7, 0xbc, 0x6d, 0xa8, 0xb0,
	0x39, 0xc1, 0x0a, 0xb8, 0x4d, 0x5f, 0xc7, 0x26, 0x89, 0x7f, 0x2c, 0x79, 0x4e, 0x2d, 0x14, 0x31,
	0xf4, 0x0b, 0x51, 0xce, 0x30, 0x5f, 0x8e, 0x17, 0xce, 0xc5, 0x29, 0x36, 0x69, 0x89, 0x78, 0x15,
	0x9b, 0x44, 0x6c, 0x8f, 0xe7, 0xdc, 0x3d, 0x21, 0x7e, 0x14, 0x9e, 0x3b, 0x7b, 0xe2, 0x85, 0xf5,
	0x9e, 0xc2, 0xdc, 0xc6, 0xb2, 0x98, 0x6e, 0xbe, 0x8f, 0x69, 0x53, 0x3d, 0x9c, 0x15, 0xf2, 0xbc,
	0x42, 0xf5, 0x9c, 0x8a, 0x38, 0x1e, 0xcf, 0x85, 0x5f, 0x50, 0xff, 0xfc, 0xc5, 0xa7, 0x78, 0xbe,
	0xf7, 0xac, 0x91, 0x66, 0x1f, 0xcc, 0xb0, 0xdd, 0x84, 0xfb, 0xe5, 0x30, 0xcc, 0xf4, 0x37, 0xd7,
	0x7c, 0x6c, 0x1a, 0x5e, 0x6f, 0xdf, 0xc3, 0xeb, 0xc3, 0x9f, 0x43, 0xfc, 0xc2, 0xa5, 0x39, 0x2a,
	0x31, 0x19, 0xd3, 0xbe, 0xad, 0xb1, 0x87, 0xa5, 0x14, 0xbf, 0xc2, 0xe3, 0x7c, 0x73, 0x2a, 0xcd,
	0x37, 0x8b, 0xd0, 0x0b, 0xd3, 0xdb, 0xa6, 0x10, 0xc6, 0xe1, 0xfe, 0x7e, 0xa3, 0x34, 0x47, 0x86,
	0x3b, 0xb0, 0x10, 0x28, 0x7a, 0x34, 0xeb, 0x87, 0xdb, 0xa4, 0xde, 0x39, 0x87, 0x68, 0xd6, 0x33,
	0x2f, 0x1e, 0xda, 0xd6, 0xc6, 0x6b, 0xe4, 0x5a, 0xcc, 0xdb, 0x26, 0xf5, 0xf3, 0xdc, 0x75, 0x1c,
	0x23, 0xf5, 0xec, 0xdc, 0xf3, 0xef, 0xb0, 0x05, 0xee, 0x93, 0x14, 0x91, 0xd1, 0xff, 0x41, 0x9d,
	0xb2, 0x26, 0xe1, 0xbe, 0xdc, 0x8c, 0xfa, 0xfd, 0x95, 0xe2, 0x26, 0x2a, 0x85, 0x8c, 0x67, 0x60,
	0x33, 0xd6, 0x57, 0xf1, 0xdc, 0x28, 0x32, 0xd3, 0x6b, 0x29, 0x2e, 0xc7, 0xef, 0x1c, 0x37, 0xea,
	0x7b, 0x52, 0x79, 0x7e, 0x6a, 0x24, 0x16, 0x60, 0xf5, 0xc4, 0x0c, 0xfc, 0x2c, 0xcc, 0x3b, 0xf6,
	0xc5, 0x63, 0x7a, 0x77, 0x8a, 0x85, 0xba, 0x87, 0x63, 0xb3, 0xa9, 0xdf, 0x53, 0x69, 0x8e, 0x15,
	0xf1, 0xb7, 0x90, 0x3f, 0x9a, 0xc6, 0xed, 0x49, 0x66, 0xc6, 0x18, 0x4d, 0xbb, 0x8e, 0xc1, 0x1b,
	0x93, 0xe8, 0x01, 0xaf, 0x5d, 0x08, 0xb5, 0x36, 0x6c, 0xb1, 0x9f, 0xdb, 0xe1, 0x8d, 0xd6, 0x14,
	0xcc, 0x9b, 0xed, 0x87, 0xcd, 0x91, 0xae, 0x01, 0x7e, 0xdd, 0x1e, 0x33, 0xe6, 0x65, 0xc4, 0xa5,
	0x09, 0x0f, 0xf6, 0x2d, 0xc2, 0xff, 0x07, 0xb0, 0xc4, 0xb3, 0xa9, 0x20, 0xed, 0xf3, 0x98, 0xb0,
	0xed, 0x8a, 0x17, 0x95, 0x3d, 0xc9, 0x18, 0xf7, 0x1e, 0x78, 0x17, 0x72, 0x7a, 0x08, 0xb3, 0xf0,
	0x0e, 0x63, 0x16, 0x19, 0x03, 0xbd, 0x1c, 0x96, 0xcc, 0x8e, 0x4d, 0xca, 0x1c, 0x4c, 0x66, 0x0f,
	0x78, 0x7c, 0xf8, 0x2d, 0x62, 0xc2, 0x3f, 0xa4, 0xd8, 0xf5, 0x5d, 0xe7, 0xe4, 0xfe, 0xfc, 0x40,
	0x2f, 0xaa, 0x19, 0xfa, 0x14, 0xdb, 0xe2, 0xf7, 0x49, 0x27, 0xe1, 0x14, 0xfc, 0xae, 0x11, 0xcb,
	0x27, 0xf1, 0x8d, 0xa0, 0x3d, 0x1e, 0x98, 0xc3, 0x28, 0xde, 0xa8, 0x44, 0x8c, 0xc5, 0x83, 0xf6,
	0x4c, 0xdc, 0xae, 0x7b, 0x51, 0x2d, 0xa9, 0x6c, 0x2a, 0xc9, 0xfb, 0x02, 0xde, 0xbd, 0xbd, 0x4b,
	0xf5, 0x81, 0xb7, 0xb7, 0xc8, 0x18, 0x51, 0xb0, 0x14, 0x66, 0x30, 0x66, 0xba, 0xe3, 0x80, 0x1c,
	0x89, 0x77, 0xdd, 0xe3, 0xf1, 0x6e, 0xfe, 0xa7, 0x78, 0x00, 0xc7, 0x03, 0x5e, 0x97, 0xe2, 0x71,
	0xd4, 0x13, 0x33, 0xc6, 0x2b, 0xe2, 0x89, 0x50, 0x0f, 0x37, 0x61, 0xc6, 0x7f, 0x3a, 0xb6, 0x2b,
	0x3b, 0x92, 0x6c, 0x61, 0xfa, 0x0b, 0xc5, 0x87, 0x54, 0x63, 0x88, 0x13, 0xa2, 0x63, 0xc8, 0xf7,
	0x34, 0x5e, 0xb8, 0xd7, 0x0f, 0xe5, 0x82, 0x17, 0xa9, 0x0f, 0x6a, 0x3c, 0x7f, 0x1d, 0x2a, 0x25,
	0x93, 0x29, 0x73, 0xde, 0x1b, 0x8f, 0xe5, 0xd4, 0x2e, 0xbc, 0x5f, 0x78, 0x76, 0x53, 0x08, 0xdf,
	0xc7, 0x63, 0xb2, 0x4f, 0xad, 0x97, 0xc4, 0xed, 0x78, 0x23, 0xb6, 0x69, 0x3c, 0x1b, 0xcf, 0xc1,
	0x1e, 0x25, 0x69, 0x3b, 0xd0, 0xd8, 0xe2, 0x1c, 0x5d, 0x98, 0x8d, 0xab, 0x91, 0x26, 0xba, 0xbb,
	0xfc, 0x7e, 0x8d, 0x34, 0x6b, 0x26, 0xff, 0x47, 0x53, 0x6d, 0xb7, 0xff, 0x26, 0xb6, 0xbf, 0x8c,
	0xcf, 0xb9, 0xa4, 0x81, 0xba, 0xb5, 0x36, 0x2e, 0xc1, 0xf3, 0xe9, 0x32, 0xcc, 0x3c, 0x9d, 0xd9,
	0x8c, 0xbc, 0x8b, 0x52, 0xbc, 0x99, 0xbf, 0x01, 0xd3, 0xca, 0x43, 0xb0, 0x7b, 0xb6, 0x22, 0x62,
	0x5f, 0x86, 0x0f, 0xf1, 0xc2, 0xd2, 0x8d, 0x6a, 0xc6, 0xef, 0x11, 0xb2, 0xc3, 0xd2, 0x79, 0x44,
	0xcd, 0x5e, 0x5e, 0x82, 0x35, 0x02, 0x6f, 0x14, 0xb6, 0xc7, 0x82, 0x8e, 0xc8, 0xcc, 0xbc, 0x84,
	0xb5, 0x4c, 0x45, 0x88, 0xf1, 0x65, 0x1b, 0xf4, 0xd7, 0xf1, 0x78, 0x1b, 0x4c, 0x25, 0x2d, 0x8d,
	0xff, 0x3f, 0xc4, 0x34, 0x67, 0x43, 0xbc, 0xa9, 0x3e, 0xb8, 0xa4, 0x9c, 0x32, 0xbc, 0x4f, 0xf1,
	0xe1, 0xd9, 0x15, 0x28, 0xb7, 0xeb, 0xbd, 0x12, 0x33, 0x20, 0xbb, 0x63, 0x26, 0xac, 0x96, 0x4b,
	0xcb, 0x3b, 0x30, 0xbd, 0xdd, 0x8b, 0x6c, 0x3e, 0xcf, 0x09, 0xff, 0xf7, 0xa0, 0xdc, 0xde, 0x3c,
	0xe2, 0x2c, 0x2c, 0x01, 0xfc, 0x2d, 0xde, 0xdc, 0xed, 0x50, 0x23, 0x2d, 0x64, 0xe7, 0x76, 0xca,
	0xce, 0x2c, 0xad, 0x8d, 0x25, 0x64, 0x7f, 0xa4, 0x9a, 0x81, 0x2d, 0xc3, 0x2d, 0x14, 0xbb, 0x54,
	0x8c, 0xb8, 0x9b, 0x4a, 0xed, 0xcd, 0x93, 0x98, 0xa6, 0xe6, 0x99, 0xbc, 0x7a, 0x88, 0x2e, 0x8c,
	0x47, 0x63, 0x06, 0xbd, 0x48, 0xf0, 0x54, 0x0b, 0xc2, 0xf4, 0xb4, 0x03, 0xc5, 0x9a, 0x58, 0x30,
	0x4d, 0xaa, 0xf7, 0x85, 0xc3, 0x85, 0xb0, 0x76, 0xa3, 0x57, 0x08, 0x3f, 0xc4, 0x73, 0xa4, 0x16,
	0xfd, 0x89, 0x98, 0x88, 0x05, 0x7d, 0xa7, 0xe0, 0x35, 0x66, 0x00, 0x99, 0x8b, 0xd0, 0xf9, 0x8d,
	0x0d, 0xb1, 0x90, 0xa8, 0x0b, 0xc5, 0x2e, 0xa2, 0x17, 0x34, 0xda, 0x51, 0xdd, 0xd6, 0xf1, 0xba,
	0xec, 0xac, 0x4b, 0x9a, 0x6e, 0x2e, 0x8d, 0xf5, 0x57, 0x8a, 0x3c, 0x1f, 0x76, 0x3a, 0xde, 0x90,
	0xdd, 0x85, 0x0f, 0x54, 0x3f, 0x45, 0xa5, 0x2b, 0xd8, 0x79, 0xc1, 0x7b, 0x78, 0x9c, 0x1c, 0x80,
	0x69, 0x73, 0x27, 0x2a, 0xb5, 0x23, 0x2f, 0xe3, 0x31, 0xb0, 0x27, 0xa6, 0xcd, 0xd7, 0x86, 0xd0,
	0x19, 0xd3, 0x8d, 0xed, 0xa9, 0x76, 0x3c, 0x02, 0xa6, 0x69, 0x53, 0xb0, 0x00, 0x69, 0xd5, 0x82,
	0xfb, 0x6f, 0x62, 0xba, 0xb2, 0x1f, 0x1e, 0xab, 0xab, 0x50, 0xb9, 0x09, 0x5a, 0x03, 0x6b, 0x24,
	0x8e, 0x27, 0x13, 0x6c, 0xbd, 0x8d, 0xf9, 0xad, 0x01, 0x35, 0xde, 0xe7, 0xf7, 0xe1, 0x7d, 0xae,
	0xa5, 0x52, 0x6b, 0x3c, 0x0d, 0xd3, 0xaf, 0xad, 0x80, 0x3b, 0xdb, 0x63, 0xe2, 0x51, 0xb6, 0xab,
	0xef, 0x85, 0x89, 0xf5, 0xd0, 0xf0, 0xff, 0x24, 0xdc, 0x09, 0xbd, 0xc2, 0xfd, 0x4e, 0xa1, 0xf2,
	0x3f, 0x4e, 0xf2, 0x4c, 0x0c, 0xbf, 0xf9, 0x5d, 0x78, 0x6f, 0xac, 0x2a, 0x89, 0x07, 0x0c, 0x66,
	0x62, 0xc2, 0x1b, 0x77, 0x7f, 0xef, 0x63, 0xe6, 0xa6, 0x5b, 0x92, 0x47, 0xa1, 0xf2, 0x53, 0x70,
	0x23, 0x8c, 0x2c, 0xa9, 0xe7, 0xf3, 0x14, 0x0f, 0x84, 0x95, 0x92, 0xfb, 0x0b, 0x02, 0x9d, 0xa9,
	0x94, 0x24, 0xe6, 0x4d, 0x5a, 0xc0, 0x4c, 0x5a, 0x7a, 0xc0, 0x6b, 0x03, 0xdc, 0xfe, 0x8d, 0x7a,
	0x36, 0xb8, 0x00, 0xab, 0xe6, 0xf2, 0x92, 0xab, 0xf3, 0xa8, 0x3e, 0x70, 0xf4, 0x39, 0x9e, 0x9c,
	0x6b, 0x61, 0x46, 0xb8, 0x17, 0x95, 0x92, 0xca, 0x5e, 0x98, 0xc0, 0x0f, 0xc9, 0xe5, 0x5b, 0x0d,
	0xab, 0x80, 0x1f, 0xa0, 0x9a, 0x29, 0xfc, 0x36, 0x95, 0x1b, 0x89, 0x81, 0x58, 0x7a, 0x37, 0x2c,
	0x89, 0x5b, 0x8b, 0xca, 0x05, 0xf7, 0xd9, 0xf0, 0x9b, 0x97, 0xb2, 0x82, 0x17, 0xb0, 0x27, 0x30,
	0x33, 0x9a, 0x6f, 0x3f, 0x70, 0xfb, 0xa4, 0xea, 0xd6, 0x59, 0x98, 0x20, 0x6f, 0x8d, 0x19, 0x94,
	0x89, 0xd4, 0x3f, 0x4c, 0x1b, 0xb1, 0x75, 0x48, 0xbf, 0x3d, 0x5e, 0x08, 0x4e, 0x26, 0xdb, 0x1c,
	0x82, 0x0f, 0x3b, 0xce, 0xce, 0xe5, 0x99, 0x4a, 0x26, 0xfd, 0x7d, 0x3b, 0xa9, 0x4b, 0x1f, 0xbc,
	0x81, 0x99, 0x8b, 0xd5, 0xe8, 0x27, 0xe1, 0x83, 0x2e, 0x51, 0x0b, 0xb5, 0x28, 0x96, 0x9a, 0x6d,
	0x42, 0xd6, 0xee, 0x9b, 0x62, 0xe6, 0xbf, 0x51, 0xaf, 0x2d, 0x9f, 0x62, 0x29, 0xfb, 0xd0, 0x90,
	0xb7, 0xc8, 0x47, 0xf0, 0xb9, 0x54, 0x9b, 0x36, 0xe5, 0xd1, 0x0e, 0xab, 0xdf, 0x6f, 0xa7, 0x5a,
	0xc2, 0x92, 0xc7, 0x52, 0x54, 0x1f, 0xac, 0x2e, 0xc3, 0x59, 0x78, 0x21, 0xdd, 0xb5, 0xc1, 0xf4,
	0x0b, 0x0a, 0x73, 0x93, 0xdf, 0xdf, 0xe0, 0xf6, 0xde, 0xb2, 0x3c, 0x79, 0x05, 0x4e, 0xa2, 0xd8,
	0x73, 0xd0, 0x6c, 0xbc, 0xa9, 0xec, 0x8f, 0x0f, 0x42, 0x35, 0xe2, 0xf9, 0x26, 0xc5, 0xa3, 0x78,
	0x21, 0x3f, 0x04, 0xcf, 0x97, 0x88, 0x8b, 0x43, 0xdd, 0xd6, 0x29, 0xc8, 0x73, 0x30, 0xd9, 0xb7,
	0x00, 0x1a, 0xc1, 0x1d, 0x78, 0x9e, 0x17, 0x49, 0xf3, 0xb6, 0xc5, 0xe3, 0x29, 0xef, 0xad, 0x24,
	0xc5, 0x68, 0xac, 0xdd, 0xea, 0x95, 0xc4, 0xcd, 0xa2, 0xd2, 0xdb, 0xcc, 0xe7, 0x64, 0x07, 0xa3,
	0x9a, 0x83, 0x47, 0xf1, 0x7c, 0x4d, 0xeb, 0xb6, 0x50, 0x88, 0x2b, 0xa3, 0x7d, 0xaf, 0x87, 0x3a,
	0x9d, 0x84, 0x17, 0xbf, 0x5a, 0x07, 0xae, 0x6e, 0x0f, 0xf5, 0xdc, 0x88, 0x4a, 0x09, 0xe0, 0x75,
	0x58, 0x2a, 0xd8, 0x0d, 0xd3, 0xb4, 0x22, 0xc4, 0x8d, 0xf5, 0x04, 0xdc, 0xc7, 0x8f, 0x61, 0xad,
	0x5a, 0x4b, 0x0f, 0x34, 0xb7, 0xc3, 0xc2, 0x82, 0xf8, 0xcd, 0x80, 0x14, 0x77, 0x54, 0xa5, 0xce,
	0x70, 0x1b, 0xb5, 0x37, 0xee, 0xd3, 0xa9, 0x96, 0x2a, 0x37, 0x47, 0xda, 0x19, 0x71, 0x00, 0x1e,
	0x8b, 0x3b, 0x61, 0xba, 0x9b, 0xa7, 0x79, 0xf5, 0x10, 0x85, 0x12, 0x4f, 0x52, 0xee, 0x87, 0x7d,
	0x22, 0x99, 0xe9, 0x49, 0x19, 0x9e, 0xa4, 0xf1, 0x79, 0x99, 0x47, 0x0f, 0xbc, 0xe9, 0xee, 0x49,
	0x26, 0xe8, 0xf9, 0x47, 0x0b, 0xcb, 0x6a, 0x2e, 0xae, 0xc5, 0xc2, 0x9d, 0xd3, 0x30, 0xad, 0x58,
	0xb3, 0x76, 0xf2, 0xf9, 0x8e, 0x47, 0xa9, 0xa6, 0x1f, 0xf1, 0xf0, 0xed, 0x78, 0x6a, 0x23, 0xf6,
	0x65, 0x23, 0xfd, 0x55, 0x0b, 0xfb, 0xe0, 0xf9, 0xb3, 0x3f, 0x3e, 0x40, 0xbe, 0x1c, 0x8d, 0xad,
	0x73, 0x73, 0xa9, 0xbf, 0x81, 0x00, 0x0b, 0x5c, 0x36, 0xc6, 0x6b, 0xec, 0x75, 0x05, 0xf7, 0xaf,
	0xc4, 0x9b, 0xf0, 0x3e, 0x98, 0x16, 0xcc, 0xc0, 0xbc, 0xd7, 0x11, 0x98, 0x6e, 0x14, 0xd1, 0x8e,
	0xb3, 0x71, 0xff, 0x3d, 0x84, 0xf9, 0x97, 0xa2, 0x03, 0xd1, 0x97, 0x62, 0xfa, 0xb0, 0x2f, 0x95,
	0x82, 0xb7, 0x76, 0x58, 0xeb, 0x3f, 0x9e, 0xcc, 0xe4, 0xf9, 0xfc, 0xf0, 0xfb, 0x01, 0xb5, 0xad,
	0x35, 0xba, 0x50, 0x5b, 0x08, 0x08, 0xb8, 0x51, 0x26, 0x51, 0xdb, 0xe6, 0x33, 0x75, 0x9d, 0xd8,
	0x8d, 0x4a, 0xd5, 0xf7, 0x6c, 0xcc, 0x88, 0xa5, 0x8b, 0xd9, 0xd6, 0x98, 0x80, 0xa7, 0x44, 0x68,
	0x49, 0x2c, 0xad, 0x4c, 0x3f, 0x38, 0x74, 0x2f, 0x1e, 0xd4, 0xab, 0x63, 0x26, 0x7c, 0x34, 0x66,
	0x34, 0xfa, 0x52, 0x79, 0xf2, 0x7e, 0xad, 0xf0, 0x9c, 0xe9, 0xb8, 0x31, 0x8a, 0x70, 0x1f, 0xc5,
	0x92, 0xc5, 0x1e, 0x21, 0x6f, 0x6b, 0xef, 0xa6, 0x9f, 0x20, 0xb3, 0x05, 0xcb, 0xc7, 0x4f, 0xc1,
	0x0c, 0x66, 0x3b, 0x2c, 0x7d, 0xc9, 0x13, 0xe3, 0x0b, 0xb1, 0xb4, 0x36, 0x4a, 0x07, 0x0e, 0xc2,
	0xa6, 0x24, 0xf5, 0xec, 0xfe, 0xc1, 0x4c, 0xd8, 0xb2, 0x98, 0x38, 0x74, 0xcf, 0x85, 0x15, 0x70,
	0xfb, 0xc6, 0x81, 0xde, 0x0d, 0x0f, 0xa8, 0x7a, 0xb6, 0xf2, 0x2f, 0x50, 0x29, 0x05, 0xdb, 0x0a,
	0x4b, 0xba, 0x7f, 0x87, 0x4d, 0x2b, 0xba, 0x93, 0x9d, 0x9c, 0x5e, 0x01, 0x7b, 0x6a, 0x88, 0x65,
	0x76, 0xc2, 0xbb, 0xc6, 0x2b, 0xa8, 0x34, 0x47, 0x19, 0x15, 0xd2, 0x45, 0x26, 0xa4, 0x1f, 0x5e,
	0xcc, 0x6f, 0x4a, 0xd2, 0x2c, 0x8c, 0x37, 0x7a, 0x5b, 0x92, 0xd9, 0x18, 0xa6, 0xed, 0x17, 0x31,
	0x16, 0x13, 0x8f, 0x3c, 0xd3, 0xfe, 0x32, 0xde, 0xfc, 0x1c, 0x4b, 0xe3, 0x3b, 0xfe, 0x2f, 0xb0,
	0xfa, 0x6a, 0x57, 0x8a, 0x25, 0x88, 0x4f, 0x93, 0x7d, 0x6c, 0x2b, 0xe2, 0x2e, 0x3c, 0x1e, 0x97,
	0xc1, 0x12, 0xa6, 0x55, 0xf1, 0x22, 0x30, 0x0b, 0xb7, 0xf7, 0xdd, 0x58, 0x2b, 0x74, 0x3c, 0x95,
	0xb6, 0xa7, 0x7d, 0xb0, 0x1a, 0x3e, 0xad, 0xdb, 0x2c, 0xac, 0xed, 0xa8, 0x65, 0xda, 0x12, 0xb1,
	0x2e, 0xde, 0xb1, 0xff, 0x19, 0x33, 0x2f, 0x27, 0xe0, 0x7e, 0x4f, 0x17, 0xb3, 0x8e, 0xd4, 0xf6,
	0xbe, 0x02, 0x66, 0xb6, 0x87, 0x61, 0x4d, 0x55, 0xfd, 0x0f, 0x1f, 0x54, 0x6e, 0x8e, 0xeb, 0xe1,
	0x49, 0xcc, 0x6c, 0x5e, 0x81, 0xc7, 0x50, 0x2a, 0x71, 0xad, 0xf7, 0x7e, 0xad, 0x81, 0x46, 0xfa,
	0xfd, 0x46, 0x4c, 0x7c, 0x1b, 0x35, 0xc3, 0xa8, 0xf5, 0xd1, 0x97, 0xbf, 0xe0, 0xf9, 0x37, 0x99,
	0x96, 0x9d, 0xcc, 0x3f, 0x1b, 0x8f, 0x97, 0x74, 0x31, 0xba, 0x0d, 0x2f, 0x3c, 0xd7, 0x60, 0x0d,
	0x12, 0x98, 0x76, 0x1c, 0x89, 0x19, 0x8e, 0x5a, 0x12, 0x98, 0x3c, 0xce, 0xc5, 0x1b, 0xdc, 0x7c,
	0x9e, 0xce, 0xd8, 0xdc, 0xe0, 0x42, 0xb2, 0xb3, 0x07, 0x45, 0x18, 0x83, 0xe7, 0x48, 0xde, 0x8e,
	0x39, 0x1d, 0x63, 0x2b, 0xe1, 0xf9, 0xdc, 0x5c, 0x8d, 0xc8, 0xe9, 0x78, 0xee, 0x8c, 0xc0, 0xcc,
	0xf2, 0x96, 0xf8, 0x9d, 0x97, 0xa7, 0xda, 0x0b, 0x47, 0x8a, 0xcb, 0xb1, 0x14, 0xba, 0x96, 0x57,
	0x18, 0xb0, 0xa6, 0xe6, 0x23, 0xaa, 0xe9, 0xed, 0xbd, 0x98, 0x36, 0x95, 0x6d, 0x00, 0x3a, 0x61,
	0xc1, 0x4f, 0xdc, 0xe0, 0x7e, 0x81, 0xdb, 0xbe, 0x3b, 0x56, 0x7b, 0xb7, 0x04, 0x03, 0xb1, 0xfd,
	0xf8, 0x40, 0x2a, 0x25, 0x8c, 0xed, 0xa9, 0x6d, 0x66, 0xf0, 0x0e, 0xd6, 0xcc, 0xad, 0x57, 0x23,
	0x4d, 0x6b, 0x20, 0xda, 0xd0, 0xc6, 0xcd, 0x47, 0xb4, 0x0f, 0x2e, 0x33, 0xf5, 0xd8, 0x8a, 0x8c,
	0xd9, 0xd8, 0x0a, 0x9b, 0xc4, 0x9c, 0x15, 0xc2, 0x76, 0x54, 0x32, 0x61, 0x3f, 0xc2, 0xed, 0x36,
	0x14, 0x8f, 0xa3, 0x48, 0xaf, 0x16, 0xa5, 0xda, 0x93, 0xd5, 0x69, 0xa1, 0xbc, 0x54, 0x1b, 0xb0,
	0x3a, 0xf5, 0x5d, 0x7e, 0x82, 0xdb, 0x71, 0x21, 0xca, 0x3f, 0x50, 0xb8, 0x20, 0x70, 0x0e, 0xe6,
	0x87, 0xca, 0xce, 0x1c, 0x2c, 0x28, 0x9c, 0x82, 0xfb, 0x24, 0xf2, 0x40, 0x1d, 0xb1, 0xe0, 0xe9,
	0x6e, 0x2a, 0x2d, 0x11, 0xc0, 0x9b, 0xd7, 0xd8, 0xcf, 0x3d, 0xc9, 0xfa, 0xf2, 0x3c, 0xdc, 0x5f,
	0xd1, 0xac, 0x6d, 0x09, 0x1a, 0x77, 0x51, 0x0c, 0xfe, 0xe0, 0x5a, 0x14, 0x86, 0x46, 0x33, 0xbc,
	0x74, 0x33, 0xfc, 0x31, 0x99, 0xc5, 0x40, 0xba, 0x96, 0xbf, 0x48, 0x26, 0xac, 0x6c, 0x87, 0x4d,
	0xb5, 0x8a, 0xe8, 0xfa, 0x83, 0x98, 0x57, 0xfd, 0x25, 0xc5, 0x9b, 0xb0, 0x6b, 0x31, 0x6d, 0x7e,
	0x9d, 0x4c, 0x70, 0xf0, 0x37, 0xfc, 0x0e, 0x37, 0x15, 0xa4, 0xdf, 0x1d, 0xcf, 0xcd, 0xd1, 0x78,
	0xfc, 0x6d, 0x4e, 0xf1, 0x17, 0x5d, 0x6f, 0xc3, 0xbc, 0xe7, 0x50, 0x2a, 0x2d, 0x15, 0x06, 0x62,
	0x3a, 0x36, 0x20, 0xd4, 0xb7, 0x23, 0xcd, 0xa3, 0xd5, 0xf5, 0x11, 0x4e, 0x9f, 0xa6, 0x5e, 0x08,
	0xf2, 0xe1, 0xb7, 0xc9, 0x89, 0xd6, 0xdf, 0xcb, 0x5e, 0x3f, 0xd2, 0xfb, 0x6b, 0xc8, 0xa7, 0x82,
	0x47, 0x85, 0x13, 0xba, 0x13, 0x94, 0x79, 0xfb, 0x88, 0xe1, 0x12, 0x65, 0x1f, 0x03, 0x8a, 0x61,
	0x65, 0x49, 0x8f, 0xc8, 0x1f, 0xcc, 0x38, 0x31, 0x89, 0x3f, 0x4c, 0xf6, 0x0c, 0x30, 0x41, 0xf6,
	0xfe, 0x71, 0xb9, 0x7c, 0x4a, 0x79, 0x4d, 0x65, 0x1f, 0xb9, 0x39, 0x23, 0x57, 0x56, 0x77, 0xf9,
	0xb4, 0xfe, 0x46, 0xb9, 0xf8, 0x5b, 0xe5, 0x0f, 0xc0, 0xb4, 0xe4, 0x44, 0x7b, 0xad, 0xf0, 0x5a,
	0x38, 0x9d, 0x9b, 0x8f, 0xbf, 0x37, 0x9c, 0xf0, 0xed, 0xac, 0xda, 0x1f, 0x96, 0xd8, 0x25, 0xbc,
	0xdf, 0x78, 0xd9, 0x5b, 0x48, 0x3c, 0x45, 0xbc, 0xb6, 0xec, 0x35, 0xe5, 0x8d, 0x70, 0xc2, 0xf7,
	0x53, 0xf9, 0x94, 0x76, 0x3c, 0x55, 0x5f, 0x0b, 0xf1, 0x63, 0x38, 0xa3, 0xe4, 0x8f, 0x4d, 0x3c,
	0x2e, 0x7f, 0xc8, 0x26, 0xfd, 0x30, 0x4c, 0x0c, 0x43, 0x42, 0x1e, 0xe4, 0x0f, 0x73, 0x5c, 0x15,
	0xda, 0xfa, 0xc1, 0x90, 0x37, 0xed, 0xbf, 0x3e, 0xa1, 0x0e, 0xf7, 0xcb, 0xde, 0x12, 0x8e, 0x4b,
	0xca, 0x3c, 0x34, 0x94, 0x93, 0xff, 0xb8, 0x54, 0xd7, 0xd0, 0xee, 0xcf, 0xcb, 0x27, 0xfd, 0xc7,
	0xc9, 0x1f, 0x4b, 0x21, 0xb4, 0xcd, 0x89, 0xf2, 0x49, 0xf8, 0x43, 0x55, 0x79, 0xd2, 0x3d, 0x6d,
	0xbf, 0x18, 0x17, 0x4f, 0xf8, 0xaf, 0xa6, 0xe2, 0xb6, 0x6c, 0xcd, 0x30, 0x41, 0xfe, 0x78, 0x4e,
	0x1a, 0xb7, 0xaa, 0x7c, 0xf2, 0x7a, 0x64, 0x49, 0x5b, 0x16, 0x85, 0x61, 0xb2, 0xe7, 0xa2, 0x09,
	0x92, 0x4e, 0x4a, 0xe2, 0xcf, 0x93, 0x34, 0x31, 0xbc, 0xcf, 0x58, 0xf9, 0x83, 0x42, 0x7b, 0x85,
	0x36, 0x97, 0xec, 0xc5, 0x63, 0x8c, 0xb2, 0xb1, 0x31, 0x28, 0xd7, 0x3e, 0xbd, 0xe4, 0x53, 0xf8,
	0x0f, 0x86, 0x74, 0x93, 0xe5, 0xb9, 0xb7, 0x71, 0x41, 0x39, 0x4d, 0x21, 0xdc, 0x2f, 0x7b, 0x24,
	0x48, 0x3f, 0xa6, 0xd1, 0x2f, 0x94, 0x2f, 0xd9, 0x3b, 0xc5, 0x93, 0x49, 0x78, 0x31, 0xc4, 0x0f,
	0x90, 0xbd, 0xc4, 0x48, 0xf6, 0x4c, 0x31, 0x59, 0x99, 0xe7, 0x9f, 0x7c, 0xd8, 0x58, 0x3e, 0xd5,
	0xfe, 0x8a, 0xdc, 0x7f, 0x4f, 0x87, 0xeb, 0xe8, 0x51, 0x27, 0xad, 0xdb, 0x34, 0x55, 0x7a, 0x7f,
	0xfa, 0x7b, 0xf2, 0x9c, 0x07, 0x42, 0xda, 0x7e, 0xca, 0x3c, 0x28, 0xbc, 0x2d, 0x8f, 0x8b, 0xfc,
	0x33, 0x25, 0xe9, 0xd8, 0xdc, 0x3b, 0xe5, 0xf3, 0x2c, 0x24, 0x7b, 0x02, 0x9a, 0x1a, 0xe2, 0x1f,
	0x93, 0xbd, 0x1f, 0xd4, 0x7a, 0xff, 0x4f, 0xe5, 0xf9, 0xb1, 0x83, 0x3c, 0x87, 0x3e, 0x0f, 0xe5,
	0xc6, 0x8f, 0x18, 0xdd, 0xa6, 0x8c, 0x96, 0x5d, 0x24, 0x7b, 0xa4, 0x92, 0xec, 0x3d, 0x60, 0x5f,
	0xd9, 0x03, 0xc2, 0x23, 0x21, 0xdf, 0xd3, 0x92, 0x8e, 0xca, 0xd5, 0xfb, 0x5b, 0xa1, 0x8d, 0xf2,
	0xef, 0x73, 0x50, 0x78, 0xff, 0xb1, 0x21, 0xff, 0x30, 0x55, 0x7e, 0x5c, 0xeb, 0xa7, 0xca, 0xbc,
	0x47, 0x4c, 0x0d, 0xf5, 0x58, 0xaa, 0xa0, 0x9c, 0x9d, 0x24, 0xbd, 0x2b, 0x7f, 0x8c, 0x68, 0xe5,
	0x50, 0x9f, 0x26, 0x99, 0x16, 0x2d, 0x12, 0xd2, 0xfc, 0x2c, 0xb4, 0x45, 0x6c, 0xab, 0x26, 0x65,
	0x1e, 0x1c, 0xce, 0x95, 0x3d, 0xf2, 0x8c, 0x91, 0x69, 0xca, 0x51, 0xf2, 0xfc, 0x1d, 0x23, 0x8f,
	0xa5, 0x09, 0xf2, 0x07, 0xe7, 0xd2, 0xb9, 0x70, 0x48, 0xae, 0xbc, 0xd1, 0xaa, 0xf4, 0x8c, 0x10,
	0xc3, 0x76, 0xe1, 0xfd, 0x3e, 0x96, 0xbd, 0x7c, 0x8c, 0x55, 0xa5, 0x47, 0x85, 0xa2, 0xb0, 0x58,
	0x28, 0xb3, 0xa8, 0xbc, 0x7c, 0xb8, 0x59, 0x52, 0xcf, 0x82, 0xf8, 0xe1, 0x72, 0x9f, 0xe7, 0xe3,
	0x2f, 0x91, 0x3d, 0x9f, 0xbc, 0xa7, 0xcc, 0x43, 0xc8, 0xa6, 0xa1, 0x1f, 0xe6, 0x84, 0x7a, 0x8e,
	0x96, 0x69, 0x40, 0x9a, 0xef, 0xd8, 0xdc, 0xfb, 0xde, 0x27, 0x7b, 0x70, 0x89, 0xf7, 0x67, 0x4a,
	0xfa, 0x4c, 0x95, 0xe3, 0xea, 0x49, 0x65, 0x9e, 0x2e, 0xa4, 0x72, 0xaf, 0x36, 0xe9, 0x07, 0xeb,
	0xd2, 0xb1, 0x5e, 0x96, 0xbe, 0x25, 0x61, 0x49, 0xd9, 0x73, 0xd7, 0x9b, 0xb2, 0x67, 0x9b, 0x01,
	0xe1, 0xfd, 0xff, 0xad, 0xcc, 0xb3, 0xd8, 0x9a, 0xca, 0xe6, 0xc8, 0xd9, 0xb2, 0x37, 0x89, 0xb1,
	0xb2, 0xe7, 0x8c, 0xfd, 0x92, 0xb2, 0xf6, 0x96, 0x69, 0xda, 0xe3, 0xb2, 0x27, 0xab, 0x33, 0xe5,
	0x8f, 0x32, 0x21, 0xd3, 0xaf, 0x97, 0xe4, 0xf1, 0xf3, 0xf7, 0x70, 0x4f, 0xb2, 0x67, 0xa1, 0xf8,
	0x71, 0xb5, 0x9f, 0xc8, 0xeb, 0xcb, 0x24, 0x79, 0x4c, 0x5f, 0x22, 0x8f, 0xbb, 0xf5, 0xe5, 0xf1,
	0x16, 0xdb, 0xf8, 0x9f, 0xb9, 0x77, 0x58, 0x2e, 0x94, 0xf3, 0x86, 0x3c, 0x7e, 0x47, 0x87, 0xfc,
	0xc7, 0xca, 0x34, 0x73, 0x8d, 0xf0, 0x5c, 0x85, 0xf7, 0x8c, 0xf3, 0x61, 0x6c, 0x12, 0x77, 0xb4,
	0xec, 0x79, 0x2b, 0xd2, 0x87, 0xcb, 0x73, 0xcf, 0x18, 0x12, 0xe2, 0x09, 0xf5, 0x6d, 0x0a, 0xd7,
	0xd3, 0x64, 0x5e, 0x08, 0xd9, 0xdb, 0x86, 0xe4, 0x31, 0xb0, 0xb2, 0x4c, 0x1b, 0xa2, 0x97, 0x93,
	0xd7, 0xe4, 0xb5, 0x3b, 0x7d, 0xee, 0xb4, 0xd0, 0x66, 0x07, 0x2a, 0xa3, 0x7b, 0xf7, 0xc9, 0x73,
	0x73, 0x74, 0xae, 0x6e, 0x45, 0xf5, 0x5d, 0x2d, 0xf7, 0x5e, 0x47, 0x87, 0x7a, 0xf4, 0x96, 0xe7,
	0xe8, 0x58, 0x79, 0x8e, 0xfe, 0x49, 0x95, 0xeb, 0x68, 0x1c, 0x47, 0xd7, 0xca, 0xf4, 0x77, 0x9c,
	0xdc, 0x97, 0xe9, 0x47, 0xd2, 0x8e, 0x92, 0x69, 0x78, 0x93, 0x3c, 0x1e, 0x2e, 0x4c, 0xde, 0x1f,
	0x99, 0xa7, 0x89, 0xeb, 0xf1, 0x6b, 0xf2, 0x07, 0xca, 0xe2, 0xbd, 0xe8, 0x5d, 0x6c, 0x9c, 0xec,
	0x15, 0x29, 0xff, 0x11, 0xae, 0xe3, 0x64, 0xba, 0x74, 0x8f, 0xa4, 0x81, 0x49, 0xfc, 0xae, 0x32,
	0x0d, 0x1e, 0x2f, 0xb7, 0x7f, 0x6f, 0x79, 0x6e, 0xdd, 0xa5, 0x8c, 0x67, 0x88, 0xe1, 0x08, 0x55,
	0xf7, 0x51, 0x1a, 0x6e, 0x51, 0xa5, 0xe7, 0xc1, 0x8e, 0xf2, 0x5a, 0x98, 0xf7, 0xf0, 0x74, 0x81,
	0xfc, 0x21, 0xc4, 0x07, 0x65, 0xde, 0x71, 0xa8, 0xbc, 0xc6, 0x7f, 0xac, 0x4a, 0xef, 0x2c, 0x31,
	0xfc, 0xaf, 0xb2, 0x8f, 0x28, 0xc6, 0xf0, 0xbe, 0x3c, 0x6e, 0x6e, 0x0a, 0xe1, 0xae, 0x5c, 0x5b,
	0xe5, 0xff, 0x0f, 0xa9, 0x71, 0x5d, 0x18, 0xda, 0x49, 0xcd, 0x31, 0x33, 0xaa, 0x8b, 0x29, 0x14,
	0xdb, 0xee, 0xac, 0xc5, 0xfc, 0x37, 0x2d, 0x89, 0x36, 0xcb, 0x07, 0x86, 0xdf, 0x35, 0xb1, 0xca,
	0x6f, 0x23, 0x5a, 0xf7, 0x70, 0x02, 0xa1, 0xcc, 0xeb, 0xa8, 0x3e, 0xec, 0x96, 0xe2, 0x34, 0x2c,
	0x0d, 0x3f, 0xbf, 0x46, 0x9a, 0x6f, 0x22, 0x3a, 0xe2, 0xf6, 0x8b, 0x9f, 0x4f, 0xaf, 0x87, 0xa5,
	0xf1, 0x8e, 0x79, 0x15, 0xbe, 0xbc, 0x8f, 0xda, 0x6c, 0x87, 0x25, 0x77, 0xe3, 0xb1, 0x84, 0x2d,
	0xda, 0x99, 0x2f, 0x82, 0xa5, 0x05, 0x65, 0xea, 0xf2, 0x36, 0xcc, 0x1f, 0x2c, 0x89, 0xcd, 0xe0,
	0x7a, 0x52, 0x2d, 0x19, 0x6a, 0x83, 0xb5, 0x9d, 0x83, 0xb0, 0x46, 0xf3, 0x19, 0x2c, 0xe1, 0x1b,
	0xce, 0x7f, 0xc6, 0x47, 0xa1, 0xda, 0x60, 0xba, 0x77, 0x2a, 0xc5, 0x1f, 0xb9, 0x5b, 0x07, 0xaf,
	0x65, 0x9b, 0x37, 0x98, 0x3e, 0xa2, 0xa9, 0xc6, 0xbd, 0x5e, 0xcd, 0xa9, 0xdc, 0x57, 0x04, 0xbb,
	0xe2, 0xc3, 0x78, 0xdb, 0x63, 0x4d, 0x7d, 0x3b, 0x2c, 0x0d, 0xbd, 0x11, 0x4b, 0x30, 0xeb, 0x7d,
	0xbc, 0xab, 0x11, 0x9c, 0x8a, 0xcd, 0xe2, 0xbe, 0x2e, 0x1f, 0x22, 0x6a, 0x64, 0x1c, 0xa5, 0x18,
	0x82, 0xa5, 0xf2, 0x65, 0xfe, 0xef, 0xbf, 0x29, 0xe8, 0x8b, 0xa5, 0xfe, 0x17, 0xd7, 0x4b, 0x98,
	0x60, 0x26, 0xd6, 0x02, 0x4d, 0xa7, 0xb2, 0xdd, 0x97, 0xc3, 0x1a, 0xb2, 0x23, 0xa9, 0xc3, 0x1b,
	0x2e, 0xa8, 0x8f, 0x84, 0x2c, 0x08, 0x9b, 0xef, 0xa3, 0xb1, 0xcd, 0xd3, 0xfa, 0xd8, 0x7e, 0xea,
	0x0c, 0x3c, 0xb1, 0x5a, 0x9b, 0x31, 0x07, 0xdb, 0x5d, 0x5f, 0x55, 0x27, 0xcd, 0xae, 0x64, 0x5f,
	0x98, 0x6c, 0x43, 0x86, 0xcf, 0x71, 0x3f, 0x35, 0x8a, 0xa3, 0xb1, 0x6d, 0xe1, 0x97, 0xc9, 0x58,
	0xdc, 0x8b, 0xd5, 0xdc, 0x87, 0xe1, 0x03, 0x7d, 0x8b, 0xe1, 0x83, 0x60, 0xaf, 0x52, 0x69, 0x6b,
	0xdf, 0x86, 0xf9, 0x87, 0x45, 0x31, 0x1d, 0x99, 0x81, 0xdd, 0x8a, 0xdd, 0x4c, 0x1b, 0x63, 0x5e,
	0x86, 0x57, 0xf0, 0x59, 0xa1, 0xfd, 0x70, 0x1b, 0xb5, 0x8d, 0xd1, 0xff, 0x3c, 0x0c, 0xc2, 0x26,
	0x20, 0x83, 0xc9, 0x36, 0xfb, 0xe0, 0xf3, 0x39, 0x4b, 0xe1, 0x73, 0x2c, 0xc7, 0x90, 0x7d, 0xc8,
	0xad, 0x1e, 0x7a, 0xb5, 0x66, 0xe5, 0xbe, 0x02, 0xb8, 0x0c, 0x9b, 0xb9, 0xc6, 0xc3, 0xb0, 0x22,
	0xf3, 0x8c, 0xd5, 0x5a, 0x26, 0x75, 0xdf, 0xa2, 0xdc, 0x83, 0x55, 0x1b, 0xbe, 0x39, 0xd8, 0x87,
	0x4c, 0xe8, 0xdb, 0x28, 0x8e, 0xc1, 0xde, 0xa1, 0x52, 0x07, 0x0c, 0x43, 0xb1, 0x49, 0xeb, 0x75,
	0x34, 0xb0, 0x79, 0x6c, 0x6d, 0xc9, 0xf9, 0x97, 0x8d, 0x75, 0xf0, 0xe1, 0xa1, 0x8b, 0xf0, 0xa9,
	0xd7, 0x5f, 0xd5, 0x4e, 0xde, 0x22, 0xfc, 0x00, 0xdb, 0x17, 0xef, 0x4d, 0xe5, 0x61, 0xc2, 0x36,
	0xb4, 0x2e, 0x16, 0xc1, 0x5f, 0x44, 0x9b, 0x45, 0xb5, 0x5f, 0xf5, 0x36, 0x7c, 0x33, 0x31, 0x08,
	0x6f, 0x92, 0x1e, 0xc1, 0x2e, 0xad, 0xda, 0x24, 0xc1, 0xb5, 0x71, 0x3a, 0x76, 0x7f, 0xb8, 0x09,
	0x95, 0x2e, 0x3e, 0xdb, 0xd0, 0x86, 0xaf, 0x3a, 0x9e, 0xc4, 0x0c, 0xf9, 0x8e, 0x58, 0x43, 0xbd,
	0x18, 0xb6, 0x9b, 0xee, 0x8d, 0xc7, 0x7b, 0xde, 0xfd, 0x68, 0xa3, 0x38, 0x04, 0x1f, 0x98, 0x3d,
	0x19, 0x9f, 0xa5, 0xb9, 0x98, 0xca, 0xb3, 0x72, 0x5f, 0x65, 0xb4, 0x49, 0xce, 0x1b, 0x43, 0x7b,
	0x7c, 0x10, 0xf4, 0x0b, 0x3c, 0xce, 0x16, 0xa3, 0x79, 0x1e, 0xbf, 0xf2, 0x68, 0x6e, 0xbb, 0x03,
	0x5f, 0xfe, 0xe7, 0xb5, 0x5b, 0x1b, 0xcf, 0x62, 0x37, 0x36, 0x8d, 0xf8, 0x3b, 0x6d, 0x09, 0xe2,
	0xc7, 0x93, 0xda, 0x18, 0xf3, 0xf9, 0x8f, 0xb9, 0x58, 0xbd, 0xfb, 0x44, 0xbd, 0x84, 0x6d, 0xf8,
	0xc6, 0xa0, 0xa5, 0x1f, 0x02, 0xfb, 0xa6, 0xe2, 0x14, 0x4c, 0xb3, 0x1e, 0xc4, 0x5a, 0x87, 0x67,
	0xa8, 0xfe, 0xb4, 0x79, 0x1b, 0xda, 0xf0, 0x55, 0xc4, 0x8f, 0xb1, 0x66, 0xfc, 0x9f, 0xf8, 0x5b,
	0x18, 0x71, 0xcd, 0xdf, 0x94, 0x96, 0x33, 0xe6, 0x60, 0x49, 0xfc, 0xba, 0xd8, 0x75, 0x7e, 0x25,
	0xe2, 0x26, 0x00, 0x00, 0x00, 0x32, 0x49, 0x44, 0x41, 0x54, 0xea, 0x65, 0x54, 0x3b, 0x08, 0xf8,
	0x2a, 0x62, 0x6f, 0xec, 0x38, 0x01, 0xec, 0xbd, 0x64, 0x43, 0xec, 0xb0, 0xa1, 0x16, 0xae, 0x26,
	0x73, 0xcc, 0xf1, 0x10, 0x16, 0x8c, 0x7c, 0x53, 0xd6, 0x62, 0x61, 0xcd, 0x55, 0x4f, 0xcc, 0xa0,
	0x1f, 0x5a, 0x3b, 0xf9, 0xfc, 0xc1, 0xff, 0x01, 0xf4, 0x4f, 0x9a, 0x26, 0x12, 0xca, 0xbf, 0xd8,
	0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static int source_serif_pro_regular_12_png_len = 8348;

static BYTE source_serif_pro_regular_12_xml[] = {
	0x3c, 0x3f, 0x78, 0x6d, 0x6c, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x31,
	0x2e, 0x30, 0x22, 0x20, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x75, 0x74,
	0x66, 0x2d, 0x38, 0x22, 0x3f, 0x3e, 0x0a, 0x3c, 0x46, 0x6f, 0x6e, 0x74, 0x20, 0x73, 0x69, 0x7a,
	0x65, 0x3d, 0x22, 0x31, 0x32, 0x22, 0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x3d, 0x22, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x53, 0x65, 0x72, 0x69, 0x66, 0x20, 0x50, 0x72, 0x6f, 0x22,
	0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x32, 0x30, 0x22, 0x20, 0x73, 0x74, 0x79,
	0x6c, 0x65, 0x3d, 0x22, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x22, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x34, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x31, 0x35, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x30, 0x20, 0x31, 0x33, 0x20, 0x30, 0x20, 0x30, 0x22, 0x20, 0x63, 0x6f, 0x64,
	0x65, 0x3d, 0x22, 0x20, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x32, 0x20,
	0x32, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x21, 0x22, 0x2f, 0x3e,
	0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36,
	0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72,
	0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x20, 0x31, 0x20, 0x35, 0x20, 0x35, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x37, 0x20, 0x32, 0x20, 0x38, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64,
	0x65, 0x3d, 0x22, 0x23, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x30, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x35, 0x20, 0x31,
	0x20, 0x38, 0x20, 0x31, 0x34, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x24, 0x22, 0x2f,
	0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
	0x31, 0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x33, 0x20, 0x32, 0x20, 0x31, 0x32, 0x20, 0x31,
	0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x25, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x32, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x33, 0x35, 0x20, 0x32, 0x20, 0x31, 0x32, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63,
	0x6f, 0x64, 0x65, 0x3d, 0x22, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x33, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x34, 0x37, 0x20, 0x31, 0x20, 0x32, 0x20, 0x35, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65,
	0x3d, 0x22, 0x27, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x3d, 0x22, 0x35, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22,
	0x31, 0x20, 0x32, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x39, 0x20, 0x30, 0x20,
	0x34, 0x20, 0x31, 0x37, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x28, 0x22, 0x2f, 0x3e,
	0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36,
	0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x32, 0x22, 0x20, 0x72,
	0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x33, 0x20, 0x30, 0x20, 0x35, 0x20, 0x31, 0x37, 0x22, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x29, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61,
	0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x2d, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22,
	0x35, 0x38, 0x20, 0x31, 0x20, 0x38, 0x20, 0x36, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x2a, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20,
	0x36, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x36, 0x20, 0x34, 0x20, 0x39, 0x20,
	0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x2b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x34, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x31, 0x20, 0x31, 0x33, 0x22, 0x20, 0x72, 0x65,
	0x63, 0x74, 0x3d, 0x22, 0x37, 0x35, 0x20, 0x31, 0x31, 0x20, 0x34, 0x20, 0x36, 0x22, 0x20, 0x63,
	0x6f, 0x64, 0x65, 0x3d, 0x22, 0x2c, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72,
	0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x3d, 0x22, 0x31, 0x20, 0x31, 0x30, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x37,
	0x39, 0x20, 0x38, 0x20, 0x34, 0x20, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x2d,
	0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x3d, 0x22, 0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x31,
	0x32, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x38, 0x33, 0x20, 0x31, 0x30, 0x20, 0x33,
	0x20, 0x33, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x2e, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x35, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x38, 0x36, 0x20, 0x31, 0x20, 0x36, 0x20, 0x31, 0x34, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x2f, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x39, 0x32, 0x20,
	0x32, 0x20, 0x37, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x30, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x39, 0x39, 0x20, 0x32, 0x20, 0x37, 0x20, 0x31, 0x31,
	0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x31, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43,
	0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d,
	0x22, 0x31, 0x30, 0x36, 0x20, 0x32, 0x20, 0x38, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64,
	0x65, 0x3d, 0x22, 0x32, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x31, 0x34, 0x20,
	0x32, 0x20, 0x37, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x33, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x32, 0x31, 0x20, 0x32, 0x20, 0x37, 0x20, 0x31,
	0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x34, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x31, 0x32, 0x38, 0x20, 0x32, 0x20, 0x37, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x35, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x33, 0x35,
	0x20, 0x31, 0x20, 0x37, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x36,
	0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x35,
	0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x34, 0x32, 0x20, 0x33, 0x20, 0x37, 0x20,
	0x31, 0x30, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x37, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x31, 0x34, 0x39, 0x20, 0x32, 0x20, 0x37, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63,
	0x6f, 0x64, 0x65, 0x3d, 0x22, 0x38, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72,
	0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x35,
	0x36, 0x20, 0x32, 0x20, 0x37, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x39, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20,
	0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x36, 0x33, 0x20, 0x35, 0x20, 0x33,
	0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x3a, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x34, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65,
	0x63, 0x74, 0x3d, 0x22, 0x31, 0x36, 0x36, 0x20, 0x35, 0x20, 0x35, 0x20, 0x31, 0x32, 0x22, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x3b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61,
	0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x35, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31,
	0x37, 0x31, 0x20, 0x33, 0x20, 0x37, 0x20, 0x39, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x26, 0x6c, 0x74, 0x3b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x37, 0x38, 0x20,
	0x35, 0x20, 0x39, 0x20, 0x34, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x3d, 0x22, 0x2f,
	0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
	0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x35, 0x22, 0x20,
	0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x31, 0x38, 0x37, 0x20, 0x33, 0x20, 0x37, 0x20, 0x39, 0x22,
	0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x3e, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68,
	0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22,
	0x31, 0x39, 0x34, 0x20, 0x31, 0x20, 0x36, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65,
	0x3d, 0x22, 0x3f, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x30, 0x30, 0x20,
	0x32, 0x20, 0x31, 0x33, 0x20, 0x31, 0x33, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x40,
	0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x3d, 0x22, 0x31, 0x31, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20,
	0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x31, 0x33, 0x20, 0x32, 0x20, 0x31,
	0x31, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x41, 0x22, 0x2f, 0x3e,
	0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31,
	0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20,
	0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x32, 0x34, 0x20, 0x32, 0x20, 0x39, 0x20, 0x31, 0x31,
	0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x42, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43,
	0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x32, 0x33, 0x33, 0x20, 0x32, 0x20, 0x39, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x43, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x31, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x34,
	0x32, 0x20, 0x32, 0x20, 0x31, 0x31, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d,
	0x22, 0x44, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22,
	0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x35, 0x33, 0x20, 0x32,
	0x20, 0x39, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x45, 0x22, 0x2f,
	0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
	0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20,
	0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x36, 0x32, 0x20, 0x32, 0x20, 0x39, 0x20, 0x31, 0x31,
	0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x46, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43,
	0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x31, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x32, 0x37, 0x31, 0x20, 0x32, 0x20, 0x31, 0x30, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63,
	0x6f, 0x64, 0x65, 0x3d, 0x22, 0x47, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72,
	0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x32, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32,
	0x38, 0x31, 0x20, 0x32, 0x20, 0x31, 0x32, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65,
	0x3d, 0x22, 0x48, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x3d, 0x22, 0x36, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22,
	0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x39, 0x33, 0x20, 0x32,
	0x20, 0x35, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x49, 0x22, 0x2f,
	0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
	0x36, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x32, 0x20, 0x34, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x32, 0x39, 0x38, 0x20, 0x32, 0x20, 0x38, 0x20, 0x31,
	0x34, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x4a, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x33, 0x30, 0x36, 0x20, 0x32, 0x20, 0x31, 0x31, 0x20, 0x31, 0x31, 0x22, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x4b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61,
	0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x33,
	0x31, 0x37, 0x20, 0x32, 0x20, 0x39, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d,
	0x22, 0x4c, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x3d, 0x22, 0x31, 0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22,
	0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x33, 0x32, 0x36, 0x20, 0x32,
	0x20, 0x31, 0x34, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x4d, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x31, 0x32, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34,
	0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x33, 0x34, 0x30, 0x20, 0x32, 0x20, 0x31, 0x32,
	0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x4e, 0x22, 0x2f, 0x3e, 0x0a,
	0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x31,
	0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72,
	0x65, 0x63, 0x74, 0x3d, 0x22, 0x33, 0x35, 0x32, 0x20, 0x32, 0x20, 0x31, 0x30, 0x20, 0x31, 0x31,
	0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x4f, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43,
	0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x33, 0x36, 0x32, 0x20, 0x32, 0x20, 0x39, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x50, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x31, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x33, 0x37,
	0x31, 0x20, 0x32, 0x20, 0x31, 0x30, 0x20, 0x31, 0x35, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d,
	0x22, 0x51, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22,
	0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x33, 0x38, 0x31, 0x20, 0x32,
	0x20, 0x31, 0x31, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x52, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x33, 0x39, 0x32, 0x20, 0x32, 0x20, 0x37, 0x20, 0x31,
	0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x53, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x33, 0x39, 0x39, 0x20, 0x32, 0x20, 0x39, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63,
	0x6f, 0x64, 0x65, 0x3d, 0x22, 0x54, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72,
	0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x32, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34,
	0x30, 0x38, 0x20, 0x32, 0x20, 0x31, 0x32, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65,
	0x3d, 0x22, 0x55, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x31, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x30, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x32, 0x30, 0x20,
	0x32, 0x20, 0x31, 0x31, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x56,
	0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x3d, 0x22, 0x31, 0x35, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20,
	0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x33, 0x31, 0x20, 0x32, 0x20, 0x31,
	0x36, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x57, 0x22, 0x2f, 0x3e,
	0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31,
	0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x34, 0x22, 0x20,
	0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x34, 0x37, 0x20, 0x32, 0x20, 0x31, 0x31, 0x20, 0x31,
	0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x58, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65,
	0x63, 0x74, 0x3d, 0x22, 0x34, 0x35, 0x38, 0x20, 0x32, 0x20, 0x31, 0x31, 0x20, 0x31, 0x31, 0x22,
	0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x59, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68,
	0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x34, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d,
	0x22, 0x34, 0x36, 0x39, 0x20, 0x32, 0x20, 0x38, 0x20, 0x31, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64,
	0x65, 0x3d, 0x22, 0x5a, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x32, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x37, 0x37, 0x20,
	0x31, 0x20, 0x34, 0x20, 0x31, 0x34, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x5b, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x35, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x38, 0x31, 0x20, 0x31, 0x20, 0x36, 0x20, 0x31,
	0x34, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x5c, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x35, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x34, 0x38, 0x37, 0x20, 0x31, 0x20, 0x34, 0x20, 0x31, 0x34, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x5d, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x39, 0x31,
	0x20, 0x35, 0x20, 0x37, 0x20, 0x35, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x5e, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x31, 0x35,
	0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x34, 0x39, 0x38, 0x20, 0x31, 0x33, 0x20, 0x37,
	0x20, 0x31, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x5f, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x35, 0x30, 0x35, 0x20, 0x31, 0x20, 0x34, 0x20, 0x34, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x60, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x30, 0x39,
	0x20, 0x35, 0x20, 0x39, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x61, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33,
	0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x31, 0x38, 0x20, 0x31, 0x20, 0x39, 0x20,
	0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x62, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x35, 0x32, 0x37, 0x20, 0x35, 0x20, 0x37, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x63, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x3d, 0x22, 0x31, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x33,
	0x34, 0x20, 0x31, 0x20, 0x39, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x64, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20,
	0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x34, 0x33, 0x20, 0x35, 0x20, 0x37,
	0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x65, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x36, 0x22, 0x20,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63,
	0x74, 0x3d, 0x22, 0x35, 0x35, 0x30, 0x20, 0x31, 0x20, 0x38, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63,
	0x6f, 0x64, 0x65, 0x3d, 0x22, 0x66, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72,
	0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x3d, 0x22, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x35,
	0x38, 0x20, 0x35, 0x20, 0x38, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x67, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30,
	0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x36, 0x36, 0x20, 0x31, 0x20,
	0x31, 0x30, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x68, 0x22, 0x2f,
	0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
	0x34, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22, 0x20,
	0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x37, 0x36, 0x20, 0x31, 0x20, 0x34, 0x20, 0x31, 0x32,
	0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x69, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43,
	0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x34, 0x22, 0x20, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x32, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x35, 0x38, 0x30, 0x20, 0x31, 0x20, 0x36, 0x20, 0x31, 0x36, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x6a, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x30, 0x20, 0x32, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x38, 0x36,
	0x20, 0x30, 0x20, 0x31, 0x30, 0x20, 0x31, 0x33, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x6b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x35, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20,
	0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x35, 0x39, 0x36, 0x20, 0x31, 0x20, 0x35,
	0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x6c, 0x22, 0x2f, 0x3e, 0x0a,
	0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x34,
	0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72,
	0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x30, 0x31, 0x20, 0x35, 0x20, 0x31, 0x34, 0x20, 0x38, 0x22,
	0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x6d, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68,
	0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x22, 0x20, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d,
	0x22, 0x36, 0x31, 0x35, 0x20, 0x35, 0x20, 0x31, 0x30, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64,
	0x65, 0x3d, 0x22, 0x6e, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d,
	0x22, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x32, 0x35, 0x20,
	0x35, 0x20, 0x38, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x6f, 0x22, 0x2f,
	0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
	0x31, 0x30, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x37, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x33, 0x33, 0x20, 0x35, 0x20, 0x39, 0x20, 0x31,
	0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x70, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c,
	0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x36, 0x34, 0x32, 0x20, 0x35, 0x20, 0x39, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x71, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x37, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x35, 0x31,
	0x20, 0x35, 0x20, 0x37, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x72, 0x22,
	0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
	0x22, 0x37, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x37, 0x22,
	0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x35, 0x38, 0x20, 0x35, 0x20, 0x36, 0x20, 0x38,
	0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x73, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43,
	0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x35, 0x22, 0x20, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x31, 0x20, 0x35, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74,
	0x3d, 0x22, 0x36, 0x36, 0x34, 0x20, 0x33, 0x20, 0x36, 0x20, 0x31, 0x30, 0x22, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x3d, 0x22, 0x74, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x3d, 0x22, 0x2d, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x37,
	0x30, 0x20, 0x35, 0x20, 0x31, 0x30, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x75, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20,
	0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x36, 0x38, 0x30, 0x20, 0x35, 0x20, 0x38,
	0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x76, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
	0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x32, 0x22,
	0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65,
	0x63, 0x74, 0x3d, 0x22, 0x36, 0x38, 0x38, 0x20, 0x35, 0x20, 0x31, 0x33, 0x20, 0x38, 0x22, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x77, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61,
	0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x37,
	0x30, 0x31, 0x20, 0x35, 0x20, 0x38, 0x20, 0x38, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22,
	0x78, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x3d, 0x22, 0x38, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x2d, 0x31,
	0x20, 0x37, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x37, 0x30, 0x39, 0x20, 0x35, 0x20,
	0x39, 0x20, 0x31, 0x32, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x79, 0x22, 0x2f, 0x3e,
	0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x38,
	0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x37, 0x22, 0x20, 0x72,
	0x65, 0x63, 0x74, 0x3d, 0x22, 0x37, 0x31, 0x38, 0x20, 0x35, 0x20, 0x36, 0x20, 0x38, 0x22, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x7a, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61,
	0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x35, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x37,
	0x32, 0x34, 0x20, 0x31, 0x20, 0x35, 0x20, 0x31, 0x34, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d,
	0x22, 0x7b, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x3d, 0x22, 0x35, 0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x32,
	0x20, 0x33, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22, 0x37, 0x32, 0x39, 0x20, 0x31, 0x20,
	0x32, 0x20, 0x31, 0x36, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x7c, 0x22, 0x2f, 0x3e,
	0x0a, 0x20, 0x3c, 0x43, 0x68, 0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x35,
	0x22, 0x20, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x30, 0x20, 0x33, 0x22, 0x20, 0x72,
	0x65, 0x63, 0x74, 0x3d, 0x22, 0x37, 0x33, 0x31, 0x20, 0x31, 0x20, 0x35, 0x20, 0x31, 0x34, 0x22,
	0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d, 0x22, 0x7d, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x3c, 0x43, 0x68,
	0x61, 0x72, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x39, 0x22, 0x20, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x3d, 0x22, 0x31, 0x20, 0x38, 0x22, 0x20, 0x72, 0x65, 0x63, 0x74, 0x3d, 0x22,
	0x37, 0x33, 0x36, 0x20, 0x36, 0x20, 0x37, 0x20, 0x33, 0x22, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x3d,
	0x22, 0x7e, 0x22, 0x2f, 0x3e, 0x0a, 0x3c, 0x2f, 0x46, 0x6f, 0x6e, 0x74, 0x3e, 0x0a
};
static int source_serif_pro_regular_12_xml_len = 5758;

/**
 * Bitmap fonts were generated using FontBuilder on Windows with the following settings:
 *
 * Line layout, no pixel separator, no "power of two image".
 * The image is a png with alpha transparency.
 * The .xml descriptor file is in the "Divo compatible" format.
 */

/**
 * These embedded resources were converted from binaries files to C arrays using "xxd -i"
 */

int rdtk_get_embedded_resource_file(const char* filename, BYTE** pData)
{
	if (strcmp(filename, "source_serif_pro_regular_12.png") == 0)
	{
		*pData = source_serif_pro_regular_12_png;
		return source_serif_pro_regular_12_png_len;
	}
	else if (strcmp(filename, "source_serif_pro_regular_12.xml") == 0)
	{
		*pData = source_serif_pro_regular_12_xml;
		return source_serif_pro_regular_12_xml_len;
	}
	else if (strcmp(filename, "btn_default_normal.9.png") == 0)
	{
		*pData = btn_default_normal_9_png;
		return btn_default_normal_9_png_len;
	}
	else if (strcmp(filename, "textfield_default.9.png") == 0)
	{
		*pData = textfield_default_9_png;
		return textfield_default_9_png_len;
	}

	return -1;
}
