.TH XScreenSaver 1 "2020-Feb-04" "X Version 11"
.SH NAME
beats - create offset beating figures
.SH SYNOPSIS
.B beats
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-count \fInumber\fP]
[\-cycle \fInumber\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
The \fIbeats\fP program draws balls that move around at a slightly different rate from each other, creating interesting chaotic and ordered beating patterns. Each cycle / pattern is created such that it finishes as a single line of balls at the top of the screen, so that the patterns can smoothly transition between each other.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds.).
.TP 8
.B \-count \fInumber\fP
Number of balls.  Default: 30.
.TP 8
.B \-cycle \fInumber\fP
Cycle type to use (Default: -1):
  -1 - pseudo-random based on current time
   0 - clockwise
   1 - rain dance
   2 - metronome
   3 - galaxy
.TP 8
.B \-tick | \-no-tick
Add a tick for 'clockwise' and 'galaxy' patterns.
.TP 8
.B \-blur | \-no-blur
Add motion blur to the ball movement.
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2020 by David Eccles.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
David Eccles (gringer) <hacking@gringene.org>, 2020-Feb-04.
