--TEST--
Testing randomization of shuffle() and str_shuffle().
--FILE--
<?php
function stats($f, $a) {
    $times = 90000;
    print "$f\n";
    ksort($a);
    foreach($a as $k => $v)
        print "$k: $v: " . sprintf('%0.3f', $v / $times) . "\n";
}
$a = array();
$times = 90000;
for ($i = 0; $i < $times; $i++) {
    $p = range(1,4);
    shuffle($p);
    $s = join('', $p);
    if (empty($a[$s])) $a[$s] = 0; 
    $a[$s]++;
}

stats('shuffle', $a);
$a = array();
$times = 90000;
for ($i = 0; $i < $times; $i++) {
    $p = '1234';
    $s = str_shuffle($p);
    if (empty($a[$s])) $a[$s] = 0;
    $a[$s]++;
}

stats('str_shuffle', $a);
?>
--EXPECTREGEX--
shuffle
1234: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1243: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1324: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1342: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1423: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1432: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2134: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2143: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2314: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2341: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2413: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2431: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3124: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3142: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3214: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3241: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3412: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3421: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4123: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4132: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4213: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4231: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4312: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4321: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
str_shuffle
1234: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1243: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1324: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1342: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1423: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
1432: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2134: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2143: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2314: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2341: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2413: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
2431: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3124: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3142: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3214: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3241: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3412: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
3421: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4123: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4132: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4213: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4231: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4312: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
4321: [34][0-9][0-9][0-9]: 0.0[3-4][0-9]
