#ifndef	KClientTypes_h
#define	KClientTypes_h

#include <KerberosSupport/KerberosConditionalMacros.h>
#include <KerberosDES/KerberosDES.h>

#if TARGET_API_MAC_OSX && TARGET_API_MAC_CARBON
    #include <CoreServices/CoreServices.h>
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_CARBON
    #include <Files.h>
#else
    #error "Unknown OS"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Constants */

/* Different kerberos name formats */
enum { 
	KClientLocalName,				/* Don't specify realm */
	KClientCommonName, 				/* Only specify realm if it isn't local */
	KClientFullName					/* Always specify realm */
};

/* Opaque types */

struct KClientSessionOpaque;
typedef struct KClientSessionOpaque* KClientSession;

struct KClientPrincipalOpaque;
typedef struct KClientPrincipalOpaque* KClientPrincipal;

/* Visible types */

typedef FSSpec KClientFile;

struct KClientAddress {
	UInt32				address;
	UInt16				port;
};
typedef struct KClientAddress KClientAddress;

struct KClientKey {
	des_cblock			key;
};
typedef struct KClientKey KClientKey;

struct KClientKeySchedule {
	des_key_schedule	keySchedule;
};
typedef struct KClientKeySchedule KClientKeySchedule;

#ifdef __cplusplus
}
#endif

#endif /* KClientTypes_h */