.\" $XFree86$
.\" Copyright 2002 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Authors:
.\"   Rickard E. (Rik) Faith <faith@redhat.com>
.\"
.TH vdltodmx 1 @vendorversion@
.SH NAME
vdltodmx - dmx configuration file parser and printer
.SH SYNOPSIS
.B vdltodmx
.I infile
.I outfile
.SH DESCRIPTION
.I vdltodmx
reads the input file, which should be in VDL configuration file format.
After a successful parse, a file in Xdmx configuration file format is
written to the output file.
.P
The VDL file format is used with
.IR xmovie ,
which is available from
http://www.llnl.gov/icc/lc/img/xmovie/xmovie.html
.SH EXAMPLE
Given the following VDL-format file:
.RS
.nf
0
2
#
#
2560 2048 Left two-thirds [restrict=*:2]
2
:2.1 1280 2048   0    0 0 0
:2.2 1280 2048   1280 0 0 0
4
1280 1024 0      0
1280 1024 0      1024
1280 1024 1280   0
1280 1024 1280   1024
#
2560 2048 Right two-thirds [restrict=*:2]
2
:2.2 1280 2048   0   0 0 0
:2.3 1280 2048   1280 0 0 0
4
1280 1024 1280    0
1280 1024 1280    1024
1280 1024 2560 0
1280 1024 2560 1024
.fi
.RE
the following DMX-format file will be produced:
.RS
.nf
#
#
virtual "Left two-thirds" 2560x2048 {
    display :2.1 1280x2048;
    display :2.2 1280x2048 @1280x0;
}
#
virtual "Right two-thirds" 2560x2048 {
    display :2.2 1280x2048;
    display :2.3 1280x2048 @1280x0;
}
.fi
.RE
.SH BUGS
If the VDL file is not in the expected format, the program will probably
dump core.
.SH "SEE ALSO"
Xdmx(1), xdmxconfig(1), vdl(3), xmovie(1)
