//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class fetches the CollectionStatistics object for a given collection.
    ///  Example:
    ///  @code
    ///  Akonadi.Collection collection = ...
    ///  Akonadi.CollectionStatisticsJob job = new Akonadi.CollectionStatisticsJob( collection );
    ///  if ( job.Exec() ) {
    ///    Akonadi.CollectionStatistics statistics = job.Statistics();
    ///    qDebug() << "Unread items:" << statistics.unreadCount();
    ///  }
    ///  @endcode
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Job that fetches collection statistics from the Akonadi storage. </short>
    [SmokeClass("Akonadi::CollectionStatisticsJob")]
    public class CollectionStatisticsJob : Akonadi.Job, IDisposable {
        protected CollectionStatisticsJob(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(CollectionStatisticsJob), this);
        }
        /// <remarks>
        ///  Creates a new collection statistics job.
        /// <param> name="collection" The collection to fetch the statistics from.
        /// </param><param> name="parent" The parent object.
        ///      </param></remarks>        <short>    Creates a new collection statistics job.</short>
        public CollectionStatisticsJob(Akonadi.Collection collection, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionStatisticsJob##", "CollectionStatisticsJob(const Akonadi::Collection&, QObject*)", typeof(void), typeof(Akonadi.Collection), collection, typeof(QObject), parent);
        }
        public CollectionStatisticsJob(Akonadi.Collection collection) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionStatisticsJob#", "CollectionStatisticsJob(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
        }
        /// <remarks>
        ///  Returns the fetched collection statistics.
        ///      </remarks>        <short>    Returns the fetched collection statistics.</short>
        public Akonadi.CollectionStatistics Statistics() {
            return (Akonadi.CollectionStatistics) interceptor.Invoke("statistics", "statistics() const", typeof(Akonadi.CollectionStatistics));
        }
        /// <remarks>
        ///  Returns the corresponding collection, if the job was executed successfully,
        ///  the collection is already updated.
        ///      </remarks>        <short>    Returns the corresponding collection, if the job was executed successfully,  the collection is already updated.</short>
        public Akonadi.Collection Collection() {
            return (Akonadi.Collection) interceptor.Invoke("collection", "collection() const", typeof(Akonadi.Collection));
        }
        [SmokeMethod("doStart()")]
        protected override void DoStart() {
            interceptor.Invoke("doStart", "doStart()", typeof(void));
        }
        [SmokeMethod("doHandleResponse(const QByteArray&, const QByteArray&)")]
        protected override void DoHandleResponse(QByteArray tag, QByteArray data) {
            interceptor.Invoke("doHandleResponse##", "doHandleResponse(const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), tag, typeof(QByteArray), data);
        }
        ~CollectionStatisticsJob() {
            interceptor.Invoke("~CollectionStatisticsJob", "~CollectionStatisticsJob()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~CollectionStatisticsJob", "~CollectionStatisticsJob()", typeof(void));
        }
        protected new ICollectionStatisticsJobSignals Emit {
            get { return (ICollectionStatisticsJobSignals) Q_EMIT; }
        }
    }

    public interface ICollectionStatisticsJobSignals : Akonadi.IJobSignals {
    }
}
