.TH "ZIP_STAT_INIT" "3" "September 22, 2013" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_stat_init\fP
\- initialize zip_stat structure
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
void
zip_stat_init zip_stat_t *sb
.SH "DESCRIPTION"
The
zip_stat_init
function initializes the members of a struct zip_stat.
The current members are described in
zip_stat(3),
but this function should be used to initialize it to
make sure none are missed.
The structure pointed to by
\fIsb\fP
must be allocated before calling
zip_stat_init.
.PP
This function should be used by functions provided to
zip_source_function(3)
when returning
\fRZIP_SOURCE_STAT\fP
information to make sure all fields are initialized.
.SH "RETURN VALUES"
If
\fIsb\fP
is valid, the function is always successful.
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
