/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceList
extends DataType
implements ResourceCollection {
    private final Vector<FilterChain> filterChains = new Vector();
    private final ArrayList<ResourceCollection> textDocuments = new ArrayList();
    private final Union cachedResources = new Union();
    private volatile boolean cached = false;
    private String encoding = null;

    public ResourceList() {
        this.cachedResources.setCache(true);
    }

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.textDocuments.add(rc);
        this.setChecked(false);
    }

    public final void addFilterChain(FilterChain filter) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filterChains.add(filter);
        this.setChecked(false);
    }

    public final void setEncoding(String encoding) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.encoding = encoding;
    }

    @Override
    public void setRefid(Reference r) throws BuildException {
        if (this.encoding != null) {
            throw this.tooManyAttributes();
        }
        if (this.filterChains.size() > 0 || this.textDocuments.size() > 0) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(r);
    }

    @Override
    public final synchronized Iterator<Resource> iterator() {
        if (this.isReference()) {
            return ((ResourceList)this.getCheckedRef()).iterator();
        }
        return this.cache().iterator();
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return ((ResourceList)this.getCheckedRef()).size();
        }
        return this.cache().size();
    }

    @Override
    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((ResourceList)this.getCheckedRef()).isFilesystemOnly();
        }
        return this.cache().isFilesystemOnly();
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            for (ResourceCollection resourceCollection : this.textDocuments) {
                if (!(resourceCollection instanceof DataType)) continue;
                ResourceList.pushAndInvokeCircularReferenceCheck((DataType)((Object)resourceCollection), stk, p);
            }
            for (FilterChain filterChain : this.filterChains) {
                ResourceList.pushAndInvokeCircularReferenceCheck(filterChain, stk, p);
            }
            this.setChecked(true);
        }
    }

    private synchronized ResourceCollection cache() {
        if (!this.cached) {
            this.dieOnCircularReference();
            for (ResourceCollection rc : this.textDocuments) {
                for (Resource r : rc) {
                    this.cachedResources.add(this.read(r));
                }
            }
            this.cached = true;
        }
        return this.cachedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceCollection read(Resource r) {
        Union union;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(r.getInputStream());
            InputStreamReader input = null;
            input = this.encoding == null ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, this.encoding);
            ChainReaderHelper crh = new ChainReaderHelper();
            crh.setPrimaryReader(input);
            crh.setFilterChains(this.filterChains);
            crh.setProject(this.getProject());
            Union streamResources = new Union();
            BufferedReader reader = new BufferedReader(crh.getAssembledReader());
            try {
                streamResources.setCache(true);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    streamResources.add(this.parse(line));
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            union = streamResources;
            Object var11_12 = null;
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Unable to read resource " + r.getName() + ": " + ioe, ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                FileUtils.close(bis);
                throw throwable;
            }
        }
        FileUtils.close(bis);
        return union;
    }

    private Resource parse(String line) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this.getProject());
        Object expanded = propertyHelper.parseProperties(line);
        if (expanded instanceof Resource) {
            return (Resource)expanded;
        }
        String expandedLine = expanded.toString();
        int colon = expandedLine.indexOf(":");
        if (colon != -1) {
            try {
                return new URLResource(expandedLine);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return new FileResource(this.getProject(), expandedLine);
    }
}

