//===--- ASTConsumer.cpp - Abstract interface for reading ASTs --*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
//  This file defines the ASTConsumer class.
//
//===----------------------------------------------------------------------===//

#include "clang/AST/ASTConsumer.h"
#include "llvm/Bitcode/BitstreamReader.h"
#include "clang/AST/Decl.h"
#include "clang/AST/DeclGroup.h"
using namespace clang;

bool ASTConsumer::HandleTopLevelDecl(DeclGroupRef D) {
  return true;
}

void ASTConsumer::HandleInterestingDecl(DeclGroupRef D) {
  HandleTopLevelDecl(D);
}

void ASTConsumer::HandleTopLevelDeclInObjCContainer(DeclGroupRef D) {}

void ASTConsumer::HandleImplicitImportDecl(ImportDecl *D) {
  HandleTopLevelDecl(DeclGroupRef(D));
}
